/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <math.h>
#include "quaternion.h"

void
quaternion_mult(Quaternion q, Quaternion other)
{
	float           x, y, z, w;	/* Current values of quaternion
					 * elements. */

	/* Conduct quaternion multiplication. */
	x = q[0], y = q[1], z = q[2], w = q[3];
	q[3] = w * other[3] - x * other[0] - y * other[1] - z * other[2];
	q[0] = w * other[0] + x * other[3] + y * other[2] - z * other[1];
	q[1] = w * other[1] + y * other[3] + z * other[0] - x * other[2];
	q[2] = w * other[2] + z * other[3] + x * other[1] - y * other[0];
}

void
quaternion_from_axis_angle(Vector axis, float angle, Quaternion q)
{
	float           den, mul;	/* Rotation axis vector norm and its
					 * inverted value. */
	float           sin_angle_2;	/* Sinus of half of rotation angle. */

	/* Normalize rotation axis vector. */
	den = vector_norm(axis);
	if (den) {
		mul = 1 / den;
		axis[X] *= mul;
		axis[Y] *= mul;
		axis[Z] *= mul;
	}
	/* Calculate sinus of half of rotation angle. */
	sin_angle_2 = (float)sin(angle / 2);

	/* Calculate quaternion elements values. */
	q[0] = axis[X] * sin_angle_2;
	q[1] = axis[Y] * sin_angle_2;
	q[2] = axis[Z] * sin_angle_2;
	q[3] = (float)cos(angle / 2);
}

void
quaternion_to_axis_angle(Quaternion q, Vector axis, float *angle)
{
	float           den, mul;	/* Auxiliary variables. */

	/* Normalize quaternion. */
	den = (float)sqrt(q[0] * q[0] + q[1] * q[1] + q[2] * q[2] + q[3] * q[3]);
	if (den) {
		mul = 1 / den;
		q[0] *= mul;
		q[1] *= mul;
		q[2] *= mul;
		q[3] *= mul;
	}
	/* Calculate rotation angle. */
	*angle = 2 * acos(q[3]);

	/* Calculate rotation axis. */
	den = sin(*angle / 2);
	if (den) {
		mul = 1 / den;

		axis[X] = q[0] * mul;
		axis[Y] = q[1] * mul;
		axis[Z] = q[2] * mul;
	} else {
		axis[X] = 0;
		axis[Y] = 1;
		axis[Z] = 0;
	}
}
