/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef object_h
#define object_h

#include "material.h"
#include "triangle.h"
#include "vertex.h"

/* Object data type. */
typedef struct {
	Vector          lo, hi;	/* Lower and upper corner of object bounding
				 * box. */
	int             vertex_count;	/* Object vertex count. */
	Vertex         *vertices;	/* Array with object vertices. */
	int             normal_count;	/* Object normal count. */
	Vector         *normals;/* Array with object normal. */
	int             material_count;	/* Object materila count. */
	Material       *materials;	/* Array with object material. */
	int             triangle_count;	/* Object triangle count. */
	Triangle       *triangles;	/* Array with object triangles. */
}               Object;

/* Create object. Argument is filename to read object description from. */
Object         *object_create(char *name);

/* Make a copy of given object. */
Object         *object_copy(Object * other);

/* Destroy object. */
void            object_destroy(Object * object);

/* Render object using OpenGL commands. */
void            object_render(Object * object);

#endif
