// +build !windows

/*
Copyright 2019 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package auth

import (
	"context"

	"github.com/gravitational/teleport/lib/backend/legacy"
	"github.com/gravitational/teleport/lib/backend/legacy/dir"
	"github.com/gravitational/teleport/lib/backend/lite"

	"github.com/gravitational/trace"
)

// NewProcessStorage returns a new instance of the process storage.
func NewProcessStorage(ctx context.Context, path string) (*ProcessStorage, error) {
	if path == "" {
		return nil, trace.BadParameter("missing parameter path")
	}

	litebk, err := lite.NewWithConfig(ctx, lite.Config{Path: path, EventsOff: true})
	if err != nil {
		return nil, trace.Wrap(err)
	}
	// Import storage data
	err = legacy.Import(ctx, litebk, func() (legacy.Exporter, error) {
		return dir.New(legacy.Params{"path": path})
	})
	if err != nil {
		return nil, trace.Wrap(err)
	}

	return &ProcessStorage{Backend: litebk}, nil
}
