// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: auth.proto

package proto

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import empty "github.com/golang/protobuf/ptypes/empty"
import services "github.com/gravitational/teleport/lib/services"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Operation identifies type of operation
type Operation int32

const (
	// INIT is sent as a first sentinel event
	// on the watch channel
	Operation_INIT Operation = 0
	// PUT identifies created or updated object
	Operation_PUT Operation = 1
	// DELETE identifies deleted object
	Operation_DELETE Operation = 2
)

var Operation_name = map[int32]string{
	0: "INIT",
	1: "PUT",
	2: "DELETE",
}
var Operation_value = map[string]int32{
	"INIT":   0,
	"PUT":    1,
	"DELETE": 2,
}

func (x Operation) String() string {
	return proto.EnumName(Operation_name, int32(x))
}
func (Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_auth_1c67c241dc026532, []int{0}
}

// Event returns cluster event
type Event struct {
	// Operation identifies operation
	Type Operation `protobuf:"varint,1,opt,name=Type,proto3,enum=proto.Operation" json:"type,omitempty"`
	// Resource contains the updated resource
	//
	// Types that are valid to be assigned to Resource:
	//	*Event_ResourceHeader
	//	*Event_CertAuthority
	//	*Event_StaticTokens
	//	*Event_ProvisionToken
	//	*Event_ClusterName
	//	*Event_ClusterConfig
	//	*Event_User
	//	*Event_Role
	//	*Event_Namespace
	//	*Event_Server
	//	*Event_ReverseTunnel
	//	*Event_TunnelConnection
	Resource             isEvent_Resource `protobuf_oneof:"Resource"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_1c67c241dc026532, []int{0}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(dst, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_Resource interface {
	isEvent_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Event_ResourceHeader struct {
	ResourceHeader *services.ResourceHeader `protobuf:"bytes,2,opt,name=ResourceHeader,oneof"`
}
type Event_CertAuthority struct {
	CertAuthority *services.CertAuthorityV2 `protobuf:"bytes,3,opt,name=CertAuthority,oneof"`
}
type Event_StaticTokens struct {
	StaticTokens *services.StaticTokensV2 `protobuf:"bytes,4,opt,name=StaticTokens,oneof"`
}
type Event_ProvisionToken struct {
	ProvisionToken *services.ProvisionTokenV2 `protobuf:"bytes,5,opt,name=ProvisionToken,oneof"`
}
type Event_ClusterName struct {
	ClusterName *services.ClusterNameV2 `protobuf:"bytes,6,opt,name=ClusterName,oneof"`
}
type Event_ClusterConfig struct {
	ClusterConfig *services.ClusterConfigV3 `protobuf:"bytes,7,opt,name=ClusterConfig,oneof"`
}
type Event_User struct {
	User *services.UserV2 `protobuf:"bytes,8,opt,name=User,oneof"`
}
type Event_Role struct {
	Role *services.RoleV3 `protobuf:"bytes,9,opt,name=Role,oneof"`
}
type Event_Namespace struct {
	Namespace *services.Namespace `protobuf:"bytes,10,opt,name=Namespace,oneof"`
}
type Event_Server struct {
	Server *services.ServerV2 `protobuf:"bytes,11,opt,name=Server,oneof"`
}
type Event_ReverseTunnel struct {
	ReverseTunnel *services.ReverseTunnelV2 `protobuf:"bytes,12,opt,name=ReverseTunnel,oneof"`
}
type Event_TunnelConnection struct {
	TunnelConnection *services.TunnelConnectionV2 `protobuf:"bytes,13,opt,name=TunnelConnection,oneof"`
}

func (*Event_ResourceHeader) isEvent_Resource()   {}
func (*Event_CertAuthority) isEvent_Resource()    {}
func (*Event_StaticTokens) isEvent_Resource()     {}
func (*Event_ProvisionToken) isEvent_Resource()   {}
func (*Event_ClusterName) isEvent_Resource()      {}
func (*Event_ClusterConfig) isEvent_Resource()    {}
func (*Event_User) isEvent_Resource()             {}
func (*Event_Role) isEvent_Resource()             {}
func (*Event_Namespace) isEvent_Resource()        {}
func (*Event_Server) isEvent_Resource()           {}
func (*Event_ReverseTunnel) isEvent_Resource()    {}
func (*Event_TunnelConnection) isEvent_Resource() {}

func (m *Event) GetResource() isEvent_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *Event) GetResourceHeader() *services.ResourceHeader {
	if x, ok := m.GetResource().(*Event_ResourceHeader); ok {
		return x.ResourceHeader
	}
	return nil
}

func (m *Event) GetCertAuthority() *services.CertAuthorityV2 {
	if x, ok := m.GetResource().(*Event_CertAuthority); ok {
		return x.CertAuthority
	}
	return nil
}

func (m *Event) GetStaticTokens() *services.StaticTokensV2 {
	if x, ok := m.GetResource().(*Event_StaticTokens); ok {
		return x.StaticTokens
	}
	return nil
}

func (m *Event) GetProvisionToken() *services.ProvisionTokenV2 {
	if x, ok := m.GetResource().(*Event_ProvisionToken); ok {
		return x.ProvisionToken
	}
	return nil
}

func (m *Event) GetClusterName() *services.ClusterNameV2 {
	if x, ok := m.GetResource().(*Event_ClusterName); ok {
		return x.ClusterName
	}
	return nil
}

func (m *Event) GetClusterConfig() *services.ClusterConfigV3 {
	if x, ok := m.GetResource().(*Event_ClusterConfig); ok {
		return x.ClusterConfig
	}
	return nil
}

func (m *Event) GetUser() *services.UserV2 {
	if x, ok := m.GetResource().(*Event_User); ok {
		return x.User
	}
	return nil
}

func (m *Event) GetRole() *services.RoleV3 {
	if x, ok := m.GetResource().(*Event_Role); ok {
		return x.Role
	}
	return nil
}

func (m *Event) GetNamespace() *services.Namespace {
	if x, ok := m.GetResource().(*Event_Namespace); ok {
		return x.Namespace
	}
	return nil
}

func (m *Event) GetServer() *services.ServerV2 {
	if x, ok := m.GetResource().(*Event_Server); ok {
		return x.Server
	}
	return nil
}

func (m *Event) GetReverseTunnel() *services.ReverseTunnelV2 {
	if x, ok := m.GetResource().(*Event_ReverseTunnel); ok {
		return x.ReverseTunnel
	}
	return nil
}

func (m *Event) GetTunnelConnection() *services.TunnelConnectionV2 {
	if x, ok := m.GetResource().(*Event_TunnelConnection); ok {
		return x.TunnelConnection
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Event) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Event_OneofMarshaler, _Event_OneofUnmarshaler, _Event_OneofSizer, []interface{}{
		(*Event_ResourceHeader)(nil),
		(*Event_CertAuthority)(nil),
		(*Event_StaticTokens)(nil),
		(*Event_ProvisionToken)(nil),
		(*Event_ClusterName)(nil),
		(*Event_ClusterConfig)(nil),
		(*Event_User)(nil),
		(*Event_Role)(nil),
		(*Event_Namespace)(nil),
		(*Event_Server)(nil),
		(*Event_ReverseTunnel)(nil),
		(*Event_TunnelConnection)(nil),
	}
}

func _Event_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Event)
	// Resource
	switch x := m.Resource.(type) {
	case *Event_ResourceHeader:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceHeader); err != nil {
			return err
		}
	case *Event_CertAuthority:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CertAuthority); err != nil {
			return err
		}
	case *Event_StaticTokens:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StaticTokens); err != nil {
			return err
		}
	case *Event_ProvisionToken:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProvisionToken); err != nil {
			return err
		}
	case *Event_ClusterName:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterName); err != nil {
			return err
		}
	case *Event_ClusterConfig:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterConfig); err != nil {
			return err
		}
	case *Event_User:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.User); err != nil {
			return err
		}
	case *Event_Role:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Role); err != nil {
			return err
		}
	case *Event_Namespace:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Namespace); err != nil {
			return err
		}
	case *Event_Server:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Server); err != nil {
			return err
		}
	case *Event_ReverseTunnel:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseTunnel); err != nil {
			return err
		}
	case *Event_TunnelConnection:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TunnelConnection); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Event.Resource has unexpected type %T", x)
	}
	return nil
}

func _Event_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Event)
	switch tag {
	case 2: // Resource.ResourceHeader
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ResourceHeader)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ResourceHeader{msg}
		return true, err
	case 3: // Resource.CertAuthority
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.CertAuthorityV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_CertAuthority{msg}
		return true, err
	case 4: // Resource.StaticTokens
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.StaticTokensV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_StaticTokens{msg}
		return true, err
	case 5: // Resource.ProvisionToken
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ProvisionTokenV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ProvisionToken{msg}
		return true, err
	case 6: // Resource.ClusterName
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ClusterNameV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ClusterName{msg}
		return true, err
	case 7: // Resource.ClusterConfig
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ClusterConfigV3)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ClusterConfig{msg}
		return true, err
	case 8: // Resource.User
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.UserV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_User{msg}
		return true, err
	case 9: // Resource.Role
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.RoleV3)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Role{msg}
		return true, err
	case 10: // Resource.Namespace
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.Namespace)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Namespace{msg}
		return true, err
	case 11: // Resource.Server
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ServerV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Server{msg}
		return true, err
	case 12: // Resource.ReverseTunnel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ReverseTunnelV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ReverseTunnel{msg}
		return true, err
	case 13: // Resource.TunnelConnection
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.TunnelConnectionV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_TunnelConnection{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Event_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Event)
	// Resource
	switch x := m.Resource.(type) {
	case *Event_ResourceHeader:
		s := proto.Size(x.ResourceHeader)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_CertAuthority:
		s := proto.Size(x.CertAuthority)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_StaticTokens:
		s := proto.Size(x.StaticTokens)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ProvisionToken:
		s := proto.Size(x.ProvisionToken)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ClusterName:
		s := proto.Size(x.ClusterName)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ClusterConfig:
		s := proto.Size(x.ClusterConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_User:
		s := proto.Size(x.User)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Role:
		s := proto.Size(x.Role)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Namespace:
		s := proto.Size(x.Namespace)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Server:
		s := proto.Size(x.Server)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ReverseTunnel:
		s := proto.Size(x.ReverseTunnel)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_TunnelConnection:
		s := proto.Size(x.TunnelConnection)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Watch specifies watch parameters
type Watch struct {
	// Kinds specifies object kinds to watch
	Kinds                []WatchKind `protobuf:"bytes,1,rep,name=Kinds" json:"kinds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Watch) Reset()         { *m = Watch{} }
func (m *Watch) String() string { return proto.CompactTextString(m) }
func (*Watch) ProtoMessage()    {}
func (*Watch) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_1c67c241dc026532, []int{1}
}
func (m *Watch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Watch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Watch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Watch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Watch.Merge(dst, src)
}
func (m *Watch) XXX_Size() int {
	return m.Size()
}
func (m *Watch) XXX_DiscardUnknown() {
	xxx_messageInfo_Watch.DiscardUnknown(m)
}

var xxx_messageInfo_Watch proto.InternalMessageInfo

// WatchKind specifies resource kind to watch
type WatchKind struct {
	// Kind is a resource kind to watch
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// LoadSecrets specifies whether to load secrets
	LoadSecrets bool `protobuf:"varint,2,opt,name=LoadSecrets,proto3" json:"load_secrets"`
	// Name is an optional specific resource type to watch,
	// if specified only the events with a specific resource
	// name will be sent
	Name                 string   `protobuf:"bytes,3,opt,name=Name,proto3" json:"name"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WatchKind) Reset()         { *m = WatchKind{} }
func (m *WatchKind) String() string { return proto.CompactTextString(m) }
func (*WatchKind) ProtoMessage()    {}
func (*WatchKind) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_1c67c241dc026532, []int{2}
}
func (m *WatchKind) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchKind) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchKind.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *WatchKind) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchKind.Merge(dst, src)
}
func (m *WatchKind) XXX_Size() int {
	return m.Size()
}
func (m *WatchKind) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchKind.DiscardUnknown(m)
}

var xxx_messageInfo_WatchKind proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Event)(nil), "proto.Event")
	proto.RegisterType((*Watch)(nil), "proto.Watch")
	proto.RegisterType((*WatchKind)(nil), "proto.WatchKind")
	proto.RegisterEnum("proto.Operation", Operation_name, Operation_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for AuthService service

type AuthServiceClient interface {
	// SendKeepAlives allows node to send a stream of keep alive requests
	SendKeepAlives(ctx context.Context, opts ...grpc.CallOption) (AuthService_SendKeepAlivesClient, error)
	// WatchEvents returns a new stream of cluster events
	WatchEvents(ctx context.Context, in *Watch, opts ...grpc.CallOption) (AuthService_WatchEventsClient, error)
	// UpsertNode upserts node
	UpsertNode(ctx context.Context, in *services.ServerV2, opts ...grpc.CallOption) (*services.KeepAlive, error)
}

type authServiceClient struct {
	cc *grpc.ClientConn
}

func NewAuthServiceClient(cc *grpc.ClientConn) AuthServiceClient {
	return &authServiceClient{cc}
}

func (c *authServiceClient) SendKeepAlives(ctx context.Context, opts ...grpc.CallOption) (AuthService_SendKeepAlivesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuthService_serviceDesc.Streams[0], "/proto.AuthService/SendKeepAlives", opts...)
	if err != nil {
		return nil, err
	}
	x := &authServiceSendKeepAlivesClient{stream}
	return x, nil
}

type AuthService_SendKeepAlivesClient interface {
	Send(*services.KeepAlive) error
	CloseAndRecv() (*empty.Empty, error)
	grpc.ClientStream
}

type authServiceSendKeepAlivesClient struct {
	grpc.ClientStream
}

func (x *authServiceSendKeepAlivesClient) Send(m *services.KeepAlive) error {
	return x.ClientStream.SendMsg(m)
}

func (x *authServiceSendKeepAlivesClient) CloseAndRecv() (*empty.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(empty.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *authServiceClient) WatchEvents(ctx context.Context, in *Watch, opts ...grpc.CallOption) (AuthService_WatchEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuthService_serviceDesc.Streams[1], "/proto.AuthService/WatchEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &authServiceWatchEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuthService_WatchEventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type authServiceWatchEventsClient struct {
	grpc.ClientStream
}

func (x *authServiceWatchEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *authServiceClient) UpsertNode(ctx context.Context, in *services.ServerV2, opts ...grpc.CallOption) (*services.KeepAlive, error) {
	out := new(services.KeepAlive)
	err := c.cc.Invoke(ctx, "/proto.AuthService/UpsertNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for AuthService service

type AuthServiceServer interface {
	// SendKeepAlives allows node to send a stream of keep alive requests
	SendKeepAlives(AuthService_SendKeepAlivesServer) error
	// WatchEvents returns a new stream of cluster events
	WatchEvents(*Watch, AuthService_WatchEventsServer) error
	// UpsertNode upserts node
	UpsertNode(context.Context, *services.ServerV2) (*services.KeepAlive, error)
}

func RegisterAuthServiceServer(s *grpc.Server, srv AuthServiceServer) {
	s.RegisterService(&_AuthService_serviceDesc, srv)
}

func _AuthService_SendKeepAlives_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AuthServiceServer).SendKeepAlives(&authServiceSendKeepAlivesServer{stream})
}

type AuthService_SendKeepAlivesServer interface {
	SendAndClose(*empty.Empty) error
	Recv() (*services.KeepAlive, error)
	grpc.ServerStream
}

type authServiceSendKeepAlivesServer struct {
	grpc.ServerStream
}

func (x *authServiceSendKeepAlivesServer) SendAndClose(m *empty.Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *authServiceSendKeepAlivesServer) Recv() (*services.KeepAlive, error) {
	m := new(services.KeepAlive)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _AuthService_WatchEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Watch)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuthServiceServer).WatchEvents(m, &authServiceWatchEventsServer{stream})
}

type AuthService_WatchEventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type authServiceWatchEventsServer struct {
	grpc.ServerStream
}

func (x *authServiceWatchEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _AuthService_UpsertNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.ServerV2)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).UpsertNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/UpsertNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).UpsertNode(ctx, req.(*services.ServerV2))
	}
	return interceptor(ctx, in, info, handler)
}

var _AuthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.AuthService",
	HandlerType: (*AuthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpsertNode",
			Handler:    _AuthService_UpsertNode_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SendKeepAlives",
			Handler:       _AuthService_SendKeepAlives_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "WatchEvents",
			Handler:       _AuthService_WatchEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "auth.proto",
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Type))
	}
	if m.Resource != nil {
		nn1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Event_ResourceHeader) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResourceHeader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ResourceHeader.Size()))
		n2, err := m.ResourceHeader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Event_CertAuthority) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CertAuthority != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.CertAuthority.Size()))
		n3, err := m.CertAuthority.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Event_StaticTokens) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StaticTokens != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.StaticTokens.Size()))
		n4, err := m.StaticTokens.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Event_ProvisionToken) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ProvisionToken != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ProvisionToken.Size()))
		n5, err := m.ProvisionToken.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Event_ClusterName) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterName != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ClusterName.Size()))
		n6, err := m.ClusterName.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Event_ClusterConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterConfig != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ClusterConfig.Size()))
		n7, err := m.ClusterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Event_User) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.User != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.User.Size()))
		n8, err := m.User.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Event_Role) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Role != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Role.Size()))
		n9, err := m.Role.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *Event_Namespace) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Namespace != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Namespace.Size()))
		n10, err := m.Namespace.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *Event_Server) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Server != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Server.Size()))
		n11, err := m.Server.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *Event_ReverseTunnel) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseTunnel != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ReverseTunnel.Size()))
		n12, err := m.ReverseTunnel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *Event_TunnelConnection) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TunnelConnection != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.TunnelConnection.Size()))
		n13, err := m.TunnelConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Watch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Watch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kinds) > 0 {
		for _, msg := range m.Kinds {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAuth(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WatchKind) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchKind) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if m.LoadSecrets {
		dAtA[i] = 0x10
		i++
		if m.LoadSecrets {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAuth(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Event) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovAuth(uint64(m.Type))
	}
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event_ResourceHeader) Size() (n int) {
	var l int
	_ = l
	if m.ResourceHeader != nil {
		l = m.ResourceHeader.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_CertAuthority) Size() (n int) {
	var l int
	_ = l
	if m.CertAuthority != nil {
		l = m.CertAuthority.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_StaticTokens) Size() (n int) {
	var l int
	_ = l
	if m.StaticTokens != nil {
		l = m.StaticTokens.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ProvisionToken) Size() (n int) {
	var l int
	_ = l
	if m.ProvisionToken != nil {
		l = m.ProvisionToken.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ClusterName) Size() (n int) {
	var l int
	_ = l
	if m.ClusterName != nil {
		l = m.ClusterName.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ClusterConfig) Size() (n int) {
	var l int
	_ = l
	if m.ClusterConfig != nil {
		l = m.ClusterConfig.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_User) Size() (n int) {
	var l int
	_ = l
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Role) Size() (n int) {
	var l int
	_ = l
	if m.Role != nil {
		l = m.Role.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Namespace) Size() (n int) {
	var l int
	_ = l
	if m.Namespace != nil {
		l = m.Namespace.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Server) Size() (n int) {
	var l int
	_ = l
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ReverseTunnel) Size() (n int) {
	var l int
	_ = l
	if m.ReverseTunnel != nil {
		l = m.ReverseTunnel.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_TunnelConnection) Size() (n int) {
	var l int
	_ = l
	if m.TunnelConnection != nil {
		l = m.TunnelConnection.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Watch) Size() (n int) {
	var l int
	_ = l
	if len(m.Kinds) > 0 {
		for _, e := range m.Kinds {
			l = e.Size()
			n += 1 + l + sovAuth(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchKind) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.LoadSecrets {
		n += 2
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAuth(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAuth(x uint64) (n int) {
	return sovAuth(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Operation(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ResourceHeader{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ResourceHeader{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertAuthority", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.CertAuthorityV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_CertAuthority{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticTokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.StaticTokensV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_StaticTokens{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProvisionToken", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ProvisionTokenV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ProvisionToken{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ClusterNameV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ClusterName{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ClusterConfigV3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ClusterConfig{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.UserV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_User{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.RoleV3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Role{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.Namespace{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Namespace{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ServerV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Server{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseTunnel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ReverseTunnelV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ReverseTunnel{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TunnelConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.TunnelConnectionV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_TunnelConnection{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Watch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Watch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Watch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kinds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kinds = append(m.Kinds, WatchKind{})
			if err := m.Kinds[len(m.Kinds)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchKind) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchKind: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchKind: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadSecrets", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LoadSecrets = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAuth(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAuth
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAuth
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAuth(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAuth = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAuth   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("auth.proto", fileDescriptor_auth_1c67c241dc026532) }

var fileDescriptor_auth_1c67c241dc026532 = []byte{
	// 827 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x94, 0xd1, 0x6e, 0xdb, 0x36,
	0x14, 0x86, 0xad, 0xc6, 0x4e, 0x6d, 0x3a, 0xf5, 0x0c, 0x36, 0x48, 0x54, 0x27, 0xb3, 0x82, 0x5c,
	0x05, 0xdd, 0x60, 0x0f, 0x0a, 0x06, 0x0c, 0xbd, 0x29, 0xaa, 0xcc, 0x40, 0x8a, 0x06, 0x59, 0x61,
	0x3b, 0x2a, 0xb0, 0x5d, 0x18, 0x8a, 0x7c, 0xea, 0x08, 0x91, 0x45, 0x81, 0xa4, 0x0d, 0x04, 0x7b,
	0x91, 0x3d, 0xc7, 0x9e, 0x22, 0x97, 0x7b, 0x02, 0x61, 0xcb, 0xee, 0xf4, 0x14, 0x05, 0x0f, 0x6d,
	0x4b, 0x74, 0x7b, 0x65, 0xf1, 0xff, 0xf9, 0x7f, 0xc7, 0x3c, 0xa2, 0x0e, 0x21, 0xc1, 0x42, 0xde,
	0xf5, 0x52, 0xce, 0x24, 0xa3, 0x35, 0xfc, 0xe9, 0xec, 0xcf, 0xd8, 0x8c, 0xe1, 0x63, 0x5f, 0x3d,
	0x69, 0xb3, 0x73, 0x34, 0x63, 0x6c, 0x16, 0x43, 0x1f, 0x57, 0xb7, 0x8b, 0xcf, 0x7d, 0x98, 0xa7,
	0xf2, 0x61, 0x65, 0xbe, 0x99, 0x45, 0xf2, 0x6e, 0x71, 0xdb, 0x0b, 0xd9, 0xbc, 0x3f, 0xe3, 0xc1,
	0x32, 0x92, 0x81, 0x8c, 0x58, 0x12, 0xc4, 0x7d, 0x09, 0x31, 0xa4, 0x8c, 0xcb, 0x7e, 0x1c, 0xdd,
	0xf6, 0x05, 0xf0, 0x65, 0x14, 0x82, 0xe8, 0xcb, 0x87, 0x14, 0x84, 0xce, 0x9e, 0x66, 0x75, 0x52,
	0x1b, 0x2c, 0x21, 0x91, 0xf4, 0x17, 0x52, 0x1d, 0x3f, 0xa4, 0x60, 0x5b, 0x27, 0xd6, 0x59, 0xcb,
	0x6d, 0x6b, 0xbf, 0xf7, 0x5b, 0x0a, 0x1c, 0x69, 0x1e, 0xcd, 0x33, 0xa7, 0xa5, 0xa2, 0x3f, 0xb2,
	0x79, 0x24, 0xb1, 0xfe, 0x10, 0x13, 0xf4, 0x77, 0xd2, 0x1a, 0x82, 0x60, 0x0b, 0x1e, 0xc2, 0x25,
	0x04, 0x53, 0xe0, 0xf6, 0xb3, 0x13, 0xeb, 0xac, 0xe9, 0xda, 0xbd, 0x75, 0xc9, 0x9e, 0xe9, 0x7b,
	0x07, 0x79, 0xe6, 0x50, 0xbe, 0xd2, 0x0a, 0xde, 0x65, 0x65, 0xb8, 0x45, 0xa2, 0x13, 0xf2, 0xe2,
	0x02, 0xb8, 0x7c, 0xb7, 0x90, 0x77, 0x8c, 0x47, 0xf2, 0xc1, 0xde, 0x41, 0xf4, 0xab, 0x02, 0x6d,
	0xd8, 0xbe, 0xeb, 0x1d, 0xe7, 0x99, 0x63, 0x87, 0xc0, 0xe5, 0x24, 0x58, 0xab, 0x46, 0x05, 0x93,
	0x47, 0xff, 0x20, 0x7b, 0x23, 0xd5, 0xaf, 0x70, 0xcc, 0xee, 0x21, 0x11, 0x76, 0x75, 0xfb, 0xaf,
	0x97, 0x5d, 0xdf, 0xf5, 0x8e, 0xf2, 0xcc, 0x39, 0x14, 0xa8, 0x4d, 0x24, 0x8a, 0x06, 0xdd, 0x80,
	0xd1, 0x90, 0xb4, 0x3e, 0x72, 0xb6, 0x8c, 0x44, 0xc4, 0x12, 0x94, 0xec, 0x1a, 0xe2, 0x3b, 0x05,
	0xde, 0xf4, 0x7d, 0xd7, 0xfb, 0x3e, 0xcf, 0x9c, 0x57, 0xe9, 0x5a, 0xd5, 0x35, 0xcc, 0x16, 0x99,
	0x11, 0xfa, 0x89, 0x34, 0x2f, 0xe2, 0x85, 0x90, 0xc0, 0xaf, 0x83, 0x39, 0xd8, 0xbb, 0x58, 0xe1,
	0xb0, 0xd4, 0xa0, 0xc2, 0xf4, 0x5d, 0xaf, 0x93, 0x67, 0xce, 0x41, 0xa8, 0xa5, 0x49, 0x12, 0xcc,
	0xcd, 0xf6, 0x97, 0x49, 0xd8, 0x7b, 0xbd, 0xbc, 0x60, 0xc9, 0xe7, 0x68, 0x66, 0x3f, 0xff, 0xaa,
	0xf7, 0x65, 0xdb, 0x3f, 0x5f, 0xf5, 0x7e, 0x05, 0x0f, 0x51, 0xdd, 0xea, 0x7d, 0x39, 0x40, 0xdf,
	0x90, 0xea, 0x8d, 0x00, 0x6e, 0xd7, 0x91, 0xdb, 0x2e, 0xb8, 0x4a, 0xf5, 0x5d, 0x7d, 0xe5, 0x16,
	0x02, 0xb8, 0x01, 0xc1, 0x8c, 0xca, 0x0e, 0x59, 0x0c, 0x76, 0x63, 0x3b, 0xab, 0x54, 0xff, 0x5c,
	0x67, 0x39, 0x8b, 0xcd, 0xf3, 0x61, 0x86, 0x5e, 0x91, 0x86, 0x3a, 0xa0, 0x48, 0x83, 0x10, 0x6c,
	0x82, 0x80, 0x97, 0x05, 0x60, 0x63, 0x79, 0x87, 0x79, 0xe6, 0xbc, 0x4c, 0xd6, 0x4b, 0x03, 0x54,
	0x00, 0xa8, 0x47, 0x76, 0x47, 0xc0, 0x97, 0xc0, 0xed, 0x26, 0xa2, 0x68, 0xe9, 0xee, 0xa0, 0xee,
	0xbb, 0xde, 0x7e, 0x9e, 0x39, 0x6d, 0x81, 0x2b, 0x03, 0xb3, 0x4a, 0xaa, 0x56, 0x0f, 0x61, 0x09,
	0x5c, 0xc0, 0x78, 0x91, 0x24, 0x10, 0xdb, 0x7b, 0xdb, 0xad, 0x36, 0xec, 0xf5, 0x35, 0xe7, 0x5a,
	0x9c, 0x48, 0x54, 0xcd, 0x56, 0x1b, 0x01, 0x7a, 0x4f, 0xda, 0xfa, 0xe9, 0x82, 0x25, 0x09, 0x84,
	0xea, 0x8b, 0xb6, 0x5f, 0x60, 0x8d, 0xe3, 0xa2, 0xc6, 0xf6, 0x0e, 0xdf, 0xf5, 0x9c, 0x3c, 0x73,
	0x8e, 0x34, 0x5e, 0xbd, 0xd0, 0x95, 0x61, 0x54, 0xfa, 0x0a, 0xec, 0x11, 0x52, 0x5f, 0x7f, 0xc6,
	0xa7, 0x97, 0xa4, 0xf6, 0x29, 0x90, 0xe1, 0x1d, 0x7d, 0x4b, 0x6a, 0x1f, 0xa2, 0x64, 0x2a, 0x6c,
	0xeb, 0x64, 0x07, 0xdf, 0x98, 0x1e, 0x30, 0x68, 0x2a, 0xc3, 0x3b, 0x7c, 0xcc, 0x9c, 0x4a, 0x9e,
	0x39, 0xdf, 0xdd, 0xab, 0x6d, 0xa5, 0x29, 0xa3, 0x73, 0xa7, 0x7f, 0x92, 0xc6, 0x66, 0x33, 0x3d,
	0x26, 0x55, 0xf5, 0x8b, 0xd3, 0xaa, 0xe1, 0xd5, 0xf3, 0xcc, 0xa9, 0xaa, 0xd8, 0x10, 0x55, 0xea,
	0x92, 0xe6, 0x15, 0x0b, 0xa6, 0x23, 0x08, 0x39, 0x48, 0x81, 0xe3, 0xa8, 0xee, 0xb5, 0xf3, 0xcc,
	0xd9, 0x8b, 0x59, 0x30, 0x9d, 0x08, 0xad, 0x0f, 0xcb, 0x9b, 0x14, 0x11, 0xbf, 0x9f, 0x9d, 0x82,
	0xa8, 0x5e, 0xfd, 0x10, 0xd5, 0xd7, 0xaf, 0x49, 0x63, 0x33, 0x0a, 0x69, 0x9d, 0x54, 0xdf, 0x5f,
	0xbf, 0x1f, 0xb7, 0x2b, 0xf4, 0x39, 0xd9, 0xf9, 0x78, 0x33, 0x6e, 0x5b, 0x94, 0x90, 0xdd, 0x5f,
	0x07, 0x57, 0x83, 0xf1, 0xa0, 0xfd, 0xcc, 0xfd, 0xdb, 0x22, 0x4d, 0x35, 0x60, 0x46, 0xba, 0xaf,
	0xf4, 0x2d, 0x69, 0x8d, 0x20, 0x99, 0x7e, 0x00, 0x48, 0xdf, 0xc5, 0xd1, 0x12, 0x04, 0x2d, 0xdd,
	0xb6, 0x8d, 0xda, 0x39, 0xe8, 0xe9, 0x21, 0xdf, 0x5b, 0x0f, 0xf9, 0xde, 0x40, 0x1d, 0xff, 0xcc,
	0xa2, 0x3f, 0x90, 0x26, 0x9e, 0x1c, 0x07, 0xb5, 0xa0, 0x7b, 0xe5, 0xd6, 0x75, 0xd6, 0x2b, 0x34,
	0x7f, 0xb2, 0xe8, 0xcf, 0x84, 0xdc, 0xa4, 0x02, 0xb8, 0xbc, 0x66, 0x53, 0xa0, 0xdf, 0xb8, 0x8c,
	0x9d, 0x6f, 0x55, 0xf7, 0xf6, 0x1f, 0xff, 0xeb, 0x56, 0x1e, 0x9f, 0xba, 0xd6, 0x3f, 0x4f, 0x5d,
	0xeb, 0xdf, 0xa7, 0xae, 0xf5, 0xd7, 0xff, 0xdd, 0xca, 0xed, 0x2e, 0xb2, 0xcf, 0xbf, 0x04, 0x00,
	0x00, 0xff, 0xff, 0x31, 0x44, 0xe3, 0x83, 0xa9, 0x06, 0x00, 0x00,
}
