/*
Copyright 2018 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package legacy

// ServerV2 is version1 resource spec of the server
type ServerV2 struct {
	// Kind is a resource kind
	Kind string `json:"kind"`
	// Version is version
	Version string `json:"version"`
	// Metadata is User metadata
	Metadata Metadata `json:"metadata"`
	// Spec contains user specification
	Spec ServerSpecV2 `json:"spec"`
}

// ServerSpecV2 is a specification for V2 Server
type ServerSpecV2 struct {
	// Addr is server host:port address
	Addr string `json:"addr"`
	// PublicAddr is the public address this cluster can be reached at.
	PublicAddr string `json:"public_addr,omitempty"`
	// Hostname is server hostname
	Hostname string `json:"hostname"`
	// CmdLabels is server dynamic labels
	CmdLabels map[string]CommandLabelV2 `json:"cmd_labels,omitempty"`
	// Rotation specifies server rotatoin status
	Rotation Rotation `json:"rotation,omitempty"`
}

// CommandLabelV2 is a label that has a value as a result of the
// output generated by running command, e.g. hostname
type CommandLabelV2 struct {
	// Period is a time between command runs
	Period Duration `json:"period"`
	// Command is a command to run
	Command []string `json:"command"` //["/usr/bin/hostname", "--long"]
	// Result captures standard output
	Result string `json:"result"`
}
