QUEUE(3)                  OpenBSD Programmer's Manual                 QUEUE(3)

NNAAMMEE
     SSLLIISSTT__EENNTTRRYY, SSLLIISSTT__HHEEAADD, SSLLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR, SSLLIISSTT__FFIIRRSSTT, SSLLIISSTT__NNEEXXTT,
     SSLLIISSTT__EENNDD, SSLLIISSTT__EEMMPPTTYY, SSLLIISSTT__FFOORREEAACCHH, SSLLIISSTT__IINNIITT, SSLLIISSTT__IINNSSEERRTT__AAFFTTEERR,
     SSLLIISSTT__IINNSSEERRTT__HHEEAADD, SSLLIISSTT__RREEMMOOVVEE__HHEEAADD, LLIISSTT__EENNTTRRYY, LLIISSTT__HHEEAADD,
     LLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR, LLIISSTT__FFIIRRSSTT, LLIISSTT__NNEEXXTT, LLIISSTT__EENNDD, LLIISSTT__EEMMPPTTYY,
     LLIISSTT__FFOORREEAACCHH, LLIISSTT__IINNIITT, LLIISSTT__IINNSSEERRTT__AAFFTTEERR, LLIISSTT__IINNSSEERRTT__BBEEFFOORREE,
     LLIISSTT__IINNSSEERRTT__HHEEAADD, LLIISSTT__RREEMMOOVVEE, SSIIMMPPLLEEQQ__EENNTTRRYY, SSIIMMPPLLEEQQ__HHEEAADD,
     SSIIMMPPLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR, SSIIMMPPLLEEQQ__FFIIRRSSTT, SSIIMMPPLLEEQQ__NNEEXXTT, SSIIMMPPLLEEQQ__EENNDD,
     SSIIMMPPLLEEQQ__EEMMPPTTYY, SSIIMMPPLLEEQQ__FFOORREEAACCHH, SSIIMMPPLLEEQQ__IINNIITT, SSIIMMPPLLEEQQ__IINNSSEERRTT__HHEEAADD,
     SSIIMMPPLLEEQQ__IINNSSEERRTT__TTAAIILL, SSIIMMPPLLEEQQ__IINNSSEERRTT__AAFFTTEERR, SSIIMMPPLLEEQQ__RREEMMOOVVEE__HHEEAADD,
     TTAAIILLQQ__EENNTTRRYY, TTAAIILLQQ__HHEEAADD, TTAAIILLQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR, TTAAIILLQQ__FFIIRRSSTT, TTAAIILLQQ__NNEEXXTT,
     TTAAIILLQQ__EENNDD, TTAAIILLQQ__LLAASSTT, TTAAIILLQQ__PPRREEVV, TTAAIILLQQ__EEMMPPTTYY, TTAAIILLQQ__FFOORREEAACCHH,
     TTAAIILLQQ__FFOORREEAACCHH__RREEVVEERRSSEE, TTAAIILLQQ__IINNIITT, TTAAIILLQQ__IINNSSEERRTT__AAFFTTEERR,
     TTAAIILLQQ__IINNSSEERRTT__BBEEFFOORREE, TTAAIILLQQ__IINNSSEERRTT__HHEEAADD, TTAAIILLQQ__IINNSSEERRTT__TTAAIILL, TTAAIILLQQ__RREEMMOOVVEE,
     CCIIRRCCLLEEQQ__EENNTTRRYY, CCIIRRCCLLEEQQ__HHEEAADD, CCIIRRCCLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR, CCIIRRCCLLEEQQ__FFIIRRSSTT,
     CCIIRRCCLLEEQQ__LLAASSTT, CCIIRRCCLLEEQQ__EENNDD, CCIIRRCCLLEEQQ__NNEEXXTT, CCIIRRCCLLEEQQ__PPRREEVV, CCIIRRCCLLEEQQ__EEMMPPTTYY,
     CCIIRRCCLLEEQQ__FFOORREEAACCHH, CCIIRRCCLLEEQQ__IINNIITT, CCIIRRCCLLEEQQ__IINNSSEERRTT__AAFFTTEERR,
     CCIIRRCCLLEEQQ__IINNSSEERRTT__BBEEFFOORREE, CCIIRRCCLLEEQQ__IINNSSEERRTT__HHEEAADD, CCIIRRCCLLEEQQ__IINNSSEERRTT__TTAAIILL,
     CCIIRRCCLLEEQQ__RREEMMOOVVEE - implementations of singly-linked lists, doubly-linked
     lists, simple queues, tail queues, and circular queues

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssyyss//qquueeuuee..hh>>

     SSLLIISSTT__EENNTTRRYY(_T_Y_P_E);

     SSLLIISSTT__HHEEAADD(_H_E_A_D_N_A_M_E, _T_Y_P_E);

     SSLLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR(_S_L_I_S_T___H_E_A_D _h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSLLIISSTT__FFIIRRSSTT(_S_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSLLIISSTT__NNEEXXTT(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _S_L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSLLIISSTT__EENNDD(_S_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _b_o_o_l
     SSLLIISSTT__EEMMPPTTYY(_S_L_I_S_T___H_E_A_D _*_h_e_a_d);

     SSLLIISSTT__FFOORREEAACCHH(_V_A_R_N_A_M_E, _S_L_I_S_T___H_E_A_D _*_h_e_a_d, _S_L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSLLIISSTT__IINNIITT(_S_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     SSLLIISSTT__IINNSSEERRTT__AAFFTTEERR(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _S_L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSLLIISSTT__IINNSSEERRTT__HHEEAADD(_S_L_I_S_T___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _S_L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSLLIISSTT__RREEMMOOVVEE__HHEEAADD(_S_L_I_S_T___H_E_A_D _*_h_e_a_d, _S_L_I_S_T___E_N_T_R_Y _N_A_M_E);

     LLIISSTT__EENNTTRRYY(_T_Y_P_E);

     LLIISSTT__HHEEAADD(_H_E_A_D_N_A_M_E, _T_Y_P_E);

     LLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR(_L_I_S_T___H_E_A_D _h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     LLIISSTT__FFIIRRSSTT(_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     LLIISSTT__NNEEXXTT(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _s_t_r_u_c_t _T_Y_P_E _*
     LLIISSTT__EENNDD(_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _b_o_o_l
     LLIISSTT__EEMMPPTTYY(_L_I_S_T___H_E_A_D _*_h_e_a_d);

     LLIISSTT__FFOORREEAACCHH(_V_A_R_N_A_M_E, _L_I_S_T___H_E_A_D _*_h_e_a_d, _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     LLIISSTT__IINNIITT(_L_I_S_T___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     LLIISSTT__IINNSSEERRTT__AAFFTTEERR(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     LLIISSTT__IINNSSEERRTT__BBEEFFOORREE(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     LLIISSTT__IINNSSEERRTT__HHEEAADD(_L_I_S_T___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     LLIISSTT__RREEMMOOVVEE(_s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _L_I_S_T___E_N_T_R_Y _N_A_M_E);

     SSIIMMPPLLEEQQ__EENNTTRRYY(_T_Y_P_E);

     SSIIMMPPLLEEQQ__HHEEAADD(_H_E_A_D_N_A_M_E, _T_Y_P_E);

     SSIIMMPPLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR(_S_I_M_P_L_E_Q___H_E_A_D _h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSIIMMPPLLEEQQ__FFIIRRSSTT(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSIIMMPPLLEEQQ__NNEEXXTT(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _S_I_M_P_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _s_t_r_u_c_t _T_Y_P_E _*
     SSIIMMPPLLEEQQ__EENNDD(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     SSIIMMPPLLEEQQ__IINNIITT(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     SSIIMMPPLLEEQQ__IINNSSEERRTT__HHEEAADD(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _S_I_M_P_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSIIMMPPLLEEQQ__IINNSSEERRTT__TTAAIILL(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _S_I_M_P_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSIIMMPPLLEEQQ__IINNSSEERRTT__AAFFTTEERR(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _S_I_M_P_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     SSIIMMPPLLEEQQ__RREEMMOOVVEE__HHEEAADD(_S_I_M_P_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _S_I_M_P_L_E_Q___E_N_T_R_Y _N_A_M_E);

     TTAAIILLQQ__EENNTTRRYY(_T_Y_P_E);

     TTAAIILLQQ__HHEEAADD(_H_E_A_D_N_A_M_E, _T_Y_P_E);

     TTAAIILLQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR(_T_A_I_L_Q___H_E_A_D _h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     TTAAIILLQQ__FFIIRRSSTT(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     TTAAIILLQQ__NNEEXXTT(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _s_t_r_u_c_t _T_Y_P_E _*
     TTAAIILLQQ__EENNDD(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     TTAAIILLQQ__LLAASSTT(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _H_E_A_D_N_A_M_E _N_A_M_E);

     TTAAIILLQQ__PPRREEVV(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _H_E_A_D_N_A_M_E _N_A_M_E, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _b_o_o_l
     TTAAIILLQQ__EEMMPPTTYY(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d);

     TTAAIILLQQ__FFOORREEAACCHH(_V_A_R_N_A_M_E, _T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     TTAAIILLQQ__FFOORREEAACCHH__RREEVVEERRSSEE(_V_A_R_N_A_M_E, _T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     TTAAIILLQQ__IINNIITT(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     TTAAIILLQQ__IINNSSEERRTT__AAFFTTEERR(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m,
             _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     TTAAIILLQQ__IINNSSEERRTT__BBEEFFOORREE(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     TTAAIILLQQ__IINNSSEERRTT__HHEEAADD(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     TTAAIILLQQ__IINNSSEERRTT__TTAAIILL(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     TTAAIILLQQ__RREEMMOOVVEE(_T_A_I_L_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _T_A_I_L_Q___E_N_T_R_Y _N_A_M_E);

     CCIIRRCCLLEEQQ__EENNTTRRYY(_T_Y_P_E);

     CCIIRRCCLLEEQQ__HHEEAADD(_H_E_A_D_N_A_M_E, _T_Y_P_E);

     CCIIRRCCLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR(_C_I_R_C_L_E_Q___H_E_A_D _h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     CCIIRRCCLLEEQQ__FFIIRRSSTT(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     CCIIRRCCLLEEQQ__LLAASSTT(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     CCIIRRCCLLEEQQ__EENNDD(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d);

     _s_t_r_u_c_t _T_Y_P_E _*
     CCIIRRCCLLEEQQ__NNEEXXTT(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _s_t_r_u_c_t _T_Y_P_E _*
     CCIIRRCCLLEEQQ__PPRREEVV(_s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _b_o_o_l
     CCIIRRCCLLEEQQ__EEMMPPTTYY(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d);

     CCIIRRCCLLEEQQ__FFOORREEAACCHH(_V_A_R_N_A_M_E, _C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     CCIIRRCCLLEEQQ__FFOORREEAACCHH__RREEVVEERRSSEE(_V_A_R_N_A_M_E, _C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     CCIIRRCCLLEEQQ__IINNIITT(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d);

     _v_o_i_d
     CCIIRRCCLLEEQQ__IINNSSEERRTT__AAFFTTEERR(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m,
             _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     CCIIRRCCLLEEQQ__IINNSSEERRTT__BBEEFFOORREE(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_l_i_s_t_e_l_m,
             _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     CCIIRRCCLLEEQQ__IINNSSEERRTT__HHEEAADD(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     CCIIRRCCLLEEQQ__IINNSSEERRTT__TTAAIILL(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m,
             _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

     _v_o_i_d
     CCIIRRCCLLEEQQ__RREEMMOOVVEE(_C_I_R_C_L_E_Q___H_E_A_D _*_h_e_a_d, _s_t_r_u_c_t _T_Y_P_E _*_e_l_m, _C_I_R_C_L_E_Q___E_N_T_R_Y _N_A_M_E);

DDEESSCCRRIIPPTTIIOONN
     These macros define and operate on five types of data structures: singly-
     linked lists, simple queues, lists, tail queues, and circular queues.
     All five structures support the following functionality:

           1.   Insertion of a new entry at the head of the list.
           2.   Insertion of a new entry after any element in the list.
           3.   Removal of an entry from the head of the list.
           4.   Forward traversal through the list.

     Singly-linked lists are the simplest of the five data structures and sup-
     port only the above functionality.  Singly-linked lists are ideal for ap-
     plications with large datasets and few or no removals, or for implement-
     ing a LIFO queue.

     Simple queues add the following functionality:

           1.   Entries can be added at the end of a list.

     However:

           1.   All list insertions must specify the head of the list.
           2.   Each head entry requires two pointers rather than one.
           3.   Code size is about 15% greater and operations run about 20%
                slower than singly-linked lists.

     Simple queues are ideal for applications with large datasets and few or
     no removals, or for implementing a FIFO queue.

     All doubly linked types of data structures (lists, tail queues, and cir-
     cle queues) additionally allow:

           1.   Insertion of a new entry before any element in the list.
           2.   Removal of any entry in the list.

     However:

           1.   Each elements requires two pointers rather than one.
           2.   Code size and execution time of operations (except for re-
                moval) is about twice that of the singly-linked data-struc-
                tures.

     Lists are the simplest of the doubly linked data structures and support
     only the above functionality over singly-linked lists.

     Tail queues add the following functionality:

           1.   Entries can be added at the end of a list.
           2.   They may be traversed backwards, at a cost.

     However:

           1.   All list insertions and removals must specify the head of the
                list.
           2.   Each head entry requires two pointers rather than one.
           3.   Code size is about 15% greater and operations run about 20%
                slower than singly-linked lists.

     Circular queues add the following functionality:

           1.   Entries can be added at the end of a list.
           2.   They may be traversed backwards, from tail to head.

     However:

           1.   All list insertions and removals must specify the head of the
                list.
           2.   Each head entry requires two pointers rather than one.
           3.   The termination condition for traversal is more complex.
           4.   Code size is about 40% greater and operations run about 45%
                slower than lists.

     In the macro definitions, _T_Y_P_E is the name tag of a user defined struc-
     ture that must contain a field of type SLIST_ENTRY, LIST_ENTRY,
     SIMPLEQ_ENTRY, TAILQ_ENTRY, or CIRCLEQ_ENTRY, named _N_A_M_E. The argument
     _H_E_A_D_N_A_M_E is the name tag of a user defined structure that must be de-
     clared using the macros SSLLIISSTT__HHEEAADD(), LLIISSTT__HHEEAADD(), SSIIMMPPLLEEQQ__HHEEAADD(),
     TTAAIILLQQ__HHEEAADD(), or CCIIRRCCLLEEQQ__HHEEAADD().  See the examples below for further ex-
     planation of how these macros are used.

SSIINNGGLLYY__LLIINNKKEEDD LLIISSTTSS
     A singly-linked list is headed by a structure defined by the SSLLIISSTT__HHEEAADD()
     macro.  This structure contains a single pointer to the first element on
     the list.  The elements are singly linked for minimum space and pointer
     manipulation overhead at the expense of O(n) removal for arbitrary ele-
     ments.  New elements can be added to the list after an existing element
     or at the head of the list.  A _S_L_I_S_T___H_E_A_D structure is declared as fol-
     lows:

           SLIST_HEAD(HEADNAME, TYPE) head;

     where _H_E_A_D_N_A_M_E is the name of the structure to be defined, and struct
     _T_Y_P_E is the type of the elements to be linked into the list.  A pointer
     to the head of the list can later be declared as:

           struct HEADNAME *headp;

     (The names head and headp are user selectable.)

     The _H_E_A_D_N_A_M_E facility is often not used, leading to the following bizarre
     code:

           SLIST_HEAD(, TYPE) head, *headp;

     The SSLLIISSTT__EENNTTRRYY() macro declares a structure that connects the elements
     in the list.

     The SSLLIISSTT__IINNIITT() macro initializes the list referenced by _h_e_a_d.

     The list can also be initialized statically by using the
     SSLLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR() macro like this:

           SLIST_HEAD(HEADNAME, TYPE) head = SLIST_HEAD_INITIALIZER(head);

     The SSLLIISSTT__IINNSSEERRTT__HHEEAADD() macro inserts the new element _e_l_m at the head of
     the list.

     The SSLLIISSTT__IINNSSEERRTT__AAFFTTEERR() macro inserts the new element _e_l_m after the ele-
     ment _l_i_s_t_e_l_m.

     The SSLLIISSTT__RREEMMOOVVEE__HHEEAADD() macro removes the first element of the list
     pointed by _h_e_a_d.

     The SSLLIISSTT__FFIIRRSSTT(), and SSLLIISSTT__NNEEXXTT() macros can be used to traverse the
     list:

           for (np = SLIST_FIRST(&head); np != NULL; np = SLIST_NEXT(np, NAME))

     Or, for simplicity, one can use the SSLLIISSTT__FFOORREEAACCHH() macro:

           SLIST_FOREACH(np, head, NAME)

     The SSLLIISSTT__EEMMPPTTYY() macro should be used to check whether a simple list is
     empty.

LLIISSTTSS
     A list is headed by a structure defined by the LLIISSTT__HHEEAADD() macro.  This
     structure contains a single pointer to the first element on the list.
     The elements are doubly linked so that an arbitrary element can be re-
     moved without traversing the list.  New elements can be added to the list
     after an existing element, before an existing element, or at the head of
     the list.  A _L_I_S_T___H_E_A_D structure is declared as follows:

           LIST_HEAD(HEADNAME, TYPE) head;

     where _H_E_A_D_N_A_M_E is the name of the structure to be defined, and struct
     _T_Y_P_E is the type of the elements to be linked into the list.  A pointer
     to the head of the list can later be declared as:

           struct HEADNAME *headp;

     (The names head and headp are user selectable.)

     The _H_E_A_D_N_A_M_E facility is often not used, leading to the following bizarre
     code:

           LIST_HEAD(, TYPE) head, *headp;

     The LLIISSTT__EENNTTRRYY() macro declares a structure that connects the elements in
     the list.

     The LLIISSTT__IINNIITT() macro initializes the list referenced by _h_e_a_d.

     The list can also be initialized statically by using the
     LLIISSTT__HHEEAADD__IINNIITTIIAALLIIZZEERR() macro like this:

           LIST_HEAD(HEADNAME, TYPE) head = LIST_HEAD_INITIALIZER(head);

     The LLIISSTT__IINNSSEERRTT__HHEEAADD() macro inserts the new element _e_l_m at the head of
     the list.

     The LLIISSTT__IINNSSEERRTT__AAFFTTEERR() macro inserts the new element _e_l_m after the ele-
     ment _l_i_s_t_e_l_m.

     The LLIISSTT__IINNSSEERRTT__BBEEFFOORREE() macro inserts the new element _e_l_m before the el-
     ement _l_i_s_t_e_l_m.

     The LLIISSTT__RREEMMOOVVEE() macro removes the element _e_l_m from the list.

     The LLIISSTT__FFIIRRSSTT(), and LLIISSTT__NNEEXXTT() macros can be used to traverse the
     list:

           for (np = LIST_FIRST(&head); np != NULL; np = LIST_NEXT(np, NAME))

     Or, for simplicity, one can use the LLIISSTT__FFOORREEAACCHH() macro:

           LIST_FOREACH(np, head, NAME)

     The LLIISSTT__EEMMPPTTYY() macro should be used to check whether a list is empty.

LLIISSTT EEXXAAMMPPLLEE
     LIST_HEAD(listhead, entry) head;
     struct listhead *headp;         /* List head. */
     struct entry {
             ...
             LIST_ENTRY(entry) entries;      /* List. */
             ...
     } *n1, *n2, *np;

     LIST_INIT(&head);                       /* Initialize the list. */

     n1 = malloc(sizeof(struct entry));      /* Insert at the head. */
     LIST_INSERT_HEAD(&head, n1, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert after. */
     LIST_INSERT_AFTER(n1, n2, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert before. */
     LIST_INSERT_BEFORE(n1, n2, entries);
                                             /* Forward traversal. */
     for (np = head.lh_first; np != NULL; np = np->entries.le_next)
             np-> ...

     while (head.lh_first != NULL)           /* Delete. */
             LIST_REMOVE(head.lh_first, entries);

SSIIMMPPLLEE QQUUEEUUEESS
     A simple queue is headed by a structure defined by the SSIIMMPPLLEEQQ__HHEEAADD()
     macro.  This structure contains a pair of pointers, one to the first ele-
     ment in the simple queue and the other to the last element in the simple
     queue.  The elements are singly linked.  New elements can be added to the
     queue after an existing element, at the head of the queue or at the tail
     of the queue.  A _S_I_M_P_L_E_Q___H_E_A_D structure is declared as follows:

           SIMPLEQ_HEAD(HEADNAME, TYPE) head;

     where _H_E_A_D_N_A_M_E is the name of the structure to be defined, and struct
     _T_Y_P_E is the type of the elements to be linked into the queue.  A pointer
     to the head of the queue can later be declared as:

           struct HEADNAME *headp;

     (The names head and headp are user selectable.)

     The SSIIMMPPLLEEQQ__EENNTTRRYY() macro declares a structure that connects the elements
     in the queue.

     The SSIIMMPPLLEEQQ__IINNIITT() macro initializes the queue referenced by _h_e_a_d.

     The queue can also be initialized statically by using the
     SSIIMMPPLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR() macro like this:

           SIMPLEQ_HEAD(HEADNAME, TYPE) head = SIMPLEQ_HEAD_INITIALIZER(head);

     The SSIIMMPPLLEEQQ__IINNSSEERRTT__HHEEAADD() macro inserts the new element _e_l_m at the head
     of the queue.

     The SSIIMMPPLLEEQQ__IINNSSEERRTT__TTAAIILL() macro inserts the new element _e_l_m at the end of
     the queue.

     The SSIIMMPPLLEEQQ__IINNSSEERRTT__AAFFTTEERR() macro inserts the new element _e_l_m after the
     element _l_i_s_t_e_l_m.

     The SSIIMMPPLLEEQQ__RREEMMOOVVEE__HHEEAADD() macro removes the first element from the queue.

     The SSIIMMPPLLEEQQ__FFIIRRSSTT(), and SSIIMMPPLLEEQQ__NNEEXXTT() macros can be used to traverse
     the queue.  The SSIIMMPPLLEEQQ__FFOORREEAACCHH() is used for queue traversal

           SIMPLEQ_FOREACH(np, head, NAME)

     The SSIIMMPPLLEEQQ__EEMMPPTTYY() macro should be used to check whether a list is emp-
     ty.

SSIIMMPPLLEE QQUUEEUUEE EEXXAAMMPPLLEE
     SIMPLEQ_HEAD(listhead, entry) head = SIMPLEQ_HEAD_INITIALIZER(head);
     struct entry {
             ...
             SIMPLEQ_ENTRY(entry) entries;   /* List. */
             ...
     } *n1, *n2, *np;

     n1 = malloc(sizeof(struct entry));      /* Insert at the head. */
     SIMPLEQ_INSERT_HEAD(&head, n1, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert after. */
     SIMPLEQ_INSERT_AFTER(n1, n2, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert at the tail. */
     SIMPLEQ_INSERT_TAIL(&head, n1, entries);
                                             /* Forward traversal. */
     for (np = SIMPLEQ_FIRST(&head); np != NULL; np = SIMPLEQ_NEXT(np, entries))
             np-> ...
                                             /* Delete. */
     while (SIMPLEQ_FIRST(&head) != NULL)
             SIMPLEQ_REMOVE_HEAD(&head, n1, entries);

TTAAIILL QQUUEEUUEESS
     A tail queue is headed by a structure defined by the TTAAIILLQQ__HHEEAADD() macro.
     This structure contains a pair of pointers, one to the first element in
     the tail queue and the other to the last element in the tail queue.  The
     elements are doubly linked so that an arbitrary element can be removed
     without traversing the tail queue.  New elements can be added to the
     queue after an existing element, before an existing element, at the head
     of the queue, or at the end the queue.  A _T_A_I_L_Q___H_E_A_D structure is de-
     clared as follows:

           TAILQ_HEAD(HEADNAME, TYPE) head;

     where _H_E_A_D_N_A_M_E is the name of the structure to be defined, and struct
     _T_Y_P_E is the type of the elements to be linked into the tail queue.  A
     pointer to the head of the tail queue can later be declared as:

           struct HEADNAME *headp;

     (The names head and headp are user selectable.)

     The TTAAIILLQQ__EENNTTRRYY() macro declares a structure that connects the elements
     in the tail queue.

     The TTAAIILLQQ__IINNIITT() macro initializes the tail queue referenced by _h_e_a_d.

     The tail queue can also be initialized statically by using the
     TTAAIILLQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR() macro.

     The TTAAIILLQQ__IINNSSEERRTT__HHEEAADD() macro inserts the new element _e_l_m at the head of
     the tail queue.

     The TTAAIILLQQ__IINNSSEERRTT__TTAAIILL() macro inserts the new element _e_l_m at the end of
     the tail queue.

     The TTAAIILLQQ__IINNSSEERRTT__AAFFTTEERR() macro inserts the new element _e_l_m after the ele-
     ment _l_i_s_t_e_l_m.

     The TTAAIILLQQ__IINNSSEERRTT__BBEEFFOORREE() macro inserts the new element _e_l_m before the
     element _l_i_s_t_e_l_m.

     The TTAAIILLQQ__RREEMMOOVVEE() macro removes the element _e_l_m from the tail queue.

     The TTAAIILL__FFIIRRSSTT(), TTAAIILLQQ__NNEEXXTT(), TTAAIILLQQ__LLAASSTT() and TTAAIILLQQ__PPRREEVV() macros can
     be used to traverse a tail queue.  The TTAAIILLQQ__FFOORREEAACCHH() is used for tail
     queue traversal

           TAILQ_FOREACH(np, head, NAME)

     The TTAAIILLQQ__FFOORREEAACCHH__RREEVVEERRSSEE() acts like TTAAIILLQQ__FFOORREEAACCHH() but traverses the
     tail queue in reverse.

     The TTAAIILLQQ__EEMMPPTTYY() macro should be used to check whether a tail queue is
     empty.

TTAAIILL QQUUEEUUEE EEXXAAMMPPLLEE
     TAILQ_HEAD(tailhead, entry) head;
     struct tailhead *headp;         /* Tail queue head. */
     struct entry {
             ...
             TAILQ_ENTRY(entry) entries;     /* Tail queue. */
             ...
     } *n1, *n2, *np;

     TAILQ_INIT(&head);                      /* Initialize the queue. */

     n1 = malloc(sizeof(struct entry));      /* Insert at the head. */
     TAILQ_INSERT_HEAD(&head, n1, entries);

     n1 = malloc(sizeof(struct entry));      /* Insert at the tail. */
     TAILQ_INSERT_TAIL(&head, n1, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert after. */
     TAILQ_INSERT_AFTER(&head, n1, n2, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert before. */
     TAILQ_INSERT_BEFORE(n1, n2, entries);
                                             /* Forward traversal. */
     for (np = TAILQ_FIRST(&head); np; np = TAILQ_NEXT(&head, entries))
             np-> ...
                                             /* Delete. */
     while (np = TAILQ_FIRST(&head))
             TAILQ_REMOVE(&head, np, entries);

CCIIRRCCUULLAARR QQUUEEUUEESS
     A circular queue is headed by a structure defined by the CCIIRRCCLLEEQQ__HHEEAADD()
     macro.  This structure contains a pair of pointers, one to the first ele-
     ment in the circular queue and the other to the last element in the cir-
     cular queue.  The elements are doubly linked so that an arbitrary element
     can be removed without traversing the queue.  New elements can be added
     to the queue after an existing element, before an existing element, at
     the head of the queue, or at the end of the queue.  A _C_I_R_C_L_E_Q___H_E_A_D struc-
     ture is declared as follows:

           CIRCLEQ_HEAD(HEADNAME, TYPE) head;

     where _H_E_A_D_N_A_M_E is the name of the structure to be defined, and struct
     _T_Y_P_E is the type of the elements to be linked into the circular queue.  A
     pointer to the head of the circular queue can later be declared as:

           struct HEADNAME *headp;

     (The names head and headp are user selectable.)

     The CCIIRRCCLLEEQQ__EENNTTRRYY() macro declares a structure that connects the elements
     in the circular queue.

     The CCIIRRCCLLEEQQ__IINNIITT() macro initializes the circular queue referenced by
     _h_e_a_d.

     The circular queue can also be initialized statically by using the
     CCIIRRCCLLEEQQ__HHEEAADD__IINNIITTIIAALLIIZZEERR() macro.

     The CCIIRRCCLLEEQQ__IINNSSEERRTT__HHEEAADD() macro inserts the new element _e_l_m at the head
     of the circular queue.

     The CCIIRRCCLLEEQQ__IINNSSEERRTT__TTAAIILL() macro inserts the new element _e_l_m at the end of
     the circular queue.

     The CCIIRRCCLLEEQQ__IINNSSEERRTT__AAFFTTEERR() macro inserts the new element _e_l_m after the
     element _l_i_s_t_e_l_m.

     The CCIIRRCCLLEEQQ__IINNSSEERRTT__BBEEFFOORREE() macro inserts the new element _e_l_m before the
     element _l_i_s_t_e_l_m.

     The CCIIRRCCLLEEQQ__RREEMMOOVVEE() macro removes the element _e_l_m from the circular
     queue.

     The CCIIRRCCLLEEQQ__FFIIRRSSTT(), CCIIRRCCLLEEQQ__LLAASSTT(), CCIIRRCCLLEEQQ__EENNDD(), CCIIRRCCLLEEQQ__NNEEXXTT() and
     CCIIRRCCLLEEQQ__PPRREEVV() macros can be used to traverse a circular queue.  The
     CCIIRRCCLLEEQQ__FFOORREEAACCHH() is used for circular queue forward traversal

           CIRCLEQ_FOREACH(np, head, NAME)

     The CCIIRRCCLLEEQQ__FFOORREEAACCHH__RREEVVEERRSSEE() macro acts like CCIIRRCCLLEEQQ__FFOORREEAACCHH() but tra-
     verses the circular queue backwards.

     The CCIIRRCCLLEEQQ__EEMMPPTTYY() macro should be used to check whether a circular
     queue is empty.

CCIIRRCCUULLAARR QQUUEEUUEE EEXXAAMMPPLLEE
     CIRCLEQ_HEAD(circleq, entry) head;
     struct circleq *headp;                  /* Circular queue head. */
     struct entry {
             ...
             CIRCLEQ_ENTRY entries;          /* Circular queue. */
             ...
     } *n1, *n2, *np;

     CIRCLEQ_INIT(&head);                    /* Initialize the circular queue. */

     n1 = malloc(sizeof(struct entry));      /* Insert at the head. */
     CIRCLEQ_INSERT_HEAD(&head, n1, entries);

     n1 = malloc(sizeof(struct entry));      /* Insert at the tail. */
     CIRCLEQ_INSERT_TAIL(&head, n1, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert after. */
     CIRCLEQ_INSERT_AFTER(&head, n1, n2, entries);

     n2 = malloc(sizeof(struct entry));      /* Insert before. */
     CIRCLEQ_INSERT_BEFORE(&head, n1, n2, entries);
                                             /* Forward traversal. */
     for (np = CIRCLEQ_FIRST(&head); np != CIRCLEQ_END(&head);
         np = CIRCLEQ_NEXT(np, entries))
             np-> ...
                                             /* Reverse traversal. */
     for (np = CIRCLEQ_LAST(&head); np != CIRCLEQ_END(&head);
         np = CIRCLEQ_PREV(np, entries))
             np-> ...
                                             /* Delete. */
     while (CIRCLEQ_FIRST(&head) != CIRCLEQ_END(&head))
             CIRCLEQ_REMOVE(&head, CIRCLEQ_FIRST(&head), entries);

NNOOTTEESS
     The SSLLIISSTT__EENNDD(), LLIISSTT__EENNDD(), SSIIMMPPLLEEQQ__EENNDD() and TTAAIILLQQ__EENNDD() macros are
     provided for symmetry with CCIIRRCCLLEEQQ__EENNDD().  They expand to NULL and don't
     serve any useful purpose.

     Trying to free a list in the following way is a common error:

           LIST_FOREACH(var, head, entry)
                   free(var);
           free(head);

     Since _v_a_r is free'd, the FFOORREEAACCHH() macro refers to a pointer that may
     have been reallocated already.  Proper code needs a second variable.

           for (var = LIST_FIRST(head); var != LIST_END(head); var = nxt) {
                   nxt = LIST_NEXT(var);
                   free(var);
           }
           LIST_INIT(head);        /* to put the list back in order */

HHIISSTTOORRYY
     The qquueeuuee functions first appeared in 4.4BSD.

OpenBSD 2.9                    December 13, 1993                            11
