SET(FEAST_SEARCH_PATHS ${FEAST_DIR})

FIND_LIBRARY(FEAST_LIB NAMES pfeast feast PATHS ${FEAST_SEARCH_PATHS})

SET(FEAST_FOUND FALSE)
IF (FEAST_LIB)
  SET(FEAST_FOUND TRUE)
    MARK_AS_ADVANCED(FEAST_LIB)
ENDIF (FEAST_LIB)

IF (FEAST_FOUND)
  IF (NOT FEAST_LIB_FIND_QUIETLY)
     MESSAGE(STATUS "Found Feast : ${FEAST_LIB}")
     GET_FILENAME_COMPONENT(FEAST_PATH ${FEAST_LIB} PATH CACHE)
     SET(FEAST_INCLUDE_DIR "${FEAST_PATH}/../include/feast" CACHE FILEPATH "FEAST include directory.")
  ENDIF (NOT FEAST_LIB_FIND_QUIETLY)
ELSE(FEAST_FOUND)
  IF (Feast_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find Feast")
  ENDIF (Feast_FIND_REQUIRED)
ENDIF (FEAST_FOUND)
