
//=============================================================================
/**
 *  @file    be_visitor_decl.cpp
 *
 *  Visitor for the base be_decl node. This serves to maintain the current
 *  state (context) of code generation for the derived visitor.
 *
 *  @author Aniruddha Gokhale
 */
//=============================================================================

#include "be_visitor_decl.h"
#include "be_visitor_sequence.h"
#include "be_visitor_context.h"
#include "be_typedef.h"
#include "be_type.h"
#include "ace/Log_Msg.h"

be_visitor_decl::be_visitor_decl (be_visitor_context *ctx)
  : ctx_ (ctx),
    os_ (*ctx->stream ())
{
}

be_visitor_decl::~be_visitor_decl ()
{
}

be_visitor_context *
be_visitor_decl::ctx ()
{
  return this->ctx_;
}

int
be_visitor_decl::gen_anonymous_base_type (be_type *bt,
                                          TAO_CodeGen::CG_STATE cg_state)
{
  be_typedef *tdef = dynamic_cast<be_typedef*> (bt);

  if (!tdef)
    {
      be_visitor_context ctx (*this->ctx_);
      ctx.state (cg_state);

      // In case our container was typedef'd.
      ctx.tdef (nullptr);

      int status = 0;

      switch (cg_state)
      {
        case TAO_CodeGen::TAO_ROOT_CH:
          {
            be_visitor_sequence_ch visitor (&ctx);
            status = bt->accept (&visitor);
            break;
          }
        case TAO_CodeGen::TAO_ROOT_CI:
          {
            break;
          }
        case TAO_CodeGen::TAO_ROOT_CS:
          {
            be_visitor_sequence_cs visitor (&ctx);
            status = bt->accept (&visitor);
            break;
          }
        case TAO_CodeGen::TAO_ROOT_CDR_OP_CS:
          {
            be_visitor_sequence_cdr_op_cs visitor (&ctx);
            status = bt->accept (&visitor);
            break;
          }
        default:
          ACE_ERROR_RETURN ((LM_ERROR,
                             "(%N:%l) be_visitor_decl::"
                             "gen_anonymous_base_type - "
                             "bad context state\n"),
                            -1);
      }

      if (status == -1)
        {
          ACE_ERROR_RETURN ((LM_ERROR,
                             "(%N:%l) be_visitor_decl::"
                             "gen_anonymous_base_type - "
                             "anonymous base type codegen failed\n"),
                            -1);
        }
    }

  return 0;
}
