/* Generated by re2c 0.13.5 on Tue Nov 18 20:30:04 2008 */
/*
 * token.re
 *
 * $Author$
 * $Date$
 *
 * Copyright (C) 2003 why the lucky stiff
 */
#include "syck.h"

#if GRAM_FILES_HAVE_TAB_SUFFIX
#include "gram.tab.h"
#else
#include "gram.h"
#endif

/*
 * Allocate quoted strings in chunks
 */
#define QUOTELEN    1024

/*
 * They do my bidding...
 */
#define YYCTYPE     char
#define YYCURSOR    parser->cursor
#define YYMARKER    parser->marker
#define YYLIMIT     parser->limit
#define YYTOKEN     parser->token
#define YYTOKTMP    parser->toktmp
#define YYLINEPTR   parser->lineptr
#define YYLINECTPTR parser->linectptr
#define YYLINE      parser->linect
#define YYFILL(n)   syck_parser_read(parser)

/*
 * Repositions the cursor at `n' offset from the token start.
 * Only works in `Header' and `Document' sections.
 */
#define YYPOS(n)    YYCURSOR = YYTOKEN + n

/*
 * Track line numbers
 */
#define NEWLINE(ptr)    YYLINEPTR = ptr + newline_len(ptr); if ( YYLINEPTR > YYLINECTPTR ) { YYLINE++; YYLINECTPTR = YYLINEPTR; }

/*
 * I like seeing the level operations as macros...
 */
#define ADD_LEVEL(len, status)  syck_parser_add_level( parser, len, status )
#define POP_LEVEL()     syck_parser_pop_level( parser )
#define CURRENT_LEVEL() syck_parser_current_level( parser )

/*
 * Force a token next time around sycklex()
 */
#define FORCE_NEXT_TOKEN(tok)    parser->force_token = tok;

/*
 * Nice little macro to ensure we're YAML_IOPENed to the current level.
 * * Only use this macro in the "Document" section *
 */
#define ENSURE_YAML_IOPEN(last_lvl, to_len, reset) \
        if ( last_lvl->spaces < to_len ) \
        { \
            if ( last_lvl->status == syck_lvl_iseq || last_lvl->status == syck_lvl_imap ) \
            { \
                goto Document; \
            } \
            else \
            { \
                ADD_LEVEL( to_len, syck_lvl_doc ); \
                if ( reset == 1 ) YYPOS(0); \
                return YAML_IOPEN; \
            } \
        } 

/*
 * Nice little macro to ensure closure of levels.
 * * Only use this macro in the "Document" section *
 */
#define ENSURE_YAML_IEND(last_lvl, to_len) \
        if ( last_lvl->spaces > to_len ) \
        { \
            syck_parser_pop_level( parser ); \
            YYPOS(0); \
            return YAML_IEND; \
        }

/*
 * Concatenates quoted string items and manages allocation
 * to the quoted string
 */
#define QUOTECAT(s, c, i, l) \
        { \
            if ( i + 1 >= c ) \
            { \
                c += QUOTELEN; \
                S_REALLOC_N( s, char, c ); \
            } \
            s[i++] = l; \
            s[i] = '\0'; \
        }

#define QUOTECATS(s, c, i, cs, cl) \
        { \
            while ( i + cl >= c ) \
            { \
                c += QUOTELEN; \
                S_REALLOC_N( s, char, c ); \
            } \
            S_MEMCPY( s + i, cs, char, cl ); \
            i += cl; \
            s[i] = '\0'; \
        }

/*
 * Tags a plain scalar with a transfer method
 * * Use only in "Plain" section *
 */
#define RETURN_IMPLICIT() \
    { \
        SyckNode *n = syck_alloc_str(); \
        YYCURSOR = YYTOKEN; \
        n->data.str->ptr = qstr; \
        n->data.str->len = qidx; \
        n->data.str->style = scalar_plain; \
        sycklval->nodeData = n; \
        if ( parser->implicit_typing == 1 ) \
        { \
            try_tag_implicit( sycklval->nodeData, parser->taguri_expansion ); \
        } \
        return YAML_PLAIN; \
    }

/* concat the inline characters to the plain scalar */
#define PLAIN_NOT_INL() \
    if ( *(YYCURSOR - 1) == ' ' || is_newline( YYCURSOR - 1 ) ) \
    { \
        YYCURSOR--; \
    } \
    QUOTECATS(qstr, qcapa, qidx, YYTOKEN, YYCURSOR - YYTOKEN); \
    goto Plain2;

/* trim spaces off the end in case of indent */
#define PLAIN_IS_INL() \
    char *walker = qstr + qidx - 1; \
    while ( walker > qstr && ( *walker == '\n' || *walker == ' ' || *walker == '\t' ) ) \
    { \
        qidx--; \
        walker[0] = '\0'; \
        walker--; \
    }

/*
 * Keep or chomp block?
 * * Use only in "ScalarBlock" section *
 */
#define RETURN_YAML_BLOCK() \
    { \
        SyckNode *n = syck_alloc_str(); \
        if ( ((SyckParser *)parser)->taguri_expansion == 1 ) \
        { \
            n->type_id = syck_taguri( YAML_DOMAIN, "str", 3 ); \
        } \
        else \
        { \
            n->type_id = syck_strndup( "str", 3 ); \
        } \
        n->data.str->ptr = qstr; \
        n->data.str->len = qidx; \
        if ( blockType == BLOCK_LIT ) { \
            n->data.str->style = scalar_literal; \
        } else { \
            n->data.str->style = scalar_fold; \
        } \
        if ( qidx > 0 ) \
        { \
            if ( nlDoWhat != NL_KEEP ) \
            { \
                char *fc = n->data.str->ptr + n->data.str->len - 1; \
                while ( is_newline( fc ) ) fc--; \
                if ( nlDoWhat != NL_CHOMP && fc < n->data.str->ptr + n->data.str->len - 1 ) \
                    fc += 1; \
                n->data.str->len = fc - n->data.str->ptr + 1; \
            } \
        } \
        sycklval->nodeData = n; \
        return YAML_BLOCK; \
    }

/*
 * Handles newlines, calculates indent
 */
#define GOBBLE_UP_YAML_INDENT( ict, start ) \
    char *indent = start; \
    NEWLINE(indent); \
    while ( indent < YYCURSOR ) \
    { \
        if ( *indent == '\t' ) \
        { \
            syckerror("TAB found in your indentation, please remove"); \
            return 0; \
        } \
        else if ( is_newline( ++indent ) ) \
        { \
            NEWLINE(indent); \
        } \
    } \
    ict = 0; \
    if ( *YYCURSOR == '\0' ) \
    { \
        ict = -1; \
        start = YYCURSOR - 1; \
    } \
    else if ( *YYLINEPTR == ' ' ) \
    { \
        ict = YYCURSOR - YYLINEPTR; \
    }

/*
 * If an indent exists at the current level, back up.
 */
#define GET_TRUE_YAML_INDENT(indt_len) \
    { \
        SyckLevel *lvl_deep = CURRENT_LEVEL(); \
        indt_len = lvl_deep->spaces; \
        if ( lvl_deep->status == syck_lvl_seq || ( indt_len == YYCURSOR - YYLINEPTR && lvl_deep->status != syck_lvl_map )  ) \
        { \
            SyckLevel *lvl_over; \
            parser->lvl_idx--; \
            lvl_over = CURRENT_LEVEL(); \
            indt_len = lvl_over->spaces; \
            parser->lvl_idx++; \
        } \
    }

/*
 * Argjh!  I hate globals!  Here for syckerror() only!
 */
SyckParser *syck_parser_ptr = NULL;

/*
 * Accessory funcs later in this file.
 */
void eat_comments( SyckParser * );
char escape_seq( char );
int is_newline( char *ptr );
int newline_len( char *ptr );
int sycklex_yaml_utf8( YYSTYPE *, SyckParser * );
int sycklex_bytecode_utf8( YYSTYPE *, SyckParser * );
int syckwrap();

/*
 * My own re-entrant sycklex() using re2c.
 * You really get used to the limited regexp.
 * It's really nice to not rely on backtracking and such.
 */
int
sycklex( YYSTYPE *sycklval, SyckParser *parser )
{
    switch ( parser->input_type )
    {
        case syck_yaml_utf8:
        return sycklex_yaml_utf8( sycklval, parser );

        case syck_yaml_utf16:
            syckerror( "UTF-16 is not currently supported in Syck.\nPlease contribute code to help this happen!" );
        break;

        case syck_yaml_utf32:
            syckerror( "UTF-32 is not currently supported in Syck.\nPlease contribute code to help this happen!" );
        break;

        case syck_bytecode_utf8:
        return sycklex_bytecode_utf8( sycklval, parser );
    }
    return YAML_DOCSEP;
}

/*
 * Parser for standard YAML [UTF-8]
 */
int
sycklex_yaml_utf8( YYSTYPE *sycklval, SyckParser *parser )
{
    int doc_level = 0;
    syck_parser_ptr = parser;
    if ( YYCURSOR == NULL ) 
    {
        syck_parser_read( parser );
    }

    if ( parser->force_token != 0 )
    {
        int t = parser->force_token;
        parser->force_token = 0;
        return t;
    }



    if ( YYLINEPTR != YYCURSOR )
    {
        goto Document;
    }

Header:

    YYTOKEN = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy7;
	case '\t':
	case ' ':	goto yy12;
	case '\n':	goto yy9;
	case '\r':	goto yy11;
	case '#':	goto yy5;
	case '-':	goto yy2;
	case '.':	goto yy4;
	default:	goto yy14;
	}
yy2:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy30;
	default:	goto yy3;
	}
yy3:
	{   YYPOS(0);
                        goto Document; 
                    }
yy4:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy23;
	default:	goto yy3;
	}
yy5:
	++YYCURSOR;
	{   eat_comments( parser ); 
                        goto Header;
                    }
yy7:
	++YYCURSOR;
	{   SyckLevel *lvl = CURRENT_LEVEL();
                        ENSURE_YAML_IEND(lvl, -1);
                        YYPOS(0);
                        return 0; 
                    }
yy9:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy18;
yy10:
	{   GOBBLE_UP_YAML_INDENT( doc_level, YYTOKEN );
                        goto Header; 
                    }
yy11:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy17;
	default:	goto yy3;
	}
yy12:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy16;
yy13:
	{   doc_level = YYCURSOR - YYLINEPTR;
                        goto Header;
                    }
yy14:
	yych = *++YYCURSOR;
	goto yy3;
yy15:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy16:
	switch (yych) {
	case '\t':
	case ' ':	goto yy15;
	default:	goto yy13;
	}
yy17:
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy18:
	switch (yych) {
	case '\t':	goto yy17;
	case '\n':
	case ' ':	goto yy19;
	case '\r':	goto yy21;
	default:	goto yy10;
	}
yy19:
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy19;
	case '\r':	goto yy21;
	default:	goto yy10;
	}
yy21:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy19;
	default:	goto yy22;
	}
yy22:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy3;
	case 1: 	goto yy10;
	}
yy23:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy24;
	default:	goto yy22;
	}
yy24:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy25;
	case '\r':	goto yy29;
	case ' ':	goto yy27;
	default:	goto yy22;
	}
yy25:
	++YYCURSOR;
yy26:
	{   SyckLevel *lvl = CURRENT_LEVEL();
                        if ( lvl->status == syck_lvl_header )
                        {
                            goto Header; 
                        }
                        else
                        {
                            ENSURE_YAML_IEND(lvl, -1);
                            YYPOS(0);
                            return 0; 
                        }
                        return 0; 
                    }
yy27:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy27;
	default:	goto yy26;
	}
yy29:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy25;
	default:	goto yy22;
	}
yy30:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy31;
	default:	goto yy22;
	}
yy31:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy32;
	case '\r':	goto yy36;
	case ' ':	goto yy34;
	default:	goto yy22;
	}
yy32:
	++YYCURSOR;
yy33:
	{   SyckLevel *lvl = CURRENT_LEVEL();
                        if ( lvl->status == syck_lvl_header )
                        {
                            YYPOS(3);
                            goto Directive; 
                        }
                        else
                        {
                            ENSURE_YAML_IEND(lvl, -1);
                            YYPOS(0);
                            return 0; 
                        }
                    }
yy34:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy34;
	default:	goto yy33;
	}
yy36:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy32;
	default:	goto yy22;
	}
}


Document:
    {
        SyckLevel *lvl = CURRENT_LEVEL();
        if ( lvl->status == syck_lvl_header )
        {
            lvl->status = syck_lvl_doc;
        }

        YYTOKEN = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy64;
	case '\t':
	case ' ':	goto yy62;
	case '\n':	goto yy39;
	case '\r':	goto yy41;
	case '!':	goto yy53;
	case '"':	goto yy57;
	case '#':	goto yy60;
	case '&':	goto yy51;
	case '\'':	goto yy55;
	case '*':	goto yy52;
	case ',':
	case ':':	goto yy49;
	case '-':
	case '?':	goto yy50;
	case '>':
	case '|':	goto yy59;
	case '[':	goto yy43;
	case ']':
	case '}':	goto yy47;
	case '{':	goto yy45;
	default:	goto yy66;
	}
yy39:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy94;
yy40:
	{   /* Isolate spaces */
                        int indt_len;
                        GOBBLE_UP_YAML_INDENT( indt_len, YYTOKEN );
                        lvl = CURRENT_LEVEL();
                        doc_level = 0;

                        /* XXX: Comment lookahead */
                        if ( *YYCURSOR == '#' )
                        {
                            goto Document;
                        }

                        /* Ignore indentation inside inlines */
                        if ( lvl->status == syck_lvl_iseq || lvl->status == syck_lvl_imap )
                        {
                            goto Document;
                        }

                        /* Check for open indent */
                        ENSURE_YAML_IEND(lvl, indt_len);
                        ENSURE_YAML_IOPEN(lvl, indt_len, 0);
                        if ( indt_len == -1 )
                        {
                            return 0;
                        }
                        return YAML_INDENT;
                    }
yy41:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy93;
	default:	goto yy42;
	}
yy42:
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        goto Plain; 
                    }
yy43:
	++YYCURSOR;
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        lvl = CURRENT_LEVEL();
                        ADD_LEVEL(lvl->spaces + 1, syck_lvl_iseq);
                        return YYTOKEN[0]; 
                    }
yy45:
	++YYCURSOR;
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        lvl = CURRENT_LEVEL();
                        ADD_LEVEL(lvl->spaces + 1, syck_lvl_imap);
                        return YYTOKEN[0]; 
                    }
yy47:
	++YYCURSOR;
	{   POP_LEVEL();
                        return YYTOKEN[0]; 
                    }
yy49:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy88;
	case '\r':	goto yy92;
	case ' ':	goto yy90;
	default:	goto yy42;
	}
yy50:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy83;
	case '\r':	goto yy87;
	case ' ':	goto yy85;
	default:	goto yy42;
	}
yy51:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy80;
	default:	goto yy42;
	}
yy52:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy77;
	default:	goto yy42;
	}
yy53:
	++YYCURSOR;
	{   goto TransferMethod; }
yy55:
	++YYCURSOR;
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        goto SingleQuote; }
yy57:
	++YYCURSOR;
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        goto DoubleQuote; }
yy59:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy72;
	case '\r':	goto yy76;
	case ' ':	goto yy74;
	case '+':
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy69;
	default:	goto yy42;
	}
yy60:
	++YYCURSOR;
	{   eat_comments( parser ); 
                        goto Document;
                    }
yy62:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy68;
yy63:
	{   goto Document; }
yy64:
	++YYCURSOR;
	{   ENSURE_YAML_IEND(lvl, -1);
                        YYPOS(0);
                        return 0; 
                    }
yy66:
	yych = *++YYCURSOR;
	goto yy42;
yy67:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy68:
	switch (yych) {
	case '\t':
	case ' ':	goto yy67;
	default:	goto yy63;
	}
yy69:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy72;
	case '\r':	goto yy76;
	case ' ':	goto yy74;
	case '+':
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy69;
	default:	goto yy71;
	}
yy71:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy40;
	case 1: 	goto yy42;
	}
yy72:
	++YYCURSOR;
yy73:
	{   if ( is_newline( YYCURSOR - 1 ) ) 
                        {
                            YYCURSOR--;
                        }
                        goto ScalarBlock; 
                    }
yy74:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy74;
	default:	goto yy73;
	}
yy76:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy72;
	default:	goto yy71;
	}
yy77:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy77;
	default:	goto yy79;
	}
yy79:
	{   ENSURE_YAML_IOPEN(lvl, doc_level, 1);
                        sycklval->name = syck_strndup( YYTOKEN + 1, YYCURSOR - YYTOKEN - 1 );
                        return YAML_ALIAS;
                    }
yy80:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy80;
	default:	goto yy82;
	}
yy82:
	{   sycklval->name = syck_strndup( YYTOKEN + 1, YYCURSOR - YYTOKEN - 1 );

                        /*
                         * Remove previous anchors of the same name.  Since the parser will likely
                         * construct deeper nodes first, we want those nodes to be placed in the
                         * queue for matching at a higher level of indentation.
                         */
                        syck_hdlr_remove_anchor(parser, sycklval->name);
                        return YAML_ANCHOR;
                    }
yy83:
	++YYCURSOR;
yy84:
	{   ENSURE_YAML_IOPEN(lvl, YYTOKEN - YYLINEPTR, 1);
                        FORCE_NEXT_TOKEN(YAML_IOPEN);
                        if ( *YYCURSOR == '#' || is_newline( YYCURSOR ) || is_newline( YYCURSOR - 1 ) )
                        {
                            YYCURSOR--; 
                            ADD_LEVEL((YYTOKEN + 1) - YYLINEPTR, syck_lvl_seq);
                        }
                        else /* spaces followed by content uses the space as indentation */
                        {
                            ADD_LEVEL(YYCURSOR - YYLINEPTR, syck_lvl_seq);
                        }
                        return YYTOKEN[0]; 
                    }
yy85:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy85;
	default:	goto yy84;
	}
yy87:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy83;
	default:	goto yy71;
	}
yy88:
	++YYCURSOR;
yy89:
	{   if ( *YYTOKEN == ':' && lvl->status != syck_lvl_imap && lvl->status != syck_lvl_iseq )
                        {
                            lvl->status = syck_lvl_map;
                        }
                        YYPOS(1); 
                        return YYTOKEN[0]; 
                    }
yy90:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy90;
	default:	goto yy89;
	}
yy92:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy88;
	default:	goto yy71;
	}
yy93:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy94:
	switch (yych) {
	case '\t':	goto yy93;
	case '\n':
	case ' ':	goto yy95;
	case '\r':	goto yy97;
	default:	goto yy40;
	}
yy95:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy95;
	case '\r':	goto yy97;
	default:	goto yy40;
	}
yy97:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy95;
	default:	goto yy71;
	}
}

    }

Directive:
    {
        YYTOKTMP = YYCURSOR;


{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy100;
	case '\t':
	case ' ':	goto yy103;
	case '%':	goto yy101;
	default:	goto yy105;
	}
yy100:
	YYCURSOR = YYMARKER;
	goto yy102;
yy101:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy108;
	default:	goto yy102;
	}
yy102:
	{   YYCURSOR = YYTOKTMP;
                        return YAML_DOCSEP;
                    }
yy103:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy107;
yy104:
	{   goto Directive; }
yy105:
	yych = *++YYCURSOR;
	goto yy102;
yy106:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy107:
	switch (yych) {
	case '\t':
	case ' ':	goto yy106;
	default:	goto yy104;
	}
yy108:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy108;
	case ':':	goto yy110;
	default:	goto yy100;
	}
yy110:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy111;
	default:	goto yy100;
	}
yy111:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy111;
	default:	goto yy113;
	}
yy113:
	{   goto Directive; }
}


    }

Plain:
    {
        int qidx = 0;
        int qcapa = 100;
        char *qstr = S_ALLOC_N( char, qcapa );
        SyckLevel *plvl;
        int parentIndent;

        YYCURSOR = YYTOKEN;
        plvl = CURRENT_LEVEL();
        GET_TRUE_YAML_INDENT(parentIndent);

Plain2: 
        YYTOKEN = YYCURSOR;

Plain3:


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy128;
	case '\t':	goto yy130;
	case '\n':	goto yy116;
	case '\r':	goto yy118;
	case ' ':	goto yy126;
	case ',':	goto yy121;
	case ':':	goto yy120;
	case ']':	goto yy124;
	case '}':	goto yy122;
	default:	goto yy131;
	}
yy116:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy146;
yy117:
	{   int indt_len, nl_count = 0;
                        SyckLevel *lvl;
                        char *tok = YYTOKEN;
                        GOBBLE_UP_YAML_INDENT( indt_len, tok );
                        lvl = CURRENT_LEVEL();

                        if ( indt_len <= parentIndent )
                        {
                            RETURN_IMPLICIT();
                        }

                        while ( YYTOKEN < YYCURSOR )
                        {
                            int nl_len = newline_len( YYTOKEN++ );
                            if ( nl_len )
                            {
                                nl_count++;
                                YYTOKEN += nl_len - 1;
                            }
                        }
                        if ( nl_count <= 1 )
                        {
                            QUOTECAT(qstr, qcapa, qidx, ' ');
                        }
                        else
                        {
                            int i;
                            for ( i = 0; i < nl_count - 1; i++ )
                            {
                                QUOTECAT(qstr, qcapa, qidx, '\n');
                            }
                        }

                        goto Plain2; 
                    }
yy118:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy145;
	default:	goto yy119;
	}
yy119:
	{   QUOTECATS(qstr, qcapa, qidx, YYTOKEN, YYCURSOR - YYTOKEN);
                        goto Plain2;
                    }
yy120:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy140;
	case '\r':	goto yy144;
	case ' ':	goto yy142;
	default:	goto yy119;
	}
yy121:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy134;
	case '\r':	goto yy138;
	case ' ':	goto yy136;
	default:	goto yy119;
	}
yy122:
	++YYCURSOR;
	{   if ( plvl->status != syck_lvl_imap )
                        {
                            PLAIN_NOT_INL();
                        }
                        else
                        {
                            PLAIN_IS_INL();
                        }
                        RETURN_IMPLICIT();
                    }
yy124:
	++YYCURSOR;
	{   if ( plvl->status != syck_lvl_iseq )
                        {
                            PLAIN_NOT_INL();
                        }
                        else
                        {
                            PLAIN_IS_INL();
                        }
                        RETURN_IMPLICIT();
                    }
yy126:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '#':	goto yy132;
	default:	goto yy127;
	}
yy127:
	{   if ( qidx == 0 ) 
                        {
                            goto Plain2;
                        }
                        else
                        {
                            goto Plain3; 
                        }
                    }
yy128:
	++YYCURSOR;
	{   RETURN_IMPLICIT(); }
yy130:
	yych = *++YYCURSOR;
	goto yy127;
yy131:
	yych = *++YYCURSOR;
	goto yy119;
yy132:
	++YYCURSOR;
	{   eat_comments( parser ); 
                        RETURN_IMPLICIT();
                    }
yy134:
	++YYCURSOR;
yy135:
	{   if ( plvl->status != syck_lvl_iseq && plvl->status != syck_lvl_imap )
                        {
                            PLAIN_NOT_INL();
                        }
                        else
                        {
                            PLAIN_IS_INL();
                        }
                        RETURN_IMPLICIT();
                    }
yy136:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy136;
	default:	goto yy135;
	}
yy138:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy134;
	default:	goto yy139;
	}
yy139:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy117;
	case 1: 	goto yy119;
	}
yy140:
	++YYCURSOR;
yy141:
	{   RETURN_IMPLICIT(); }
yy142:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy142;
	default:	goto yy141;
	}
yy144:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy140;
	default:	goto yy139;
	}
yy145:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy146:
	switch (yych) {
	case '\t':	goto yy145;
	case '\n':
	case ' ':	goto yy147;
	case '\r':	goto yy149;
	default:	goto yy117;
	}
yy147:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy147;
	case '\r':	goto yy149;
	default:	goto yy117;
	}
yy149:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy147;
	default:	goto yy139;
	}
}

    }

SingleQuote:
    {
        int qidx = 0;
        int qcapa = 100;
        char *qstr = S_ALLOC_N( char, qcapa );

SingleQuote2:
        YYTOKEN = YYCURSOR;


{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy158;
	case '\n':	goto yy152;
	case '\r':	goto yy154;
	case '\'':	goto yy156;
	default:	goto yy159;
	}
yy152:
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy163;
yy153:
	{   int indt_len;
                        int nl_count = 0;
                        SyckLevel *lvl;
                        GOBBLE_UP_YAML_INDENT( indt_len, YYTOKEN );
                        lvl = CURRENT_LEVEL();

                        if ( lvl->status != syck_lvl_str )
                        {
                            ADD_LEVEL( indt_len, syck_lvl_str );
                        }
                        else if ( indt_len < lvl->spaces )
                        {
                            /* Error! */
                        }

                        while ( YYTOKEN < YYCURSOR )
                        {
                            int nl_len = newline_len( YYTOKEN++ );
                            if ( nl_len )
                            {
                                nl_count++;
                                YYTOKEN += nl_len - 1;
                            }
                        }
                        if ( nl_count <= 1 )
                        {
                            QUOTECAT(qstr, qcapa, qidx, ' ');
                        }
                        else
                        {
                            int i;
                            for ( i = 0; i < nl_count - 1; i++ )
                            {
                                QUOTECAT(qstr, qcapa, qidx, '\n');
                            }
                        }

                        goto SingleQuote2; 
                    }
yy154:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy162;
	default:	goto yy155;
	}
yy155:
	{   QUOTECAT(qstr, qcapa, qidx, *(YYCURSOR - 1)); 
                        goto SingleQuote2; 
                    }
yy156:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\'':	goto yy160;
	default:	goto yy157;
	}
yy157:
	{   SyckLevel *lvl;
                        SyckNode *n = syck_alloc_str();
                        lvl = CURRENT_LEVEL();

                        if ( lvl->status == syck_lvl_str )
                        {
                            POP_LEVEL();
                        }
                        if ( ((SyckParser *)parser)->taguri_expansion == 1 )
                        {
                            n->type_id = syck_taguri( YAML_DOMAIN, "str", 3 );
                        }
                        else
                        {
                            n->type_id = syck_strndup( "str", 3 );
                        }
                        n->data.str->ptr = qstr;
                        n->data.str->len = qidx;
                        n->data.str->style = scalar_1quote;
                        sycklval->nodeData = n;
                        return YAML_PLAIN; 
                    }
yy158:
	yych = *++YYCURSOR;
	goto yy157;
yy159:
	yych = *++YYCURSOR;
	goto yy155;
yy160:
	++YYCURSOR;
	{   QUOTECAT(qstr, qcapa, qidx, '\'');
                        goto SingleQuote2; 
                    }
yy162:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy163:
	switch (yych) {
	case '\t':	goto yy162;
	case '\n':
	case ' ':	goto yy164;
	case '\r':	goto yy166;
	default:	goto yy153;
	}
yy164:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy164;
	case '\r':	goto yy166;
	default:	goto yy153;
	}
yy166:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy164;
	default:	goto yy167;
	}
yy167:
	YYCURSOR = YYMARKER;
	goto yy153;
}


    }


DoubleQuote:
    {
        int keep_nl = 1;
        int qidx = 0;
        int qcapa = 100;
        char *qstr = S_ALLOC_N( char, qcapa );

DoubleQuote2:
        YYTOKEN = YYCURSOR;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy175;
	case '\n':	goto yy170;
	case '\r':	goto yy172;
	case '"':	goto yy177;
	case '\\':	goto yy174;
	default:	goto yy178;
	}
yy170:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy192;
yy171:
	{   int indt_len;
                        int nl_count = 0;
                        SyckLevel *lvl;
                        GOBBLE_UP_YAML_INDENT( indt_len, YYTOKEN );
                        lvl = CURRENT_LEVEL();

                        if ( lvl->status != syck_lvl_str )
                        {
                            ADD_LEVEL( indt_len, syck_lvl_str );
                        }
                        else if ( indt_len < lvl->spaces )
                        {
                            /* FIXME */
                        }

                        if ( keep_nl == 1 )
                        {
                            while ( YYTOKEN < YYCURSOR )
                            {
                                int nl_len = newline_len( YYTOKEN++ );
                                if ( nl_len )
                                {
                                    nl_count++;
                                    YYTOKEN += nl_len - 1;
                                }
                            }
                            if ( nl_count <= 1 )
                            {
                                QUOTECAT(qstr, qcapa, qidx, ' ');
                            }
                            else
                            {
                                int i;
                                for ( i = 0; i < nl_count - 1; i++ )
                                {
                                    QUOTECAT(qstr, qcapa, qidx, '\n');
                                }
                            }
                        }

                        keep_nl = 1;
                        goto DoubleQuote2; 
                    }
yy172:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy191;
	default:	goto yy173;
	}
yy173:
	{   QUOTECAT(qstr, qcapa, qidx, *(YYCURSOR - 1)); 
                        goto DoubleQuote2; 
                    }
yy174:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\n':	goto yy182;
	case '\r':	goto yy184;
	case ' ':	goto yy179;
	case '"':
	case '0':
	case '\\':
	case 'a':
	case 'b':
	case 'e':
	case 'f':
	case 'n':
	case 'r':
	case 't':
	case 'v':	goto yy186;
	case 'x':	goto yy185;
	default:	goto yy173;
	}
yy175:
	++YYCURSOR;
yy176:
	{   SyckLevel *lvl;
                        SyckNode *n = syck_alloc_str();
                        lvl = CURRENT_LEVEL();

                        if ( lvl->status == syck_lvl_str )
                        {
                            POP_LEVEL();
                        }
                        if ( ((SyckParser *)parser)->taguri_expansion == 1 )
                        {
                            n->type_id = syck_taguri( YAML_DOMAIN, "str", 3 );
                        }
                        else
                        {
                            n->type_id = syck_strndup( "str", 3 );
                        }
                        n->data.str->ptr = qstr;
                        n->data.str->len = qidx;
                        n->data.str->style = scalar_2quote;
                        sycklval->nodeData = n;
                        return YAML_PLAIN; 
                    }
yy177:
	yych = *++YYCURSOR;
	goto yy176;
yy178:
	yych = *++YYCURSOR;
	goto yy173;
yy179:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy182;
	case '\r':	goto yy184;
	case ' ':	goto yy179;
	default:	goto yy181;
	}
yy181:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy171;
	case 1: 	goto yy173;
	}
yy182:
	++YYCURSOR;
	{   keep_nl = 0;
                        YYCURSOR--;
                        goto DoubleQuote2; 
                    }
yy184:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy182;
	default:	goto yy181;
	}
yy185:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy188;
	default:	goto yy181;
	}
yy186:
	++YYCURSOR;
	{   char ch = *( YYCURSOR - 1 );
                        QUOTECAT(qstr, qcapa, qidx, escape_seq( ch ));
                        goto DoubleQuote2; 
                    }
yy188:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy189;
	default:	goto yy181;
	}
yy189:
	++YYCURSOR;
	{   long ch;
                        char *chr_text = syck_strndup( YYTOKEN, 4 );
                        chr_text[0] = '0';
                        ch = strtol( chr_text, NULL, 16 );
                        free( chr_text );
                        QUOTECAT(qstr, qcapa, qidx, ch);
                        goto DoubleQuote2; 
                    }
yy191:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy192:
	switch (yych) {
	case '\t':	goto yy191;
	case '\n':
	case ' ':	goto yy193;
	case '\r':	goto yy195;
	default:	goto yy171;
	}
yy193:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy193;
	case '\r':	goto yy195;
	default:	goto yy171;
	}
yy195:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy193;
	default:	goto yy181;
	}
}

    }

TransferMethod:
    {
        int qidx = 0;
        int qcapa = 100;
        char *qstr = S_ALLOC_N( char, qcapa );

TransferMethod2:
        YYTOKTMP = YYCURSOR;


{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy198;
	case '\n':	goto yy200;
	case '\r':	goto yy202;
	case ' ':	goto yy201;
	case '\\':	goto yy204;
	default:	goto yy205;
	}
yy198:
	++YYCURSOR;
yy199:
	{   SyckLevel *lvl;
                        YYCURSOR = YYTOKTMP;
                        if ( YYCURSOR == YYTOKEN + 1 )
                        {
                            free( qstr );
                            return YAML_ITRANSFER;
                        }

                        lvl = CURRENT_LEVEL();

                        /*
                         * URL Prefixing
                         */
                        if ( *qstr == '^' )
                        {
                            sycklval->name = S_ALLOC_N( char, qidx + strlen( lvl->domain ) );
                            sycklval->name[0] = '\0';
                            strcat( sycklval->name, lvl->domain );
                            strncat( sycklval->name, qstr + 1, qidx - 1 );
                            free( qstr );
                        }
                        else
                        {
                            char *carat = qstr;
                            char *qend = qstr + qidx;
                            while ( (++carat) < qend )
                            {
                                if ( *carat == '^' )
                                    break;
                            }

                            if ( carat < qend )
                            {
                                free( lvl->domain );
                                lvl->domain = syck_strndup( qstr, carat - qstr );
                                sycklval->name = S_ALLOC_N( char, ( qend - carat ) + strlen( lvl->domain ) );
                                sycklval->name[0] = '\0';
                                strcat( sycklval->name, lvl->domain );
                                strncat( sycklval->name, carat + 1, ( qend - carat ) - 1 );
                                free( qstr );
                            }
                            else
                            {
                                sycklval->name = qstr;
                            }
                        }

                        return YAML_TRANSFER; 
                    }
yy200:
	yych = *++YYCURSOR;
	goto yy199;
yy201:
	yych = *++YYCURSOR;
	goto yy214;
yy202:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy198;
	default:	goto yy203;
	}
yy203:
	{   QUOTECAT(qstr, qcapa, qidx, *(YYCURSOR - 1)); 
                        goto TransferMethod2;
                    }
yy204:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '"':
	case '0':
	case '\\':
	case 'a':
	case 'b':
	case 'e':
	case 'f':
	case 'n':
	case 'r':
	case 't':
	case 'v':	goto yy208;
	case 'x':	goto yy206;
	default:	goto yy203;
	}
yy205:
	yych = *++YYCURSOR;
	goto yy203;
yy206:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy210;
	default:	goto yy207;
	}
yy207:
	YYCURSOR = YYMARKER;
	goto yy203;
yy208:
	++YYCURSOR;
	{  char ch = *( YYCURSOR - 1 );
                        QUOTECAT(qstr, qcapa, qidx, escape_seq( ch ));
                        goto TransferMethod2;
                    }
yy210:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy211;
	default:	goto yy207;
	}
yy211:
	++YYCURSOR;
	{   long ch;
                        char *chr_text = syck_strndup( YYTOKTMP, 4 );
                        chr_text[0] = '0';
                        ch = strtol( chr_text, NULL, 16 );
                        free( chr_text );
                        QUOTECAT(qstr, qcapa, qidx, ch);
                        goto TransferMethod2;
                    }
yy213:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy214:
	switch (yych) {
	case ' ':	goto yy213;
	default:	goto yy199;
	}
}

    }

ScalarBlock:
    {
        int qidx = 0;
        int qcapa = 100;
        char *qstr = S_ALLOC_N( char, qcapa );
        int blockType = 0;
        int nlDoWhat = 0;
        int lastIndent = 0;
        int forceIndent = -1;
        char *yyt = YYTOKEN;
        SyckLevel *lvl = CURRENT_LEVEL();
        int parentIndent = -1;

        switch ( *yyt )
        {
            case '|': blockType = BLOCK_LIT; break;
            case '>': blockType = BLOCK_FOLD; break;
        }

        while ( ++yyt <= YYCURSOR )
        {
            if ( *yyt == '-' )
            {
                nlDoWhat = NL_CHOMP;
            }
            else if ( *yyt == '+' )
            {
                nlDoWhat = NL_KEEP;
            }
            else if ( isdigit( *yyt ) )
            {
                forceIndent = strtol( yyt, NULL, 10 );
            }
        }

        qstr[0] = '\0';
        YYTOKEN = YYCURSOR;

ScalarBlock2:
        YYTOKEN = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy223;
	case '\n':	goto yy217;
	case '\r':	goto yy219;
	case '#':	goto yy221;
	case '-':	goto yy225;
	default:	goto yy226;
	}
yy217:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy236;
yy218:
	{   char *pacer;
                        char *tok = YYTOKEN;
                        int indt_len = 0, nl_count = 0, fold_nl = 0, nl_begin = 0;
                        GOBBLE_UP_YAML_INDENT( indt_len, tok );
                        lvl = CURRENT_LEVEL();

                        if ( lvl->status != syck_lvl_block )
                        {
                            GET_TRUE_YAML_INDENT(parentIndent);
                            if ( forceIndent > 0 ) forceIndent += parentIndent;
                            if ( indt_len > parentIndent )
                            {
                                int new_spaces = forceIndent > 0 ? forceIndent : indt_len;
                                ADD_LEVEL( new_spaces, syck_lvl_block );
                                lastIndent = indt_len - new_spaces;
                                nl_begin = 1;
                                lvl = CURRENT_LEVEL();
                            }
                            else
                            {
                                YYCURSOR = YYTOKEN;
                                RETURN_YAML_BLOCK();
                            }
                        }

                        /*
                         * Fold only in the event of two lines being on the leftmost
                         * indentation.
                         */
                        if ( blockType == BLOCK_FOLD && lastIndent == 0 && ( indt_len - lvl->spaces ) == 0 )
                        {
                            fold_nl = 1;
                        }

                        pacer = YYTOKEN;
                        while ( pacer < YYCURSOR )
                        {
                            int nl_len = newline_len( pacer++ );
                            if ( nl_len )
                            {
                                nl_count++;
                                pacer += nl_len - 1;
                            }
                        }

                        if ( fold_nl == 1 || nl_begin == 1 )
                        {
                            nl_count--;
                        }

                        if ( nl_count < 1 && nl_begin == 0 )
                        {
                            QUOTECAT(qstr, qcapa, qidx, ' ');
                        }
                        else
                        {
                            int i;
                            for ( i = 0; i < nl_count; i++ )
                            {
                                QUOTECAT(qstr, qcapa, qidx, '\n');
                            }
                        }

                        lastIndent = indt_len - lvl->spaces;
                        YYCURSOR -= lastIndent;

                        if ( indt_len < lvl->spaces )
                        {
                            POP_LEVEL();
                            YYCURSOR = YYTOKEN;
                            RETURN_YAML_BLOCK();
                        }
                        goto ScalarBlock2;
                    }
yy219:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy235;
	default:	goto yy220;
	}
yy220:
	{   QUOTECAT(qstr, qcapa, qidx, *YYTOKEN);
                        goto ScalarBlock2;
                    }
yy221:
	++YYCURSOR;
	{   lvl = CURRENT_LEVEL();
                        if ( lvl->status != syck_lvl_block )
                        {
                            eat_comments( parser );
                            YYTOKEN = YYCURSOR;
                        }
                        else
                        {
                            QUOTECAT(qstr, qcapa, qidx, *YYTOKEN);
                        }
                        goto ScalarBlock2;
                    }
yy223:
	++YYCURSOR;
	{   YYCURSOR--;
                        POP_LEVEL();
                        RETURN_YAML_BLOCK(); 
                    }
yy225:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy227;
	default:	goto yy220;
	}
yy226:
	yych = *++YYCURSOR;
	goto yy220;
yy227:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy229;
	default:	goto yy228;
	}
yy228:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy218;
	case 1: 	goto yy220;
	}
yy229:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy230;
	case '\r':	goto yy234;
	case ' ':	goto yy232;
	default:	goto yy228;
	}
yy230:
	++YYCURSOR;
yy231:
	{   if ( YYTOKEN == YYLINEPTR )
                        {
                            if ( blockType == BLOCK_FOLD && qidx > 0 )
                            {
                                qidx -= 1;
                            }
                            QUOTECAT(qstr, qcapa, qidx, '\n');
                            POP_LEVEL();
                            YYCURSOR = YYTOKEN;
                            RETURN_YAML_BLOCK();
                        }
                        else
                        {
                            QUOTECAT(qstr, qcapa, qidx, *YYTOKEN);
                            YYCURSOR = YYTOKEN + 1;
                            goto ScalarBlock2;
                        }
                    }
yy232:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case ' ':	goto yy232;
	default:	goto yy231;
	}
yy234:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\n':	goto yy230;
	default:	goto yy228;
	}
yy235:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy236:
	switch (yych) {
	case '\t':	goto yy235;
	case '\n':
	case ' ':	goto yy237;
	case '\r':	goto yy239;
	default:	goto yy218;
	}
yy237:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':
	case ' ':	goto yy237;
	case '\r':	goto yy239;
	default:	goto yy218;
	}
yy239:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy237;
	default:	goto yy228;
	}
}

    }

    return 0;

}

void
eat_comments( SyckParser *parser )
{
Comment:
    {
        YYTOKEN = YYCURSOR;


{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:	goto yy242;
	case '\n':	goto yy244;
	case '\r':	goto yy245;
	default:	goto yy247;
	}
yy242:
	++YYCURSOR;
yy243:
	{   YYCURSOR = YYTOKEN;
                        return;
                    }
yy244:
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy249;
yy245:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '\n':	goto yy248;
	default:	goto yy246;
	}
yy246:
	{   goto Comment; 
                    }
yy247:
	yych = *++YYCURSOR;
	goto yy246;
yy248:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy249:
	switch (yych) {
	case '\n':	goto yy248;
	case '\r':	goto yy250;
	default:	goto yy243;
	}
yy250:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\n':	goto yy248;
	default:	goto yy251;
	}
yy251:
	YYCURSOR = YYMARKER;
	goto yy243;
}


    }

}

char
escape_seq( char ch )
{
    switch ( ch )
    {
        case '0': return '\0';
        case 'a': return 7;
        case 'b': return '\010';
        case 'e': return '\033';
        case 'f': return '\014';
        case 'n': return '\n';
        case 'r': return '\015';
        case 't': return '\t';
        case 'v': return '\013';
        default: return ch;
    }
}

int
is_newline( char *ptr )
{
    return newline_len( ptr );
}

int
newline_len( char *ptr )
{
    if ( *ptr == '\n' )
        return 1;
    
    if ( *ptr == '\r' && *( ptr + 1 ) == '\n' )
        return 2;

    return 0;
}

int 
syckwrap()
{
    return 1;
}

void 
syckerror( const char *msg )
{
    if ( syck_parser_ptr->error_handler == NULL )
        syck_parser_ptr->error_handler = syck_default_error_handler;

    syck_parser_ptr->root = syck_parser_ptr->root_on_error;
    (syck_parser_ptr->error_handler)(syck_parser_ptr, msg);
}

