//===----------------------------------------------------------------------===//
//
// This source file is part of the Soto for AWS open source project
//
// Copyright (c) 2017-2020 the Soto project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of Soto project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//

// THIS FILE IS AUTOMATICALLY GENERATED by https://github.com/swift-aws/soto/blob/main/CodeGenerator/Sources/CodeGenerator/main.swift. DO NOT EDIT.

import Foundation
import SotoCore

public extension SNS {
    // MARK: Enums

    // MARK: Shapes

    struct AddPermissionInput: AWSEncodableShape {
        /// The action you want to allow for the specified principal(s). Valid values: Any Amazon SNS action name, for example Publish.
        @CustomCoding<StandardArrayCoder>
        public var actionName: [String]
        /// The AWS account IDs of the users (principals) who will be given access to the specified actions. The users must have AWS accounts, but do not need to be signed up for this service.
        @CustomCoding<StandardArrayCoder>
        public var aWSAccountId: [String]
        /// A unique identifier for the new policy statement.
        public let label: String
        /// The ARN of the topic whose access control policy you wish to modify.
        public let topicArn: String

        public init(actionName: [String], aWSAccountId: [String], label: String, topicArn: String) {
            self.actionName = actionName
            self.aWSAccountId = aWSAccountId
            self.label = label
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case actionName = "ActionName"
            case aWSAccountId = "AWSAccountId"
            case label = "Label"
            case topicArn = "TopicArn"
        }
    }

    struct CheckIfPhoneNumberIsOptedOutInput: AWSEncodableShape {
        /// The phone number for which you want to check the opt out status.
        public let phoneNumber: String

        public init(phoneNumber: String) {
            self.phoneNumber = phoneNumber
        }

        private enum CodingKeys: String, CodingKey {
            case phoneNumber
        }
    }

    struct CheckIfPhoneNumberIsOptedOutResponse: AWSDecodableShape {
        /// Indicates whether the phone number is opted out:    true – The phone number is opted out, meaning you cannot publish SMS messages to it.    false – The phone number is opted in, meaning you can publish SMS messages to it.
        public let isOptedOut: Bool?

        public init(isOptedOut: Bool? = nil) {
            self.isOptedOut = isOptedOut
        }

        private enum CodingKeys: String, CodingKey {
            case isOptedOut
        }
    }

    struct ConfirmSubscriptionInput: AWSEncodableShape {
        /// Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is true and the request has an AWS signature, then only the topic owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
        public let authenticateOnUnsubscribe: String?
        /// Short-lived token sent to an endpoint during the Subscribe action.
        public let token: String
        /// The ARN of the topic for which you wish to confirm a subscription.
        public let topicArn: String

        public init(authenticateOnUnsubscribe: String? = nil, token: String, topicArn: String) {
            self.authenticateOnUnsubscribe = authenticateOnUnsubscribe
            self.token = token
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case authenticateOnUnsubscribe = "AuthenticateOnUnsubscribe"
            case token = "Token"
            case topicArn = "TopicArn"
        }
    }

    struct ConfirmSubscriptionResponse: AWSDecodableShape {
        /// The ARN of the created subscription.
        public let subscriptionArn: String?

        public init(subscriptionArn: String? = nil) {
            self.subscriptionArn = subscriptionArn
        }

        private enum CodingKeys: String, CodingKey {
            case subscriptionArn = "SubscriptionArn"
        }
    }

    struct CreateEndpointResponse: AWSDecodableShape {
        /// EndpointArn returned from CreateEndpoint action.
        public let endpointArn: String?

        public init(endpointArn: String? = nil) {
            self.endpointArn = endpointArn
        }

        private enum CodingKeys: String, CodingKey {
            case endpointArn = "EndpointArn"
        }
    }

    struct CreatePlatformApplicationInput: AWSEncodableShape {
        /// For a list of attributes, see SetPlatformApplicationAttributes
        @CustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]
        /// Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters long.
        public let name: String
        /// The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).
        public let platform: String

        public init(attributes: [String: String], name: String, platform: String) {
            self.attributes = attributes
            self.name = name
            self.platform = platform
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case name = "Name"
            case platform = "Platform"
        }
    }

    struct CreatePlatformApplicationResponse: AWSDecodableShape {
        /// PlatformApplicationArn is returned.
        public let platformApplicationArn: String?

        public init(platformApplicationArn: String? = nil) {
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct CreatePlatformEndpointInput: AWSEncodableShape {
        /// For a list of attributes, see SetEndpointAttributes.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?
        /// Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.
        public let customUserData: String?
        /// PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
        public let platformApplicationArn: String
        /// Unique identifier created by the notification service for an app on a device. The specific name for Token will vary, depending on which notification service is being used. For example, when using APNS as the notification service, you need the device token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent is called the registration ID.
        public let token: String

        public init(attributes: [String: String]? = nil, customUserData: String? = nil, platformApplicationArn: String, token: String) {
            self.attributes = attributes
            self.customUserData = customUserData
            self.platformApplicationArn = platformApplicationArn
            self.token = token
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case customUserData = "CustomUserData"
            case platformApplicationArn = "PlatformApplicationArn"
            case token = "Token"
        }
    }

    struct CreateTopicInput: AWSEncodableShape {
        /// A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that the CreateTopic action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    DisplayName – The display name to use for a topic with SMS subscriptions.    Policy – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.   The following attribute applies only to server-side-encryption:    KmsMasterKeyId - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms. For more examples, see KeyId in the AWS Key Management Service API Reference.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?
        /// The name of the topic you want to create. Constraints: Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
        public let name: String
        /// The list of tags to add to a new topic.  To be able to tag a topic on creation, you must have the sns:CreateTopic and sns:TagResource permissions.
        @OptionalCustomCoding<StandardArrayCoder>
        public var tags: [Tag]?

        public init(attributes: [String: String]? = nil, name: String, tags: [Tag]? = nil) {
            self.attributes = attributes
            self.name = name
            self.tags = tags
        }

        public func validate(name: String) throws {
            try tags?.forEach {
                try $0.validate(name: "\(name).tags[]")
            }
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case name = "Name"
            case tags = "Tags"
        }
    }

    struct CreateTopicResponse: AWSDecodableShape {
        /// The Amazon Resource Name (ARN) assigned to the created topic.
        public let topicArn: String?

        public init(topicArn: String? = nil) {
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case topicArn = "TopicArn"
        }
    }

    struct DeleteEndpointInput: AWSEncodableShape {
        /// EndpointArn of endpoint to delete.
        public let endpointArn: String

        public init(endpointArn: String) {
            self.endpointArn = endpointArn
        }

        private enum CodingKeys: String, CodingKey {
            case endpointArn = "EndpointArn"
        }
    }

    struct DeletePlatformApplicationInput: AWSEncodableShape {
        /// PlatformApplicationArn of platform application object to delete.
        public let platformApplicationArn: String

        public init(platformApplicationArn: String) {
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct DeleteTopicInput: AWSEncodableShape {
        /// The ARN of the topic you want to delete.
        public let topicArn: String

        public init(topicArn: String) {
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case topicArn = "TopicArn"
        }
    }

    struct Endpoint: AWSDecodableShape {
        /// Attributes for endpoint.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?
        /// EndpointArn for mobile app and device.
        public let endpointArn: String?

        public init(attributes: [String: String]? = nil, endpointArn: String? = nil) {
            self.attributes = attributes
            self.endpointArn = endpointArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case endpointArn = "EndpointArn"
        }
    }

    struct GetEndpointAttributesInput: AWSEncodableShape {
        /// EndpointArn for GetEndpointAttributes input.
        public let endpointArn: String

        public init(endpointArn: String) {
            self.endpointArn = endpointArn
        }

        private enum CodingKeys: String, CodingKey {
            case endpointArn = "EndpointArn"
        }
    }

    struct GetEndpointAttributesResponse: AWSDecodableShape {
        /// Attributes include the following:    CustomUserData – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.    Enabled – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.    Token – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.  The device token for the iOS platform is returned in lowercase.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?

        public init(attributes: [String: String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
        }
    }

    struct GetPlatformApplicationAttributesInput: AWSEncodableShape {
        /// PlatformApplicationArn for GetPlatformApplicationAttributesInput.
        public let platformApplicationArn: String

        public init(platformApplicationArn: String) {
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct GetPlatformApplicationAttributesResponse: AWSDecodableShape {
        /// Attributes include the following:    EventEndpointCreated – Topic ARN to which EndpointCreated event notifications should be sent.    EventEndpointDeleted – Topic ARN to which EndpointDeleted event notifications should be sent.    EventEndpointUpdated – Topic ARN to which EndpointUpdate event notifications should be sent.    EventDeliveryFailure – Topic ARN to which DeliveryFailure event notifications should be sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?

        public init(attributes: [String: String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
        }
    }

    struct GetSMSAttributesInput: AWSEncodableShape {
        /// A list of the individual attribute names, such as MonthlySpendLimit, for which you want values. For all attribute names, see SetSMSAttributes. If you don't use this parameter, Amazon SNS returns all SMS attributes.
        @OptionalCustomCoding<StandardArrayCoder>
        public var attributes: [String]?

        public init(attributes: [String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes
        }
    }

    struct GetSMSAttributesResponse: AWSDecodableShape {
        /// The SMS attribute names and their values.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?

        public init(attributes: [String: String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes
        }
    }

    struct GetSubscriptionAttributesInput: AWSEncodableShape {
        /// The ARN of the subscription whose properties you want to get.
        public let subscriptionArn: String

        public init(subscriptionArn: String) {
            self.subscriptionArn = subscriptionArn
        }

        private enum CodingKeys: String, CodingKey {
            case subscriptionArn = "SubscriptionArn"
        }
    }

    struct GetSubscriptionAttributesResponse: AWSDecodableShape {
        /// A map of the subscription's attributes. Attributes in this map include the following:    ConfirmationWasAuthenticated – true if the subscription confirmation request was authenticated.    DeliveryPolicy – The JSON serialization of the subscription's delivery policy.    EffectiveDeliveryPolicy – The JSON serialization of the effective delivery policy that takes into account the topic delivery policy and account system defaults.    FilterPolicy – The filter policy JSON that is assigned to the subscription. For more information, see Amazon SNS Message Filtering in the Amazon SNS Developer Guide.    Owner – The AWS account ID of the subscription's owner.    PendingConfirmation – true if the subscription hasn't been confirmed. To confirm a pending subscription, call the ConfirmSubscription action with a confirmation token.    RawMessageDelivery – true if raw message delivery is enabled for the subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.    RedrivePolicy – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.    SubscriptionArn – The subscription's ARN.    TopicArn – The topic ARN that the subscription is associated with.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?

        public init(attributes: [String: String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
        }
    }

    struct GetTopicAttributesInput: AWSEncodableShape {
        /// The ARN of the topic whose properties you want to get.
        public let topicArn: String

        public init(topicArn: String) {
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case topicArn = "TopicArn"
        }
    }

    struct GetTopicAttributesResponse: AWSDecodableShape {
        /// A map of the topic's attributes. Attributes in this map include the following:    DeliveryPolicy – The JSON serialization of the topic's delivery policy.    DisplayName – The human-readable name used in the From field for notifications to email and email-json endpoints.    Owner – The AWS account ID of the topic's owner.    Policy – The JSON serialization of the topic's access control policy.    SubscriptionsConfirmed – The number of confirmed subscriptions for the topic.    SubscriptionsDeleted – The number of deleted subscriptions for the topic.    SubscriptionsPending – The number of subscriptions pending confirmation for the topic.    TopicArn – The topic's ARN.    EffectiveDeliveryPolicy – The JSON serialization of the effective delivery policy, taking system defaults into account.   The following attribute applies only to server-side-encryption:    KmsMasterKeyId - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms. For more examples, see KeyId in the AWS Key Management Service API Reference.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?

        public init(attributes: [String: String]? = nil) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
        }
    }

    struct ListEndpointsByPlatformApplicationInput: AWSEncodableShape {
        /// NextToken string is used when calling ListEndpointsByPlatformApplication action to retrieve additional records that are available after the first page results.
        public let nextToken: String?
        /// PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
        public let platformApplicationArn: String

        public init(nextToken: String? = nil, platformApplicationArn: String) {
            self.nextToken = nextToken
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct ListEndpointsByPlatformApplicationResponse: AWSDecodableShape {
        /// Endpoints returned for ListEndpointsByPlatformApplication action.
        @OptionalCustomCoding<StandardArrayCoder>
        public var endpoints: [Endpoint]?
        /// NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records are available after the first page results.
        public let nextToken: String?

        public init(endpoints: [Endpoint]? = nil, nextToken: String? = nil) {
            self.endpoints = endpoints
            self.nextToken = nextToken
        }

        private enum CodingKeys: String, CodingKey {
            case endpoints = "Endpoints"
            case nextToken = "NextToken"
        }
    }

    struct ListPhoneNumbersOptedOutInput: AWSEncodableShape {
        /// A NextToken string is used when you call the ListPhoneNumbersOptedOut action to retrieve additional records that are available after the first page of results.
        public let nextToken: String?

        public init(nextToken: String? = nil) {
            self.nextToken = nextToken
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken
        }
    }

    struct ListPhoneNumbersOptedOutResponse: AWSDecodableShape {
        /// A NextToken string is returned when you call the ListPhoneNumbersOptedOut action if additional records are available after the first page of results.
        public let nextToken: String?
        /// A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page can contain up to 100 phone numbers.
        @OptionalCustomCoding<StandardArrayCoder>
        public var phoneNumbers: [String]?

        public init(nextToken: String? = nil, phoneNumbers: [String]? = nil) {
            self.nextToken = nextToken
            self.phoneNumbers = phoneNumbers
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken
            case phoneNumbers
        }
    }

    struct ListPlatformApplicationsInput: AWSEncodableShape {
        /// NextToken string is used when calling ListPlatformApplications action to retrieve additional records that are available after the first page results.
        public let nextToken: String?

        public init(nextToken: String? = nil) {
            self.nextToken = nextToken
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
        }
    }

    struct ListPlatformApplicationsResponse: AWSDecodableShape {
        /// NextToken string is returned when calling ListPlatformApplications action if additional records are available after the first page results.
        public let nextToken: String?
        /// Platform applications returned when calling ListPlatformApplications action.
        @OptionalCustomCoding<StandardArrayCoder>
        public var platformApplications: [PlatformApplication]?

        public init(nextToken: String? = nil, platformApplications: [PlatformApplication]? = nil) {
            self.nextToken = nextToken
            self.platformApplications = platformApplications
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case platformApplications = "PlatformApplications"
        }
    }

    struct ListSubscriptionsByTopicInput: AWSEncodableShape {
        /// Token returned by the previous ListSubscriptionsByTopic request.
        public let nextToken: String?
        /// The ARN of the topic for which you wish to find subscriptions.
        public let topicArn: String

        public init(nextToken: String? = nil, topicArn: String) {
            self.nextToken = nextToken
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case topicArn = "TopicArn"
        }
    }

    struct ListSubscriptionsByTopicResponse: AWSDecodableShape {
        /// Token to pass along to the next ListSubscriptionsByTopic request. This element is returned if there are more subscriptions to retrieve.
        public let nextToken: String?
        /// A list of subscriptions.
        @OptionalCustomCoding<StandardArrayCoder>
        public var subscriptions: [Subscription]?

        public init(nextToken: String? = nil, subscriptions: [Subscription]? = nil) {
            self.nextToken = nextToken
            self.subscriptions = subscriptions
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case subscriptions = "Subscriptions"
        }
    }

    struct ListSubscriptionsInput: AWSEncodableShape {
        /// Token returned by the previous ListSubscriptions request.
        public let nextToken: String?

        public init(nextToken: String? = nil) {
            self.nextToken = nextToken
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
        }
    }

    struct ListSubscriptionsResponse: AWSDecodableShape {
        /// Token to pass along to the next ListSubscriptions request. This element is returned if there are more subscriptions to retrieve.
        public let nextToken: String?
        /// A list of subscriptions.
        @OptionalCustomCoding<StandardArrayCoder>
        public var subscriptions: [Subscription]?

        public init(nextToken: String? = nil, subscriptions: [Subscription]? = nil) {
            self.nextToken = nextToken
            self.subscriptions = subscriptions
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case subscriptions = "Subscriptions"
        }
    }

    struct ListTagsForResourceRequest: AWSEncodableShape {
        /// The ARN of the topic for which to list tags.
        public let resourceArn: String

        public init(resourceArn: String) {
            self.resourceArn = resourceArn
        }

        public func validate(name: String) throws {
            try validate(resourceArn, name: "resourceArn", parent: name, max: 1011)
            try validate(resourceArn, name: "resourceArn", parent: name, min: 1)
        }

        private enum CodingKeys: String, CodingKey {
            case resourceArn = "ResourceArn"
        }
    }

    struct ListTagsForResourceResponse: AWSDecodableShape {
        /// The tags associated with the specified topic.
        @OptionalCustomCoding<StandardArrayCoder>
        public var tags: [Tag]?

        public init(tags: [Tag]? = nil) {
            self.tags = tags
        }

        private enum CodingKeys: String, CodingKey {
            case tags = "Tags"
        }
    }

    struct ListTopicsInput: AWSEncodableShape {
        /// Token returned by the previous ListTopics request.
        public let nextToken: String?

        public init(nextToken: String? = nil) {
            self.nextToken = nextToken
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
        }
    }

    struct ListTopicsResponse: AWSDecodableShape {
        /// Token to pass along to the next ListTopics request. This element is returned if there are additional topics to retrieve.
        public let nextToken: String?
        /// A list of topic ARNs.
        @OptionalCustomCoding<StandardArrayCoder>
        public var topics: [Topic]?

        public init(nextToken: String? = nil, topics: [Topic]? = nil) {
            self.nextToken = nextToken
            self.topics = topics
        }

        private enum CodingKeys: String, CodingKey {
            case nextToken = "NextToken"
            case topics = "Topics"
        }
    }

    struct MessageAttributeValue: AWSEncodableShape {
        /// Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.
        public let binaryValue: Data?
        /// Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see Message Attribute Data Types.
        public let dataType: String
        /// Strings are Unicode with UTF8 binary encoding. For a list of code values, see ASCII Printable Characters.
        public let stringValue: String?

        public init(binaryValue: Data? = nil, dataType: String, stringValue: String? = nil) {
            self.binaryValue = binaryValue
            self.dataType = dataType
            self.stringValue = stringValue
        }

        private enum CodingKeys: String, CodingKey {
            case binaryValue = "BinaryValue"
            case dataType = "DataType"
            case stringValue = "StringValue"
        }
    }

    struct OptInPhoneNumberInput: AWSEncodableShape {
        /// The phone number to opt in.
        public let phoneNumber: String

        public init(phoneNumber: String) {
            self.phoneNumber = phoneNumber
        }

        private enum CodingKeys: String, CodingKey {
            case phoneNumber
        }
    }

    struct OptInPhoneNumberResponse: AWSDecodableShape {
        public init() {}
    }

    struct PlatformApplication: AWSDecodableShape {
        /// Attributes for platform application object.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?
        /// PlatformApplicationArn for platform application object.
        public let platformApplicationArn: String?

        public init(attributes: [String: String]? = nil, platformApplicationArn: String? = nil) {
            self.attributes = attributes
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct PublishInput: AWSEncodableShape {
        public struct _MessageAttributesEncoding: DictionaryCoderProperties { public static let entry: String? = "entry"; public static let key = "Name"; public static let value = "Value" }

        /// The message you want to send. If you are publishing to a topic and you want to send the same message to all transport protocols, include the text of the message as a String value. If you want to send different messages for each transport protocol, set the value of the MessageStructure parameter to json and use a JSON object for the Message parameter.   Constraints:   With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes, not 262,144 characters).   For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters. If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages, each fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word boundaries. The total size limit for a single SMS Publish action is 1,600 characters.   JSON-specific constraints:   Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.   The values will be parsed (unescaped) before they are used in outgoing messages.   Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).   Values have a minimum length of 0 (the empty string, "", is allowed).   Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit message sizes).   Non-string values will cause the key to be ignored.   Keys that do not correspond to supported transport protocols are ignored.   Duplicate keys are not allowed.   Failure to parse or validate any key or value in the message will cause the Publish call to return an error (no partial delivery).
        public let message: String
        /// Message attributes for Publish action.
        @OptionalCustomCoding<DictionaryCoder<_MessageAttributesEncoding, String, MessageAttributeValue>>
        public var messageAttributes: [String: MessageAttributeValue]?
        /// Set MessageStructure to json if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set MessageStructure to json, the value of the Message parameter must:    be a syntactically valid JSON object; and   contain at least a top-level JSON key of "default" with a value that is a string.   You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g., "http"). Valid value: json
        public let messageStructure: String?
        /// The phone number to which you want to deliver an SMS message. Use E.164 format. If you don't specify a value for the PhoneNumber parameter, you must specify a value for the TargetArn or TopicArn parameters.
        public let phoneNumber: String?
        /// Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This field will also be included, if present, in the standard JSON messages delivered to other endpoints. Constraints: Subjects must be ASCII text that begins with a letter, number, or punctuation mark; must not include line breaks or control characters; and must be less than 100 characters long.
        public let subject: String?
        /// If you don't specify a value for the TargetArn parameter, you must specify a value for the PhoneNumber or TopicArn parameters.
        public let targetArn: String?
        /// The topic you want to publish to. If you don't specify a value for the TopicArn parameter, you must specify a value for the PhoneNumber or TargetArn parameters.
        public let topicArn: String?

        public init(message: String, messageAttributes: [String: MessageAttributeValue]? = nil, messageStructure: String? = nil, phoneNumber: String? = nil, subject: String? = nil, targetArn: String? = nil, topicArn: String? = nil) {
            self.message = message
            self.messageAttributes = messageAttributes
            self.messageStructure = messageStructure
            self.phoneNumber = phoneNumber
            self.subject = subject
            self.targetArn = targetArn
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case message = "Message"
            case messageAttributes = "MessageAttributes"
            case messageStructure = "MessageStructure"
            case phoneNumber = "PhoneNumber"
            case subject = "Subject"
            case targetArn = "TargetArn"
            case topicArn = "TopicArn"
        }
    }

    struct PublishResponse: AWSDecodableShape {
        /// Unique identifier assigned to the published message. Length Constraint: Maximum 100 characters
        public let messageId: String?

        public init(messageId: String? = nil) {
            self.messageId = messageId
        }

        private enum CodingKeys: String, CodingKey {
            case messageId = "MessageId"
        }
    }

    struct RemovePermissionInput: AWSEncodableShape {
        /// The unique label of the statement you want to remove.
        public let label: String
        /// The ARN of the topic whose access control policy you wish to modify.
        public let topicArn: String

        public init(label: String, topicArn: String) {
            self.label = label
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case label = "Label"
            case topicArn = "TopicArn"
        }
    }

    struct SetEndpointAttributesInput: AWSEncodableShape {
        /// A map of the endpoint attributes. Attributes in this map include the following:    CustomUserData – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.    Enabled – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.    Token – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.
        @CustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]
        /// EndpointArn used for SetEndpointAttributes action.
        public let endpointArn: String

        public init(attributes: [String: String], endpointArn: String) {
            self.attributes = attributes
            self.endpointArn = endpointArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case endpointArn = "EndpointArn"
        }
    }

    struct SetPlatformApplicationAttributesInput: AWSEncodableShape {
        /// A map of the platform application attributes. Attributes in this map include the following:    PlatformCredential – The credential received from the notification service. For APNS and APNS_SANDBOX, PlatformCredential is private key. For GCM (Firebase Cloud Messaging), PlatformCredential is API key. For ADM, PlatformCredential is client secret.    PlatformPrincipal – The principal received from the notification service. For APNS and APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM (Firebase Cloud Messaging), there is no PlatformPrincipal. For ADM, PlatformPrincipal is client id.    EventEndpointCreated – Topic ARN to which EndpointCreated event notifications are sent.    EventEndpointDeleted – Topic ARN to which EndpointDeleted event notifications are sent.    EventEndpointUpdated – Topic ARN to which EndpointUpdate event notifications are sent.    EventDeliveryFailure – Topic ARN to which DeliveryFailure event notifications are sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.    SuccessFeedbackRoleArn – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.    FailureFeedbackRoleArn – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.    SuccessFeedbackSampleRate – Sample rate percentage (0-100) of successfully delivered messages.
        @CustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]
        /// PlatformApplicationArn for SetPlatformApplicationAttributes action.
        public let platformApplicationArn: String

        public init(attributes: [String: String], platformApplicationArn: String) {
            self.attributes = attributes
            self.platformApplicationArn = platformApplicationArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case platformApplicationArn = "PlatformApplicationArn"
        }
    }

    struct SetSMSAttributesInput: AWSEncodableShape {
        /// The default settings for sending SMS messages from your account. You can set values for the following attribute names:  MonthlySpendLimit – The maximum amount in USD that you are willing to spend each month to send SMS messages. When Amazon SNS determines that sending an SMS message would incur a cost that exceeds this limit, it stops sending SMS messages within minutes.  Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval, if you continue to send SMS messages, you will incur costs that exceed your limit.  By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the limit, submit an SNS Limit Increase case. For New limit value, enter your desired monthly spend limit. In the Use Case Description field, explain that you are requesting an SMS monthly spend limit increase.  DeliveryStatusIAMRole – The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log that includes the message price, the success or failure status, the reason for failure (if the message failed), the message dwell time, and other information.  DeliveryStatusSuccessSamplingRate – The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example, to write logs only for failed deliveries, set this value to 0. To write logs for 10% of your successful deliveries, set it to 10.  DefaultSenderID – A string, such as your business brand, that is displayed as the sender on the receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11 alphanumeric characters, and it must contain at least one letter.  DefaultSMSType – The type of SMS message that you will send by default. You can assign the following values:    Promotional – (Default) Noncritical messages, such as marketing messages. Amazon SNS optimizes the message delivery to incur the lowest cost.    Transactional – Critical messages that support customer transactions, such as one-time passcodes for multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the highest reliability.    UsageReportS3Bucket – The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The report includes the following information for each SMS message that was successfully delivered by your account:   Time that the message was published (in UTC)   Message ID   Destination phone number   Message type   Delivery status   Message price (in USD)   Part number (a message is split into multiple parts if it is too long for a single message)   Total number of parts   To receive the report, the bucket must have a policy that allows the Amazon SNS service principle to perform the s3:PutObject and s3:GetBucketLocation actions. For an example bucket policy and usage report, see Monitoring SMS Activity in the Amazon SNS Developer Guide.
        @CustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]

        public init(attributes: [String: String]) {
            self.attributes = attributes
        }

        private enum CodingKeys: String, CodingKey {
            case attributes
        }
    }

    struct SetSMSAttributesResponse: AWSDecodableShape {
        public init() {}
    }

    struct SetSubscriptionAttributesInput: AWSEncodableShape {
        /// A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that the SetTopicAttributes action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    FilterPolicy – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.    RawMessageDelivery – When set to true, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.    RedrivePolicy – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
        public let attributeName: String
        /// The new value for the attribute in JSON format.
        public let attributeValue: String?
        /// The ARN of the subscription to modify.
        public let subscriptionArn: String

        public init(attributeName: String, attributeValue: String? = nil, subscriptionArn: String) {
            self.attributeName = attributeName
            self.attributeValue = attributeValue
            self.subscriptionArn = subscriptionArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributeName = "AttributeName"
            case attributeValue = "AttributeValue"
            case subscriptionArn = "SubscriptionArn"
        }
    }

    struct SetTopicAttributesInput: AWSEncodableShape {
        /// A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that the SetTopicAttributes action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    DisplayName – The display name to use for a topic with SMS subscriptions.    Policy – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.   The following attribute applies only to server-side-encryption:    KmsMasterKeyId - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms. For more examples, see KeyId in the AWS Key Management Service API Reference.
        public let attributeName: String
        /// The new value for the attribute.
        public let attributeValue: String?
        /// The ARN of the topic to modify.
        public let topicArn: String

        public init(attributeName: String, attributeValue: String? = nil, topicArn: String) {
            self.attributeName = attributeName
            self.attributeValue = attributeValue
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributeName = "AttributeName"
            case attributeValue = "AttributeValue"
            case topicArn = "TopicArn"
        }
    }

    struct SubscribeInput: AWSEncodableShape {
        /// A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that the SetTopicAttributes action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    FilterPolicy – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.    RawMessageDelivery – When set to true, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.    RedrivePolicy – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
        @OptionalCustomCoding<StandardDictionaryCoder>
        public var attributes: [String: String]?
        /// The endpoint that you want to receive notifications. Endpoints vary by protocol:   For the http protocol, the (public) endpoint is a URL beginning with http://    For the https protocol, the (public) endpoint is a URL beginning with https://    For the email protocol, the endpoint is an email address   For the email-json protocol, the endpoint is an email address   For the sms protocol, the endpoint is a phone number of an SMS-enabled device   For the sqs protocol, the endpoint is the ARN of an Amazon SQS queue   For the application protocol, the endpoint is the EndpointArn of a mobile app and device.   For the lambda protocol, the endpoint is the ARN of an Amazon Lambda function.
        public let endpoint: String?
        /// The protocol you want to use. Supported protocols include:    http – delivery of JSON-encoded message via HTTP POST    https – delivery of JSON-encoded message via HTTPS POST    email – delivery of message via SMTP    email-json – delivery of JSON-encoded message via SMTP    sms – delivery of message via SMS    sqs – delivery of JSON-encoded message to an Amazon SQS queue    application – delivery of JSON-encoded message to an EndpointArn for a mobile app and device.    lambda – delivery of JSON-encoded message to an Amazon Lambda function.
        public let `protocol`: String
        /// Sets whether the response from the Subscribe request includes the subscription ARN, even if the subscription is not yet confirmed.   If you set this parameter to true, the response includes the ARN in all cases, even if the subscription is not yet confirmed. In addition to the ARN for confirmed subscriptions, the response also includes the pending subscription ARN value for subscriptions that aren't yet confirmed. A subscription becomes confirmed when the subscriber calls the ConfirmSubscription action with a confirmation token.    The default value is false.
        public let returnSubscriptionArn: Bool?
        /// The ARN of the topic you want to subscribe to.
        public let topicArn: String

        public init(attributes: [String: String]? = nil, endpoint: String? = nil, protocol: String, returnSubscriptionArn: Bool? = nil, topicArn: String) {
            self.attributes = attributes
            self.endpoint = endpoint
            self.protocol = `protocol`
            self.returnSubscriptionArn = returnSubscriptionArn
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case attributes = "Attributes"
            case endpoint = "Endpoint"
            case `protocol` = "Protocol"
            case returnSubscriptionArn = "ReturnSubscriptionArn"
            case topicArn = "TopicArn"
        }
    }

    struct SubscribeResponse: AWSDecodableShape {
        /// The ARN of the subscription if it is confirmed, or the string "pending confirmation" if the subscription requires confirmation. However, if the API request parameter ReturnSubscriptionArn is true, then the value is always the subscription ARN, even if the subscription requires confirmation.
        public let subscriptionArn: String?

        public init(subscriptionArn: String? = nil) {
            self.subscriptionArn = subscriptionArn
        }

        private enum CodingKeys: String, CodingKey {
            case subscriptionArn = "SubscriptionArn"
        }
    }

    struct Subscription: AWSDecodableShape {
        /// The subscription's endpoint (format depends on the protocol).
        public let endpoint: String?
        /// The subscription's owner.
        public let owner: String?
        /// The subscription's protocol.
        public let `protocol`: String?
        /// The subscription's ARN.
        public let subscriptionArn: String?
        /// The ARN of the subscription's topic.
        public let topicArn: String?

        public init(endpoint: String? = nil, owner: String? = nil, protocol: String? = nil, subscriptionArn: String? = nil, topicArn: String? = nil) {
            self.endpoint = endpoint
            self.owner = owner
            self.protocol = `protocol`
            self.subscriptionArn = subscriptionArn
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case endpoint = "Endpoint"
            case owner = "Owner"
            case `protocol` = "Protocol"
            case subscriptionArn = "SubscriptionArn"
            case topicArn = "TopicArn"
        }
    }

    struct Tag: AWSEncodableShape & AWSDecodableShape {
        /// The required key portion of the tag.
        public let key: String
        /// The optional value portion of the tag.
        public let value: String

        public init(key: String, value: String) {
            self.key = key
            self.value = value
        }

        public func validate(name: String) throws {
            try validate(key, name: "key", parent: name, max: 128)
            try validate(key, name: "key", parent: name, min: 1)
            try validate(value, name: "value", parent: name, max: 256)
            try validate(value, name: "value", parent: name, min: 0)
        }

        private enum CodingKeys: String, CodingKey {
            case key = "Key"
            case value = "Value"
        }
    }

    struct TagResourceRequest: AWSEncodableShape {
        /// The ARN of the topic to which to add tags.
        public let resourceArn: String
        /// The tags to be added to the specified topic. A tag consists of a required key and an optional value.
        @CustomCoding<StandardArrayCoder>
        public var tags: [Tag]

        public init(resourceArn: String, tags: [Tag]) {
            self.resourceArn = resourceArn
            self.tags = tags
        }

        public func validate(name: String) throws {
            try validate(resourceArn, name: "resourceArn", parent: name, max: 1011)
            try validate(resourceArn, name: "resourceArn", parent: name, min: 1)
            for tag in tags {
                try tag.validate(name: "\(name).tags[]")
            }
        }

        private enum CodingKeys: String, CodingKey {
            case resourceArn = "ResourceArn"
            case tags = "Tags"
        }
    }

    struct TagResourceResponse: AWSDecodableShape {
        public init() {}
    }

    struct Topic: AWSDecodableShape {
        /// The topic's ARN.
        public let topicArn: String?

        public init(topicArn: String? = nil) {
            self.topicArn = topicArn
        }

        private enum CodingKeys: String, CodingKey {
            case topicArn = "TopicArn"
        }
    }

    struct UnsubscribeInput: AWSEncodableShape {
        /// The ARN of the subscription to be deleted.
        public let subscriptionArn: String

        public init(subscriptionArn: String) {
            self.subscriptionArn = subscriptionArn
        }

        private enum CodingKeys: String, CodingKey {
            case subscriptionArn = "SubscriptionArn"
        }
    }

    struct UntagResourceRequest: AWSEncodableShape {
        /// The ARN of the topic from which to remove tags.
        public let resourceArn: String
        /// The list of tag keys to remove from the specified topic.
        @CustomCoding<StandardArrayCoder>
        public var tagKeys: [String]

        public init(resourceArn: String, tagKeys: [String]) {
            self.resourceArn = resourceArn
            self.tagKeys = tagKeys
        }

        public func validate(name: String) throws {
            try validate(resourceArn, name: "resourceArn", parent: name, max: 1011)
            try validate(resourceArn, name: "resourceArn", parent: name, min: 1)
            for tagKey in tagKeys {
                try validate(tagKey, name: "tagKeys[]", parent: name, max: 128)
                try validate(tagKey, name: "tagKeys[]", parent: name, min: 1)
            }
        }

        private enum CodingKeys: String, CodingKey {
            case resourceArn = "ResourceArn"
            case tagKeys = "TagKeys"
        }
    }

    struct UntagResourceResponse: AWSDecodableShape {
        public init() {}
    }
}
