/*
 * Decompiled with CFR 0.152.
 */
package smr.JavaDeps;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import smr.JavaDeps.DepNode;
import smr.JavaDeps.GraphCycleException;

public class DepTable {
    private String sourceFileName;
    private String packageName;
    private Hashtable alias;
    private Vector wildImport;
    private Hashtable table = new Hashtable();
    private String curKey;
    private DepNode curValue;
    private boolean isFirstDefinition;
    private Vector graphNodes;
    private String destDir;
    private String classList;
    private String stubList;
    private String lineSeparator;

    public DepTable(String string) {
        this.destDir = string;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void startFile(String string) {
        this.sourceFileName = string;
        this.packageName = null;
        this.alias = new Hashtable();
        this.wildImport = new Vector();
        this.curKey = null;
        this.curValue = null;
        this.isFirstDefinition = true;
    }

    public void startPackage(String string) {
        this.packageName = string;
    }

    public void addImport(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3.equals("*")) {
            this.wildImport.addElement(string2);
            return;
        }
        this.alias.put(string3, string);
    }

    public void startDefinition(String string) {
        Object object;
        String string2 = String.valueOf(this.packageName != null ? String.valueOf(this.packageName) + "." : "") + string;
        String string3 = "";
        if (this.destDir == null) {
            object = new File(this.sourceFileName);
            if (((File)object).getParent() != null) {
                string3 = String.valueOf(((File)object).getParent()) + File.separator;
            }
            int n = string2.lastIndexOf(46);
            string3 = String.valueOf(string3) + string2.substring(n + 1) + ".class";
        } else {
            string3 = String.valueOf(this.destDir) + File.separator + string2.replace('.', File.separatorChar) + ".class";
        }
        this.curKey = string2;
        if (this.isFirstDefinition) {
            this.isFirstDefinition = false;
            this.curValue = new DepNode(string2, string3, this.sourceFileName);
            object = this.alias.elements();
            while (object.hasMoreElements()) {
                this.addReference((String)object.nextElement());
            }
        } else {
            this.curValue.addClass(string2, string3);
        }
        this.table.put(this.curKey, this.curValue);
    }

    public void addReference(String string) {
        Object object;
        boolean bl;
        boolean bl2 = bl = string.lastIndexOf(46) >= 0;
        if (!bl && (object = (String)this.alias.get(string)) != null) {
            string = object;
            bl = true;
        }
        if (bl) {
            this.curValue.addLink(string);
            return;
        }
        if (this.packageName == null) {
            this.curValue.addLink(string);
        } else {
            this.curValue.addLink(String.valueOf(this.packageName) + "." + string);
        }
        object = this.wildImport.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            this.curValue.addLink(String.valueOf(string2) + "." + string);
        }
    }

    public void addReference(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addReference((String)enumeration.nextElement());
        }
    }

    public void addReference(String string, boolean bl) {
        if (bl) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                this.addReference(string.substring(0, n));
                return;
            }
        } else {
            this.addReference(string);
        }
    }

    public void hasNative() {
        this.curValue.setHasNative();
    }

    private void setGraphToWhite() {
        Enumeration enumeration = this.graphNodes.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode = (DepNode)enumeration.nextElement();
            depNode.colour = 0;
        }
    }

    private void addGraphNode(DepNode depNode) {
        this.graphNodes.addElement(depNode);
    }

    private void removeGraphNode(DepNode depNode) {
        this.graphNodes.removeElement(depNode);
    }

    private void removeGraphNode(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.graphNodes.removeElement(enumeration.nextElement());
        }
    }

    private void replaceGraphLinks(Vector vector, DepNode depNode) {
        Enumeration enumeration = this.graphNodes.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode2 = (DepNode)enumeration.nextElement();
            depNode2.replaceLink(vector, depNode);
        }
    }

    private void buildGraph(boolean bl) {
        if (bl) {
            System.err.println("Building graph ...");
            System.err.println();
        }
        this.graphNodes = new Vector();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode = (DepNode)enumeration.nextElement();
            if (depNode.colour != 0) continue;
            depNode.colour = (byte)2;
            this.addGraphNode(depNode);
            Enumeration enumeration2 = depNode.adjacent();
            depNode.clearLinks();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                DepNode depNode2 = (DepNode)this.table.get(string);
                if (depNode2 == null) continue;
                depNode.addLink(depNode2);
            }
            if (!bl) continue;
            System.err.println("NODE: " + depNode);
            System.err.println();
        }
        this.table = null;
    }

    private void collapseCycles(boolean bl) {
        boolean bl2;
        do {
            DepNode depNode;
            bl2 = false;
            this.setGraphToWhite();
            try {
                Enumeration enumeration = this.graphNodes.elements();
                while (enumeration.hasMoreElements()) {
                    depNode = (DepNode)enumeration.nextElement();
                    if (depNode.colour != 0) continue;
                    this.collapseVisit(depNode);
                }
            }
            catch (GraphCycleException graphCycleException) {
                bl2 = true;
                depNode = new DepNode(graphCycleException.nodeSet);
                if (bl) {
                    System.err.println("CYCLE: " + graphCycleException.nodeSet);
                    System.err.println();
                    System.err.println("Created node: " + depNode);
                    System.err.println();
                    System.err.println();
                }
                this.removeGraphNode(graphCycleException.nodeSet);
                this.addGraphNode(depNode);
                this.replaceGraphLinks(graphCycleException.nodeSet, depNode);
            }
        } while (bl2);
    }

    private void collapseVisit(DepNode depNode) throws GraphCycleException {
        depNode.colour = 1;
        Enumeration enumeration = depNode.adjacent();
        while (enumeration.hasMoreElements()) {
            DepNode depNode2 = (DepNode)enumeration.nextElement();
            if (depNode2.colour == 0) {
                this.collapseVisit(depNode2);
                continue;
            }
            if (depNode2.colour != 1) continue;
            throw new GraphCycleException(depNode2);
        }
        depNode.colour = (byte)2;
    }

    private void dumpVisit(DepNode depNode) {
        Object object;
        depNode.colour = 1;
        Enumeration enumeration = depNode.adjacent();
        while (enumeration.hasMoreElements()) {
            object = (DepNode)enumeration.nextElement();
            if (((DepNode)object).colour == 0) {
                this.dumpVisit((DepNode)object);
                continue;
            }
            if (((DepNode)object).colour != 1) continue;
            throw new RuntimeException("graph should be DAG!");
        }
        depNode.dump();
        this.classList = String.valueOf(this.classList) + " \\" + this.lineSeparator + "\t" + depNode.classFiles();
        object = depNode.stubFiles();
        if (object != null) {
            this.stubList = String.valueOf(this.stubList) + "\t" + (String)object + " \\" + this.lineSeparator;
        }
        depNode.colour = (byte)2;
    }

    public void dump(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3) {
        DepNode.emitComments = bl2;
        DepNode.buildStubs = bl3;
        DepNode.buildCommand = string;
        DepNode.headerBuildCommand = string2;
        if (bl2) {
            System.out.println("# -- Automatically generated by JavaDeps --");
            System.out.println();
        }
        if (bl) {
            System.err.println("Building dependencies graph");
        }
        this.buildGraph(bl);
        if (bl) {
            System.err.println("Collapsing dependency cycles");
        }
        this.collapseCycles(bl);
        if (bl) {
            System.err.println("Dumping...");
        }
        this.setGraphToWhite();
        this.classList = "";
        this.stubList = "";
        Enumeration enumeration = this.graphNodes.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode = (DepNode)enumeration.nextElement();
            if (depNode.colour != 0) continue;
            this.dumpVisit(depNode);
        }
        System.out.println();
        if (string2 != null) {
            System.out.println("STUBS = \\ " + this.lineSeparator + this.stubList + "# end of stubs list" + this.lineSeparator);
        }
        System.out.println(String.valueOf(string3) + " = " + this.classList + this.lineSeparator + "# end of classes list");
    }
}

