/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.ModuleBody;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.mapping.Environment;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class AutoloadProcedure
extends Procedure
implements Externalizable {
    String className;
    Procedure loaded;

    public AutoloadProcedure() {
    }

    public AutoloadProcedure(String string, String string2) {
        super(string);
        this.className = string2;
    }

    public Object apply0() {
        return this.getLoaded().apply0();
    }

    public Object apply1(Object object2) {
        return this.getLoaded().apply1(object2);
    }

    public Object apply2(Object object2, Object object3) {
        return this.getLoaded().apply2(object2, object3);
    }

    public Object apply3(Object object2, Object object3, Object object4) {
        return this.getLoaded().apply3(object2, object3, object4);
    }

    public Object apply4(Object object2, Object object3, Object object4, Object object5) {
        return this.getLoaded().apply4(object2, object3, object4, object5);
    }

    public Object applyN(Object[] objectArray) {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof AutoloadProcedure) {
            throw new InternalError("circularity in autoload of " + this.name());
        }
        return this.loaded.applyN(objectArray);
    }

    public Procedure getLoaded() {
        if (this.loaded == null) {
            this.load();
        }
        return this.loaded;
    }

    public Object getProperty(Object object2, Object object3) {
        Object object4 = super.getProperty(object2, null);
        if (object4 != null) {
            return object4;
        }
        return this.getLoaded().getProperty(object2, object3);
    }

    public Procedure getSetter() {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof HasSetter) {
            return this.loaded.getSetter();
        }
        return super.getSetter();
    }

    void load() {
        String string = this.name();
        try {
            this.loaded = (Procedure)Class.forName(this.className).newInstance();
            if (this.loaded == this) {
                this.throw_error("circularity detected");
            }
            Environment environment = Environment.getCurrent();
            if (this.loaded instanceof ModuleBody) {
                ClassMemberConstraint.defineAll(this.loaded, environment);
                ((ModuleBody)this.loaded).run();
                Procedure procedure = environment.getBinding(string).getProcedure();
                if (procedure == null || !(procedure instanceof Procedure)) {
                    this.throw_error("invalid ModuleBody class - does not define " + string);
                }
                this.loaded = procedure;
            } else if (string != null) {
                if (environment.getFunction(string) == this) {
                    environment.putFunction(string, this.loaded);
                }
                if (this.loaded.name() == null) {
                    this.loaded.setName(string);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throw_error("failed to find class ");
        }
        catch (InstantiationException instantiationException) {
            this.throw_error("failed to instantiate class ");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throw_error("illegal access in class ");
        }
    }

    public int numArgs() {
        return this.getLoaded().numArgs();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        if (this.name() != null) {
            printWriter.print(this.name());
        }
        printWriter.print('>');
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.className = (String)objectInput.readObject();
    }

    private void throw_error(String string) {
        this.loaded = null;
        throw new RuntimeException(String.valueOf(string) + this.className + " while autoloading " + (this.name() == null ? "" : this.name().toString()));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.className);
    }
}

