/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.FluidBinding;
import gnu.mapping.FluidConstraint;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;

public class Future
extends Thread {
    Object result;
    Future parent;
    public FluidBinding fluidBindings;
    Environment environment;
    InPort in;
    OutPort out;
    OutPort err;
    Exception exception;
    Procedure action;
    static Future defaultContext = null;

    public Future(Procedure procedure) {
        Environment environment;
        this.action = procedure;
        this.in = InPort.inDefault();
        this.out = OutPort.outDefault();
        this.err = OutPort.errDefault();
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            this.parent = (Future)thread2;
            environment = this.parent.environment;
        } else {
            environment = Environment.user();
        }
        this.environment = environment;
    }

    public Future(Procedure procedure, Environment environment) {
        this.action = procedure;
        Thread thread2 = Thread.currentThread();
        this.environment = environment;
    }

    public Future(Procedure procedure, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        this.action = procedure;
        Thread thread2 = Thread.currentThread();
        this.environment = environment;
        this.in = inPort;
        this.out = outPort;
        this.err = outPort2;
    }

    public static Future getContext() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return (Future)thread2;
        }
        if (defaultContext == null) {
            Future.getDefaultContext();
        }
        return defaultContext;
    }

    static synchronized void getDefaultContext() {
        if (defaultContext == null) {
            defaultContext = new Future(null);
        }
    }

    public void resetFluids(FluidBinding fluidBinding) {
        FluidBinding fluidBinding2;
        FluidBinding fluidBinding3 = fluidBinding2 = this.fluidBindings;
        while (fluidBinding3 != fluidBinding) {
            Binding binding = fluidBinding3.binding;
            FluidConstraint fluidConstraint = (FluidConstraint)binding.constraint;
            if (fluidConstraint.referenceCount-- <= 0) {
                binding.constraint = fluidConstraint.savedConstraint;
            }
            fluidBinding3 = fluidBinding3.previous;
        }
        this.fluidBindings = fluidBinding;
    }

    public void run() {
        try {
            this.result = this.action.apply0();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    public void setFluids(FluidBinding fluidBinding) {
        FluidBinding fluidBinding2 = this.fluidBindings;
        FluidBinding fluidBinding3 = fluidBinding;
        while (fluidBinding3 != fluidBinding2) {
            Binding binding = fluidBinding3.binding;
            Constraint constraint = binding.constraint;
            if (constraint instanceof FluidConstraint) {
                ++((FluidConstraint)constraint).referenceCount;
            } else {
                binding.constraint = new FluidConstraint(constraint);
            }
            fluidBinding3 = fluidBinding3.previous;
        }
        this.fluidBindings = fluidBinding;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<future ");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public Object waitForResult() {
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("thread join [force] was interrupted");
        }
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception.toString());
        }
        return this.result;
    }
}

