/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.Frame;
import gnu.jemacs.buffer.Window;
import gnu.jemacs.lang.ELisp;
import gnu.jemacs.lang.Symbol;
import gnu.kawa.util.FString;
import gnu.kawa.util.LList;
import gnu.mapping.Binding;
import gnu.mapping.Binding2;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class Command
extends TextAction {
    Object command;
    private KeyStroke key;

    Command(Procedure procedure, KeyStroke keyStroke) {
        super(procedure.getName());
        this.command = procedure;
        this.key = keyStroke;
    }

    Command(Object object2, String string, KeyStroke keyStroke) {
        super(string);
        if (object2 instanceof String) {
            object2 = Symbol.getBinding((String)object2);
        }
        this.command = object2;
        this.key = keyStroke;
    }

    Command(Keymap keymap, KeyStroke keyStroke) {
        super(keymap.getName());
        this.command = keymap;
        this.key = keyStroke;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object2 = this.command;
        if (object2 instanceof Binding2 && (object2 = Command.resolveSymbol(object2)) == null) {
            throw new Error("no function defined for " + ((Binding2)this.command).getName());
        }
        if (object2 instanceof TextAction) {
            ((TextAction)object2).actionPerformed(actionEvent);
        } else {
            Buffer buffer = Window.getSelected().buffer;
            if (object2 instanceof Keymap) {
                if (this.key != null) {
                    buffer.keymap.pushPrefix(this.key);
                }
            } else {
                buffer.keymap.pendingLength = 0;
                Command.perform(object2);
            }
        }
    }

    public final Object getCommand() {
        return Command.resolveSymbol(this.command);
    }

    public static void perform(Object object2) {
        try {
            Object object3;
            Object object4;
            if (object2 instanceof String || object2 instanceof Binding2) {
                object4 = Command.resolveSymbol(object2);
                if (object4 == null) {
                    throw new Error("no function defined for " + object2);
                }
                object2 = object4;
            }
            if ((object3 = ((Procedure)(object4 = (Procedure)object2)).getProperty("emacs-interactive", null)) != null) {
                if (object3 instanceof String) {
                    ((Procedure)object4).applyN(Command.processInteractionString(object3.toString()));
                } else if (object3 == LList.Empty) {
                    ((Procedure)object4).apply0();
                } else {
                    System.err.println("not implemented: interactive not a string");
                    ((Procedure)object4).apply0();
                }
            } else {
                ((Procedure)object4).apply0();
            }
        }
        catch (CancelledException cancelledException) {}
    }

    public static Object[] processInteractionString(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Buffer buffer = Buffer.getCurrent();
        block13: while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '@': {
                    if (n3 != n2 - 1) break;
                    n3 = n2;
                    break;
                }
                case '*': {
                    if (n3 != n2 - 1) break;
                    n3 = n2;
                    break;
                }
                case '_': {
                    if (n3 != n2 - 1) break;
                    n3 = n2;
                    break;
                }
                case 'r': {
                    ++n4;
                }
                default: {
                    ++n4;
                    while (n2 < n) {
                        if ((c = string.charAt(n2++)) == '\n') continue block13;
                    }
                    continue block13;
                }
                case '\n': 
            }
        }
        Object[] objectArray = new Object[n4];
        int n5 = 0;
        System.err.println("Get " + n4 + " args");
        n2 = n3;
        while (n2 < n) {
            int n6;
            int n7;
            int n8;
            char c;
            block18: {
                c = string.charAt(n2++);
                n8 = n2;
                do {
                    if (n2 < n) continue;
                    n6 = n2 - n8;
                    break block18;
                } while ((n7 = string.charAt(n2++)) != 10);
                n6 = n2 - 1 - n8;
            }
            switch (c) {
                case 'P': {
                    objectArray[n5++] = ELisp.FALSE;
                    break;
                }
                case 'p': {
                    objectArray[n5++] = IntNum.one();
                    break;
                }
                case 'r': {
                    n7 = buffer.checkMark() + 1;
                    int n9 = buffer.getPoint();
                    if (n7 <= n9) {
                        objectArray[n5++] = IntNum.make(n7);
                        objectArray[n5++] = IntNum.make(n9);
                        break;
                    }
                    objectArray[n5++] = IntNum.make(n9);
                    objectArray[n5++] = IntNum.make(n7);
                    break;
                }
                case 'F': 
                case 'S': 
                case 's': {
                    String string2 = Frame.selectedFrame.ask(string.substring(n8, n8 + n6));
                    objectArray[n5++] = c == 'S' ? string2.intern() : new FString(string2);
                    break;
                }
                default: {
                    System.err.println("un-implemented interactive prompt:" + c);
                    objectArray[n5++] = ELisp.FALSE;
                }
            }
        }
        return objectArray;
    }

    static Object resolveSymbol(Object object2) {
        int n = 100;
        do {
            if (object2 instanceof String) {
                object2 = Symbol.getBinding(object2);
            }
            if (!(object2 instanceof Binding2)) {
                return object2;
            }
            object2 = ((Binding2)object2).functionValue;
        } while (--n >= 0);
        throw new Error("circular binding for " + object2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Command[");
        if (this.command instanceof Binding) {
            stringBuffer.append(((Binding)this.command).getName());
        } else if (this.command instanceof Keymap) {
            stringBuffer.append("Keymap[");
            stringBuffer.append(((Keymap)this.command).getName());
            stringBuffer.append(']');
        } else {
            stringBuffer.append(this.command);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

