/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.Parser;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.Printable;
import java.io.PrintWriter;

public abstract class Expression
implements Printable {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public final void compile(Compilation compilation, Type type) {
        this.compile(compilation, StackTarget.getInstance(type));
    }

    public abstract void compile(Compilation var1, Target var2);

    public final void compileNotePosition(Compilation compilation, Target target) {
        String string = compilation.filename;
        int n = compilation.position;
        compilation.filename = this.filename;
        compilation.position = this.position;
        this.compile(compilation, target);
        compilation.filename = string;
        compilation.position = n;
    }

    public final void compileWithPosition(Compilation compilation, Target target) {
        int n = this.getLine();
        if (n > 0) {
            compilation.method.compile_linenumber(n);
            this.compileNotePosition(compilation, target);
        } else {
            this.compile(compilation, target);
        }
    }

    public Object eval(Environment environment) {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public final String getFile() {
        return this.filename;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public static Expression makeWhile(Object object2, Object object3, Parser parser) {
        Expression[] expressionArray = new Expression[1];
        LetExp letExp = new LetExp(expressionArray);
        String string = "%do%loop";
        Declaration declaration = letExp.addDeclaration(string);
        ApplyExp applyExp = new ApplyExp(new ReferenceExp(declaration), noExpressions);
        LambdaExp lambdaExp = new LambdaExp();
        parser.push(lambdaExp);
        lambdaExp.body = new IfExp(parser.parse(object2), new BeginExp(parser.parse(object3), applyExp), QuoteExp.voidExp);
        lambdaExp.setName(string);
        parser.pop(lambdaExp);
        expressionArray[0] = lambdaExp;
        declaration.noteValue(lambdaExp);
        letExp.setBody(new ApplyExp(new ReferenceExp(declaration), noExpressions));
        return letExp;
    }

    public abstract void print(PrintWriter var1);

    public final void setFile(String string) {
        this.filename = string;
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final void setLine(int n, int n2) {
        this.position = (n << 12) + n2;
    }

    abstract Object walk(ExpWalker var1);
}

