/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ZipMember;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipArchive {
    static final int LREC_SIZE = 26;
    static final int CREC_SIZE = 42;
    static final int ECREC_SIZE = 18;
    static final int TOTAL_ENTRIES_CENTRAL_DIR = 10;
    static final int SIZE_CENTRAL_DIRECTORY = 12;
    static final int C_COMPRESSED_SIZE = 16;
    static final int C_UNCOMPRESSED_SIZE = 20;
    static final int C_FILENAME_LENGTH = 24;
    static final int C_RELATIVE_OFFSET_LOCAL_HEADER = 38;
    RandomAccessFile file;
    String archive_name;
    long size;
    int count_in;
    int count_out;
    ZipMember firstEntry;
    ZipMember lastEntry;
    byte[] buffer = new byte[100];

    public ZipArchive(File file, String mode) throws IOException {
        this.archive_name = file.getName();
        this.file = new RandomAccessFile(file, mode);
        this.readDirectory();
    }

    public ZipArchive(String name, String mode) throws IOException {
        this.archive_name = name;
        this.file = new RandomAccessFile(name, mode);
        this.readDirectory();
    }

    ZipMember addMember(String name) {
        ZipMember zmemb = new ZipMember(name);
        if (this.firstEntry == null) {
            this.firstEntry = zmemb;
        } else {
            this.lastEntry.next = zmemb;
        }
        this.lastEntry = zmemb;
        return zmemb;
    }

    public ZipMember append(String name, byte[] contents) throws IOException {
        long start;
        int len = name.length();
        byte[] bname = new byte[len];
        name.getBytes(0, len, bname, 0);
        ZipMember prev = this.lastEntry;
        ZipMember zmemb = this.addMember(name);
        ++this.count_out;
        zmemb.compressed_size = contents.length;
        zmemb.setSize(contents.length);
        zmemb.relative_offset_local_header = start = prev == null ? 0L : prev.fileStart() + prev.compressed_size;
        this.file.seek(start);
        this.writeLocalHeader(zmemb);
        this.file.write(bname);
        this.file.write(contents);
        return zmemb;
    }

    public void close() throws IOException {
        if (this.count_out > 0) {
            this.writeEndHeaders();
        }
        this.file.close();
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        long total = 0L;
        int count;
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
            total += (long)count;
        }
        return total;
    }

    public static void copy(InputStream in, String name, byte[] buffer) throws IOException {
        File dir;
        File f = new File(name);
        String dir_name = f.getParent();
        if (dir_name != null && !(dir = new File(dir_name)).exists()) {
            System.err.println("mkdirs:" + dir.mkdirs());
        }
        if (name.charAt(name.length() - 1) != '/') {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            ZipArchive.copy(in, out, buffer);
            ((OutputStream)out).close();
        }
    }

    public ZipMember find(String name) {
        ZipMember zipd = this.firstEntry;
        while (zipd != null) {
            if (zipd.matches(name)) {
                return zipd;
            }
            zipd = zipd.next;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            ZipArchive.usage();
        }
        String command = args[0];
        String archive_name = args[1];
        try {
            if (command.equals("t") || command.equals("p") || command.equals("x")) {
                PrintStream out = System.out;
                byte[] buf = new byte[1024];
                if (args.length == 2) {
                    ZipEntry zent;
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(archive_name));
                    ZipInputStream zin = new ZipInputStream(in);
                    while ((zent = zin.getNextEntry()) != null) {
                        String name = zent.getName();
                        if (command.equals("t")) {
                            out.print(name);
                            out.print(" size: ");
                            out.println(zent.getSize());
                            continue;
                        }
                        if (command.equals("p")) {
                            ZipArchive.copy((InputStream)zin, out, buf);
                            continue;
                        }
                        ZipArchive.copy((InputStream)zin, name, buf);
                    }
                } else {
                    ZipFile zar = new ZipFile(archive_name);
                    int i = 2;
                    while (i < args.length) {
                        String name = args[i];
                        ZipEntry zent = zar.getEntry(name);
                        if (zent == null) {
                            System.err.println("zipfile " + archive_name + ":" + args[i] + " - not found");
                            System.exit(-1);
                        } else if (command.equals("t")) {
                            out.print(name);
                            out.print(" size: ");
                            out.println(zent.getSize());
                        } else if (command.equals("p")) {
                            ZipArchive.copy(zar.getInputStream(zent), out, buf);
                        } else {
                            ZipArchive.copy(zar.getInputStream(zent), name, buf);
                        }
                        ++i;
                    }
                }
            } else if (command.equals("q")) {
                ZipArchive zar = new ZipArchive(archive_name, "rw");
                int i = 2;
                while (i < args.length) {
                    File in = new File(args[i]);
                    if (!in.exists()) {
                        throw new IOException(String.valueOf(args[i]) + " - not found");
                    }
                    if (!in.canRead()) {
                        throw new IOException(String.valueOf(args[i]) + " - not readable");
                    }
                    FileInputStream fin = new FileInputStream(in);
                    int size = (int)in.length();
                    byte[] contents = new byte[size];
                    if (fin.read(contents) != size) {
                        throw new IOException(String.valueOf(args[i]) + " - read error");
                    }
                    fin.close();
                    zar.append(args[i], contents);
                    ++i;
                }
                zar.close();
            } else {
                ZipArchive.usage();
            }
        }
        catch (IOException ex) {
            System.err.println("I/O Exception:  " + ex);
        }
    }

    private int read4() throws IOException {
        int byte0 = this.file.read() & 0xFF;
        int byte1 = this.file.read() & 0xFF;
        int byte2 = this.file.read() & 0xFF;
        int byte3 = this.file.read() & 0xFF;
        return (byte3 << 24) + (byte2 << 16) + (byte1 << 8) + byte0;
    }

    void readDirectory() throws IOException {
        this.size = this.file.length();
        if (this.size == 0L) {
            this.count_in = 0;
            return;
        }
        if (this.size < 22L) {
            throw new IOException("zipfile too short");
        }
        this.file.seek(this.size - 22L);
        if (this.file.read() != 80 || this.file.read() != 75 || this.file.read() != 5 || this.file.read() != 6) {
            throw new IOException("not a valid zipfile");
        }
        this.file.skipBytes(6);
        this.count_in = this.readu2();
        int dir_size = this.read4();
        this.file.seek(this.size - (long)(dir_size + 18 + 4));
        int i = 0;
        while (i < this.count_in) {
            this.file.skipBytes(20);
            long compressed_size = this.read4();
            long uncompressed_size = this.read4();
            int filename_length = this.readu2();
            this.file.skipBytes(12);
            long relative_offset_local_header = this.read4();
            byte[] name = new byte[filename_length];
            this.file.readFully(name);
            ZipMember zipd = this.addMember(new String(name, 0));
            zipd.compressed_size = compressed_size;
            zipd.setSize(uncompressed_size);
            zipd.relative_offset_local_header = relative_offset_local_header;
            ++i;
        }
    }

    private int readu2() throws IOException {
        int byte0 = this.file.read() & 0xFF;
        int byte1 = this.file.read() & 0xFF;
        return byte1 << 8 | byte0;
    }

    public int size() {
        return this.count_in + this.count_out;
    }

    private static void usage() {
        System.err.println("zipfile [ptxq] archive [file ...]");
        System.exit(-1);
    }

    void write2(int val, byte[] buffer, int pos) {
        buffer[pos] = (byte)val;
        buffer[pos + 1] = (byte)(val >> 8);
    }

    void write4(int val, byte[] buffer, int pos) {
        buffer[pos] = (byte)val;
        buffer[pos + 1] = (byte)(val >> 8);
        buffer[pos + 2] = (byte)(val >> 16);
        buffer[pos + 3] = (byte)(val >> 24);
    }

    void writeCentralHeader(ZipMember zmember) throws IOException {
        int i = 46;
        while (--i >= 0) {
            this.buffer[i] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 1;
        this.buffer[3] = 2;
        this.buffer[4] = 20;
        this.buffer[5] = 3;
        this.buffer[6] = 10;
        this.write4((int)zmember.compressed_size, this.buffer, 20);
        this.write4((int)zmember.getSize(), this.buffer, 24);
        this.write2(zmember.getName().length(), this.buffer, 28);
        this.write4((int)zmember.relative_offset_local_header, this.buffer, 42);
        this.file.write(this.buffer, 0, 46);
    }

    void writeEndHeaders() throws IOException {
        int count = 0;
        long dir_start = this.lastEntry == null ? 0L : this.lastEntry.fileStart() + this.lastEntry.compressed_size;
        this.file.seek(dir_start);
        ZipMember zmemb = this.firstEntry;
        while (zmemb != null) {
            this.writeCentralHeader(zmemb);
            String name = zmemb.getName();
            int len = name.length();
            byte[] bname = new byte[len];
            name.getBytes(0, len, bname, 0);
            this.file.write(bname);
            ++count;
            zmemb = zmemb.next;
        }
        if (count != this.count_in + this.count_out) {
            throw new Error("internal error writeEndHeaders");
        }
        long dir_size = this.file.getFilePointer() - dir_start;
        int i = 22;
        while (--i >= 0) {
            this.buffer[i] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 5;
        this.buffer[3] = 6;
        this.write2(count, this.buffer, 8);
        this.write2(count, this.buffer, 10);
        this.write4((int)dir_size, this.buffer, 12);
        this.write4((int)dir_start, this.buffer, 16);
        this.file.write(this.buffer, 0, 22);
    }

    void writeLocalHeader(ZipMember zmember) throws IOException {
        int i = 30;
        while (--i >= 0) {
            this.buffer[i] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 3;
        this.buffer[3] = 4;
        this.buffer[4] = 10;
        this.write2(zmember.getName().length(), this.buffer, 26);
        this.write4((int)zmember.compressed_size, this.buffer, 18);
        this.write4((int)zmember.getSize(), this.buffer, 22);
        this.file.write(this.buffer, 0, 30);
    }
}

