/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Location;
import gnu.bytecode.Type;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Variable
extends Location
implements Enumeration {
    Variable next;
    private int flags = 1;
    private static final int SIMPLE_FLAG = 1;
    private static final int PARAMETER_FLAG = 2;
    private static final int ARTIFICIAL_FLAG = 4;
    static final int UNASSIGNED = -1;
    int offset = -1;
    int start_pc;
    int end_pc;

    public Variable() {
    }

    public Variable(String name) {
        this.setName(name);
    }

    public Variable(String name, Type type) {
        this.setName(name);
        this.setType(type);
    }

    public void allocateLocal(CodeAttr code) {
        if (this.offset != -1) {
            return;
        }
        int i = 0;
        while (!this.reserveLocal(i, code)) {
            ++i;
        }
        return;
    }

    final boolean dead() {
        return this.end_pc > 0;
    }

    public void freeLocal(CodeAttr code) {
        this.end_pc = code.PC;
        int size = this.getType().size > 4 ? 2 : 1;
        while (--size >= 0) {
            code.locals.used[this.offset + size] = null;
        }
    }

    public final boolean hasMoreElements() {
        return this.next != null;
    }

    public final boolean isArtificial() {
        return (this.flags & 4) != 0;
    }

    public final boolean isAssigned() {
        return this.offset != -1;
    }

    public final boolean isParameter() {
        return (this.flags & 2) != 0;
    }

    public final boolean isSimple() {
        return (this.flags & 1) != 0;
    }

    public Object nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException("Variable enumeration");
        }
        return this.next;
    }

    public final Variable nextVar() {
        return this.next;
    }

    public boolean reserveLocal(int varIndex, CodeAttr code) {
        int size;
        int n = size = this.getType().size > 4 ? 2 : 1;
        if (code.locals.used == null) {
            code.locals.used = new Variable[20 + size];
        } else if (code.getMaxLocals() + size >= code.locals.used.length) {
            Variable[] new_locals = new Variable[2 * code.locals.used.length + size];
            System.arraycopy(code.locals.used, 0, new_locals, 0, code.getMaxLocals());
            code.locals.used = new_locals;
        }
        int j = 0;
        while (j < size) {
            if (code.locals.used[varIndex + j] != null) {
                return false;
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < size) {
            code.locals.used[varIndex + j2] = this;
            ++j2;
        }
        if (varIndex + size > code.getMaxLocals()) {
            code.setMaxLocals(varIndex + size);
        }
        this.offset = varIndex;
        return true;
    }

    public final void setArtificial(boolean artificial) {
        this.setFlag(artificial, 4);
    }

    private void setFlag(boolean setting, int flag) {
        this.flags = setting ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final void setParameter(boolean parameter) {
        this.setFlag(parameter, 2);
    }

    public final void setSimple(boolean simple) {
        this.setFlag(simple, 1);
    }

    public String toString() {
        return "Variable[" + this.getName() + " offset:" + this.offset + ']';
    }
}

