#!/bin/sh

# $Id: update_test4.sh 1635 2023-03-30 04:16:57Z peter $

# Copyright (C) 2012 Peter Johansson
# Copyright (C) 2015 Jari Häkkinen, Peter Johansson
#
# This file is part of svndigest, http://dev.thep.lu.se/svndigest
#
# svndigest is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# svndigest is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with svndigest. If not, see <http://www.gnu.org/licenses/>.

# test that when a changeset only removes a directory that this will
# be reflected in mother's output

# we want to a wc from rev52
wc_revision=52
# remove wc as downdating potentially causes conflicts
rm -rf test/testSubDir/update_test4.sh.dir/toy_project
required="repo"
. test/init.sh || exit 99

targetdir=out
rm -rf out/*
$mkdir_p out

# run svndigest in r52
SVNDIGEST_run 0 -r $rootdir -t $targetdir --ignore-cache --format=none
test -e stderr || exit_fail
test -s stderr && exit_fail

# remove directories that are prone to conflicts
rm -rf $rootdir/design
rm -rf $rootdir/late_copy

# update to rev 53, which removes directory 'design'
$SVN update -r 53 $rootdir || exit_fail

# try running svndigest and make sure it runs although no file in
# current revision has changed (topdir has changed though as directory
# 'design' was removed).
SVNDIGEST_run 0 -r $rootdir -t $targetdir --ignore-cache --format=none -u
test -e stderr || exit_fail
test -s stderr && exit_fail

grep '^Printing' stdout || exit_fail

exit_success;
