// $Id: graph.cc 1635 2023-03-30 04:16:57Z peter $

/*
	Copyright (C) 2010 Jari Häkkinen, Peter Johansson
	Copyright (C) 2011, 2023 Peter Johansson

	This file is part of svndigest, http://dev.thep.lu.se/svndigest

	svndigest is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	svndigest is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with svndigest. If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>

#include "Suite.h"

#include "lib/Graph.h"
#include "lib/Vector.h"

#include <cstdlib>
#include <ostream>

using namespace theplu::svndigest;

void test_graph(const std::string format, test::Suite& suite);
void test_graph__(const std::string format, test::Suite& suite);

int main(int argc, char* argv[])
{
	test::Suite suite(argc, argv);

#ifndef HAVE_PLPLOT
	suite.out() << "no plplot: skip test\n";
	exit(EXIT_SKIP);
#endif

	test_graph("svg", suite);
	test_graph("png", suite);
	test_graph("pdf", suite);

	return suite.exit_status();
}


void test_graph(const std::string format, test::Suite& suite)
{
	suite.out() << "testing " << format << std::endl;
	for (size_t i=0; i<20; ++i)
		test_graph__(format, suite);
}


void test_graph__(const std::string format, test::Suite& suite)
{
	std::string filename("plot.");
	filename+=format;
	Graph graph(filename, format);
	graph.ymax(10);
	graph.current_color(255, 0, 0);
	SumVector data;
	graph.rev_max(100);
	data.set(99,1);
	graph.plot(data, "label", 1);
}
