## $Id: yat_common.m4 4326 2023-03-12 00:37:24Z peter $
#
# Copyright (C) 2009, 2010, 2012, 2013, 2014, 2018, 2020 Peter Johansson
#
# This file is part of the yat library, http://dev.thep.lu.se/yat
#
# The yat library is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 3 of the
# License, or (at your option) any later version.
#
# The yat library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with yat. If not, see <http://www.gnu.org/licenses/>.
#

#
# This file contains some small useful macros.
#
# serial 4 (yat 0.16)
#


# YAT_ECHO_LOG(STRING)
# ====================
# print STRING to config.log
AC_DEFUN([YAT_ECHO_LOG],
[
  AC_PREREQ([2.58])
  AS_ECHO(["$as_me:${as_lineno-$LINENO}: $1"]) >&AS_MESSAGE_LOG_FD
]) #YAT_ECHO_LOG


# YAT_RUN_LOG(COMMAND, [ACTION-IF-TRUE], [ACTION-IF-FALSE])
# =========================================================
# run COMMAND and log the output, set status in $yat_status and log
# it. If status is zero execute ACTION-IF-TRUE, else execute
# ACTION-IF-FALSE and log stderror from COMMAND
AC_DEFUN([YAT_RUN_LOG],
[
  AC_PREREQ([2.58])
  m4_pushdef([COMMAND], [$1])
  YAT_ECHO_LOG([COMMAND])
  COMMAND >&AS_MESSAGE_LOG_FD 2>conftest.err
  yat_status=$?
  YAT_ECHO_LOG([status: $yat_status])
  AS_IF([test $yat_status = 0], [$2],
        [test -f conftest.err && cat conftest.err >&AS_MESSAGE_LOG_FD; $3])
  m4_popdef([COMMAND])
]) #YAT_RUN_LOG


# YAT_SET_CONTAINS(set, value, [if-present], [if-not-present])
# ============================================================
# Loop over set (space-separated) and if value exists, execute
# if-present. otherwise execute if-not-present
AC_DEFUN([YAT_SET_CONTAINS],
[
AS_IF([AS_ECHO([$1]) | tr ' ' '\n' | grep "^$2$" > /dev/null], [$3], [$4])
]) #YAT_SET_CONTAINS


# YAT_VAR_REMOVE(VAR, LIST)
# ==========================
# Loop over LIST (space-separated) and for each value, remove value from VAR.
AC_DEFUN([YAT_VAR_REMOVE],
[
AS_IF([test x"$2" != x], [
  for value in $2; do
    APR_REMOVEFROM([$1], [$value])
  done
])
])

# YAT_CHECK_LA_LIBS(CODE, LIBS, VALUE, VAR)
# ============================================
# Check if we can create a libtool archive based on CODE linking with
# LIBS. If not, add VALUE to VAR.
AC_DEFUN([YAT_CHECK_LA_LIBS],
[
save_LIBS=$LIBS
LIBS="$2"
AC_MSG_CHECKING([if libtool archive can be created with $LIBS])
YAT_LT_LINK_LA_IFELSE([$1],
  [AC_MSG_RESULT([yes])],
  [AC_MSG_RESULT([no])
   $4="$$4 $3"])
LIBS=$save_LIBS
])

# YAT_SEARCH_LIBS(function, libraries, [action-if-found],
#                 [action-if-not-found], [other-libraries])
# =================================================================
# Same as AC_SEARCH_LIBS, but do not append LIBS with found library
# (if-found). Found library is stored in $yat_cv_search_<function>, set
# to empty string if no library required, and set to no if no library
# found.
AC_DEFUN([YAT_SEARCH_LIBS],
[
AS_VAR_PUSHDEF([yat_Search], [yat_cv_search_$1])
dnl cache variable used in autoconf code (AC_SEARCH_LIBS)
AS_VAR_PUSHDEF([yat_ac_Search], [ac_cv_search_$1])
yat_func_search_save_LIBS=$LIBS

AC_SEARCH_LIBS([$1], [$2], [
    LIBS=$yat_func_search_save_LIBS
    AS_VAR_IF([yat_ac_Search], ["none required"], [], [
      AS_VAR_COPY([yat_Search], [yat_ac_Search])
    ])
    $3
  ], [
    AS_VAR_COPY([yat_ac_Search], [yat_Search])
    $4
  ], [$5])

AS_VAR_POPDEF([yat_ac_Search])
AS_VAR_POPDEF([yat_Search])
]) # YAT_SEARCH_LIBS


# YAT_AC_WRITE_TO_FILE([FILE-NAME], [CONTENT])
# ============================================
#
# When autoconf is run, create a file 'FILE-NAME' with CONTENT.
# Variables that need to be expanded by M4 cannot be quoted e.g.
# m4_define([my_text], [yada yada])
# YAT_AC_WRITE_TO_FILE([foo.txt], [This is my example ]my_text[ and no less])
#
# Within a macro definition, a dollar ($) followed by 0-9, #, @, or *
# is expanded by M4 and to avoid that one can use the pattern
# YAT_AC_WRITE_TO_FILE([foo.txt], [some prefix]$[1 and suffix])
# which outputs: some prefix $1 and suffix
AC_DEFUN([YAT_AC_WRITE_TO_FILE],
[
_YAT_AC_WRITE_TO_FILE([$1], [$2], [write])
])


# YAT_AC_APPEND_TO_FILE([FILE-NAME], [CONTENT])
# =============================================
#
# Same as YAT_AC_WRITE_TO_FILE but append to file instead
AC_DEFUN([YAT_AC_APPEND_TO_FILE],
[
_YAT_AC_WRITE_TO_FILE([$1], [$2], [append])
])


# _YAT_AC_WRITE_TO_FILE([FILE-NAME], [CONTENT], [MODE])
# =====================================================
AC_DEFUN([_YAT_AC_WRITE_TO_FILE],
[m4_define([yat_DIRECTION_OP], [m4_case([$3], [write], [>],
                                    [append], [>>],
				    [m4_fatal([invalid mode $3])])])
m4_syscmd([cat ]yat_DIRECTION_OP[ $1 << '_yat_EOF'
$2
_yat_EOF
])
dnl abort if syscmd failed
m4_if(m4_sysval, [0], [], [m4_fatal([$0: cannot write: $1])])
])
