// $Id: css.cc 1515 2012-09-26 00:35:10Z peter $

/*
	Copyright (C) 2006 Peter Johansson
	Copyright (C) 2007, 2008 Jari Häkkinen, Peter Johansson
	Copyright (C) 2009, 2010, 2012 Peter Johansson

	This file is part of svndigest, http://dev.thep.lu.se/svndigest

	svndigest is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	svndigest is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with svndigest. If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>

#include "css.h"

#include <fstream>
#include <string>

namespace theplu{
namespace svndigest{

	void print_css(const std::string& str)
	{
		std::ofstream s(str.c_str());
		s << "<-- svndigest.css generated by " << PACKAGE_STRING << "\n"

			<< "Copyright (C) 2006 Peter Johansson\n"
			<< "Copyright (C) 2007, 2008 Jari Häkkinen, Peter Johansson\n"
			<< "Copyright (C) 2009, 2010 Peter Johansson\n"
			<< "\nThis file is part of svndigest, "
			<< "http://dev.thep.lu.se/svndigest\n\n"

			<< "svndigest is free software; you can redistribute it and/or "
			<< "modify it\n"
			<< "under the terms of the GNU General Public License as published by\n"
			<< "the Free Software Foundation; either version 3 of the License, or\n"
			<< "(at your option) any later version.\n\n"

			<< "svndigest is distributed in the hope that it will be useful, but\n"
			<< "WITHOUT ANY WARRANTY; without even the implied warranty of\n"
			<< "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
			<< "General Public License for more details.\n\n"

			<< "You should have received a copy of the GNU General Public License\n"
			<< "along with svndigest. If not, see <http://www.gnu.org/licenses/>.\n"

			<< "\n\nThis file was initially inspired by the cascading style sheet\n"
			<< "within the Trac open source project (http://trac.edgewall.org/)\n"
			<< "Copyright (C) 2003-2006 Edgewall Software\n"
			<< "All rights reserved.\n\n"

			<< "Redistribution and use in source and binary forms, with or without\n"
			<< "modification, are permitted provided that the following conditions\n"
			<< "are met:\n\n"

			<< "1. Redistributions of source code must retain the above copyright\n"
			<< "   notice, this list of conditions and the following disclaimer.\n"
			<< "2. Redistributions in binary form must reproduce the above copyright\n"
			<< "   notice, this list of conditions and the following disclaimer in\n"
			<< "   the documentation and/or other materials provided with the\n"
			<< "   distribution.\n"
			<< "3. The name of the author may not be used to endorse or promote\n"
			<< "   products derived from this software without specific prior\n"
			<< "   written permission.\n\n"

			<< "THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS\n"
			<< "OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n"
			<< "WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
			<< "ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY\n"
			<< "DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
			<< "DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n"
			<< "GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
			<< "INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n"
			<< "WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
			<< "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
			<< "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.-->\n";

		s << "body {\n";
		s << " background: #fff; \n";
		s << " color: #000; \n";
		s << " margin: 0px; \n";
		s << " padding: 0; \n";
		s << "} \n";
		s << "\n";

		s << "#menu {\n";
		s << " background: #eee;\n";
		s << " width: 100%;\n";
		s << " margin: 0px;\n";
		s << " padding: 0px;\n";
		s << "}\n\n";
		s << "#menu ul\n";
		s << "{ \n";
		s << "padding: 0px;\n";
		s << "margin: 0px;list-style-type: none; text-align: center;"
			<< "border-bottom: 1px solid black;}\n";
		s << "#menu ul li { display: inline; border-right: 1px solid black;}\n";
		s << "#menu ul li a {text-decoration: none; padding-right: 1em;"
			<< "padding-left: 1em; margin: 0px;}\n";
		s << "#menu ul li a:hover{ color: #000; background: #ddd;}\n";
		s << "#menu ul li.highlight a {color: #fff; background: #777; }";
		s << "\n";
		s << "#main {\n";
		s << " margin: 10px; \n";
		s << "}\n";
		s << "\n";

		s << "body, th, td {\n";
		s << " font: normal 13px verdana,arial,'Bitstream Vera Sans',"
			<< "helvetica,sans-serif;\n";
		s << "}\n";
		s << ":link, :visited {\n";
		s << " text-decoration: none;\n";
		s << " color: #b00;\n";
		s << "}\n";
		s << "\n";

		s << "div.main {\n";
		s << "margin-top: 50px;\n";
		s << "margin-left: 50px;\n";
		s << " \n";
		s << "}\n";

		s << "table.main {\n";
		s << " text-align: left;\n";
		s << " padding: 0 1em .1em 0;\n";
		s << "}\n";
		s << "table.main th {\n";
		s << " text-align: left;\n";
		s << " padding: 0 1em 0.5em 0;\n";
		s << " font-size: 150%;\n";
		s << " font-wheight: bold;\n";
		s << "}\n";
		s << "table.main td {\n";
		s << " padding: 0 1em .1em 0;\n";
		s << "}\n\n";
		s << "div.main img { border: 0; }\n";

		s << "p.plot { text-align: center; }\n";
		s << "p.plot img { border: 0; }\n";

		s << "p.footer {\n";
		s << "text-align: center;\n";
		s << "font-size: 70%;\n";
		s << "}\n\n";

		s << "table.blame {\n";
		s << " border: 1px solid #ddd;\n";
		s << " border-spacing: 0;\n";
		s << " border-top: 0;\n";
		s << " empty-cells: show;\n";
		s << " font-size: 12px;\n";
		s << " line-height: 130%;\n";
		s << " padding: 0;\n";
		s << " margin: 0 auto;\n";
		s << " table-layout: fixed;\n";
		s << " width: 100%;\n";
		s << "}\n";
		s << "table.blame th {\n";
		s << " border-right: 1px solid #d7d7d7;\n";
		s << " border-bottom: 1px solid #998;\n";
		s << " font-size: 11px;\n";
		s << "}\n";
		s << "table.blame th.author { width: 5em; text-align:right }\n";
		s << "table.blame th.date { width: 8em; text-align:center }\n";
		s << "table.blame th.rev { width: 3em }\n";
		s << "table.blame th.line { width: 3em }\n";
		s << "table.blame thead th {\n";
		s << " background: #eee;\n";
		s << " border-top: 1px solid #d7d7d7;\n";
		s << " color: #999;\n";
		s << " padding: 0 .25em;\n";
		s << " text-align: center;\n";
		s << " white-space: nowrap;\n";
		s << "}\n";
		s << "table.blame tbody td {\n";
		s << " border-right: 1px solid #f0f0f0;\n";
		s << " font: normal 11px monospace;\n";
		s << " overflow: hidden;\n";
		s << " padding: 1px 2px;\n";
		s << " vertical-align: top;\n";
		s << "}\n";
		s << "table.blame tbody td.author { text-align: right; }\n";
		s << "table.blame tbody td.date {text-align:right;padding-right:1.45em;}\n";
		s << "table.blame tbody td.rev { text-align: right; }\n";
		std::string bg_lt_code("cfcfff");
		std::string bg_lt_comment("e8e8ff");
		std::string bg_lt_other("ffffff");
		s << "table.blame tbody td.line-code { text-align: right; "
			<< "background: #" << bg_lt_code << "; }\n";
		s << "table.blame tbody td.line-comment { text-align: right; "
			<< "background: #" << bg_lt_comment << "; }\n";
		s << "table.blame tbody td.line-other { text-align: right; "
			<< "background: #" << bg_lt_other << "; }\n";
		s << "table.blame tbody tr:hover { background: #eed; }\n";
		s << "table.blame tbody td a { display: block; }\n";
		s << "\n";

		s << "table.listings {\n";
		s << " clear: both;\n";
		s << " border-bottom: 1px solid #d7d7d7;\n";
		s << " border-collapse: collapse;\n";
		s << " border-spacing: 0;\n";
		s << " margin-top: 1em;\n";
		s << " width: 100%;\n";
		s << "}\n";
		s << "\n";
		s << "table.listings th {\n";
		s << " text-align: left;\n";
		s << " padding: 0 1em .1em 0;\n";
		s << " font-size: 12px\n";
		s << "}\n";
		s << "table.listings thead { background: #f7f7f0 }\n";
		s << "table.listings thead th {\n";
		s << " border: 1px solid #d7d7d7;\n";
		s << " border-bottom-color: #999;\n";
		s << " font-size: 11px;\n";
		s << " font-wheight: bold;\n";
		s << " padding: 2px .5em;\n";
		s << " vertical-align: bottom;\n";
		s << "}\n";
		s << "\n";
		s << "table.listings tbody td, table.listing tbody th {\n";
		s << " border: 1px dotted #ddd;\n";
		s << " padding: .33em .5em;\n";
		s << " vertical-align: top;\n";
		s << "}\n";
		s << "\n";
		s << "table.listings tbody tr { border-top: 1px solid #ddd }\n";
		s << "table.listings tbody tr.light { background-color: #fcfcfc }\n";
		s << "table.listings tbody tr.dark { background-color: #f7f7f7 }\n";
		s << "table.listings tbody tr:hover { background: #eed }\n";
		s << "table.listings tbody td { text-align: left }\n";
		s << "table.listings tbody td a { display: block; }\n";
		s << "table.listings tbody td.directory a { font-weight: bold }\n";
		s << "\n";

		s << ".sep { color: #666}\n";
		s << "div.blame_legend .code { background: #" << bg_lt_code << "; }\n"
			<< "div.blame_legend .comment { background: #" << bg_lt_comment << "; }\n"
			<< "div.blame_legend .other { background: #" << bg_lt_other << "; }\n"
			<< "div.blame_legend {\n"
			<< "float: left;\n"
			<< "font-size: 9px;\n"
			<< "margin: 1em 0;\n"
			<< "padding: .5em;\n"
			<< "} \n"
			<< "div.blame_legend dt {\n"
			<< "background: #fff;\n"
			<< "border: 1px solid #999;\n"
			<< "float: left;\n"
			<< "margin: .1em .5em .1em 2em;\n"
			<< "overflow: hidden;\n"
			<< "width: .8em; height: .8em;\n"
			<< "}\n"
			<< "div.blame_legend dl, div.blame_legend dd {\n"
			<< "display: inline;\n"
			<< "float: left;\n"
			<< "padding: 0;\n"
			<< "margin: 0;\n"
			<< "margin-right: 1.5em;\n"
			<< "}\n";
		s.close();
	}

}} // end of namespace svndigest and namespace theplu
