#include "CEnemyBase.h"
#include "svinepalsen.h"

CEnemyBase::CEnemyBase()
{
  phaser = NULL;
  explode = NULL;
  walzingout = NULL;
  expdraw = 0;
  enemyBoom = NULL;
}

CEnemyBase::~CEnemyBase()
{
}

void CEnemyBase::initEnemy(class Svinepalsen *pals, SDL_Surface* scr, float *deltatime, float *time, CSprite* ship, CSprite (*shipbullets)[BULLETS],int (*shipbdraw)[BULLETS], int *life, int *lives, int *score, CBigBoom *eboom)
{	
  enemyBoom = eboom;
  enemybase.init("data/art/alienfighters");
  for(int i=0;i<ENEMIES;i++) { enemies[i].init(&enemybase,scr); }
  
  //expcloudbase.init("data/explosion01");
  //expcloud.init(&expcloudbase,scr);
  
  bulletbase.init("data/art/bullets");
  for(int i=0;i<BULLETS;i++) {
		bullets[i].init(&bulletbase,scr); 
		bullets[i].setFrame(2);
    bullets[i].stopAnim();
	}
  
  phaser = Mix_LoadWAV("data/audio/enemyphaser.wav");
  explode = Mix_LoadWAV("data/audio/explosion.wav");
  //walzingout = Mix_LoadWAV("data/audio/walzingout.wav");
  
	//temp = *pals;
  //dt = deltatime;
	//pals->addBullet();
	
	
	//dt = pals->dt;
	palsen = pals;
}

void CEnemyBase::drawOnScene()
{
  //if(expdraw==1) { expcloud.draw(); }
  
  for(int i=0;i<BULLETS;i++)
  {
    if(bdraw[i]==1) { bullets[i].draw(); }
  }
  
  for(int i=0;i<ENEMIES;i++)
  {
    if(edraw[i]==1) { enemies[i].draw(); }
  }
  enemyBoom->draw_bang_dots(palsen->screen,palsen->dt * 0.10);
}

void CEnemyBase::enemyFire() {
  for(int i=0;i<BULLETS;i++) {
    if(bdraw[i]==1) {
      bullets[i].yadd(-(int)((palsen->dt)*1.5));
      if(bullets[i].gety()< -20 ) { bdraw[i]=0; }
    }
    else
    {
      int renemy = rand()%9;
      if ((edraw[renemy]==1) && (rand()%50 == 0)) {
        bullets[i].set(enemies[renemy].getx()+10,enemies[renemy].gety()+20);
        bdraw[i]=1;
        Mix_PlayChannel(-1,phaser,0);
      }
    }
    if(palsen->Sprite_Collide(bullets[i],palsen->mainship)) {
      palsen->life -= 2;
      if (palsen->life < 0) {
        Mix_PlayChannel(1,explode,0);
        palsen->lives = palsen->lives -1;
        enemyBoom->makebangdots((int)palsen->mainship.getx(),(int)palsen->mainship.gety(),2,2,palsen->mainship.getSurface(),2,10);
      }
    }
  }
}

void CEnemyBase::enemyMovement() {
  for(int i=0;i<ENEMIES;i++) {
    if(edraw[i]==1) {
      enemies[i].xadd(-((float)espeed[i]+1)*(palsen->dt)*0.25);
      if(einfo[i]>0) {
        enemies[i].yset((cos((enemies[i].getx()+einfo[i])*0.0174532925)*100)+230);
      }
      if(enemies[i].getx()<-40) {
        edraw[i]=0;
        continue;
      }
      for(int j=0;j<BULLETS;j++) {
        if((palsen->bdraw)[j]==1) {
          if(palsen->Sprite_Collide((palsen->bullets)[j],enemies[i])) {
            elife[i]--;
            if(elife[i]<1) {
              //expcloud.set(enemies[i].getx(),enemies[i].gety());
              enemyBoom->makebangdots((int)enemies[i].getx(),(int)enemies[i].gety(),2,2,enemies[i].getSurface(),2,10);
              
              expdraw = 1;
              Mix_PlayChannel(1,explode,0);
              edraw[i]=0;
              
              palsen->score+=(rand()%20)+30;
              (palsen->bdraw)[j]=0;
              
              continue;
            } 
            else {
              palsen->score+=1;
              (palsen->bdraw)[j]=0;
            }
          }
        }
      }

      /*if(ship.getSpeed()==0 && Sprite_Collide(ship,enemies[i]))
      {
	lives--;
	if(lives<0)
	{
	  gameover=1;
	  break;
	}
	edraw[i]=0;
	ship.set(10,245);
	ship.setSpeed(1);
	ship.startAnim();
	dtime=(Uint32)sdlgt;
	Mix_PlayChannel(1,explode,0);
      }*/
    }
  }
}

void CEnemyBase::nextScene() {
  enemyFire();
  enemyMovement();
  //drawBigBoom(screen);
  
  if((palsen->sdlgt)-lastenemy>1400) {
    addEnemy();
    lastenemy=(Uint32)(palsen->sdlgt);
  }
  if((palsen->sdlgt)-lastexplosion>400) {
    expdraw=0;
    lastexplosion=(Uint32)(palsen->sdlgt);
  }
}

void CEnemyBase::addEnemy() {
  for(int i=0;i<ENEMIES;i++) {
    if(edraw[i]==0) {
      if(rand()%2 == 0) {
        enemies[i].setFrame(1);
        einfo[i]=rand()%300+1;
      } 
      else {
        enemies[i].setFrame(0);
        einfo[i]=0;
      }
      enemies[i].stopAnim();
      enemies[i].set(800,60+rand()%350);
      espeed[i]=rand()%4+1;
      elife[i]=rand()%3+1;
      edraw[i]=1;
      return;
    }
  }
}
