#!/bin/bash

# Copyright (C) 2006 Christian Stigen Larsen <csl@sublevel3.org>
# This script is in the public domain.

if test "$#" == "0" ; then
	echo "usage: lookup [ hostname(s) ]"
	echo "looks up if hosts are blocked by surbl.org"
	exit 1
fi

while test ! -z "${1}" ; do

	echo -n "checking ${1} ... "
	surblhost -q -r 2>/dev/null ${1}

	if test "$?" == "2"; then
		echo "blocked"
	else
		echo "not blocked"
	fi	

	shift
done

echo ""
echo "for more information, see http://www.surbl.org/lists.html"
exit 0
