/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.AngleFormat;
import com.jhlabs.map.Unit;
import com.jhlabs.map.Units;
import com.jhlabs.map.proj.AiryProjection;
import com.jhlabs.map.proj.AitoffProjection;
import com.jhlabs.map.proj.AlbersProjection;
import com.jhlabs.map.proj.AugustProjection;
import com.jhlabs.map.proj.BipolarProjection;
import com.jhlabs.map.proj.BoggsProjection;
import com.jhlabs.map.proj.BonneProjection;
import com.jhlabs.map.proj.CassiniProjection;
import com.jhlabs.map.proj.CentralCylindricalProjection;
import com.jhlabs.map.proj.CollignonProjection;
import com.jhlabs.map.proj.CrasterProjection;
import com.jhlabs.map.proj.DenoyerProjection;
import com.jhlabs.map.proj.Eckert1Projection;
import com.jhlabs.map.proj.Eckert2Projection;
import com.jhlabs.map.proj.Eckert4Projection;
import com.jhlabs.map.proj.Eckert5Projection;
import com.jhlabs.map.proj.Ellipsoid;
import com.jhlabs.map.proj.EquidistantAzimuthalProjection;
import com.jhlabs.map.proj.EquidistantConicProjection;
import com.jhlabs.map.proj.EulerProjection;
import com.jhlabs.map.proj.FaheyProjection;
import com.jhlabs.map.proj.FoucautProjection;
import com.jhlabs.map.proj.FoucautSinusoidalProjection;
import com.jhlabs.map.proj.GallProjection;
import com.jhlabs.map.proj.GnomonicAzimuthalProjection;
import com.jhlabs.map.proj.GoodeProjection;
import com.jhlabs.map.proj.HammerProjection;
import com.jhlabs.map.proj.HatanoProjection;
import com.jhlabs.map.proj.KavraiskyVProjection;
import com.jhlabs.map.proj.LagrangeProjection;
import com.jhlabs.map.proj.LambertConformalConicProjection;
import com.jhlabs.map.proj.LambertEqualAreaConicProjection;
import com.jhlabs.map.proj.LandsatProjection;
import com.jhlabs.map.proj.LarriveeProjection;
import com.jhlabs.map.proj.LaskowskiProjection;
import com.jhlabs.map.proj.LoximuthalProjection;
import com.jhlabs.map.proj.MBTFPPProjection;
import com.jhlabs.map.proj.MBTFPQProjection;
import com.jhlabs.map.proj.MBTFPSProjection;
import com.jhlabs.map.proj.MercatorProjection;
import com.jhlabs.map.proj.MillerProjection;
import com.jhlabs.map.proj.MolleweideProjection;
import com.jhlabs.map.proj.Murdoch1Projection;
import com.jhlabs.map.proj.Murdoch2Projection;
import com.jhlabs.map.proj.Murdoch3Projection;
import com.jhlabs.map.proj.NellProjection;
import com.jhlabs.map.proj.NicolosiProjection;
import com.jhlabs.map.proj.NullProjection;
import com.jhlabs.map.proj.ObliqueMercatorProjection;
import com.jhlabs.map.proj.OrthographicAzimuthalProjection;
import com.jhlabs.map.proj.PerspectiveConicProjection;
import com.jhlabs.map.proj.PerspectiveProjection;
import com.jhlabs.map.proj.PlateCarreeProjection;
import com.jhlabs.map.proj.PolyconicProjection;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import com.jhlabs.map.proj.PutninsP2Projection;
import com.jhlabs.map.proj.PutninsP4Projection;
import com.jhlabs.map.proj.PutninsP5PProjection;
import com.jhlabs.map.proj.PutninsP5Projection;
import com.jhlabs.map.proj.QuarticAuthalicProjection;
import com.jhlabs.map.proj.RectangularPolyconicProjection;
import com.jhlabs.map.proj.RobinsonProjection;
import com.jhlabs.map.proj.SinusoidalProjection;
import com.jhlabs.map.proj.StereographicAzimuthalProjection;
import com.jhlabs.map.proj.TCCProjection;
import com.jhlabs.map.proj.TCEAProjection;
import com.jhlabs.map.proj.TransverseMercatorProjection;
import com.jhlabs.map.proj.URMFPSProjection;
import com.jhlabs.map.proj.VanDerGrintenProjection;
import com.jhlabs.map.proj.VitkovskyProjection;
import com.jhlabs.map.proj.Wagner1Projection;
import com.jhlabs.map.proj.Wagner2Projection;
import com.jhlabs.map.proj.Wagner3Projection;
import com.jhlabs.map.proj.Wagner4Projection;
import com.jhlabs.map.proj.Wagner5Projection;
import com.jhlabs.map.proj.Wagner7Projection;
import com.jhlabs.map.proj.WerenskioldProjection;
import com.jhlabs.map.proj.WinkelTripelProjection;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProjectionFactory {
    private static final double SIXTH = 0.16666666666666666;
    private static final double RA4 = 0.04722222222222222;
    private static final double RA6 = 0.022156084656084655;
    private static final double RV4 = 0.06944444444444445;
    private static final double RV6 = 0.04243827160493827;
    private static AngleFormat format = new AngleFormat("DdM", true);
    static Hashtable registry;

    public static Projection fromPROJ4Specification(String[] args) {
        Unit unit;
        Projection projection = null;
        Ellipsoid ellipsoid = null;
        double a = 0.0;
        double b = 0.0;
        double es = 0.0;
        Hashtable<String, String> params = new Hashtable<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int index;
            String arg = args[i];
            if (!arg.startsWith("+") || (index = arg.indexOf(61)) == -1) continue;
            String key = arg.substring(1, index);
            String value = arg.substring(index + 1);
            params.put(key, value);
        }
        String s = (String)params.get("proj");
        if (s != null && (projection = ProjectionFactory.getNamedPROJ4Projection(s)) == null) {
            throw new ProjectionException("Unknown projection: " + s);
        }
        s = (String)params.get("init");
        if (s != null) {
            projection = ProjectionFactory.getNamedPROJ4CoordinateSystem(s);
            if (projection == null) {
                throw new ProjectionException("Unknown projection: " + s);
            }
            a = projection.getEquatorRadius();
            es = projection.getEllipsoid().getEccentricitySquared();
        }
        String ellipsoidName = "";
        s = (String)params.get("R");
        if (s != null) {
            a = Double.parseDouble(s);
        } else {
            s = (String)params.get("ellps");
            if (s == null) {
                s = (String)params.get("datum");
            }
            if (s != null) {
                Ellipsoid[] ellipsoids = Ellipsoid.ellipsoids;
                for (int i = 0; i < ellipsoids.length; ++i) {
                    if (!ellipsoids[i].shortName.equals(s)) continue;
                    ellipsoid = ellipsoids[i];
                    break;
                }
                if (ellipsoid == null) {
                    throw new ProjectionException("Unknown ellipsoid: " + s);
                }
                es = ellipsoid.eccentricity2;
                a = ellipsoid.equatorRadius;
                ellipsoidName = s;
            } else {
                s = (String)params.get("a");
                if (s != null) {
                    a = Double.parseDouble(s);
                }
                if ((s = (String)params.get("es")) != null) {
                    es = Double.parseDouble(s);
                } else {
                    s = (String)params.get("rf");
                    if (s != null) {
                        es = Double.parseDouble(s);
                        es *= 2.0 - es;
                    } else {
                        s = (String)params.get("f");
                        if (s != null) {
                            es = Double.parseDouble(s);
                            es = 1.0 / es;
                            es *= 2.0 - es;
                        } else {
                            s = (String)params.get("b");
                            if (s != null) {
                                b = Double.parseDouble(s);
                                es = 1.0 - b * b / (a * a);
                            }
                        }
                    }
                }
                if (b == 0.0) {
                    b = a * Math.sqrt(1.0 - es);
                }
            }
            s = (String)params.get("R_A");
            if (s != null && Boolean.getBoolean(s)) {
                a *= 1.0 - es * (0.16666666666666666 + es * (0.04722222222222222 + es * 0.022156084656084655));
            } else {
                s = (String)params.get("R_V");
                if (s != null && Boolean.getBoolean(s)) {
                    a *= 1.0 - es * (0.16666666666666666 + es * (0.06944444444444445 + es * 0.04243827160493827));
                } else {
                    s = (String)params.get("R_a");
                    if (s != null && Boolean.getBoolean(s)) {
                        a = 0.5 * (a + b);
                    } else {
                        s = (String)params.get("R_g");
                        if (s != null && Boolean.getBoolean(s)) {
                            a = Math.sqrt(a * b);
                        } else {
                            s = (String)params.get("R_h");
                            if (s != null && Boolean.getBoolean(s)) {
                                a = 2.0 * a * b / (a + b);
                                es = 0.0;
                            } else {
                                s = (String)params.get("R_lat_a");
                                if (s != null) {
                                    double tmp = Math.sin(ProjectionFactory.parseAngle(s));
                                    if (Math.abs(tmp) > 1.5707963267948966) {
                                        throw new ProjectionException("-11");
                                    }
                                    tmp = 1.0 - es * tmp * tmp;
                                    a *= 0.5 * (1.0 - es + tmp) / (tmp * Math.sqrt(tmp));
                                    es = 0.0;
                                } else {
                                    s = (String)params.get("R_lat_g");
                                    if (s != null) {
                                        double tmp = Math.sin(ProjectionFactory.parseAngle(s));
                                        if (Math.abs(tmp) > 1.5707963267948966) {
                                            throw new ProjectionException("-11");
                                        }
                                        tmp = 1.0 - es * tmp * tmp;
                                        a *= Math.sqrt(1.0 - es) / tmp;
                                        es = 0.0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        projection.setEllipsoid(new Ellipsoid(ellipsoidName, a, es, ellipsoidName));
        s = (String)params.get("lat_0");
        if (s != null) {
            projection.setProjectionLatitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lon_0")) != null) {
            projection.setProjectionLongitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_1")) != null) {
            projection.setProjectionLatitude1Degrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_2")) != null) {
            projection.setProjectionLatitude2Degrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("lat_ts")) != null) {
            projection.setTrueScaleLatitudeDegrees(ProjectionFactory.parseAngle(s));
        }
        if ((s = (String)params.get("x_0")) != null) {
            projection.setFalseEasting(Double.parseDouble(s));
        }
        if ((s = (String)params.get("y_0")) != null) {
            projection.setFalseNorthing(Double.parseDouble(s));
        }
        if ((s = (String)params.get("k_0")) == null) {
            s = (String)params.get("k");
        }
        if (s != null) {
            projection.setScaleFactor(Double.parseDouble(s));
        }
        if ((s = (String)params.get("units")) != null && (unit = Units.findUnits(s)) != null) {
            projection.setFromMetres(unit.value);
        }
        if ((s = (String)params.get("to_meter")) != null) {
            projection.setFromMetres(1.0 / Double.parseDouble(s));
        }
        if (projection instanceof TransverseMercatorProjection && (s = (String)params.get("zone")) != null) {
            ((TransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(s));
        }
        projection.initialize();
        return projection;
    }

    private static double parseAngle(String s) {
        return format.parse(s, null).doubleValue();
    }

    static void register(String name, Class cls, String description) {
        registry.put(name, cls);
    }

    static Projection getNamedPROJ4Projection(String name) {
        Class cls;
        if (registry == null) {
            ProjectionFactory.initialize();
        }
        if ((cls = (Class)registry.get(name)) != null) {
            try {
                Projection projection = (Projection)cls.newInstance();
                if (projection != null) {
                    projection.setName(name);
                }
                return projection;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static void initialize() {
        registry = new Hashtable();
        ProjectionFactory.register("aea", AlbersProjection.class, "Albers Equal Area");
        ProjectionFactory.register("aeqd", EquidistantAzimuthalProjection.class, "Azimuthal Equidistant");
        ProjectionFactory.register("airy", AiryProjection.class, "Airy");
        ProjectionFactory.register("aitoff", AitoffProjection.class, "Aitoff");
        ProjectionFactory.register("alsk", Projection.class, "Mod. Stereographics of Alaska");
        ProjectionFactory.register("apian", Projection.class, "Apian Globular I");
        ProjectionFactory.register("august", AugustProjection.class, "August Epicycloidal");
        ProjectionFactory.register("bacon", Projection.class, "Bacon Globular");
        ProjectionFactory.register("bipc", BipolarProjection.class, "Bipolar conic of western hemisphere");
        ProjectionFactory.register("boggs", BoggsProjection.class, "Boggs Eumorphic");
        ProjectionFactory.register("bonne", BonneProjection.class, "Bonne (Werner lat_1=90)");
        ProjectionFactory.register("cass", CassiniProjection.class, "Cassini");
        ProjectionFactory.register("cc", CentralCylindricalProjection.class, "Central Cylindrical");
        ProjectionFactory.register("cea", Projection.class, "Equal Area Cylindrical");
        ProjectionFactory.register("collg", CollignonProjection.class, "Collignon");
        ProjectionFactory.register("crast", CrasterProjection.class, "Craster Parabolic (Putnins P4)");
        ProjectionFactory.register("denoy", DenoyerProjection.class, "Denoyer Semi-Elliptical");
        ProjectionFactory.register("eck1", Eckert1Projection.class, "Eckert I");
        ProjectionFactory.register("eck2", Eckert2Projection.class, "Eckert II");
        ProjectionFactory.register("eck4", Eckert4Projection.class, "Eckert IV");
        ProjectionFactory.register("eck5", Eckert5Projection.class, "Eckert V");
        ProjectionFactory.register("eqc", PlateCarreeProjection.class, "Equidistant Cylindrical (Plate Caree)");
        ProjectionFactory.register("eqdc", EquidistantConicProjection.class, "Equidistant Conic");
        ProjectionFactory.register("euler", EulerProjection.class, "Euler");
        ProjectionFactory.register("fahey", FaheyProjection.class, "Fahey");
        ProjectionFactory.register("fouc", FoucautProjection.class, "Foucaut");
        ProjectionFactory.register("fouc_s", FoucautSinusoidalProjection.class, "Foucaut Sinusoidal");
        ProjectionFactory.register("gall", GallProjection.class, "Gall (Gall Stereographic)");
        ProjectionFactory.register("gnom", GnomonicAzimuthalProjection.class, "Gnomonic");
        ProjectionFactory.register("goode", GoodeProjection.class, "Goode Homolosine");
        ProjectionFactory.register("hammer", HammerProjection.class, "Hammer & Eckert-Greifendorff");
        ProjectionFactory.register("hatano", HatanoProjection.class, "Hatano Asymmetrical Equal Area");
        ProjectionFactory.register("kav5", KavraiskyVProjection.class, "Kavraisky V");
        ProjectionFactory.register("lagrng", LagrangeProjection.class, "Lagrange");
        ProjectionFactory.register("larr", LarriveeProjection.class, "Larrivee");
        ProjectionFactory.register("lask", LaskowskiProjection.class, "Laskowski");
        ProjectionFactory.register("latlong", NullProjection.class, "Lat/Long");
        ProjectionFactory.register("lcc", LambertConformalConicProjection.class, "Lambert Conformal Conic");
        ProjectionFactory.register("leac", LambertEqualAreaConicProjection.class, "Lambert Equal Area Conic");
        ProjectionFactory.register("loxim", LoximuthalProjection.class, "Loximuthal");
        ProjectionFactory.register("lsat", LandsatProjection.class, "Space oblique for LANDSAT");
        ProjectionFactory.register("mbt_fps", MBTFPSProjection.class, "McBryde-Thomas Flat-Pole Sine (No. 2)");
        ProjectionFactory.register("mbtfpp", MBTFPPProjection.class, "McBride-Thomas Flat-Polar Parabolic");
        ProjectionFactory.register("mbtfpq", MBTFPQProjection.class, "McBryde-Thomas Flat-Polar Quartic");
        ProjectionFactory.register("merc", MercatorProjection.class, "Mercator");
        ProjectionFactory.register("mill", MillerProjection.class, "Miller Cylindrical");
        ProjectionFactory.register("moll", MolleweideProjection.class, "Mollweide");
        ProjectionFactory.register("murd1", Murdoch1Projection.class, "Murdoch I");
        ProjectionFactory.register("murd2", Murdoch2Projection.class, "Murdoch II");
        ProjectionFactory.register("murd3", Murdoch3Projection.class, "Murdoch III");
        ProjectionFactory.register("nell", NellProjection.class, "Nell");
        ProjectionFactory.register("nicol", NicolosiProjection.class, "Nicolosi Globular");
        ProjectionFactory.register("nsper", PerspectiveProjection.class, "Near-sided perspective");
        ProjectionFactory.register("omerc", ObliqueMercatorProjection.class, "Oblique Mercator");
        ProjectionFactory.register("ortho", OrthographicAzimuthalProjection.class, "Orthographic");
        ProjectionFactory.register("pconic", PerspectiveConicProjection.class, "Perspective Conic");
        ProjectionFactory.register("poly", PolyconicProjection.class, "Polyconic (American)");
        ProjectionFactory.register("putp2", PutninsP2Projection.class, "Putnins P2");
        ProjectionFactory.register("putp4p", PutninsP4Projection.class, "Putnins P4'");
        ProjectionFactory.register("putp5", PutninsP5Projection.class, "Putnins P5");
        ProjectionFactory.register("putp5p", PutninsP5PProjection.class, "Putnins P5'");
        ProjectionFactory.register("qua_aut", QuarticAuthalicProjection.class, "Quartic Authalic");
        ProjectionFactory.register("robin", RobinsonProjection.class, "Robinson");
        ProjectionFactory.register("rpoly", RectangularPolyconicProjection.class, "Rectangular Polyconic");
        ProjectionFactory.register("sinu", SinusoidalProjection.class, "Sinusoidal (Sanson-Flamsteed)");
        ProjectionFactory.register("stere", StereographicAzimuthalProjection.class, "Stereographic");
        ProjectionFactory.register("tcc", TCCProjection.class, "Transverse Central Cylindrical");
        ProjectionFactory.register("tcea", TCEAProjection.class, "Transverse Cylindrical Equal Area");
        ProjectionFactory.register("tmerc", TransverseMercatorProjection.class, "Transverse Mercator");
        ProjectionFactory.register("urmfps", URMFPSProjection.class, "Urmaev Flat-Polar Sinusoidal");
        ProjectionFactory.register("utm", TransverseMercatorProjection.class, "Universal Transverse Mercator (UTM)");
        ProjectionFactory.register("vandg", VanDerGrintenProjection.class, "van der Grinten (I)");
        ProjectionFactory.register("vitk1", VitkovskyProjection.class, "Vitkovsky I");
        ProjectionFactory.register("wag1", Wagner1Projection.class, "Wagner I (Kavraisky VI)");
        ProjectionFactory.register("wag2", Wagner2Projection.class, "Wagner II");
        ProjectionFactory.register("wag3", Wagner3Projection.class, "Wagner III");
        ProjectionFactory.register("wag4", Wagner4Projection.class, "Wagner IV");
        ProjectionFactory.register("wag5", Wagner5Projection.class, "Wagner V");
        ProjectionFactory.register("wag7", Wagner7Projection.class, "Wagner VII");
        ProjectionFactory.register("weren", WerenskioldProjection.class, "Werenskiold I");
        ProjectionFactory.register("wintri", WinkelTripelProjection.class, "Winkel Tripel");
    }

    public static Projection readProjectionFile(String file, String name) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ProjectionFactory.class.getResourceAsStream("/nad/" + file)));
        StreamTokenizer t = new StreamTokenizer(reader);
        t.commentChar(35);
        t.ordinaryChars(48, 57);
        t.ordinaryChars(46, 46);
        t.ordinaryChars(45, 45);
        t.ordinaryChars(43, 43);
        t.wordChars(48, 57);
        t.wordChars(39, 39);
        t.wordChars(34, 34);
        t.wordChars(95, 95);
        t.wordChars(46, 46);
        t.wordChars(45, 45);
        t.wordChars(43, 43);
        t.wordChars(44, 44);
        t.nextToken();
        while (t.ttype == 60) {
            t.nextToken();
            if (t.ttype != -3) {
                throw new IOException(t.lineno() + ": Word expected after '<'");
            }
            String cname = t.sval;
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '>' expected");
            }
            t.nextToken();
            Vector<String> v = new Vector<String>();
            String values = "";
            while (t.ttype != 60) {
                if (t.ttype == 43) {
                    t.nextToken();
                }
                if (t.ttype != -3) {
                    throw new IOException(t.lineno() + ": Word expected after '+'");
                }
                String key = t.sval;
                t.nextToken();
                if (t.ttype != 61) continue;
                t.nextToken();
                if (t.ttype != -3) {
                    throw new IOException(t.lineno() + ": Value expected after '='");
                }
                String value = t.sval;
                t.nextToken();
                if (key.startsWith("+")) {
                    v.add(key + "=" + value);
                    continue;
                }
                v.add("+" + key + "=" + value);
            }
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '<>' expected");
            }
            t.nextToken();
            if (!cname.equals(name)) continue;
            Object[] args = new String[v.size()];
            v.copyInto(args);
            reader.close();
            return ProjectionFactory.fromPROJ4Specification((String[])args);
        }
        reader.close();
        return null;
    }

    public static Projection getNamedPROJ4CoordinateSystem(String name) {
        String[] files = new String[]{"world", "nad83", "nad27", "esri", "epsg"};
        try {
            int p = name.indexOf(58);
            if (p >= 0) {
                return ProjectionFactory.readProjectionFile(name.substring(0, p), name.substring(p + 1));
            }
            for (int i = 0; i < files.length; ++i) {
                Projection projection = ProjectionFactory.readProjectionFile(files[i], name);
                if (projection == null) continue;
                return projection;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        Projection projection = ProjectionFactory.fromPROJ4Specification(args);
        if (projection != null) {
            System.out.println(projection.getPROJ4Description());
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("+") || arg.startsWith("-")) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(new File(args[i])));
                    Point2D.Double p = new Point2D.Double();
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer t = new StringTokenizer(line, " ");
                        String slon = t.nextToken();
                        String slat = t.nextToken();
                        p.x = format.parse(slon, null).doubleValue();
                        p.y = format.parse(slat, null).doubleValue();
                        projection.transform(p, p);
                        System.out.println(p.x + " " + p.y);
                    }
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IOException: " + args[i] + ": " + e.getMessage());
                }
            }
        } else {
            System.out.println("Can't find projection " + args[0]);
        }
    }
}

