/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import trafficdefinition.RandomTrafficDefinitionLayer;
import ui.controls.SimTimeEdit;

public class DlgRandomLayerProperties
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton btnCancel = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private RandomTrafficDefinitionLayer layer = null;
    private JLabel lblBeginTime = null;
    private JLabel lblEndingTime = null;
    private SimTimeEdit steBeginTime = null;
    private SimTimeEdit steEndTime = null;
    private JLabel lblVehicles = null;
    private JSpinner spnVehicles = null;

    public DlgRandomLayerProperties(Frame frame, RandomTrafficDefinitionLayer randomTrafficDefinitionLayer) {
        super(frame);
        this.initialize();
        this.layer = randomTrafficDefinitionLayer;
        this.steBeginTime.setValue(randomTrafficDefinitionLayer.getStartingTime());
        this.steEndTime.setValue(randomTrafficDefinitionLayer.getEndingTime());
        this.spnVehicles.setValue(randomTrafficDefinitionLayer.getVehiclesPerSecond());
        this.setVisible(true);
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(283, 92, 73, 26));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgRandomLayerProperties.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(283, 123, 73, 26));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgRandomLayerProperties.this.SaveProperties();
                    DlgRandomLayerProperties.this.setVisible(false);
                }
            });
        }
        return this.btnOK;
    }

    protected void SaveProperties() {
        this.layer.setStartingTime(this.steBeginTime.getValue());
        this.layer.setEndingTime(this.steEndTime.getValue());
        this.layer.setVehiclesPerSecond((Integer)this.spnVehicles.getValue());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblVehicles = new JLabel();
            this.lblVehicles.setBounds(new Rectangle(18, 129, 173, 16));
            this.lblVehicles.setText("Average vehicles per second:");
            this.lblEndingTime = new JLabel();
            this.lblEndingTime.setBounds(new Rectangle(13, 71, 80, 18));
            this.lblEndingTime.setText("Ending time:");
            this.lblBeginTime = new JLabel();
            this.lblBeginTime.setBounds(new Rectangle(12, 12, 82, 21));
            this.lblBeginTime.setText("Starting time:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.lblBeginTime, null);
            this.jContentPane.add((Component)this.lblEndingTime, null);
            this.jContentPane.add((Component)this.getSteBeginTime(), null);
            this.jContentPane.add((Component)this.getSteEndTime(), null);
            this.jContentPane.add((Component)this.lblVehicles, null);
            this.jContentPane.add((Component)this.getSpnVehicles(), null);
        }
        return this.jContentPane;
    }

    private void initialize() {
        this.setSize(373, 191);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("Random traffic layer properties");
        this.setContentPane(this.getJContentPane());
    }

    private SimTimeEdit getSteBeginTime() {
        if (this.steBeginTime == null) {
            this.steBeginTime = new SimTimeEdit();
            this.steBeginTime.setBounds(new Rectangle(102, 12, 166, 48));
        }
        return this.steBeginTime;
    }

    private SimTimeEdit getSteEndTime() {
        if (this.steEndTime == null) {
            this.steEndTime = new SimTimeEdit();
            this.steEndTime.setBounds(new Rectangle(103, 71, 166, 46));
        }
        return this.steEndTime;
    }

    private JSpinner getSpnVehicles() {
        if (this.spnVehicles == null) {
            this.spnVehicles = new JSpinner();
            this.spnVehicles.setBounds(new Rectangle(193, 128, 67, 20));
            this.spnVehicles.setModel(new SpinnerNumberModel(1, 1, 100000, 1));
        }
        return this.spnVehicles;
    }
}

