/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simulation.JobType;
import ui.controls.SimTimeEdit;

public class DlgAddEditJobType
extends JDialog {
    private JobType currentJobType = null;
    int answer = 2;
    private static final long serialVersionUID = 1L;
    private JButton btnCancel = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private JLabel lblEndingTime = null;
    private JLabel lblName = null;
    private JLabel lblStartingTime = null;
    private SimTimeEdit steEndingTime = null;
    private SimTimeEdit steStartingTime = null;
    private JTextField txtName = null;

    public DlgAddEditJobType(Dialog dialog) {
        super(dialog);
        this.initialize();
        this.currentJobType = null;
        this.setTitle("Create job type");
        this.setVisible(true);
    }

    public DlgAddEditJobType(Dialog dialog, JobType jobType) {
        super(dialog);
        this.initialize();
        this.currentJobType = jobType;
        this.txtName.setText(jobType.getName());
        this.steStartingTime.setValue(jobType.getStartingTime());
        this.steEndingTime.setValue(jobType.getEndingTime());
        this.setTitle("Edit job type");
        if (jobType.getName().equals("Default")) {
            this.DisableDialog();
        }
        this.setVisible(true);
    }

    public int getAnswer() {
        return this.answer;
    }

    public JobType getJobType() {
        return this.currentJobType;
    }

    private void DisableDialog() {
        this.txtName.setEnabled(false);
        this.steStartingTime.setEnabled(false);
        this.steEndingTime.setEnabled(false);
        this.btnOK.setEnabled(false);
        this.setTitle("Default job type");
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(131, 154, 76, 21));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgAddEditJobType.this.Cancel();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(214, 154, 71, 21));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgAddEditJobType.this.OK();
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblEndingTime = new JLabel();
            this.lblEndingTime.setBounds(new Rectangle(15, 93, 84, 18));
            this.lblEndingTime.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblEndingTime.setText("Ending time:");
            this.lblStartingTime = new JLabel();
            this.lblStartingTime.setBounds(new Rectangle(15, 31, 84, 18));
            this.lblStartingTime.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblStartingTime.setText("Starting time:");
            this.lblName = new JLabel();
            this.lblName.setBounds(new Rectangle(15, 10, 84, 18));
            this.lblName.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblName.setText("Name:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.lblName, null);
            this.jContentPane.add((Component)this.getTxtName(), null);
            this.jContentPane.add((Component)this.lblStartingTime, null);
            this.jContentPane.add((Component)this.lblEndingTime, null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getSteStartingTime(), null);
            this.jContentPane.add((Component)this.getSteEndingTime(), null);
        }
        return this.jContentPane;
    }

    private SimTimeEdit getSteEndingTime() {
        if (this.steEndingTime == null) {
            this.steEndingTime = new SimTimeEdit();
            this.steEndingTime.setBounds(new Rectangle(110, 95, 174, 54));
        }
        return this.steEndingTime;
    }

    private SimTimeEdit getSteStartingTime() {
        if (this.steStartingTime == null) {
            this.steStartingTime = new SimTimeEdit();
            this.steStartingTime.setBounds(new Rectangle(109, 33, 166, 54));
        }
        return this.steStartingTime;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.setBounds(new Rectangle(110, 10, 176, 20));
        }
        return this.txtName;
    }

    private void initialize() {
        this.setSize(297, 213);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setTitle("Job type");
        this.setContentPane(this.getJContentPane());
    }

    protected void Cancel() {
        this.answer = 2;
        this.setVisible(false);
    }

    protected void OK() {
        if (this.txtName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a name");
            return;
        }
        if (this.steEndingTime.getValue() <= this.steStartingTime.getValue()) {
            JOptionPane.showMessageDialog(this, "The ending time must be later than the starting time");
            return;
        }
        if (this.currentJobType == null) {
            this.currentJobType = new JobType(this.txtName.getText(), this.steStartingTime.getValue(), this.steEndingTime.getValue());
        } else {
            this.currentJobType.setName(this.txtName.getText());
            this.currentJobType.setStartingTime(this.steStartingTime.getValue());
            this.currentJobType.setEndingTime(this.steEndingTime.getValue());
        }
        this.answer = 0;
        this.setVisible(false);
    }
}

