/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import classes.TypeSelection;
import enums.EditingMode;
import enums.SelectionType;
import enums.ToolType;
import helpers.ApplicationSettings;
import helpers.Broadcaster;
import interfaces.CurrentLayerChangedListener;
import interfaces.ProjectChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roadnetwork.RoadNetwork;
import simulation.SimulationExporter;
import simulation.VehicleType;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.TrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;
import ui.Display;
import ui.PnlLayers;
import ui.PnlProperties;
import ui.dialogs.DlgExportSimulation;
import ui.dialogs.DlgManageJobTypes;
import ui.dialogs.DlgManageVehicleTypes;
import ui.dialogs.DlgNewProject;
import ui.dialogs.DlgRandomLayerProperties;
import ui.dialogs.DlgSelectTypes;
import ui.dialogs.DlgSettings;
import ui.filefilters.ProjectFileFilter;
import ui.filefilters.TDLFileFilter;

public class MainWindow
extends JFrame
implements CurrentLayerChangedListener,
WindowListener,
ProjectChangedListener {
    private static final long serialVersionUID = 1L;
    private JToggleButton btnAddSelection = null;
    private JToggleButton btnCreateAccident = null;
    private JToggleButton btnCreateArea = null;
    private JToggleButton btnCreateAreaFlow = null;
    private JToggleButton btnCreateFlowEdgeToEdge = null;
    private JToggleButton btnCreateHotSpot = null;
    private JToggleButton btnCreateSchool = null;
    private JButton btnDelete = null;
    private JToggleButton btnNewSelection = null;
    private JToggleButton btnPan = null;
    private JToggleButton btnRemoveSelection = null;
    private JToggleButton btnSelect = null;
    private JButton btnUndelete = null;
    private JToggleButton btnZoom = null;
    private TrafficDefinitionLayer currentTrafficLayer = null;
    private JPanel jContentPane = null;
    private Display mapDisplay = null;
    private JMenu mnuFile = null;
    private JMenuItem mnuitmClose = null;
    private JCheckBoxMenuItem mnuitmDeletedMapElements = null;
    private JCheckBoxMenuItem mnuitmDrawAllTrafficLayers = null;
    private JMenuItem mnuitmExit = null;
    private JMenuItem mnuitmExportSimulation = null;
    private JMenuItem mnuitmSelectActivityBasedVehicleTypes = null;
    private JMenuItem mnuitmJobTypes = null;
    private JMenuItem mnuitmLayerSelectVehicleTypes = null;
    private JMenuItem mnuitmLayerProperties = null;
    private JMenuItem mnuitmNew = null;
    private JMenuItem mnuitmOpen = null;
    private JMenuItem mnuitmPurgeDeleted = null;
    private JMenuItem mnuitmSave = null;
    private JMenuItem mnuitmSaveAs = null;
    private JMenuItem mnuitmExportTDL = null;
    private JMenuItem mnuitmSelectAll = null;
    private JMenuItem mnuitmSelectInverse = null;
    private JMenuItem mnuitmSelectNone = null;
    private JMenuItem mnuitmSettings = null;
    private JMenuItem mnuitmVehicleTypes = null;
    private JMenuItem mnuitmZoomToFit = null;
    private JMenuItem mnuitmHelpAbout = null;
    private JMenuBar mnuMain = null;
    private JMenu mnuSelect = null;
    private JMenu mnuSimulation = null;
    private JMenu mnuHelp = null;
    private JMenu mnuTrafficLayer = null;
    private JMenu mnuView = null;
    private PnlLayers pnlLayers = null;
    private PnlProperties pnlProperties = null;
    private JPanel pnlScrollDisplay = null;
    private Project project = null;
    private JScrollBar scrlMapHorizontal = null;
    private JScrollBar scrlMapVertical = null;
    private ButtonGroup SelectionTypeGroup = new ButtonGroup();
    private JSplitPane splitPane = null;
    private JSplitPane splitPaneRight = null;
    private JToolBar tlbTools = null;
    private ButtonGroup ToolGroup = new ButtonGroup();

    public MainWindow() {
        this.initialize();
        this.SetToolbarEnabled(false);
        Broadcaster.addProjectChangedListener(this);
        this.addWindowListener(this);
        this.pnlLayers.addCurrentLayerChangedListener(this);
        this.pnlLayers.addCurrentLayerChangedListener(this.pnlProperties);
        this.pnlLayers.addCurrentLayerChangedListener(this.mapDisplay);
        Broadcaster.addProjectChangedListener(this.pnlProperties);
        this.pnlProperties.setMapDisplay(this.mapDisplay);
    }

    @Override
    public void CurrentLayerChanged(Layer<? extends ProjectElement> layer) {
        if (layer instanceof RoadNetwork) {
            this.setEditingMode(EditingMode.Map);
            this.currentTrafficLayer = null;
        } else if (layer instanceof UserDefinedTrafficDefinitionLayer) {
            this.setEditingMode(EditingMode.UserDefinedTraffic);
            this.currentTrafficLayer = (TrafficDefinitionLayer)layer;
        } else if (layer instanceof ActivityBasedTrafficDefinitionLayer) {
            this.setEditingMode(EditingMode.ActivityBasedTraffic);
            this.currentTrafficLayer = (TrafficDefinitionLayer)layer;
        } else if (layer instanceof RandomTrafficDefinitionLayer) {
            this.setEditingMode(EditingMode.RandomTraffic);
            this.currentTrafficLayer = (TrafficDefinitionLayer)layer;
        }
    }

    @Override
    public void ProjectChanged(Project project) {
        this.project = project;
        if (this.project == null) {
            this.mnuitmClose.setEnabled(false);
            this.mnuitmSave.setEnabled(false);
            this.mnuitmSaveAs.setEnabled(false);
            this.mnuitmExportTDL.setEnabled(false);
            this.mnuitmPurgeDeleted.setEnabled(false);
            this.mnuSelect.setEnabled(false);
            this.mnuView.setEnabled(false);
            this.mnuTrafficLayer.setEnabled(false);
            this.mnuSimulation.setEnabled(false);
            this.SetToolbarEnabled(false);
            this.scrlMapVertical.setEnabled(false);
            this.scrlMapHorizontal.setEnabled(false);
            this.setTitle("SUMO Traffic Generator");
            this.btnNewSelection.setSelected(true);
            this.currentTrafficLayer = null;
        } else {
            this.mnuitmClose.setEnabled(true);
            this.mnuitmSave.setEnabled(true);
            this.mnuitmSaveAs.setEnabled(true);
            this.mnuitmExportTDL.setEnabled(true);
            this.mnuitmPurgeDeleted.setEnabled(true);
            this.mnuSelect.setEnabled(true);
            this.mnuView.setEnabled(true);
            this.mnuSimulation.setEnabled(true);
            this.scrlMapVertical.setEnabled(true);
            this.scrlMapHorizontal.setEnabled(true);
            this.SetToolbarEnabled(true);
            this.setTitle("SUMO Traffic Generator - " + this.project.getFileName());
            this.setEditingMode(EditingMode.Map);
            this.getMapDisplay().setTool(ToolType.Pan);
        }
    }

    public void setEditingMode(EditingMode editingMode) {
        switch (editingMode) {
            case Map: {
                this.btnCreateFlowEdgeToEdge.setEnabled(false);
                this.btnCreateAreaFlow.setEnabled(false);
                this.btnCreateArea.setEnabled(false);
                this.btnCreateHotSpot.setEnabled(false);
                this.btnCreateAccident.setEnabled(false);
                this.btnCreateSchool.setEnabled(false);
                this.btnUndelete.setEnabled(true);
                this.mnuTrafficLayer.setEnabled(false);
                break;
            }
            case UserDefinedTraffic: {
                this.btnCreateFlowEdgeToEdge.setEnabled(true);
                this.btnCreateAreaFlow.setEnabled(true);
                this.btnCreateHotSpot.setEnabled(true);
                this.btnCreateAccident.setEnabled(true);
                this.btnCreateSchool.setEnabled(false);
                this.btnCreateArea.setEnabled(false);
                this.btnUndelete.setEnabled(false);
                this.mnuTrafficLayer.setEnabled(false);
                break;
            }
            case ActivityBasedTraffic: {
                this.btnCreateFlowEdgeToEdge.setEnabled(false);
                this.btnCreateAreaFlow.setEnabled(false);
                this.btnCreateHotSpot.setEnabled(false);
                this.btnCreateAccident.setEnabled(false);
                this.btnCreateSchool.setEnabled(true);
                this.btnCreateArea.setEnabled(true);
                this.btnUndelete.setEnabled(false);
                this.mnuTrafficLayer.setEnabled(false);
                break;
            }
            case RandomTraffic: {
                this.btnCreateFlowEdgeToEdge.setEnabled(false);
                this.btnCreateAreaFlow.setEnabled(false);
                this.btnCreateArea.setEnabled(false);
                this.btnCreateHotSpot.setEnabled(false);
                this.btnCreateAccident.setEnabled(false);
                this.btnCreateSchool.setEnabled(false);
                this.btnUndelete.setEnabled(false);
                this.mnuTrafficLayer.setEnabled(true);
            }
        }
        this.btnPan.setSelected(true);
        this.getMapDisplay().setTool(ToolType.Pan);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.Exit();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private int CloseProject() {
        switch (JOptionPane.showConfirmDialog(this, "Would you like to save your changes?")) {
            case 0: {
                this.SaveProject();
            }
            case 1: {
                break;
            }
            case -1: 
            case 2: {
                return 2;
            }
        }
        this.project.Close();
        Broadcaster.NotifyProjectChanged(null);
        return 0;
    }

    private void Exit() {
        if (this.project != null && this.CloseProject() == 2) {
            return;
        }
        System.exit(0);
    }

    private JToggleButton getBtnAddSelection() {
        if (this.btnAddSelection == null) {
            this.btnAddSelection = new JToggleButton();
            this.btnAddSelection.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/selectionadd.png")));
            this.btnAddSelection.setToolTipText("Add to selection");
            this.btnAddSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SetAddToSelection();
                }
            });
        }
        return this.btnAddSelection;
    }

    private JToggleButton getBtnCreateAccident() {
        if (this.btnCreateAccident == null) {
            this.btnCreateAccident = new JToggleButton();
            this.btnCreateAccident.setText("Accident");
            this.btnCreateAccident.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/accident.png")));
            this.btnCreateAccident.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Accident);
                }
            });
        }
        return this.btnCreateAccident;
    }

    private JToggleButton getBtnCreateArea() {
        if (this.btnCreateArea == null) {
            this.btnCreateArea = new JToggleButton();
            this.btnCreateArea.setText("Traffic Area");
            this.btnCreateArea.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/traffic_area.png")));
            this.btnCreateArea.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Area);
                }
            });
        }
        return this.btnCreateArea;
    }

    private JToggleButton getBtnCreateAreaFlow() {
        if (this.btnCreateAreaFlow == null) {
            this.btnCreateAreaFlow = new JToggleButton();
            this.btnCreateAreaFlow.setText("Area Flow");
            this.btnCreateAreaFlow.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/areaflow.png")));
            this.btnCreateAreaFlow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.AreaFlow);
                }
            });
        }
        return this.btnCreateAreaFlow;
    }

    private JToggleButton getBtnCreateFlowEdgeToEdge() {
        if (this.btnCreateFlowEdgeToEdge == null) {
            this.btnCreateFlowEdgeToEdge = new JToggleButton();
            this.btnCreateFlowEdgeToEdge.setText("Flow");
            this.btnCreateFlowEdgeToEdge.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/flow.png")));
            this.btnCreateFlowEdgeToEdge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Flow);
                }
            });
        }
        return this.btnCreateFlowEdgeToEdge;
    }

    private JToggleButton getBtnCreateHotSpot() {
        if (this.btnCreateHotSpot == null) {
            this.btnCreateHotSpot = new JToggleButton();
            this.btnCreateHotSpot.setText("Hotspot");
            this.btnCreateHotSpot.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/hotspotinout.png")));
            this.btnCreateHotSpot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Hotspot);
                }
            });
        }
        return this.btnCreateHotSpot;
    }

    private JToggleButton getBtnCreateSchool() {
        if (this.btnCreateSchool == null) {
            this.btnCreateSchool = new JToggleButton();
            this.btnCreateSchool.setText("School");
            this.btnCreateSchool.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/school.png")));
            this.btnCreateSchool.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.School);
                }
            });
        }
        return this.btnCreateSchool;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/delete.png")));
            this.btnDelete.setToolTipText("Delete");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().DeleteSelectedObjects();
                }
            });
        }
        return this.btnDelete;
    }

    private JToggleButton getBtnNewSelection() {
        if (this.btnNewSelection == null) {
            this.btnNewSelection = new JToggleButton();
            this.btnNewSelection.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/selectionnew.png")));
            this.btnNewSelection.setToolTipText("New selection");
            this.btnNewSelection.setSelected(true);
            this.btnNewSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SetNewSelection();
                }
            });
        }
        return this.btnNewSelection;
    }

    private JToggleButton getBtnPan() {
        if (this.btnPan == null) {
            this.btnPan = new JToggleButton();
            this.btnPan.setPreferredSize(new Dimension(16, 16));
            this.btnPan.setSize(new Dimension(16, 16));
            this.btnPan.setSelected(false);
            this.btnPan.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/pan.gif")));
            this.btnPan.setToolTipText("Pan");
            this.btnPan.setLocation(new Point(16, 5));
            this.btnPan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Pan);
                }
            });
        }
        return this.btnPan;
    }

    private JToggleButton getBtnRemoveSelection() {
        if (this.btnRemoveSelection == null) {
            this.btnRemoveSelection = new JToggleButton();
            this.btnRemoveSelection.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/selectionremove.png")));
            this.btnRemoveSelection.setToolTipText("Subtract from selection");
            this.btnRemoveSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SetRemoveFromSelection();
                }
            });
        }
        return this.btnRemoveSelection;
    }

    private JToggleButton getBtnSelect() {
        if (this.btnSelect == null) {
            this.btnSelect = new JToggleButton();
            this.btnSelect.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/select.png")));
            this.btnSelect.setToolTipText("Select");
            this.btnSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Select);
                }
            });
            this.btnSelect.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (MainWindow.this.btnSelect.isSelected()) {
                        MainWindow.this.btnNewSelection.setVisible(true);
                        MainWindow.this.btnAddSelection.setVisible(true);
                        MainWindow.this.btnRemoveSelection.setVisible(true);
                    } else {
                        MainWindow.this.btnNewSelection.setVisible(false);
                        MainWindow.this.btnAddSelection.setVisible(false);
                        MainWindow.this.btnRemoveSelection.setVisible(false);
                    }
                }
            });
        }
        return this.btnSelect;
    }

    private JButton getBtnUndelete() {
        if (this.btnUndelete == null) {
            this.btnUndelete = new JButton();
            this.btnUndelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/undelete.png")));
            this.btnUndelete.setToolTipText("Undelete");
            this.btnUndelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().UndeleteSelectedObjects();
                }
            });
        }
        return this.btnUndelete;
    }

    private JToggleButton getBtnZoom() {
        if (this.btnZoom == null) {
            this.btnZoom = new JToggleButton();
            this.btnZoom.setToolTipText("Zoom");
            this.btnZoom.setPreferredSize(new Dimension(24, 24));
            this.btnZoom.setBounds(new Rectangle(296, 1, 24, 24));
            this.btnZoom.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/zoom.png")));
            this.btnZoom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().setTool(ToolType.Zoom);
                }
            });
        }
        return this.btnZoom;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTlbTools(), "First");
            this.jContentPane.add((Component)this.getSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private Display getMapDisplay() {
        if (this.mapDisplay == null) {
            this.mapDisplay = new Display(this.getScrlMapVertical(), this.getScrlMapHorizontal());
        }
        return this.mapDisplay;
    }

    private JMenu getMnuFile() {
        if (this.mnuFile == null) {
            this.mnuFile = new JMenu();
            this.mnuFile.setText("File");
            this.mnuFile.add(this.getMnuitmNew());
            this.mnuFile.add(this.getMnuitmOpen());
            this.mnuFile.add(this.getMnuitmSave());
            this.mnuFile.add(this.getMnuitmSaveAs());
            this.mnuFile.add(this.getMnuitmExportTDL());
            this.mnuFile.add(this.getMnuitmClose());
            this.mnuFile.add(this.getMnuitmPurgeDeleted());
            this.mnuFile.add(this.getMnuitmExit());
        }
        return this.mnuFile;
    }

    private JMenuItem getMnuitmClose() {
        if (this.mnuitmClose == null) {
            this.mnuitmClose = new JMenuItem();
            this.mnuitmClose.setText("Close");
            this.mnuitmClose.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmClose.setEnabled(false);
            this.mnuitmClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.CloseProject();
                }
            });
        }
        return this.mnuitmClose;
    }

    private JCheckBoxMenuItem getMnuitmDeletedMapElements() {
        if (this.mnuitmDeletedMapElements == null) {
            this.mnuitmDeletedMapElements = new JCheckBoxMenuItem();
            this.mnuitmDeletedMapElements.setText("Show deleted map elements");
            this.mnuitmDeletedMapElements.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MainWindow.this.getMapDisplay().setShowDeleted(MainWindow.this.mnuitmDeletedMapElements.isSelected());
                }
            });
        }
        return this.mnuitmDeletedMapElements;
    }

    private JCheckBoxMenuItem getMnuitmDrawAllTrafficLayers() {
        if (this.mnuitmDrawAllTrafficLayers == null) {
            this.mnuitmDrawAllTrafficLayers = new JCheckBoxMenuItem();
            this.mnuitmDrawAllTrafficLayers.setText("Draw all traffic layers");
            this.mnuitmDrawAllTrafficLayers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MainWindow.this.getMapDisplay().setDrawAllTrafficLayers(MainWindow.this.mnuitmDrawAllTrafficLayers.isSelected());
                }
            });
        }
        return this.mnuitmDrawAllTrafficLayers;
    }

    private JMenuItem getMnuitmExit() {
        if (this.mnuitmExit == null) {
            this.mnuitmExit = new JMenuItem();
            this.mnuitmExit.setText("Exit");
            this.mnuitmExit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/exit.png")));
            this.mnuitmExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.Exit();
                }
            });
        }
        return this.mnuitmExit;
    }

    private JMenuItem getMnuitmExportSimulation() {
        if (this.mnuitmExportSimulation == null) {
            this.mnuitmExportSimulation = new JMenuItem();
            this.mnuitmExportSimulation.setText("Export...");
            this.mnuitmExportSimulation.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmExportSimulation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ExportSimulation();
                }
            });
        }
        return this.mnuitmExportSimulation;
    }

    private JMenuItem getMnuitmHelpAbout() {
        if (this.mnuitmHelpAbout == null) {
            this.mnuitmHelpAbout = new JMenuItem();
            this.mnuitmHelpAbout.setText("About...");
            this.mnuitmHelpAbout.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ShowHelpAbout();
                }
            });
        }
        return this.mnuitmHelpAbout;
    }

    protected void ShowHelpAbout() {
        JOptionPane.showMessageDialog(this, "Version 1.1\nDeveloped by Leontios Papaleontiou and others");
    }

    private JMenuItem getMnuitmSelectActivityBasedVehicleTypes() {
        if (this.mnuitmSelectActivityBasedVehicleTypes == null) {
            this.mnuitmSelectActivityBasedVehicleTypes = new JMenuItem();
            this.mnuitmSelectActivityBasedVehicleTypes.setText("Select vehicle types for activity-based layers...");
            this.mnuitmSelectActivityBasedVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmSelectActivityBasedVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SelectActivityBasedVehicleTypes();
                }
            });
        }
        return this.mnuitmSelectActivityBasedVehicleTypes;
    }

    private JMenuItem getMnuitmJobTypes() {
        if (this.mnuitmJobTypes == null) {
            this.mnuitmJobTypes = new JMenuItem();
            this.mnuitmJobTypes.setText("Job types...");
            this.mnuitmJobTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/jobtypes.png")));
            this.mnuitmJobTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ShowJobTypes();
                }
            });
        }
        return this.mnuitmJobTypes;
    }

    private JMenuItem getMnuitmLayerSelectVehicleTypes() {
        if (this.mnuitmLayerSelectVehicleTypes == null) {
            this.mnuitmLayerSelectVehicleTypes = new JMenuItem();
            this.mnuitmLayerSelectVehicleTypes.setText("Select vehicle types...");
            this.mnuitmLayerSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SelectRandomTrafficLayerVehicleTypes();
                }
            });
        }
        return this.mnuitmLayerSelectVehicleTypes;
    }

    private JMenuItem getMnuitmLayerProperties() {
        if (this.mnuitmLayerProperties == null) {
            this.mnuitmLayerProperties = new JMenuItem();
            this.mnuitmLayerProperties.setText("Properties...");
            this.mnuitmLayerProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SetTrafficLayerProperties();
                }
            });
        }
        return this.mnuitmLayerProperties;
    }

    private JMenuItem getMnuitmNew() {
        if (this.mnuitmNew == null) {
            this.mnuitmNew = new JMenuItem();
            this.mnuitmNew.setText("New project...");
            this.mnuitmNew.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/new.png")));
            this.mnuitmNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.NewProject();
                }
            });
        }
        return this.mnuitmNew;
    }

    private JMenuItem getMnuitmOpen() {
        if (this.mnuitmOpen == null) {
            this.mnuitmOpen = new JMenuItem();
            this.mnuitmOpen.setText("Open");
            this.mnuitmOpen.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/open.png")));
            this.mnuitmOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.OpenProject();
                }
            });
        }
        return this.mnuitmOpen;
    }

    private JMenuItem getMnuitmPurgeDeleted() {
        if (this.mnuitmPurgeDeleted == null) {
            this.mnuitmPurgeDeleted = new JMenuItem();
            this.mnuitmPurgeDeleted.setText("Purge deleted map");
            this.mnuitmPurgeDeleted.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/purge.png")));
            this.mnuitmPurgeDeleted.setEnabled(false);
            this.mnuitmPurgeDeleted.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.PurgeDeleted();
                }
            });
        }
        return this.mnuitmPurgeDeleted;
    }

    private JMenuItem getMnuitmSave() {
        if (this.mnuitmSave == null) {
            this.mnuitmSave = new JMenuItem();
            this.mnuitmSave.setText("Save");
            this.mnuitmSave.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/save.png")));
            this.mnuitmSave.setEnabled(false);
            this.mnuitmSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SaveProject();
                }
            });
        }
        return this.mnuitmSave;
    }

    private JMenuItem getMnuitmSaveAs() {
        if (this.mnuitmSaveAs == null) {
            this.mnuitmSaveAs = new JMenuItem();
            this.mnuitmSaveAs.setText("Save As...");
            this.mnuitmSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmSaveAs.setEnabled(false);
            this.mnuitmSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SaveProjectAs();
                }
            });
        }
        return this.mnuitmSaveAs;
    }

    private JMenuItem getMnuitmExportTDL() {
        if (this.mnuitmExportTDL == null) {
            this.mnuitmExportTDL = new JMenuItem();
            this.mnuitmExportTDL.setText("Export TDL...");
            this.mnuitmExportTDL.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmExportTDL.setEnabled(false);
            this.mnuitmExportTDL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ExportTDL();
                }
            });
        }
        return this.mnuitmExportTDL;
    }

    private JMenuItem getMnuitmSelectAll() {
        if (this.mnuitmSelectAll == null) {
            this.mnuitmSelectAll = new JMenuItem();
            this.mnuitmSelectAll.setText("Select All");
            this.mnuitmSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SelectAll();
                }
            });
        }
        return this.mnuitmSelectAll;
    }

    private JMenuItem getMnuitmSelectInverse() {
        if (this.mnuitmSelectInverse == null) {
            this.mnuitmSelectInverse = new JMenuItem();
            this.mnuitmSelectInverse.setText("Select Inverse");
            this.mnuitmSelectInverse.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmSelectInverse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SelectInverse();
                }
            });
        }
        return this.mnuitmSelectInverse;
    }

    private JMenuItem getMnuitmSelectNone() {
        if (this.mnuitmSelectNone == null) {
            this.mnuitmSelectNone = new JMenuItem();
            this.mnuitmSelectNone.setText("Select None");
            this.mnuitmSelectNone.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmSelectNone.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.SelectNone();
                }
            });
        }
        return this.mnuitmSelectNone;
    }

    private JMenuItem getMnuitmSettings() {
        if (this.mnuitmSettings == null) {
            this.mnuitmSettings = new JMenuItem();
            this.mnuitmSettings.setText("Settings...");
            this.mnuitmSettings.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/settings.png")));
            this.mnuitmSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ShowSettings();
                }
            });
        }
        return this.mnuitmSettings;
    }

    private JMenuItem getMnuitmVehicleTypes() {
        if (this.mnuitmVehicleTypes == null) {
            this.mnuitmVehicleTypes = new JMenuItem();
            this.mnuitmVehicleTypes.setText("Vehicle types...");
            this.mnuitmVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.mnuitmVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.ShowVehicleTypes();
                }
            });
        }
        return this.mnuitmVehicleTypes;
    }

    private JMenuItem getMnuitmZoomToFit() {
        if (this.mnuitmZoomToFit == null) {
            this.mnuitmZoomToFit = new JMenuItem();
            this.mnuitmZoomToFit.setText("Zoom to fit");
            this.mnuitmZoomToFit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/clear.png")));
            this.mnuitmZoomToFit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.getMapDisplay().ZoomToFitAndCenter();
                }
            });
        }
        return this.mnuitmZoomToFit;
    }

    private JMenuBar getMnuMain() {
        if (this.mnuMain == null) {
            this.mnuMain = new JMenuBar();
            this.mnuMain.add(this.getMnuFile());
            this.mnuMain.add(this.getMnuSelect());
            this.mnuMain.add(this.getMnuView());
            this.mnuMain.add(this.getMnuTrafficLayer());
            this.mnuMain.add(this.getMnuSimulation());
            this.mnuMain.add(this.getMnuHelp());
        }
        return this.mnuMain;
    }

    private JMenu getMnuSelect() {
        if (this.mnuSelect == null) {
            this.mnuSelect = new JMenu();
            this.mnuSelect.setText("Select");
            this.mnuSelect.setEnabled(false);
            this.mnuSelect.add(this.getMnuitmSelectInverse());
            this.mnuSelect.add(this.getMnuitmSelectNone());
            this.mnuSelect.add(this.getMnuitmSelectAll());
        }
        return this.mnuSelect;
    }

    private JMenu getMnuSimulation() {
        if (this.mnuSimulation == null) {
            this.mnuSimulation = new JMenu();
            this.mnuSimulation.setText("Simulation");
            this.mnuSimulation.setEnabled(false);
            this.mnuSimulation.add(this.getMnuitmExportSimulation());
            this.mnuSimulation.add(this.getMnuitmSelectActivityBasedVehicleTypes());
        }
        return this.mnuSimulation;
    }

    private JMenu getMnuHelp() {
        if (this.mnuHelp == null) {
            this.mnuHelp = new JMenu();
            this.mnuHelp.setText("Help");
            this.mnuHelp.add(this.getMnuitmHelpAbout());
        }
        return this.mnuHelp;
    }

    private JMenu getMnuTrafficLayer() {
        if (this.mnuTrafficLayer == null) {
            this.mnuTrafficLayer = new JMenu();
            this.mnuTrafficLayer.setText("Traffic Layer");
            this.mnuTrafficLayer.setEnabled(false);
            this.mnuTrafficLayer.add(this.getMnuitmLayerSelectVehicleTypes());
            this.mnuTrafficLayer.add(this.getMnuitmLayerProperties());
        }
        return this.mnuTrafficLayer;
    }

    private JMenu getMnuView() {
        if (this.mnuView == null) {
            this.mnuView = new JMenu();
            this.mnuView.setText("View");
            this.mnuView.setEnabled(false);
            this.mnuView.add(this.getMnuitmDeletedMapElements());
            this.mnuView.add(this.getMnuitmDrawAllTrafficLayers());
            this.mnuView.add(this.getMnuitmZoomToFit());
            this.mnuView.add(this.getMnuitmSettings());
            this.mnuView.add(this.getMnuitmJobTypes());
            this.mnuView.add(this.getMnuitmVehicleTypes());
        }
        return this.mnuView;
    }

    private PnlLayers getPnlLayers() {
        if (this.pnlLayers == null) {
            this.pnlLayers = new PnlLayers();
        }
        return this.pnlLayers;
    }

    private PnlProperties getPnlProperties() {
        if (this.pnlProperties == null) {
            this.pnlProperties = new PnlProperties();
        }
        return this.pnlProperties;
    }

    private JPanel getPnlScrollDisplay() {
        if (this.pnlScrollDisplay == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            this.pnlScrollDisplay = new JPanel();
            this.pnlScrollDisplay.setLayout(new GridBagLayout());
            this.pnlScrollDisplay.add((Component)this.getMapDisplay(), gridBagConstraints3);
            this.pnlScrollDisplay.add((Component)this.getScrlMapVertical(), gridBagConstraints2);
            this.pnlScrollDisplay.add((Component)this.getScrlMapHorizontal(), gridBagConstraints);
        }
        return this.pnlScrollDisplay;
    }

    private JScrollBar getScrlMapHorizontal() {
        if (this.scrlMapHorizontal == null) {
            this.scrlMapHorizontal = new JScrollBar();
            this.scrlMapHorizontal.setOrientation(0);
            this.scrlMapHorizontal.setEnabled(false);
        }
        return this.scrlMapHorizontal;
    }

    private JScrollBar getScrlMapVertical() {
        if (this.scrlMapVertical == null) {
            this.scrlMapVertical = new JScrollBar();
            this.scrlMapVertical.setEnabled(false);
        }
        return this.scrlMapVertical;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setDividerLocation(640);
            this.splitPane.setResizeWeight(1.0);
            this.splitPane.setDividerSize(8);
            this.splitPane.setLeftComponent(this.getPnlScrollDisplay());
            this.splitPane.setRightComponent(this.getSplitPaneRight());
        }
        return this.splitPane;
    }

    private JSplitPane getSplitPaneRight() {
        if (this.splitPaneRight == null) {
            this.splitPaneRight = new JSplitPane();
            this.splitPaneRight.setOrientation(0);
            this.splitPaneRight.setResizeWeight(1.0);
            this.splitPaneRight.setDividerLocation(200);
            this.splitPaneRight.setDividerSize(8);
            this.splitPaneRight.setContinuousLayout(true);
            this.splitPaneRight.setTopComponent(this.getPnlLayers());
            this.splitPaneRight.setBottomComponent(this.getPnlProperties());
            this.splitPaneRight.setOneTouchExpandable(true);
        }
        return this.splitPaneRight;
    }

    private JToolBar getTlbTools() {
        if (this.tlbTools == null) {
            this.tlbTools = new JToolBar();
            this.tlbTools.setName("Tools");
            this.tlbTools.setPreferredSize(new Dimension(500, 32));
            this.tlbTools.setVisible(true);
            this.tlbTools.setRollover(true);
            this.tlbTools.add(this.getBtnSelect());
            this.tlbTools.add(this.getBtnZoom());
            this.tlbTools.add(this.getBtnPan());
            this.tlbTools.add(new JToolBar.Separator());
            this.tlbTools.add(this.getBtnCreateFlowEdgeToEdge());
            this.tlbTools.add(this.getBtnCreateAreaFlow());
            this.tlbTools.add(this.getBtnCreateHotSpot());
            this.tlbTools.add(this.getBtnCreateAccident());
            this.tlbTools.add(new JToolBar.Separator());
            this.tlbTools.add(this.getBtnCreateArea());
            this.tlbTools.add(this.getBtnCreateSchool());
            this.tlbTools.add(new JToolBar.Separator());
            this.tlbTools.add(this.getBtnDelete());
            this.tlbTools.add(this.getBtnUndelete());
            this.tlbTools.add(new JToolBar.Separator());
            this.tlbTools.add(this.getBtnNewSelection());
            this.tlbTools.add(this.getBtnAddSelection());
            this.tlbTools.add(this.getBtnRemoveSelection());
            this.SelectionTypeGroup.add(this.getBtnNewSelection());
            this.SelectionTypeGroup.add(this.getBtnAddSelection());
            this.SelectionTypeGroup.add(this.getBtnRemoveSelection());
            this.ToolGroup.add(this.getBtnCreateFlowEdgeToEdge());
            this.ToolGroup.add(this.getBtnCreateAreaFlow());
            this.ToolGroup.add(this.getBtnCreateHotSpot());
            this.ToolGroup.add(this.getBtnCreateAccident());
            this.ToolGroup.add(this.getBtnCreateArea());
            this.ToolGroup.add(this.getBtnCreateSchool());
            this.ToolGroup.add(this.getBtnPan());
            this.ToolGroup.add(this.getBtnZoom());
            this.ToolGroup.add(this.getBtnSelect());
        }
        return this.tlbTools;
    }

    private void initialize() {
        this.setSize(946, 505);
        this.setPreferredSize(new Dimension(946, 505));
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.getMnuMain());
        this.setContentPane(this.getJContentPane());
        this.setTitle("SUMO Traffic Generator");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NewProject() {
        if (this.project != null && this.CloseProject() == 2) {
            return;
        }
        DlgNewProject dlgNewProject = new DlgNewProject(this);
        dlgNewProject.setSize(new Dimension(452, 153));
        if (dlgNewProject.getAnswer() == 0) {
            try {
                this.setCursor(3);
                Project project = new Project(dlgNewProject.getProjectPath(), dlgNewProject.getMapFile());
                Broadcaster.NotifyProjectChanged(project);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "An error occured while creating the project", "Error", 0);
                JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
                exception.printStackTrace();
            }
            finally {
                this.setCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OpenProject() {
        if (this.project != null && this.CloseProject() == 2) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select project path");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new ProjectFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        try {
            this.setCursor(3);
            File file = jFileChooser.getSelectedFile();
            Project project = new Project(file.getAbsolutePath());
            Broadcaster.NotifyProjectChanged(project);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occured while opening the project", "Error", 0);
            exception.printStackTrace();
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveProject() {
        try {
            this.setCursor(3);
            this.project.Save();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occured while saving the project", "Error", 0);
            exception.printStackTrace();
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExportTDL() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select export file");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new TDLFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 1) {
            return;
        }
        try {
            this.setCursor(3);
            File file = jFileChooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(".tdl")) {
                file = new File(file.getAbsolutePath() + ".tdl");
            }
            this.project.saveTDL(file.getAbsolutePath());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occured while exporting the project", "Error", 0);
            exception.printStackTrace();
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveProjectAs() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select project path");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new ProjectFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 1) {
            return;
        }
        try {
            this.setCursor(3);
            File file = jFileChooser.getSelectedFile();
            this.project.SaveAs(file.getAbsolutePath());
            this.setTitle("SUMO Traffic Generator - " + this.project.getFileName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occured while saving the project", "Error", 0);
            exception.printStackTrace();
        }
        finally {
            this.setCursor(0);
        }
    }

    private void SetToolbarEnabled(boolean bl) {
        for (Component component : this.tlbTools.getComponents()) {
            component.setEnabled(bl);
        }
    }

    protected void SelectActivityBasedVehicleTypes() {
        TypeSelection<VehicleType> typeSelection = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> typeSelection2 = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getActivityBasedTrafficVehicleSelection());
        typeSelection2.addTypesNotInSelection(typeSelection);
        DlgSelectTypes<VehicleType> dlgSelectTypes = new DlgSelectTypes<VehicleType>(typeSelection2);
        dlgSelectTypes.setVisible(true);
        if (dlgSelectTypes.getAnswer() == 0) {
            typeSelection2.removeTypesWithZeroPercentage();
            Project.getCurrentlyLoadedProject().setActivityBasedTrafficVehicleSelection(typeSelection2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ExportSimulation() {
        if (!ApplicationSettings.Validate()) {
            JOptionPane.showMessageDialog(this, "Before you export the simulation you need to set the paths in the View > Settings dialog");
            return;
        }
        DlgExportSimulation dlgExportSimulation = new DlgExportSimulation((Frame)this, this.project);
        dlgExportSimulation.setVisible(true);
        if (dlgExportSimulation.getAnswer() == 0) {
            List<TrafficDefinitionLayer> list = dlgExportSimulation.getSelectedLayers();
            try {
                this.setCursor(3);
                SimulationExporter.ExportSimulation(this.project, list);
            }
            finally {
                this.setCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void PurgeDeleted() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to permanently remove the deleted parts of the map?") == 0) {
            try {
                this.setCursor(3);
                this.project.getRoadNetwork().PurgeDeleted();
            }
            finally {
                this.setCursor(0);
            }
            this.getMapDisplay().Refresh();
        }
    }

    protected void SelectAll() {
        this.getMapDisplay().SelectAll();
    }

    protected void SelectInverse() {
        this.getMapDisplay().SelectInverse();
    }

    protected void SelectNone() {
        this.getMapDisplay().SelectNone();
    }

    protected void SelectRandomTrafficLayerVehicleTypes() {
        if (this.currentTrafficLayer instanceof RandomTrafficDefinitionLayer) {
            RandomTrafficDefinitionLayer randomTrafficDefinitionLayer = (RandomTrafficDefinitionLayer)this.currentTrafficLayer;
            TypeSelection<VehicleType> typeSelection = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
            TypeSelection<VehicleType> typeSelection2 = new TypeSelection<VehicleType>(randomTrafficDefinitionLayer.getVehicleSelection());
            typeSelection2.addTypesNotInSelection(typeSelection);
            DlgSelectTypes<VehicleType> dlgSelectTypes = new DlgSelectTypes<VehicleType>(typeSelection2);
            dlgSelectTypes.setVisible(true);
            if (dlgSelectTypes.getAnswer() == 0) {
                typeSelection2.removeTypesWithZeroPercentage();
                randomTrafficDefinitionLayer.setVehicleSelection(typeSelection2);
            }
        }
    }

    protected void SetTrafficLayerProperties() {
        if (this.currentTrafficLayer instanceof RandomTrafficDefinitionLayer) {
            DlgRandomLayerProperties dlgRandomLayerProperties = new DlgRandomLayerProperties((Frame)this, (RandomTrafficDefinitionLayer)this.currentTrafficLayer);
        }
    }

    protected void SetAddToSelection() {
        this.getMapDisplay().setSelectionType(SelectionType.Add);
    }

    protected void SetNewSelection() {
        this.getMapDisplay().setSelectionType(SelectionType.New);
    }

    protected void SetRemoveFromSelection() {
        this.getMapDisplay().setSelectionType(SelectionType.Remove);
    }

    protected void ShowJobTypes() {
        DlgManageJobTypes dlgManageJobTypes = new DlgManageJobTypes((Frame)this, this.project.getJobTypes());
        this.project.setJobTypes(dlgManageJobTypes.getJobTypes());
    }

    protected void ShowSettings() {
        DlgSettings dlgSettings = new DlgSettings(this);
        dlgSettings.setVisible(true);
    }

    protected void ShowVehicleTypes() {
        DlgManageVehicleTypes dlgManageVehicleTypes = new DlgManageVehicleTypes((Frame)this, this.project.getVehicleTypes());
        this.project.setVehicleTypes(dlgManageVehicleTypes.getVehicleTypes());
    }
}

