/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import helpers.RandomNumberProvider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import shapes.AreaExt;
import shapes.Rectangle2DExt;
import simulation.JobType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class TrafficArea
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private int population = 0;
    private TypeSelection<JobType> residentsJobSelection;
    private AreaExt shape;
    private TypeSelection<JobType> workersJobSelection;
    private int workPositions = 0;
    float averageAdultsPerHouse = 3.0f;
    float averageChildrenPerHouse = 2.0f;
    float possibilityAdultHasJob = 0.98f;
    float possibilityAdultIsDriver = 0.8f;
    float possibilityDriverHasCar = 0.8f;

    public TrafficArea(Shape shape) {
        this.name = "Area " + String.valueOf(increment++);
        this.shape = new AreaExt(shape);
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        arrayList.add(new Handle(new Point2D.Double(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY()), "location", MotionRestriction.None));
        this.addHandles(arrayList);
        this.residentsJobSelection = new TypeSelection();
        this.residentsJobSelection.add(new Pair<JobType, Float>(Project.getCurrentlyLoadedProject().getDefaultJobType(), Float.valueOf(1.0f)));
        this.workersJobSelection = new TypeSelection();
        this.workersJobSelection.add(new Pair<JobType, Float>(Project.getCurrentlyLoadedProject().getDefaultJobType(), Float.valueOf(1.0f)));
        this.exportPolygon = true;
    }

    public TrafficArea(TrafficArea trafficArea) {
        super(trafficArea);
        this.color = new Color(trafficArea.color.getRGB());
        this.population = trafficArea.population;
        this.workPositions = trafficArea.workPositions;
        this.shape = new AreaExt(trafficArea.shape);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.shape != null) {
            graphics2D.fill(this.shape);
        }
        super.Draw(graphics2D, d, bl, bl2);
        graphics2D.setColor(color);
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new TrafficArea(this);
    }

    public float getAverageAdultsPerHouse() {
        return this.averageAdultsPerHouse;
    }

    public float getAverageChildrenPerHouse() {
        return this.averageChildrenPerHouse;
    }

    public Color getColor() {
        return this.color;
    }

    public int getPopulation() {
        return this.population;
    }

    public float getPossibilityAdultHasJob() {
        return this.possibilityAdultHasJob;
    }

    public float getPossibilityAdultIsDriver() {
        return this.possibilityAdultIsDriver;
    }

    public float getPossibilityDriverHasCar() {
        return this.possibilityDriverHasCar;
    }

    public Point2D.Double getRandomPointInArea() {
        double d;
        double d2;
        double d3;
        double d4;
        Point2D.Double double_ = null;
        Random random = RandomNumberProvider.getRandom();
        do {
            d3 = this.shape.getBounds2D().getMaxX() - this.shape.getBounds2D().getMinX();
            d = this.shape.getBounds2D().getMaxY() - this.shape.getBounds2D().getMinY();
        } while (!this.shape.contains(double_ = new Point2D.Double(d4 = random.nextDouble() * d3 + this.shape.getBounds2D().getMinX(), d2 = random.nextDouble() * d + this.shape.getBounds2D().getMinY())));
        return double_;
    }

    public TypeSelection<JobType> getResidentsJobSelection() {
        return this.residentsJobSelection;
    }

    public AreaExt getShape() {
        return this.shape;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Area: </b> " + this.name + "<br>" + "<b>Population:</b> " + this.population + "<br>" + "<b>Work positions:</b> " + this.workPositions + "</html>";
    }

    public TypeSelection<JobType> getWorkersJobSelection() {
        return this.workersJobSelection;
    }

    public int getWorkPositions() {
        return this.workPositions;
    }

    @Override
    public void handleLocationChanged(Handle handle) {
        if (handle.getName().equals("location")) {
            Point2D.Double double_ = new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getCenterY());
            double d = handle.getLocation().x - double_.x;
            double d2 = handle.getLocation().y - double_.y;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(d, d2);
            this.shape.transform(affineTransform);
        }
    }

    @Override
    public boolean Hit(Point point) {
        return this.shape.contains(point);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.shape.intersects(rectangle);
    }

    public void setAverageAdultsPerHouse(float f) {
        this.averageAdultsPerHouse = f;
    }

    public void setAverageChildrenPerHouse(float f) {
        this.averageChildrenPerHouse = f;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPopulation(int n) {
        this.population = n;
    }

    public void setPossibilityAdultHasJob(float f) {
        this.possibilityAdultHasJob = f;
    }

    public void setPossibilityAdultIsDriver(float f) {
        this.possibilityAdultIsDriver = f;
    }

    public void setPossibilityDriverHasCar(float f) {
        this.possibilityDriverHasCar = f;
    }

    public void setResidentsJobSelection(TypeSelection<JobType> typeSelection) {
        this.residentsJobSelection = typeSelection;
    }

    public void setWorkersJobSelection(TypeSelection<JobType> typeSelection) {
        this.workersJobSelection = typeSelection;
    }

    public void setWorkPositions(int n) {
        this.workPositions = n;
    }

    @Override
    public String getGeometryXML() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new Float((float)this.color.getRed() / 255.0f).toString() + "," + new Float((float)this.color.getGreen() / 255.0f).toString() + "," + new Float((float)this.color.getBlue() / 255.0f).toString();
        stringBuilder.append("<poly id=\"Traffic Area " + this.name + "\" type=\"Traffic Area\" color=\"" + string + "\" fill=\"true\" layer=\"-3\">");
        stringBuilder.append(XMLHelpers.shapeToXML(this.shape));
        stringBuilder.append("</poly>\n");
        return stringBuilder.toString();
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<trafficArea name=\"" + this.name + "\" possibilityAdultIsDriver=\"" + String.valueOf(this.possibilityAdultIsDriver) + "\" possibilityDriverHasCar=\"" + String.valueOf(this.possibilityDriverHasCar) + "\" workingPositions=\"" + String.valueOf(this.workPositions) + "\" possibilityAdultHasJob=\"" + String.valueOf(this.possibilityAdultHasJob) + "\" averageChildrenPerHouse=\"" + String.valueOf(this.averageChildrenPerHouse) + "\" population=\"" + String.valueOf(this.population) + "\" averageAdultsPerHouse=\"" + String.valueOf(this.averageAdultsPerHouse) + "\">\n");
        stringBuilder.append(XMLHelpers.jobSelectionToXML("residentsJobSelection", this.residentsJobSelection));
        stringBuilder.append(XMLHelpers.jobSelectionToXML("workersJobSelection", this.workersJobSelection));
        stringBuilder.append("<shape>");
        stringBuilder.append(XMLHelpers.shapeToXML(this.shape));
        stringBuilder.append("</shape>\n");
        stringBuilder.append("</trafficArea>\n");
        return stringBuilder.toString();
    }
}

