/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import enums.MotionRestriction;
import enums.SchoolType;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import roadnetwork.Edge;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class School
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Edge closestEdge = null;
    private Point2DExt location;
    private SchoolType schoolType;
    private Rectangle2DExt shape;
    private int timeClosing;
    private int timeOpening;
    private int capacity;
    private int availableCapacity;

    public School(Point2D.Double double_) {
        this.name = "School " + String.valueOf(increment++);
        this.shape = new Rectangle2DExt();
        this.shape.setFrameFromCenter(double_.x, double_.y, double_.x + 15.0, double_.y + 15.0);
        this.location = new Point2DExt(double_);
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        arrayList.add(new Handle(double_, "location", MotionRestriction.None));
        this.addHandles(arrayList);
        this.timeOpening = TimeConverter.toSeconds(7, 30);
        this.timeClosing = TimeConverter.toSeconds(13, 30);
        this.schoolType = SchoolType.Kindergarden;
        this.capacity = 800;
        this.exportPolygon = true;
    }

    public School(School school) {
        super(school);
        this.closestEdge = school.closestEdge;
        this.location = new Point2DExt(school.location);
        this.shape = new Rectangle2DExt(school.shape);
        this.schoolType = school.schoolType;
        this.capacity = school.capacity;
        this.timeClosing = school.timeClosing;
        this.timeOpening = school.timeOpening;
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(Color.ORANGE);
        }
        if (bl2) {
            graphics2D.setColor(Color.GREEN);
        }
        if (this.shape != null) {
            graphics2D.fill(this.shape);
        }
        super.Draw(graphics2D, d, bl, bl2);
        graphics2D.setColor(color);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return this.shape;
    }

    public Edge getClosestEdge() {
        return this.closestEdge;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public int amountOfTimeChildCanWaitAfterSchool() {
        int n = 0;
        switch (this.schoolType) {
            case Kindergarden: {
                n = 0;
                break;
            }
            case Elementary: {
                n = 600;
                break;
            }
            case Middle: {
                n = 1200;
                break;
            }
            case High: {
                n = 1800;
            }
        }
        return n;
    }

    public int getPriority() {
        int n = 0;
        switch (this.schoolType) {
            case Kindergarden: {
                n = 4;
                break;
            }
            case Elementary: {
                n = 3;
                break;
            }
            case Middle: {
                n = 2;
                break;
            }
            case High: {
                n = 1;
            }
        }
        return n;
    }

    public SchoolType getSchoolType() {
        return this.schoolType;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public int getAvailableCapacity() {
        return this.availableCapacity;
    }

    public void setAvailableCapacity(int n) {
        this.availableCapacity = n;
    }

    public int getTimeClosing() {
        return this.timeClosing;
    }

    public int getTimeOpening() {
        return this.timeOpening;
    }

    @Override
    public String getToolTip() {
        return "<html><b>School</b> " + this.name + "<br>" + "<b>Type:</b> " + this.schoolType.name() + "<br>" + "<b>Time opening:</b> " + TimeConverter.toString(this.timeOpening) + "<br>" + "<b>Time closing:</b> " + TimeConverter.toString(this.timeClosing) + "<br>" + "<b>Capacity:</b> " + String.valueOf(this.capacity) + "</html>";
    }

    @Override
    public void handleLocationChanged(Handle handle) {
        if (handle.getName().equals("location")) {
            this.location = new Point2DExt(handle.getLocation());
            this.shape.setFrameFromCenter(this.location.x, this.location.y, this.location.x + 15.0, this.location.y + 15.0);
        }
    }

    @Override
    public boolean Hit(Point point) {
        return this.shape.getBounds2D().contains(point.x, point.y) && this.shape.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.shape.intersects(rectangle);
    }

    public void setClosestEdge(Edge edge) {
        this.closestEdge = edge;
    }

    public void setSchoolType(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public void setTimeClosing(int n) {
        this.timeClosing = n;
    }

    public void setTimeOpening(int n) {
        this.timeOpening = n;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new School(this);
    }

    @Override
    public String getGeometryXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<poly id=\"" + this.schoolType.name() + " School " + this.name + "\" type=\"School\" color=\"1,0,0\" fill=\"true\" layer=\"-1\">");
        stringBuilder.append(String.valueOf(this.shape.getMinX()) + "," + String.valueOf(this.shape.getMinY()));
        stringBuilder.append(" " + String.valueOf(this.shape.getMinX()) + "," + String.valueOf(this.shape.getMaxY()));
        stringBuilder.append(" " + String.valueOf(this.shape.getMaxX()) + "," + String.valueOf(this.shape.getMaxY()));
        stringBuilder.append(" " + String.valueOf(this.shape.getMaxX()) + "," + String.valueOf(this.shape.getMinY()));
        stringBuilder.append("</poly>\n");
        return stringBuilder.toString();
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<school name=\"" + this.name + "\" openingTime=\"" + String.valueOf(this.timeOpening) + "\" closingTime=\"" + String.valueOf(this.timeClosing) + "\" level=\"" + this.schoolType.name() + "\" capacity=\"" + String.valueOf(this.capacity) + "\" location=\"" + String.valueOf(this.location.x) + "," + String.valueOf(this.location.y) + "\" />\n");
        return stringBuilder.toString();
    }

    public static class SchoolPriorityComparator
    implements Comparator<School> {
        @Override
        public int compare(School school, School school2) {
            return school.getPriority() - school2.getPriority();
        }
    }
}

