/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.TrafficDefinitionLayer;

public class RandomTrafficDefinitionLayer
extends TrafficDefinitionLayer {
    private static final long serialVersionUID = 1L;
    private int startingTime = 0;
    private int endingTime = 0;
    private int vehiclesPerSecond = 0;
    private TypeSelection<VehicleType> vehicleSelection;

    public RandomTrafficDefinitionLayer() {
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public RandomTrafficDefinitionLayer(RandomTrafficDefinitionLayer randomTrafficDefinitionLayer) {
        super(randomTrafficDefinitionLayer);
    }

    @Override
    public TrafficDefinitionLayer duplicate() {
        return new RandomTrafficDefinitionLayer(this);
    }

    @Override
    public String toString() {
        return super.toString() + "(Random layer)";
    }

    public int getEndingTime() {
        return this.endingTime;
    }

    public void setEndingTime(int n) {
        this.endingTime = n;
    }

    public int getStartingTime() {
        return this.startingTime;
    }

    public void setStartingTime(int n) {
        this.startingTime = n;
    }

    public int getVehiclesPerSecond() {
        return this.vehiclesPerSecond;
    }

    public void setVehiclesPerSecond(int n) {
        this.vehiclesPerSecond = n;
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    public void setVehicleSelection(TypeSelection<VehicleType> typeSelection) {
        this.vehicleSelection = typeSelection;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<randomTrafficLayer name=\"" + this.name + "\" startingTime =\"" + String.valueOf(this.startingTime) + "\" endingTime =\"" + String.valueOf(this.endingTime) + "\" vehiclesPerSecond=\"" + String.valueOf(this.vehiclesPerSecond) + "\">\n");
        stringBuilder.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        stringBuilder.append("</randomTrafficLayer>\n");
        return stringBuilder.toString();
    }
}

