/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import enums.MotionRestriction;
import interfaces.HandleListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import shapes.Point2DExt;

public class Handle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8791712547811891550L;
    private Point2DExt location;
    private String name;
    private HandleListener listener;
    private MotionRestriction restriction;

    public Handle(Point2D.Double double_, String string, MotionRestriction motionRestriction) {
        this.location = new Point2DExt(double_);
        this.name = string;
        this.restriction = motionRestriction;
    }

    public Handle(Handle handle) {
        this.location = new Point2DExt(handle.location);
        this.name = handle.name;
        this.restriction = handle.restriction;
    }

    public void setHandleListener(HandleListener handleListener) {
        this.listener = handleListener;
    }

    public String getName() {
        return this.name;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocationAndNotify(Point2D.Double double_) {
        this.setLocation(double_);
        if (this.listener != null) {
            this.listener.handleLocationChanged(this);
        }
    }

    public void setUnrestrictedLocation(Point2D.Double double_) {
        this.location.x = double_.x;
        this.location.y = double_.y;
    }

    private void setLocation(Point2D.Double double_) {
        switch (this.restriction) {
            case Horizontal: {
                this.location.x = double_.x;
                break;
            }
            case Vertical: {
                this.location.y = double_.y;
                break;
            }
            case None: {
                this.location.x = double_.x;
                this.location.y = double_.y;
            }
        }
    }

    public void Draw(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Point2D point2D = affineTransform.transform(this.location, null);
        graphics2D.setTransform(new AffineTransform());
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D.getX() + 2.0, point2D.getY() + 2.0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(double_);
        graphics2D.setTransform(affineTransform);
    }

    public boolean hit(Point point, AffineTransform affineTransform) {
        Point2D point2D = affineTransform.transform(this.location, null);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D.getX() + 5.0, point2D.getY() + 5.0);
        return double_.contains(point);
    }
}

