/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import helpers.DrawingHelper;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import shapes.Ellipse2DExt;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class AreaFlow
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int constructionPhase = 0;
    private int beginTime = 0;
    private int endTime = 100;
    private int numberOfVehicles = 100;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private Line2DExt arrow;
    private Ellipse2DExt startArea;
    private Ellipse2DExt endArea;
    private Point2DExt startAreaCenter;
    private double startAreaRadiusX;
    private double startAreaRadiusY;
    private Point2DExt endAreaCenter;
    private double endAreaRadiusX;
    private double endAreaRadiusY;
    private TypeSelection<VehicleType> vehicleSelection;

    public AreaFlow() {
        this.name = "Area Flow " + String.valueOf(increment++);
        this.startArea = new Ellipse2DExt();
        this.endArea = new Ellipse2DExt();
        this.arrow = new Line2DExt();
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    private AreaFlow(AreaFlow areaFlow) {
        super(areaFlow);
        this.constructionPhase = areaFlow.constructionPhase;
        this.beginTime = areaFlow.beginTime;
        this.endTime = areaFlow.endTime;
        this.numberOfVehicles = areaFlow.numberOfVehicles;
        this.color = new Color(areaFlow.color.getRGB());
        this.startArea = new Ellipse2DExt(areaFlow.startArea);
        this.startAreaCenter = new Point2DExt(areaFlow.startAreaCenter);
        this.startAreaRadiusX = areaFlow.startAreaRadiusX;
        this.startAreaRadiusY = areaFlow.startAreaRadiusY;
        this.endArea = new Ellipse2DExt(areaFlow.endArea);
        this.endAreaCenter = new Point2DExt(areaFlow.endAreaCenter);
        this.endAreaRadiusX = areaFlow.endAreaRadiusX;
        this.endAreaRadiusY = areaFlow.endAreaRadiusY;
        this.arrow = new Line2DExt(areaFlow.arrow);
        this.vehicleSelection = new TypeSelection<VehicleType>(areaFlow.vehicleSelection);
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.startArea != null) {
            graphics2D.fill(this.startArea);
        }
        if (this.endArea != null) {
            graphics2D.fill(this.endArea);
        }
        if (this.arrow != null) {
            graphics2D.setColor(Color.BLACK);
            DrawingHelper.drawArrowHead(graphics2D, this.arrow.x1, this.arrow.y1, this.arrow.x2, this.arrow.y2, 1.0f);
            graphics2D.draw(this.arrow);
        }
        super.Draw(graphics2D, d, bl, bl2);
        graphics2D.setColor(color);
    }

    public void createHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        Handle handle = new Handle(this.startAreaCenter, "StartAreaCenter", MotionRestriction.None);
        Handle handle2 = new Handle(new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y), "StartAreaRadiusX", MotionRestriction.Horizontal);
        Handle handle3 = new Handle(new Point2D.Double(this.startAreaCenter.x, this.startAreaCenter.y + this.startAreaRadiusY), "StartAreaRadiusY", MotionRestriction.Vertical);
        Handle handle4 = new Handle(this.endAreaCenter, "EndAreaCenter", MotionRestriction.None);
        Handle handle5 = new Handle(new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y), "EndAreaRadiusX", MotionRestriction.Horizontal);
        Handle handle6 = new Handle(new Point2D.Double(this.endAreaCenter.x, this.endAreaCenter.y + this.endAreaRadiusY), "EndAreaRadiusY", MotionRestriction.Vertical);
        arrayList.add(handle);
        arrayList.add(handle2);
        arrayList.add(handle3);
        arrayList.add(handle4);
        arrayList.add(handle5);
        arrayList.add(handle6);
        super.addHandles(arrayList);
    }

    @Override
    public Rectangle2DExt getBounds() {
        Rectangle2D rectangle2D = this.startArea.getBounds2D();
        rectangle2D.add(this.endArea.getBounds2D());
        return new Rectangle2DExt(rectangle2D.getCenterX(), rectangle2D.getCenterY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public Color getColor() {
        return this.color;
    }

    public Ellipse2DExt getEndArea() {
        return this.endArea;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    public Ellipse2DExt getStartArea() {
        return this.startArea;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Area flow</b> " + this.name + "<br>" + "<b>Number of vehicles:</b> " + String.valueOf(this.numberOfVehicles) + "<br>" + "<b>Start time:</b> " + TimeConverter.toString(this.beginTime) + "<br>" + "<b>End time:</b> " + TimeConverter.toString(this.endTime) + "</html>";
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle handle) {
        if (handle.getName().equals("StartAreaCenter")) {
            this.startAreaCenter = new Point2DExt(handle.getLocation());
            ((Handle)this.handles.get("StartAreaRadiusX")).setUnrestrictedLocation(new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y));
            ((Handle)this.handles.get("StartAreaRadiusY")).setUnrestrictedLocation(new Point2D.Double(this.startAreaCenter.x, this.startAreaCenter.y + this.startAreaRadiusY));
        } else if (handle.getName().equals("StartAreaRadiusX")) {
            this.startAreaRadiusX = handle.getLocation().x - this.startAreaCenter.x;
        } else if (handle.getName().equals("StartAreaRadiusY")) {
            this.startAreaRadiusY = handle.getLocation().y - this.startAreaCenter.y;
        } else if (handle.getName().equals("EndAreaCenter")) {
            this.endAreaCenter = new Point2DExt(handle.getLocation());
            ((Handle)this.handles.get("EndAreaRadiusX")).setUnrestrictedLocation(new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y));
            ((Handle)this.handles.get("EndAreaRadiusY")).setUnrestrictedLocation(new Point2D.Double(this.endAreaCenter.x, this.endAreaCenter.y + this.endAreaRadiusY));
        } else if (handle.getName().equals("EndAreaRadiusX")) {
            this.endAreaRadiusX = handle.getLocation().x - this.endAreaCenter.x;
        } else if (handle.getName().equals("EndAreaRadiusY")) {
            this.endAreaRadiusY = handle.getLocation().y - this.endAreaCenter.y;
        }
        this.startArea.setFrameFromCenter(this.startAreaCenter, new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y + this.startAreaRadiusY));
        this.endArea.setFrameFromCenter(this.endAreaCenter, new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y + this.endAreaRadiusY));
        this.arrow.setLine(this.startAreaCenter, this.endAreaCenter);
    }

    @Override
    public boolean Hit(Point point) {
        if (this.arrow.getBounds2D().contains(point.x, point.y) && this.arrow.contains(point.x, point.y)) {
            return true;
        }
        if (this.startArea.getBounds2D().contains(point.x, point.y) && this.startArea.contains(point.x, point.y)) {
            return true;
        }
        return this.endArea.getBounds2D().contains(point.x, point.y) && this.endArea.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.arrow.intersects(rectangle) || this.startArea.intersects(rectangle) || this.endArea.intersects(rectangle);
    }

    public void setBeginTime(int n) {
        this.beginTime = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEndAreaCenter(Point2D.Double double_) {
        this.endAreaCenter = new Point2DExt(double_.x, double_.y);
        this.arrow.setLine(this.startAreaCenter, this.endAreaCenter);
    }

    public void setEndAreaRadius(Point2D.Double double_) {
        this.endAreaRadiusX = double_.x - this.endAreaCenter.x;
        this.endAreaRadiusY = double_.y - this.endAreaCenter.y;
        this.endArea.setFrameFromCenter(this.endAreaCenter, new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y + this.endAreaRadiusY));
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public void setNumberOfVehicles(int n) {
        this.numberOfVehicles = n;
    }

    public void setStartAreaCenter(Point2D.Double double_) {
        this.startAreaCenter = new Point2DExt(double_.x, double_.y);
    }

    public void setStartAreaRadius(Point2D.Double double_) {
        this.startAreaRadiusX = double_.x - this.startAreaCenter.x;
        this.startAreaRadiusY = double_.y - this.startAreaCenter.y;
        this.startArea.setFrameFromCenter(this.startAreaCenter, new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y + this.startAreaRadiusY));
    }

    public void setVehicleSelection(TypeSelection<VehicleType> typeSelection) {
        this.vehicleSelection = typeSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new AreaFlow(this);
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<areaFlow name=\"" + this.name + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\" startingTime=\"" + String.valueOf(this.beginTime) + "\" endingTime=\"" + String.valueOf(this.endTime) + "\">\n");
        stringBuilder.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        stringBuilder.append("<sourceAreaShape>");
        stringBuilder.append(XMLHelpers.shapeToXML(this.startArea));
        stringBuilder.append("</sourceAreaShape>\n");
        stringBuilder.append("<destinationAreaShape>");
        stringBuilder.append(XMLHelpers.shapeToXML(this.endArea));
        stringBuilder.append("</destinationAreaShape>\n");
        stringBuilder.append("</areaFlow>\n");
        return stringBuilder.toString();
    }
}

