/*
 * Decompiled with CFR 0.152.
 */
package shapes;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import shapes.Polygon2D;

public class PolygonIterator
implements PathIterator {
    private double[] _coords;
    private int _index = 0;
    private boolean _done = false;

    public PolygonIterator(Polygon2D polygon2D, AffineTransform affineTransform) {
        int n = polygon2D.getVertexCount() * 2;
        this._coords = new double[n];
        if (polygon2D instanceof Polygon2D.Float) {
            Polygon2D.Float float_ = (Polygon2D.Float)polygon2D;
            if (affineTransform == null || affineTransform.isIdentity()) {
                for (int i = 0; i < n; ++i) {
                    this._coords[i] = float_._coords[i];
                }
            } else {
                affineTransform.transform(float_._coords, 0, this._coords, 0, n / 2);
            }
        } else {
            Polygon2D.Double double_ = (Polygon2D.Double)polygon2D;
            if (affineTransform == null || affineTransform.isIdentity()) {
                System.arraycopy(double_._coords, 0, this._coords, 0, n);
            } else {
                affineTransform.transform(double_._coords, 0, this._coords, 0, n / 2);
            }
        }
    }

    @Override
    public int currentSegment(double[] dArray) {
        if (this._index == this._coords.length) {
            if (this._done) {
                return 4;
            }
            dArray[0] = this._coords[0];
            dArray[1] = this._coords[1];
            return 1;
        }
        dArray[0] = this._coords[this._index];
        dArray[1] = this._coords[this._index + 1];
        if (this._index == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int currentSegment(float[] fArray) {
        if (this._index == this._coords.length) {
            if (this._done) {
                return 4;
            }
            fArray[0] = (float)this._coords[0];
            fArray[1] = (float)this._coords[1];
            return 1;
        }
        fArray[0] = (float)this._coords[this._index];
        fArray[1] = (float)this._coords[this._index + 1];
        if (this._index == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    @Override
    public void next() {
        if (this._index == this._coords.length) {
            this._done = true;
        } else {
            this._index += 2;
        }
    }
}

