/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import classes.ProjectElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import shapes.Polygon2D;
import shapes.Rectangle2DExt;

public abstract class RoadNetworkElement
extends ProjectElement
implements Serializable {
    private static final long serialVersionUID = -8383351961238071184L;
    protected String id;
    protected Polygon2D.Double shape;

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2 && !bl) {
            graphics2D.setColor(Color.BLACK);
        }
        if (bl2 && !bl) {
            graphics2D.setColor(Color.GREEN);
        }
        if (!bl2 && bl) {
            graphics2D.setColor(Color.RED);
        }
        if (bl2 && bl) {
            graphics2D.setColor(Color.ORANGE);
        }
        graphics2D.fill(this.shape);
        graphics2D.setColor(color);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt(this.shape.getBounds2D());
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean Hit(Point point) {
        return this.shape.getBounds2D().contains(point.x, point.y) && this.shape.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.shape.intersects(rectangle);
    }

    public boolean Overlaps(Shape shape) {
        return this.shape.overlaps(shape);
    }

    public void setId(String string) {
        this.id = string;
    }
}

