/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import roadnetwork.Lane;
import roadnetwork.RoadNetworkElement;
import shapes.Line2DExt;
import shapes.Polygon2D;
import trafficdefinition.TrafficDefinitionElement;

public class Edge
extends RoadNetworkElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<TrafficDefinitionElement> dependentTrafficElements = null;
    private List<Line2DExt> dividers = new ArrayList<Line2DExt>();
    private String from = "";
    private List<Lane> lanes = new ArrayList<Lane>();
    private float length = 0.0f;
    private int priority = 0;
    private float speedLimit = 0.0f;
    private String to = "";

    public void AddDependentTrafficElement(TrafficDefinitionElement trafficDefinitionElement) {
        if (this.dependentTrafficElements == null) {
            this.dependentTrafficElements = new ArrayList<TrafficDefinitionElement>();
        }
        if (!this.dependentTrafficElements.contains(trafficDefinitionElement)) {
            this.dependentTrafficElements.add(trafficDefinitionElement);
        }
    }

    public void AddLane(Lane lane) {
        this.lanes.add(lane);
    }

    /*
     * WARNING - void declaration
     */
    public void CalculateShape() {
        void var14_24;
        double d = 1.6 * (double)this.lanes.size();
        int n = Integer.MAX_VALUE;
        for (Lane serializable2 : this.lanes) {
            n = Math.min(n, serializable2.GetTotalPoints());
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> arrayList3 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> arrayList4 = new ArrayList<Point2D.Double>();
        for (int dArray = 0; dArray < n; ++dArray) {
            Point2D.Double double_;
            Point2D.Double double_2;
            arrayList3.clear();
            arrayList4.clear();
            if (dArray == n - 1) {
                for (Lane lane : this.lanes) {
                    arrayList3.add(lane.GetPoint(dArray));
                    arrayList4.add(lane.GetPoint(dArray - 1));
                }
            } else {
                for (Lane lane : this.lanes) {
                    arrayList3.add(lane.GetPoint(dArray));
                    arrayList4.add(lane.GetPoint(dArray + 1));
                }
            }
            Point2D.Double n2 = new Point2D.Double();
            Point2D.Double i = new Point2D.Double();
            for (int j = 0; j < this.lanes.size() - 1; ++j) {
                n2.x = (((Point2D.Double)arrayList3.get((int)j)).x + ((Point2D.Double)arrayList3.get((int)(j + 1))).x) / 2.0;
                n2.y = (((Point2D.Double)arrayList3.get((int)j)).y + ((Point2D.Double)arrayList3.get((int)(j + 1))).y) / 2.0;
                i.x = (((Point2D.Double)arrayList4.get((int)j)).x + ((Point2D.Double)arrayList4.get((int)(j + 1))).x) / 2.0;
                i.y = (((Point2D.Double)arrayList4.get((int)j)).y + ((Point2D.Double)arrayList4.get((int)(j + 1))).y) / 2.0;
                this.dividers.add(new Line2DExt(n2, i));
            }
            Point2D.Double double_3 = this.PointsCenter(arrayList3);
            Point2D.Double double_4 = this.PointsCenter(arrayList4);
            if (double_3.y == double_4.y) {
                double_2 = new Point2D.Double(double_3.x, double_3.y - d);
                double_ = new Point2D.Double(double_3.x, double_3.y + d);
            } else if (double_3.x == double_4.x) {
                double_2 = new Point2D.Double(double_3.x - d, double_3.y);
                double_ = new Point2D.Double(double_3.x + d, double_3.y);
            } else {
                double d2 = -(double_4.x - double_3.x) / (double_4.y - double_3.y);
                double_2 = new Point2D.Double(d / Math.sqrt(d2 * d2 + 1.0) + double_3.x, double_3.y + d2 * d / Math.sqrt(d2 * d2 + 1.0));
                double_ = new Point2D.Double(-d / Math.sqrt(d2 * d2 + 1.0) + double_3.x, double_3.y - d2 * d / Math.sqrt(d2 * d2 + 1.0));
            }
            arrayList.add(double_2);
            arrayList2.add(double_);
        }
        double[] dArray = new double[n * 2 * 2];
        int n2 = 0;
        for (Point2D.Double double_ : arrayList2) {
            dArray[n2++] = double_.x;
            dArray[n2++] = double_.y;
        }
        int n3 = arrayList.size() - 1;
        while (var14_24 >= 0) {
            dArray[n2++] = ((Point2D.Double)arrayList.get((int)var14_24)).x;
            dArray[n2++] = ((Point2D.Double)arrayList.get((int)var14_24)).y;
            --var14_24;
        }
        this.shape = new Polygon2D.Double(dArray);
    }

    public int DistanceFrom(Edge edge) {
        return (int)Math.round(this.lanes.get(0).GetPoint(0).distance(edge.lanes.get(0).GetPoint(0)));
    }

    public double DistanceFrom(Point2D.Double double_) {
        return this.lanes.get(0).GetPoint(0).distance(double_);
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        super.Draw(graphics2D, d, bl, bl2);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.YELLOW);
        if (d > 2.0) {
            Stroke stroke = graphics2D.getStroke();
            float[] fArray = new float[]{1.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(0.1f, 0, 0, 10.0f, fArray, 0.0f));
            for (Line2DExt line2DExt : this.dividers) {
                graphics2D.draw(line2DExt);
            }
            graphics2D.setStroke(stroke);
        }
        graphics2D.setColor(color);
    }

    public String getFrom() {
        return this.from;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public float getLength() {
        return this.length;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public String getTo() {
        return this.to;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Edge</b> " + this.id + "<br>" + "<b>Priority:</b> " + this.priority + "<br>" + "<b>Speed limit:</b> " + this.speedLimit + "<br>" + "</html>";
    }

    public boolean HasDependentTrafficElements() {
        return this.dependentTrafficElements != null;
    }

    public List<TrafficDefinitionElement> getDependentTrafficElements() {
        return this.dependentTrafficElements;
    }

    public void RemoveDependentTrafficElement(TrafficDefinitionElement trafficDefinitionElement) {
        if (this.dependentTrafficElements != null && this.dependentTrafficElements.contains(trafficDefinitionElement)) {
            this.dependentTrafficElements.remove(trafficDefinitionElement);
            if (this.dependentTrafficElements.isEmpty()) {
                this.dependentTrafficElements = null;
            }
        }
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setSpeedLimit(float f) {
        this.speedLimit = f;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public String toString() {
        return "Edge " + this.id;
    }

    private Point2D.Double PointsCenter(List<Point2D.Double> list) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        for (Point2D.Double double_2 : list) {
            double_.x += double_2.x;
            double_.y += double_2.y;
        }
        double_.x /= (double)list.size();
        double_.y /= (double)list.size();
        return double_;
    }
}

