/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ProjectElement;
import enums.SelectionCount;
import enums.SelectionType;
import interfaces.DrawableLayer;
import interfaces.ModifiedCollectionListener;
import interfaces.SelectionChangedListener;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Layer<E extends ProjectElement>
implements Serializable,
DrawableLayer {
    private static final long serialVersionUID = 3687220504361334150L;
    private transient List<ModifiedCollectionListener> modifiedCollectionListeners = null;
    private transient List<SelectionChangedListener> selectionChangedListeners = null;
    protected final List<E> elements = new ArrayList();
    protected final List<E> selectedElements = new ArrayList();

    public final void addModifiedCollectionListener(ModifiedCollectionListener modifiedCollectionListener) {
        if (this.modifiedCollectionListeners == null) {
            this.modifiedCollectionListeners = new ArrayList<ModifiedCollectionListener>();
        }
        this.modifiedCollectionListeners.add(modifiedCollectionListener);
    }

    public final void removeModifiedCollectionListener(ModifiedCollectionListener modifiedCollectionListener) {
        if (this.modifiedCollectionListeners != null && this.modifiedCollectionListeners.contains(modifiedCollectionListener)) {
            this.modifiedCollectionListeners.remove(modifiedCollectionListener);
        }
    }

    protected final void NotifyCollectionModified() {
        for (ModifiedCollectionListener modifiedCollectionListener : this.modifiedCollectionListeners) {
            modifiedCollectionListener.CollectionModified();
        }
    }

    public final void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        if (this.selectionChangedListeners == null) {
            this.selectionChangedListeners = new ArrayList<SelectionChangedListener>();
        }
        this.selectionChangedListeners.add(selectionChangedListener);
    }

    public final void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        if (this.selectionChangedListeners != null && this.selectionChangedListeners.contains(selectionChangedListener)) {
            this.selectionChangedListeners.remove(selectionChangedListener);
        }
    }

    protected final void NotifySelectionChanged(List<? extends ProjectElement> list) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        block4: for (SelectionChangedListener selectionChangedListener : this.selectionChangedListeners) {
            switch (list.size()) {
                case 0: {
                    selectionChangedListener.SelectionChanged(SelectionCount.None, null);
                    continue block4;
                }
                case 1: {
                    selectionChangedListener.SelectionChanged(SelectionCount.Single, list.get(0));
                    continue block4;
                }
            }
            selectionChangedListener.SelectionChanged(SelectionCount.Multiple, null);
        }
    }

    protected void NotifySelectionChanged() {
        this.NotifySelectionChanged(this.selectedElements);
    }

    public List<E> getElements() {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.addAll(this.elements);
        arrayList.addAll(this.selectedElements);
        return arrayList;
    }

    public boolean SelectElement(E e) {
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
        if (this.elements.contains(e)) {
            this.selectedElements.add(e);
            this.elements.remove(e);
            return true;
        }
        return false;
    }

    public void SelectNoneElements() {
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
    }

    public void SelectInverseElements() {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.addAll(this.elements);
        this.elements.clear();
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
        this.selectedElements.addAll(arrayList);
    }

    public void SelectAllElements() {
        this.selectedElements.addAll(this.elements);
        this.elements.clear();
    }

    public void AddElements(List<? extends E> list) {
        for (ProjectElement projectElement : list) {
            this.elements.add(projectElement);
        }
    }

    public final E PointHitTest(Point2D point2D) {
        Point point = new Point((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()));
        for (ProjectElement projectElement : this.getElements()) {
            if (!projectElement.Hit(point)) continue;
            return (E)projectElement;
        }
        return null;
    }

    protected List<E> RectangleHitTest(Rectangle rectangle, List<E> list) {
        ArrayList<ProjectElement> arrayList = new ArrayList<ProjectElement>();
        for (ProjectElement projectElement : list) {
            if (!projectElement.Hit(rectangle)) continue;
            arrayList.add(projectElement);
        }
        return arrayList;
    }

    public abstract void DeleteSelectedElements();

    @Override
    public abstract void Draw(Graphics2D var1, double var2);

    protected final void RemoveFromSelection(Rectangle rectangle) {
        List<E> list = this.RectangleHitTest(rectangle, this.selectedElements);
        if (list.size() > 0) {
            this.elements.addAll(list);
            this.selectedElements.removeAll(list);
        }
    }

    protected final void AddToSelection(Rectangle rectangle) {
        List<E> list = this.RectangleHitTest(rectangle, this.elements);
        if (list.size() > 0) {
            this.elements.removeAll(list);
            this.selectedElements.addAll(list);
        }
    }

    public abstract void AlterSelection(Rectangle var1, SelectionType var2);

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.SelectNoneElements();
        objectOutputStream.defaultWriteObject();
    }
}

