/*
 * Decompiled with CFR 0.152.
 */
package de.uniluebeck.itm.tcpip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Storage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Byte> storageList;
    private int position;
    private ListIterator<Byte> listIt;

    public Storage() {
        this.storageList = new ArrayList<Byte>();
        this.init();
    }

    public Storage(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public Storage(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("packet can't be null");
        }
        if (n2 > byArray.length) {
            throw new IndexOutOfBoundsException("length exceeds packet length");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("content is outside the array");
        }
        this.storageList = new ArrayList<Byte>();
        for (int i = n; i < n2; ++i) {
            this.writeByte(byArray[i]);
        }
        this.init();
    }

    public Storage(short[] sArray) {
        this(sArray, 0, sArray.length);
    }

    public Storage(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new NullPointerException("packet can't be null");
        }
        if (n2 > sArray.length) {
            throw new IndexOutOfBoundsException("length exceeds packet length");
        }
        if (n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException("content is outside the array");
        }
        this.storageList = new ArrayList<Byte>();
        for (int i = n; i < n2; ++i) {
            this.writeByte(sArray[i]);
        }
        this.init();
    }

    public boolean validPos() {
        return this.position < this.storageList.size() && this.position >= 0 && this.storageList.size() != 0;
    }

    public int position() {
        return this.position;
    }

    public void writeByte(short s) throws IllegalArgumentException {
        this.writeByte((int)s);
    }

    public void writeByte(int n) throws IllegalArgumentException {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException("Error writing byte: byte value may only range from -128 to 127.");
        }
        this.storageList.add(new Byte((byte)n));
    }

    public short readByte() throws IllegalStateException {
        if (!this.validPos()) {
            throw new IllegalStateException("Error reading byte, invalid list position specified for reading: " + this.position);
        }
        ++this.position;
        return this.listIt.next().byteValue();
    }

    public void writeUnsignedByte(short s) throws IllegalArgumentException {
        this.writeUnsignedByte((int)s);
    }

    public void writeUnsignedByte(int n) throws IllegalArgumentException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Error writing unsigned byte: byte value may only range from 0 to 255.");
        }
        if (n > 127) {
            this.storageList.add(new Byte((byte)(n - 256)));
        } else {
            this.storageList.add(new Byte((byte)n));
        }
    }

    public short readUnsignedByte() throws IllegalStateException {
        if (!this.validPos()) {
            throw new IllegalStateException("Error reading unsigned byte, invalid list position specified for reading: " + this.position);
        }
        ++this.position;
        return (short)((this.listIt.next() + 256) % 256);
    }

    public void writeShort(int n) throws IllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[2];
        if (n < Short.MIN_VALUE || n > 32768) {
            throw new IllegalArgumentException("Error writing short: short value may only range from -32768 to 32768.");
        }
        try {
            dataOutputStream.writeShort(n);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < 2; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public int readShort() throws IllegalStateException {
        byte[] byArray = new byte[2];
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            s = dataInputStream.readShort();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return s;
    }

    public void writeInt(int n) throws IllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[4];
        try {
            dataOutputStream.writeInt(n);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < 4; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public int readInt() throws IllegalStateException {
        byte[] byArray = new byte[4];
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            n = dataInputStream.readInt();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public void writeFloat(float f) throws IllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[4];
        try {
            dataOutputStream.writeFloat(f);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < 4; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public float readFloat() throws IllegalStateException {
        byte[] byArray = new byte[4];
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            f = dataInputStream.readFloat();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return f;
    }

    public void writeDouble(double d) throws IllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[8];
        try {
            dataOutputStream.writeDouble(d);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < 8; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public double readDouble() throws IllegalStateException {
        byte[] byArray = new byte[8];
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            d = dataInputStream.readDouble();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return d;
    }

    public void writeStringUTF8(String string) throws IllegalArgumentException {
        this.writeString(string, "UTF-8");
    }

    public void writeStringASCII(String string) throws IllegalArgumentException {
        this.writeString(string, "US-ASCII");
    }

    public void writeStringISOLATIN1(String string) throws IllegalArgumentException {
        this.writeString(string, "ISO-8859-1");
    }

    public void writeStringUTF16BE(String string) throws IllegalArgumentException {
        this.writeString(string, "UTF-16BE");
    }

    public void writeStringUTF16LE(String string) throws IllegalArgumentException {
        this.writeString(string, "UTF-16LE");
    }

    private void writeString(String string, String string2) throws IllegalArgumentException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return;
        }
        this.writeInt(string.length());
        for (int i = 0; i < byArray.length; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public String readStringUTF8() throws IllegalArgumentException {
        return this.readString("UTF-8");
    }

    public String readStringASCII() throws IllegalArgumentException {
        return this.readString("US-ASCII");
    }

    public String readStringISOLATIN1() throws IllegalArgumentException {
        return this.readString("ISO-8859-1");
    }

    public String readStringUTF16BE() throws IllegalArgumentException {
        return this.readString("UTF-16BE");
    }

    public String readStringUTF16LE() throws IllegalArgumentException {
        return this.readString("UTF-16LE");
    }

    private String readString(String string) throws IllegalStateException {
        String string2 = new String("");
        int n = this.readInt();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public void reset() {
        this.storageList.clear();
        this.init();
    }

    public int size() {
        return this.storageList.size();
    }

    public List<Byte> getStorageList() {
        return Collections.unmodifiableList(this.storageList);
    }

    private void init() {
        this.position = 0;
        this.listIt = this.storageList.listIterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.storageList.size(); ++i) {
            if (i == this.position) {
                stringBuilder.append("[");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02X", this.storageList.get(i)));
        }
        return stringBuilder.toString();
    }
}

