/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.ws.conf;

import de.tudresden.ws.log.Log;
import de.tudresden.ws.log.Log_txt;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Config {
    public boolean running = false;
    public SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static String host = "127.0.0.1";
    public static String port = "4223";
    public static String url = "SUMO";
    public String name = "Sumo Webservice";
    public static String sumo_bin = "f:/Programme/sumo-svn/bin/sumo-gui64.exe";
    public static String config_file = "simulation/lsa/config.sumo.cfg";
    public HashMap<String, String> sumo_output = new HashMap();
    public Date lastactiontime;
    public String version = "1.1";
    public Log logger = new Log_txt();

    public Config() {
        this.refresh_actiontime();
    }

    public boolean read_config(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            if (file.exists()) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    sAXParser.parse(file, Config.get_handler());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.out.println("The file " + file.getAbsolutePath() + " does not exist.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public String get_url() {
        String string = "http://" + host + ":" + port + "/" + url;
        return string;
    }

    public void refresh_actiontime() {
        this.lastactiontime = new Date();
    }

    public String get_actiontime() {
        return this.df.format(this.lastactiontime);
    }

    private static DefaultHandler get_handler() {
        DefaultHandler defaultHandler = new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string3.equals("host")) {
                    host = attributes.getValue("value");
                }
                if (string3.equals("port")) {
                    port = attributes.getValue("value");
                }
                if (string3.equals("name")) {
                    url = attributes.getValue("value");
                }
                if (string3.equals("sumo_bin")) {
                    sumo_bin = attributes.getValue("value");
                }
                if (string3.equals("config_file")) {
                    config_file = attributes.getValue("value");
                }
            }

            @Override
            public void endElement(String string, String string2, String string3) throws SAXException {
            }

            @Override
            public void characters(char[] cArray, int n, int n2) throws SAXException {
            }
        };
        return defaultHandler;
    }
}

