/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.util;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.TraCIException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class StringList
implements List<String> {
    private final List<String> list;

    public StringList() {
        this.list = new ArrayList<String>();
    }

    public StringList(List<String> list) {
        this.list = list;
    }

    public StringList(Storage storage, boolean bl) throws TraCIException {
        if (bl && storage.readByte() != 14) {
            throw new TraCIException("string list expected");
        }
        int n = storage.readInt();
        this.list = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.list.add(storage.readStringASCII());
        }
    }

    public void writeTo(Storage storage, boolean bl) {
        if (bl) {
            storage.writeByte(14);
        }
        storage.writeInt(this.list.size());
        for (String string : this.list) {
            storage.writeStringASCII(string);
        }
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public void add(int n, String string) {
        this.list.add(n, string);
    }

    @Override
    public boolean add(String string) {
        return this.list.add(string);
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.list.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        return this.list.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    @Override
    public String get(int n) {
        return this.list.get(n);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<String> listIterator(int n) {
        return this.list.listIterator(n);
    }

    @Override
    public String remove(int n) {
        return this.list.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public String set(int n, String string) {
        return this.list.set(n, string);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<String> subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }
}

