/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0x98, 0x84, 0x63, 0x2C, 0x34, 0x28, 0xA2, 0xAE, 0x73, 0xE0,
        0x13, 0x53, 0x9A, 0x9B, 0x78, 0xAE, 0x83, 0xD7, 0x18, 0x2A,
        0xB3, 0x22, 0x63, 0x09, 0x29, 0xFC, 0x4F, 0x49, 0x5B, 0x30,
        0xF0, 0x6F, 0xCA, 0xD9, 0x5D, 0x75, 0x60, 0x11, 0x4E, 0x7C,
        0x1B, 0x50, 0xBA, 0x7B, 0x49, 0x94, 0x88, 0x99, 0x63, 0xA5,
        0x9B, 0x7A, 0x4C, 0x42, 0x50, 0xF7, 0x63, 0xFC, 0x17, 0x29,
        0xEE, 0x95, 0x8C, 0x48, 0x61, 0x09, 0x50, 0xD6, 0xA3, 0x7A,
        0x28, 0xEC, 0xAF, 0x2C, 0x4B, 0x6C, 0x77, 0xFA, 0x1C, 0xAA,
        0x10, 0x41, 0xD9, 0xBF, 0x47, 0xCF, 0x51, 0x08, 0x42, 0x48,
        0xEE, 0x78, 0x67, 0x13, 0xE0, 0x1D, 0x3C, 0x54, 0x3C, 0x00,
        0x93, 0x3C, 0x7A, 0x13, 0xAA, 0x3E, 0x81, 0x9F, 0x27, 0xCB,
        0xBA, 0xCA, 0x5C, 0x30, 0x32, 0x6D, 0xCC, 0x93, 0xEC, 0x9A,
        0x63, 0x89, 0x14, 0x4D, 0x15, 0xB5, 0xD7, 0x38, 0x83, 0x35,
        0x6B, 0x5D, 0xF4, 0x86, 0x5F, 0x60, 0x61, 0xC0, 0x41, 0xDF,
        0x12, 0x1C, 0x5E, 0x99, 0xAB, 0x76, 0x64, 0x3C, 0x3B, 0x05,
        0x3D, 0xA4, 0x21, 0x04, 0x3A, 0xAE, 0xED, 0x51, 0x35, 0x42,
        0xC8, 0xAE, 0x2C, 0x07, 0xD3, 0x7B, 0x67, 0x27, 0x22, 0x29,
        0x91, 0x88, 0x57, 0x19, 0x5E, 0xA7, 0x90, 0x5D, 0xCF, 0x6B,
        0xC8, 0x7F, 0xCB, 0x35, 0x00, 0xB6, 0xA1, 0x47, 0x60, 0xFC,
        0x5B, 0x45, 0xC4, 0x4A, 0xAD, 0xC8, 0x28, 0x76, 0xF3, 0x0B,
        0xC5, 0x8B, 0x95, 0x51, 0xF2, 0xBA, 0x77, 0xA1, 0x87, 0xA7,
        0xC7, 0x26, 0x42, 0x1C, 0xE5, 0xEA, 0xE8, 0x3E, 0xCF, 0xC9,
        0xB6, 0xA3, 0x96, 0x79, 0xB6, 0xB4, 0x57, 0xDE, 0x71, 0x70,
        0x05, 0x45, 0x27, 0xF0, 0x9F, 0x72, 0x87, 0xB5, 0xD5, 0xDF,
        0xA3, 0x5C, 0xBC, 0x61, 0xB6, 0x67, 0xDD, 0x70, 0x1C, 0x9C,
        0x1A, 0x5B, 0x9D, 0x4C, 0x1C, 0x03
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.52 */
