#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0xC8,0xB6,0xC5,0xB3,0x5B,0x11,0xA6,0xA3,0x5B,0xAF,0x6E,0x47,
		0x48,0x68,0x54,0x5D,0x17,0xE1,0x05,0xA2,0x04,0x71,0xD7,0xA1,
		0xD4,0xD4,0xC4,0x46,0x6F,0x1C,0x95,0xC6,0xFE,0xF2,0xAD,0xDC,
		0xEB,0x97,0x95,0x97,0x52,0x15,0x39,0xDC,0xE7,0x5D,0x59,0xC2,
		0xA9,0x31,0x74,0x08,0x31,0xF7,0xD8,0xFF,0xF3,0xEC,0xE9,0xE7,
		0xA1,0xC0,0xCC,0x2B,0x0E,0x45,0x56,0x06,0x64,0xE2,0x75,0x51,
		0xBB,0x20,0xF9,0x7F,0x0C,0xD6,0x92,0xA5,0x76,0x87,0x4D,0x74,
		0xEE,0x70,0x15,0x1F,0xE9,0x51,0x9E,0xB4,0xBF,0xEF,0xBE,0x22,
		0xAC,0x0E,0x5F,0xE3,0x23,0x74,0x28,0xFC,0x00,0x7E,0xE7,0x5B,
		0x14,0x00,0x1E,0x36,0xB6,0xE0,0x7F,0x35,0xF5,0x5F,0xE6,0x98,
		0xCC,0xE4,0x35,0xC8,0x67,0x5F,0xDA,0x4B,0x81,0xA3,0xC2,0xE8,
		0x20,0x7B,0xFF,0x25,0xE0,0x24,0x6A,0xB2,0x2C,0xE3,0xC8,0x2E,
		0xAA,0x66,0xAE,0xB5,0x02,0xB2,0x77,0x7B,0x6B,0xCD,0xF1,0x1E,
		0xF7,0xDD,0x93,0x7C,0xC2,0xAC,0x17,0x63,0x6E,0x08,0x1F,0x06,
		0xB5,0x54,0x58,0xDC,0xC0,0x91,0x6F,0xE8,0xC8,0xC8,0xB0,0x58,
		0x6D,0x90,0xF0,0x34,0xB3,0x98,0xCC,0x02,0x52,0xAF,0xA5,0xD3,
		0x44,0x1C,0xC8,0x99,0x0F,0xF2,0x76,0x71,0x2A,0x22,0x58,0x05,
		0xE3,0x2A,0xFF,0xFA,0xCF,0x02,0x50,0x38,0x74,0xE8,0xE7,0x87,
		0xB5,0x13,0x0A,0xAC,0x21,0x87,0x53,0xBB,0xFE,0x7A,0x38,0x0E,
		0x37,0xAB,0xAB,0xB7,0x77,0xDD,0x16,0x7E,0xCA,0x1D,0xD7,0xB2,
		0x81,0x11,0x4E,0x9C,0xBF,0x0B,0xAA,0x41,0xA1,0x6A,0x30,0x18,
		0xC9,0xD4,0x1B,0xB3,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
#endif /* OPENSSL_NO_DH */
