/*
 * Copyright (C) 2024      Colin Ian King
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */
#include "stress-ng.h"

/*
 *  GNU "long options" command line options
 */
const struct option stress_long_options[] = {
	{ "abort",		0,	0,	OPT_abort },
	{ "access",		1,	0,	OPT_access },
	{ "access-ops",		1,	0,	OPT_access_ops },
	{ "acl",		1,	0,	OPT_acl },
	{ "acl-rand",		0,	0,	OPT_acl_rand },
	{ "acl-ops",		1,	0,	OPT_acl_ops },
	{ "af-alg",		1,	0,	OPT_af_alg },
	{ "af-alg-dump",	0,	0,	OPT_af_alg_dump },
	{ "af-alg-ops",		1,	0,	OPT_af_alg_ops },
	{ "affinity",		1,	0,	OPT_affinity },
	{ "affinity-delay",	1,	0,	OPT_affinity_delay },
	{ "affinity-ops",	1,	0,	OPT_affinity_ops },
	{ "affinity-pin",	0,	0,	OPT_affinity_pin },
	{ "affinity-rand",	0,	0,	OPT_affinity_rand },
	{ "affinity-sleep",	1,	0,	OPT_affinity_sleep },
	{ "aggressive",		0,	0,	OPT_aggressive },
	{ "aio",		1,	0,	OPT_aio },
	{ "aio-ops",		1,	0,	OPT_aio_ops },
	{ "aio-requests",	1,	0,	OPT_aio_requests },
	{ "aiol",		1,	0,	OPT_aiol},
	{ "aiol-ops",		1,	0,	OPT_aiol_ops },
	{ "aiol-requests",	1,	0,	OPT_aiol_requests },
	{ "alarm",		1,	0,	OPT_alarm },
	{ "alarm-ops",		1,	0,	OPT_alarm_ops },
	{ "all",		1,	0,	OPT_all },
	{ "apparmor",		1,	0,	OPT_apparmor },
	{ "apparmor-ops",	1,	0,	OPT_apparmor_ops },
	{ "atomic",		1,	0,	OPT_atomic },
	{ "atomic-ops",		1,	0,	OPT_atomic_ops },
	{ "bad-altstack",	1,	0,	OPT_bad_altstack },
	{ "bad-altstack-ops",	1,	0,	OPT_bad_altstack_ops },
	{ "bad-ioctl",		1,	0,	OPT_bad_ioctl },
	{ "bad-ioctl-method",	1,	0,	OPT_bad_ioctl_method },
	{ "bad-ioctl-ops",	1,	0,	OPT_bad_ioctl_ops },
	{ "backoff",		1,	0,	OPT_backoff },
	{ "besselmath",		1,	0,	OPT_besselmath },
	{ "besselmath-method",	1,	0,	OPT_besselmath_method },
	{ "besselmath-ops",	1,	0,	OPT_besselmath_ops },
	{ "bigheap",		1,	0,	OPT_bigheap },
	{ "bigheap-bytes",	1,	0,	OPT_bigheap_bytes },
	{ "bigheap-growth",	1,	0,	OPT_bigheap_growth },
	{ "bigheap-mlock",	0,	0,	OPT_bigheap_mlock },
	{ "bigheap-ops",	1,	0,	OPT_bigheap_ops },
	{ "bind-mount",		1,	0,	OPT_bind_mount },
	{ "bind-mount-ops",	1,	0,	OPT_bind_mount_ops },
	{ "binderfs",		1,	0,	OPT_binderfs },
	{ "binderfs-ops",	1,	0,	OPT_binderfs_ops },
	{ "bitonicsort",	1,	0,	OPT_bitonicsort },
	{ "bitonicsort-ops",	1,	0,	OPT_bitonicsort_ops },
	{ "bitonicsort-size",	1,	0,	OPT_bitonicsort_size },
	{ "bitops",		1,	0,	OPT_bitops },
	{ "bitops-method",	1,	0,	OPT_bitops_method },
	{ "bitops-ops",		1,	0,	OPT_bitops_ops },
	{ "branch",		1,	0,	OPT_branch },
	{ "branch-ops",		1,	0,	OPT_branch_ops },
	{ "brk",		1,	0,	OPT_brk },
	{ "brk-bytes",		1,	0,	OPT_brk_bytes },
	{ "brk-mlock",		0,	0,	OPT_brk_mlock },
	{ "brk-notouch",	0,	0,	OPT_brk_notouch },
	{ "brk-ops",		1,	0,	OPT_brk_ops },
	{ "bsearch",		1,	0,	OPT_bsearch },
	{ "bsearch-method",	1,	0,	OPT_bsearch_method },
	{ "bsearch-ops",	1,	0,	OPT_bsearch_ops },
	{ "bsearch-size",	1,	0,	OPT_bsearch_size },
	{ "bubblesort",		1,	0,	OPT_bubblesort },
	{ "bubblesort-method",	1,	0,	OPT_bubblesort_method },
	{ "bubblesort-ops",	1,	0,	OPT_bubblesort_ops },
	{ "bubblesort-size",	1,	0,	OPT_bubblesort_size },
	{ "c-states",		0,	0,	OPT_c_states },
	{ "cache",		1,	0, 	OPT_cache },
	{ "cache-size",		1,	0, 	OPT_cache_size},
	{ "cache-cldemote",	0,	0,	OPT_cache_cldemote },
	{ "cache-clflushopt",	0,	0,	OPT_cache_clflushopt },
	{ "cache-clwb",		0,	0,	OPT_cache_clwb },
	{ "cache-enable-all",	0,	0,	OPT_cache_enable_all },
	{ "cache-fence",	0,	0,	OPT_cache_fence },
	{ "cache-flush",	0,	0,	OPT_cache_flush },
	{ "cache-level",	1,	0,	OPT_cache_level },
	{ "cache-no-affinity",	0,	0,	OPT_cache_no_affinity },
	{ "cache-ops",		1,	0,	OPT_cache_ops },
	{ "cache-prefetch",	0,	0,	OPT_cache_prefetch },
	{ "cache-sfence",	0,	0,	OPT_cache_sfence },
	{ "cache-ways",		1,	0,	OPT_cache_ways },
	{ "cacheline",		1,	0, 	OPT_cacheline },
	{ "cacheline-affinity",	0,	0,	OPT_cacheline_affinity },
	{ "cacheline-method",	1,	0,	OPT_cacheline_method },
	{ "cacheline-ops",	1,	0,	OPT_cacheline_ops },
	{ "cap",		1,	0, 	OPT_cap },
	{ "cap-ops",		1,	0, 	OPT_cap_ops },
	{ "chattr",		1,	0, 	OPT_chattr },
	{ "chattr-ops",		1,	0,	OPT_chattr_ops },
	{ "change-cpu",		0,	0,	OPT_change_cpu },
	{ "chdir",		1,	0, 	OPT_chdir },
	{ "chdir-dirs",		1,	0,	OPT_chdir_dirs },
	{ "chdir-ops",		1,	0, 	OPT_chdir_ops },
	{ "chmod",		1,	0, 	OPT_chmod },
	{ "chmod-ops",		1,	0,	OPT_chmod_ops },
	{ "chown",		1,	0, 	OPT_chown},
	{ "chown-ops",		1,	0,	OPT_chown_ops },
	{ "chroot",		1,	0, 	OPT_chroot},
	{ "chroot-ops",		1,	0,	OPT_chroot_ops },
	{ "cgroup",		1,	0,	OPT_cgroup },
	{ "cgroup-ops",		1,	0,	OPT_cgroup_ops },
	{ "class",		1,	0,	OPT_class },
	{ "clock",		1,	0,	OPT_clock },
	{ "clock-ops",		1,	0,	OPT_clock_ops },
	{ "clone",		1,	0,	OPT_clone },
	{ "clone-max",		1,	0,	OPT_clone_max },
	{ "clone-ops",		1,	0,	OPT_clone_ops },
	{ "close",		1,	0,	OPT_close },
	{ "close-ops",		1,	0,	OPT_close_ops },
	{ "config",		0,	0,	OPT_config },
	{ "context",		1,	0,	OPT_context },
	{ "context-ops",	1,	0,	OPT_context_ops },
	{ "copy-file",		1,	0,	OPT_copy_file },
	{ "copy-file-bytes",	1,	0,	OPT_copy_file_bytes },
	{ "copy-file-ops",	1,	0,	OPT_copy_file_ops },
	{ "cpu",		1,	0,	OPT_cpu },
	{ "cpu-ops",		1,	0,	OPT_cpu_ops },
	{ "cpu-load",		1,	0,	OPT_cpu_load },
	{ "cpu-load-slice",	1,	0,	OPT_cpu_load_slice },
	{ "cpu-method",		1,	0,	OPT_cpu_method },
	{ "cpu-online",		1,	0,	OPT_cpu_online },
	{ "cpu-online-affinity",0,	0,	OPT_cpu_online_affinity },
	{ "cpu-online-all",	0,	0,	OPT_cpu_online_all },
	{ "cpu-online-ops",	1,	0,	OPT_cpu_online_ops },
	{ "crypt",		1,	0,	OPT_crypt },
	{ "crypt-method",	1,	0,	OPT_crypt_method },
	{ "crypt-ops",		1,	0,	OPT_crypt_ops },
	{ "cyclic",		1,	0,	OPT_cyclic },
	{ "cyclic-dist",	1,	0,	OPT_cyclic_dist },
	{ "cyclic-method",	1,	0,	OPT_cyclic_method },
	{ "cyclic-ops",		1,	0,	OPT_cyclic_ops },
	{ "cyclic-policy",	1,	0,	OPT_cyclic_policy },
	{ "cyclic-prio",	1,	0,	OPT_cyclic_prio },
	{ "cyclic-samples",	1,	0,	OPT_cyclic_samples },
	{ "cyclic-sleep",	1,	0,	OPT_cyclic_sleep },
	{ "daemon",		1,	0,	OPT_daemon },
	{ "daemon-ops",		1,	0,	OPT_daemon_ops },
	{ "daemon-wait",	0,	0,	OPT_daemon_wait },
	{ "dccp",		1,	0,	OPT_dccp },
	{ "dccp-domain",	1,	0,	OPT_dccp_domain },
	{ "dccp-if",		1,	0,	OPT_dccp_if },
	{ "dccp-msgs",		1,	0,	OPT_dccp_msgs },
	{ "dccp-ops",		1,	0,	OPT_dccp_ops },
	{ "dccp-opts",		1,	0,	OPT_dccp_opts },
	{ "dccp-port",		1,	0,	OPT_dccp_port },
	{ "dekker",		1,	0,	OPT_dekker },
	{ "dekker-ops",		1,	0,	OPT_dekker_ops },
	{ "dentry",		1,	0,	OPT_dentry },
	{ "dentry-ops",		1,	0,	OPT_dentry_ops },
	{ "dentries",		1,	0,	OPT_dentries },
	{ "dentry-order",	1,	0,	OPT_dentry_order },
	{ "dev",		1,	0,	OPT_dev },
	{ "dev-file",		1,	0,	OPT_dev_file },
	{ "dev-ops",		1,	0,	OPT_dev_ops },
	{ "dev-shm",		1,	0,	OPT_dev_shm },
	{ "dev-shm-ops",	1,	0,	OPT_dev_shm_ops },
	{ "dir",		1,	0,	OPT_dir },
	{ "dir-dirs",		1,	0,	OPT_dir_dirs },
	{ "dir-ops",		1,	0,	OPT_dir_ops },
	{ "dirdeep",		1,	0,	OPT_dirdeep },
	{ "dirdeep-bytes",	1,	0,	OPT_dirdeep_bytes },
	{ "dirdeep-dirs",	1,	0,	OPT_dirdeep_dirs },
	{ "dirdeep-files",	1,	0,	OPT_dirdeep_files },
	{ "dirdeep-inodes",	1,	0,	OPT_dirdeep_inodes },
	{ "dirdeep-ops",	1,	0,	OPT_dirdeep_ops },
	{ "dirmany",		1,	0,	OPT_dirmany },
	{ "dirmany-bytes",	1,	0,	OPT_dirmany_bytes },
	{ "dirmany-ops",	1,	0,	OPT_dirmany_ops },
	{ "dry-run",		0,	0,	OPT_dry_run },
	{ "dnotify",		1,	0,	OPT_dnotify },
	{ "dnotify-ops",	1,	0,	OPT_dnotify_ops },
	{ "dup",		1,	0,	OPT_dup },
	{ "dup-ops",		1,	0,	OPT_dup_ops },
	{ "dynlib",		1,	0,	OPT_dynlib },
	{ "dynlib-ops",		1,	0,	OPT_dynlib_ops },
	{ "eigen",		1,	0,	OPT_eigen },
	{ "eigen-ops",		1,	0,	OPT_eigen_ops },
	{ "eigen-method",	1,	0,	OPT_eigen_method },
	{ "eigen-size",		1,	0,	OPT_eigen_size },
	{ "efivar",		1,	0,	OPT_efivar },
	{ "efivar-ops",		1,	0,	OPT_efivar_ops },
	{ "enosys",		1,	0,	OPT_enosys },
	{ "enosys-ops",		1,	0,	OPT_enosys_ops },
	{ "env",		1,	0,	OPT_env },
	{ "env-ops",		1,	0,	OPT_env_ops },
	{ "epoll",		1,	0,	OPT_epoll },
	{ "epoll-domain",	1,	0,	OPT_epoll_domain },
	{ "epoll-ops",		1,	0,	OPT_epoll_ops },
	{ "epoll-port",		1,	0,	OPT_epoll_port },
	{ "epoll-sockets",	1,	0,	OPT_epoll_sockets },
	{ "eventfd",		1,	0,	OPT_eventfd },
	{ "eventfd-nonblock",	0,	0,	OPT_eventfd_nonblock },
	{ "eventfd-ops",	1,	0,	OPT_eventfd_ops },
	{ "exclude",		1,	0,	OPT_exclude },
	{ "exec",		1,	0,	OPT_exec },
	{ "exec-fork-method",	1,	0,	OPT_exec_fork_method },
	{ "exec-max",		1,	0,	OPT_exec_max },
	{ "exec-method",	1,	0,	OPT_exec_method },
	{ "exec-no-pthread",	0,	0,	OPT_exec_no_pthread },
	{ "exec-ops",		1,	0,	OPT_exec_ops },
	{ "exit-group",		1,	0,	OPT_exit_group },
	{ "exit-group-ops",	1,	0,	OPT_exit_group_ops },
	{ "expmath",		1,	0,	OPT_expmath },
	{ "expmath-method",	1,	0,	OPT_expmath_method },
	{ "expmath-ops",	1,	0,	OPT_expmath_ops },
	{ "factor",		1,	0,	OPT_factor },
	{ "factor-digits",	1,	0,	OPT_factor_digits },
	{ "factor-ops",		1,	0,	OPT_factor_ops },
	{ "fallocate",		1,	0,	OPT_fallocate },
	{ "fallocate-bytes",	1,	0,	OPT_fallocate_bytes },
	{ "fallocate-ops",	1,	0,	OPT_fallocate_ops },
	{ "fanotify",		1,	0,	OPT_fanotify },
	{ "fanotify-ops",	1,	0,	OPT_fanotify_ops },
	{ "far-branch",		1,	0,	OPT_far_branch },
	{ "far-branch-flush",	0,	0,	OPT_far_branch_flush },
	{ "far-branch-ops",	1,	0,	OPT_far_branch_ops },
	{ "far-branch-pages",	1,	0,	OPT_far_branch_pages },
	{ "fault",		1,	0,	OPT_fault },
	{ "fault-ops",		1,	0,	OPT_fault_ops },
	{ "fcntl",		1,	0,	OPT_fcntl},
	{ "fcntl-ops",		1,	0,	OPT_fcntl_ops },
	{ "fd-fork",		1,	0,	OPT_fd_fork },
	{ "fd-fork-fds",	1,	0,	OPT_fd_fork_fds },
	{ "fd-fork-file",	1,	0,	OPT_fd_fork_file },
	{ "fd-fork-ops",	1,	0,	OPT_fd_fork_ops },
	{ "fd-race",		1,	0,	OPT_fd_race },
	{ "fd-race-dev",	0,	0,	OPT_fd_race_dev },
	{ "fd-race-ops",	1,	0,	OPT_fd_race_ops },
	{ "fd-race-proc",	0,	0,	OPT_fd_race_proc },
	{ "fibsearch",		1,	0,	OPT_fibsearch },
	{ "fibsearch-ops",	1,	0,	OPT_fibsearch_ops },
	{ "fibsearch-size",	1,	0,	OPT_fibsearch_size },
	{ "fiemap",		1,	0,	OPT_fiemap },
	{ "fiemap-bytes",	1,	0,	OPT_fiemap_bytes },
	{ "fiemap-ops",		1,	0,	OPT_fiemap_ops },
	{ "fifo",		1,	0,	OPT_fifo },
	{ "fifo-data-size",	1,	0,	OPT_fifo_data_size },
	{ "fifo-ops",		1,	0,	OPT_fifo_ops },
	{ "fifo-readers",	1,	0,	OPT_fifo_readers },
	{ "file-ioctl",		1,	0,	OPT_file_ioctl },
	{ "file-ioctl-ops",	1,	0,	OPT_file_ioctl_ops },
	{ "filename",		1,	0,	OPT_filename },
	{ "filename-ops",	1,	0,	OPT_filename_ops },
	{ "filename-opts",	1,	0,	OPT_filename_opts },
	{ "flock",		1,	0,	OPT_flock },
	{ "flock-ops",		1,	0,	OPT_flock_ops },
	{ "flushcache",		1,	0,	OPT_flushcache },
	{ "flushcache-ops",	1,	0,	OPT_flushcache_ops },
	{ "fma",		1,	0,	OPT_fma },
	{ "fma-ops",		1,	0,	OPT_fma_ops },
	{ "fma-libc",		0,	0,	OPT_fma_libc },
	{ "fork",		1,	0,	OPT_fork },
	{ "fork-max",		1,	0,	OPT_fork_max },
	{ "fork-ops",		1,	0,	OPT_fork_ops },
	{ "fork-pageout",	0,	0,	OPT_fork_pageout },
	{ "fork-unmap",		0,	0,	OPT_fork_unmap },
	{ "fork-vm",		0,	0,	OPT_fork_vm },
	{ "forkheavy",		1,	0,	OPT_forkheavy },
	{ "forkheavy-allocs",	1,	0,	OPT_forkheavy_allocs },
	{ "forkheavy-mlock",	0,	0,	OPT_forkheavy_mlock },
	{ "forkheavy-ops",	1,	0,	OPT_forkheavy_ops },
	{ "forkheavy-procs",	1,	0,	OPT_forkheavy_procs },
	{ "fp",			1,	0,	OPT_fp },
	{ "fp-method",		1,	0,	OPT_fp_method },
	{ "fp-ops",		1,	0,	OPT_fp_ops },
	{ "fp-error",		1,	0,	OPT_fp_error},
	{ "fp-error-ops",	1,	0,	OPT_fp_error_ops },
	{ "fpunch",		1,	0,	OPT_fpunch },
	{ "fpunch-bytes",	1,	0,	OPT_fpunch_bytes },
	{ "fpunch-ops",		1,	0,	OPT_fpunch_ops },
	{ "fractal",		1,	0,	OPT_fractal },
	{ "fractal-iterations",	1,	0,	OPT_fractal_iterations },
	{ "fractal-method",	1,	0,	OPT_fractal_method },
	{ "fractal-xsize",	1,	0,	OPT_fractal_xsize },
	{ "fractal-ysize",	1,	0,	OPT_fractal_ysize },
	{ "fractal-ops",	1,	0,	OPT_fractal_ops },
	{ "fsize",		1,	0,	OPT_fsize },
	{ "fsize-ops",		1,	0,	OPT_fsize_ops },
	{ "fstat",		1,	0,	OPT_fstat },
	{ "fstat-dir",		1,	0,	OPT_fstat_dir },
	{ "fstat-ops",		1,	0,	OPT_fstat_ops },
	{ "ftrace",		0,	0,	OPT_ftrace },
	{ "full",		1,	0,	OPT_full },
	{ "full-ops",		1,	0,	OPT_full_ops },
	{ "funccall",		1,	0,	OPT_funccall },
	{ "funccall-method",	1,	0,	OPT_funccall_method },
	{ "funccall-ops",	1,	0,	OPT_funccall_ops },
	{ "funcret",		1,	0,	OPT_funcret },
	{ "funcret-method",	1,	0,	OPT_funcret_method },
	{ "funcret-ops",	1,	0,	OPT_funcret_ops },
	{ "futex",		1,	0,	OPT_futex },
	{ "futex-ops",		1,	0,	OPT_futex_ops },
	{ "get",		1,	0,	OPT_get },
	{ "get-ops",		1,	0,	OPT_get_ops },
	{ "get-slow-sync",	0,	0,	OPT_get_slow_sync },
	{ "getrandom",		1,	0,	OPT_getrandom },
	{ "getrandom-ops",	1,	0,	OPT_getrandom_ops },
	{ "getdent",		1,	0,	OPT_getdent },
	{ "getdent-ops",	1,	0,	OPT_getdent_ops },
	{ "goto",		1,	0,	OPT_goto },
	{ "goto-direction", 	1,	0,	OPT_goto_direction },
	{ "goto-ops",		1,	0,	OPT_goto_ops },
	{ "gpu",		1,	0,	OPT_gpu },
	{ "gpu-devnode",	1,	0,	OPT_gpu_devnode },
	{ "gpu-frag",		1,	0,	OPT_gpu_frag },
	{ "gpu-ops",		1,	0,	OPT_gpu_ops },
	{ "gpu-tex-size",	1,	0,	OPT_gpu_size },
	{ "gpu-upload",		1,	0,	OPT_gpu_uploads },
	{ "gpu-xsize",		1,	0,	OPT_gpu_xsize },
	{ "gpu-ysize",		1,	0,	OPT_gpu_ysize },
	{ "handle",		1,	0,	OPT_handle },
	{ "handle-ops",		1,	0,	OPT_handle_ops },
	{ "hash",		1,	0,	OPT_hash },
	{ "hash-method",	1,	0,	OPT_hash_method },
	{ "hash-ops",		1,	0,	OPT_hash_ops },
	{ "hdd",		1,	0,	OPT_hdd },
	{ "hdd-bytes",		1,	0,	OPT_hdd_bytes },
	{ "hdd-ops",		1,	0,	OPT_hdd_ops },
	{ "hdd-opts",		1,	0,	OPT_hdd_opts },
	{ "hdd-write-size", 	1,	0,	OPT_hdd_write_size },
	{ "heapsort",		1,	0,	OPT_heapsort },
	{ "heapsort-method",	1,	0,	OPT_heapsort_method },
	{ "heapsort-ops",	1,	0,	OPT_heapsort_ops },
	{ "heapsort-size",	1,	0,	OPT_heapsort_size },
	{ "hrtimers",		1,	0,	OPT_hrtimers },
	{ "hrtimers-adjust",	0,	0,	OPT_hrtimers_adjust },
	{ "hrtimers-ops",	1,	0,	OPT_hrtimers_ops },
	{ "help",		0,	0,	OPT_help },
	{ "hsearch",		1,	0,	OPT_hsearch },
	{ "hsearch-method",	1,	0,	OPT_hsearch_method },
	{ "hsearch-ops",	1,	0,	OPT_hsearch_ops },
	{ "hsearch-size",	1,	0,	OPT_hsearch_size },
	{ "icache",		1,	0,	OPT_icache },
	{ "icache-ops",		1,	0,	OPT_icache_ops },
	{ "icmp-flood",		1,	0,	OPT_icmp_flood },
	{ "icmp-flood-ops",	1,	0,	OPT_icmp_flood_ops },
	{ "icmp-flood-max-size", 0,	0,	OPT_icmp_flood_max_size },
	{ "idle-page",		1,	0,	OPT_idle_page },
	{ "idle-page-ops",	1,	0,	OPT_idle_page_ops },
	{ "ignite-cpu",		0,	0, 	OPT_ignite_cpu },
	{ "interrupts",		0,	0,	OPT_interrupts },
	{ "inode-flags",	1,	0,	OPT_inode_flags },
	{ "inode-flags-ops",	1,	0,	OPT_inode_flags_ops },
	{ "inotify",		1,	0,	OPT_inotify },
	{ "inotify-ops",	1,	0,	OPT_inotify_ops },
	{ "insertionsort",	1,	0,	OPT_insertionsort },
	{ "insertionsort-ops",	1,	0,	OPT_insertionsort_ops },
	{ "insertionsort-size",	1,	0,	OPT_insertionsort_size },
	{ "intmath",		1,	0,	OPT_intmath },
	{ "intmath-method",	1,	0,	OPT_intmath_method },
	{ "intmath-ops",	1,	0,	OPT_intmath_ops },
	{ "io",			1,	0,	OPT_io },
	{ "io-ops",		1,	0,	OPT_io_ops },
	{ "iomix",		1,	0,	OPT_iomix },
	{ "iomix-bytes",	1,	0,	OPT_iomix_bytes },
	{ "iomix-ops",		1,	0,	OPT_iomix_ops },
	{ "ionice-class",	1,	0,	OPT_ionice_class },
	{ "ionice-level",	1,	0,	OPT_ionice_level },
	{ "ioport",		1,	0,	OPT_ioport },
	{ "ioport-ops",		1,	0,	OPT_ioport_ops },
	{ "ioport-opts",	1,	0,	OPT_ioport_opts },
	{ "ioprio",		1,	0,	OPT_ioprio },
	{ "ioprio-ops",		1,	0,	OPT_ioprio_ops },
	{ "iostat",		1,	0,	OPT_iostat },
	{ "io-uring",		1,	0,	OPT_io_uring },
	{ "io-uring-entries",	1,	0,	OPT_io_uring_entries },
	{ "io-uring-ops",	1,	0,	OPT_io_uring_ops },
	{ "io-uring-rand",	0,	0,	OPT_io_uring_rand },
	{ "ipsec-mb",		1,	0,	OPT_ipsec_mb },
	{ "ipsec-mb-feature",	1,	0,	OPT_ipsec_mb_feature },
	{ "ipsec-mb-jobs",	1,	0,	OPT_ipsec_mb_jobs },
	{ "ipsec-mb-method",	1,	0,	OPT_ipsec_mb_method },
	{ "ipsec-mb-ops",	1,	0,	OPT_ipsec_mb_ops },
	{ "itimer",		1,	0,	OPT_itimer },
	{ "itimer-freq",	1,	0,	OPT_itimer_freq },
	{ "itimer-ops",		1,	0,	OPT_itimer_ops },
	{ "itimer-rand",	0,	0,	OPT_itimer_rand },
	{ "job",		1,	0,	OPT_job },
	{ "jpeg",		1,	0,	OPT_jpeg },
	{ "jpeg-height",	1,	0,	OPT_jpeg_height },
	{ "jpeg-image",		1,	0,	OPT_jpeg_image },
	{ "jpeg-ops",		1,	0,	OPT_jpeg_ops },
	{ "jpeg-quality",	1,	0,	OPT_jpeg_quality },
	{ "jpeg-width",		1,	0,	OPT_jpeg_width },
	{ "judy",		1,	0,	OPT_judy },
	{ "judy-ops",		1,	0,	OPT_judy_ops },
	{ "judy-size",		1,	0,	OPT_judy_size },
	{ "kcmp",		1,	0,	OPT_kcmp },
	{ "kcmp-ops",		1,	0,	OPT_kcmp_ops },
	{ "keep-files",		0,	0,	OPT_keep_files },
	{ "keep-name",		0,	0,	OPT_keep_name },
	{ "key",		1,	0,	OPT_key },
	{ "key-ops",		1,	0,	OPT_key_ops },
	{ "kill",		1,	0,	OPT_kill },
	{ "kill-ops",		1,	0,	OPT_kill_ops },
	{ "klog",		1,	0,	OPT_klog },
	{ "klog-check",		0,	0,	OPT_klog_check },
	{ "klog-ops",		1,	0,	OPT_klog_ops },
	{ "ksm",		0,	0,	OPT_ksm },
	{ "kvm",		1,	0,	OPT_kvm },
	{ "kvm-ops",		1,	0,	OPT_kvm_ops },
	{ "l1cache",		1,	0, 	OPT_l1cache },
	{ "l1cache-line-size",	1,	0,	OPT_l1cache_line_size },
	{ "l1cache-method",	1,	0,	OPT_l1cache_method },
	{ "l1cache-mlock",	0,	0,	OPT_l1cache_mlock },
	{ "l1cache-ops",	1,	0,	OPT_l1cache_ops },
	{ "l1cache-sets",	1,	0,	OPT_l1cache_sets},
	{ "l1cache-size",	1,	0,	OPT_l1cache_size },
	{ "l1cache-ways",	1,	0,	OPT_l1cache_ways},
	{ "landlock",		1,	0,	OPT_landlock },
	{ "landlock-ops",	1,	0,	OPT_landlock_ops },
	{ "led",		1,	0,	OPT_led },
	{ "led-ops",		1,	0,	OPT_led_ops },
	{ "lease",		1,	0,	OPT_lease },
	{ "lease-breakers",	1,	0,	OPT_lease_breakers },
	{ "lease-ops",		1,	0,	OPT_lease_ops },
	{ "link",		1,	0,	OPT_link },
	{ "link-ops",		1,	0,	OPT_link_ops },
	{ "link-sync",		0,	0,	OPT_link_sync },
	{ "list",		1,	0,	OPT_list },
	{ "list-method",	1,	0,	OPT_list_method },
	{ "list-ops",		1,	0,	OPT_list_ops },
	{ "list-size",		1,	0,	OPT_list_size },
	{ "llc-affinity",	1,	0,	OPT_llc_affinity },
	{ "llc-affinity-mlock",	0,	0,	OPT_llc_affinity_mlock },
	{ "llc-affinity-ops",	1,	0,	OPT_llc_affinity_ops },
	{ "loadavg",		1,	0,	OPT_loadavg },
	{ "loadavg-ops",	1,	0,	OPT_loadavg_ops },
	{ "loadavg-max",	1,	0,	OPT_loadavg_max },
	{ "locka",		1,	0,	OPT_locka },
	{ "locka-ops",		1,	0,	OPT_locka_ops },
	{ "lockbus",		1,	0,	OPT_lockbus },
	{ "lockbus-ops",	1,	0,	OPT_lockbus_ops },
	{ "lockbus-nosplit",	0,	0,	OPT_lockbus_nosplit },
	{ "lockf",		1,	0,	OPT_lockf },
	{ "lockf-nonblock", 	0,	0,	OPT_lockf_nonblock },
	{ "lockf-ops",		1,	0,	OPT_lockf_ops },
	{ "lockmix",		1,	0,	OPT_lockmix },
	{ "lockmix-ops",	1,	0,	OPT_lockmix_ops },
	{ "lockofd",		1,	0,	OPT_lockofd },
	{ "lockofd-ops",	1,	0,	OPT_lockofd_ops },
	{ "log-brief",		0,	0,	OPT_log_brief },
	{ "log-file",		1,	0,	OPT_log_file },
	{ "log-lockless",	0,	0,	OPT_log_lockless },
	{ "logmath",		1,	0,	OPT_logmath },
	{ "logmath-method",	1,	0,	OPT_logmath_method },
	{ "logmath-ops",	1,	0,	OPT_logmath_ops },
	{ "longjmp",		1,	0,	OPT_longjmp },
	{ "longjmp-ops",	1,	0,	OPT_longjmp_ops },
	{ "loop",		1,	0,	OPT_loop },
	{ "loop-ops",		1,	0,	OPT_loop_ops },
	{ "lsearch",		1,	0,	OPT_lsearch },
	{ "lsearch-method",	1,	0,	OPT_lsearch_method },
	{ "lsearch-ops",	1,	0,	OPT_lsearch_ops },
	{ "lsearch-size",	1,	0,	OPT_lsearch_size },
	{ "lsm",		1,	0,	OPT_lsm },
	{ "lsm-ops",		1,	0,	OPT_lsm_ops },
	{ "madvise",		1,	0,	OPT_madvise },
	{ "madvise-ops",	1,	0,	OPT_madvise_ops },
	{ "madvise-hwpoison",	0,	0,	OPT_madvise_hwpoison },
	{ "malloc",		1,	0,	OPT_malloc },
	{ "malloc-bytes",	1,	0,	OPT_malloc_bytes },
	{ "malloc-max",		1,	0,	OPT_malloc_max },
	{ "malloc-mlock",	0,	0,	OPT_malloc_mlock },
	{ "malloc-ops",		1,	0,	OPT_malloc_ops },
	{ "malloc-pthreads",	1,	0,	OPT_malloc_pthreads },
	{ "malloc-thresh",	1,	0,	OPT_malloc_threshold },
	{ "malloc-touch",	0,	0,	OPT_malloc_touch },
	{ "malloc-trim",	0,	0,	OPT_malloc_trim },
	{ "malloc-zerofree",	0,	0,	OPT_malloc_zerofree },
	{ "matrix",		1,	0,	OPT_matrix },
	{ "matrix-method",	1,	0,	OPT_matrix_method },
	{ "matrix-ops",		1,	0,	OPT_matrix_ops },
	{ "matrix-size",	1,	0,	OPT_matrix_size },
	{ "matrix-yx",		0,	0,	OPT_matrix_yx },
	{ "matrix-3d",		1,	0,	OPT_matrix_3d },
	{ "matrix-3d-method",	1,	0,	OPT_matrix_3d_method },
	{ "matrix-3d-ops",	1,	0,	OPT_matrix_3d_ops },
	{ "matrix-3d-size",	1,	0,	OPT_matrix_3d_size },
	{ "matrix-3d-zyx",	0,	0,	OPT_matrix_3d_zyx },
	{ "maximize",		0,	0,	OPT_maximize },
	{ "max-fd",		1,	0,	OPT_max_fd },
	{ "mbind",		1,	0,	OPT_mbind },
	{ "mcontend",		1,	0,	OPT_mcontend },
	{ "mcontend-ops",	1,	0,	OPT_mcontend_ops },
	{ "membarrier",		1,	0,	OPT_membarrier },
	{ "membarrier-ops",	1,	0,	OPT_membarrier_ops },
	{ "memcpy",		1,	0,	OPT_memcpy },
	{ "memcpy-method",	1,	0,	OPT_memcpy_method },
	{ "memcpy-ops",		1,	0,	OPT_memcpy_ops },
	{ "memfd",		1,	0,	OPT_memfd },
	{ "memfd-bytes",	1,	0,	OPT_memfd_bytes },
	{ "memfd-fds",		1,	0,	OPT_memfd_fds },
	{ "memfd-madvise",	0,	0,	OPT_memfd_madvise },
	{ "memfd-mlock",	0,	0,	OPT_memfd_mlock },
	{ "memfd-ops",		1,	0,	OPT_memfd_ops },
	{ "memfd-zap-pte",	0,	0,	OPT_memfd_zap_pte },
	{ "memhotplug",		1,	0,	OPT_memhotplug },
	{ "memhotplug-ops",	1,	0,	OPT_memhotplug_ops },
	{ "memhotplug-mmap",	0,	0,	OPT_memhotplug_mmap },
	{ "memrate",		1,	0,	OPT_memrate },
	{ "memrate-bytes",	1,	0,	OPT_memrate_bytes },
	{ "memrate-flush",	0,	0,	OPT_memrate_flush },
	{ "memrate-ops",	1,	0,	OPT_memrate_ops },
	{ "memrate-rd-mbs",	1,	0,	OPT_memrate_rd_mbs },
	{ "memrate-wr-mbs",	1,	0,	OPT_memrate_wr_mbs },
	{ "memthrash",		1,	0,	OPT_memthrash },
	{ "memthrash-method",	1,	0,	OPT_memthrash_method },
	{ "memthrash-ops",	1,	0,	OPT_memthrash_ops },
	{ "mergesort",		1,	0,	OPT_mergesort },
	{ "mergesort-method",	1,	0,	OPT_mergesort_method },
	{ "mergesort-ops",	1,	0,	OPT_mergesort_ops },
	{ "mergesort-size",	1,	0,	OPT_mergesort_size },
	{ "metamix",		1,	0,	OPT_metamix },
        { "metamix-ops",	1,	0,	OPT_metamix_ops },
        { "metamix-bytes",	1,	0,	OPT_metamix_bytes },
	{ "metrics",		0,	0,	OPT_metrics },
	{ "metrics-brief",	0,	0,	OPT_metrics_brief },
	{ "mincore",		1,	0,	OPT_mincore },
	{ "mincore-ops",	1,	0,	OPT_mincore_ops },
	{ "mincore-random",	0,	0,	OPT_mincore_rand },
	{ "min-nanosleep",	1,	0,	OPT_min_nanosleep },
	{ "min-nanosleep-ops",	1,	0,	OPT_min_nanosleep_ops },
	{ "min-nanosleep-max",	1,	0,	OPT_min_nanosleep_max },
	{ "min-nanosleep-sched",1,	0,	OPT_min_nanosleep_sched },
	{ "misaligned",		1,	0,	OPT_misaligned },
	{ "misaligned-method",	1,	0,	OPT_misaligned_method },
	{ "misaligned-ops",	1,	0,	OPT_misaligned_ops },
	{ "minimize",		0,	0,	OPT_minimize },
	{ "mknod",		1,	0,	OPT_mknod },
	{ "mknod-ops",		1,	0,	OPT_mknod_ops },
	{ "mlock",		1,	0,	OPT_mlock },
	{ "mlock-ops",		1,	0,	OPT_mlock_ops },
	{ "mlockmany",		1,	0,	OPT_mlockmany },
	{ "mlockmany-ops",	1,	0,	OPT_mlockmany_ops },
	{ "mlockmany-procs",	1,	0,	OPT_mlockmany_procs },
	{ "mmap",		1,	0,	OPT_mmap },
	{ "mmap-async",		0,	0,	OPT_mmap_async },
	{ "mmap-bytes",		1,	0,	OPT_mmap_bytes },
	{ "mmap-file",		0,	0,	OPT_mmap_file },
	{ "mmap-madvise",	0,	0,	OPT_mmap_madvise },
	{ "mmap-mergeable",	0,	0,	OPT_mmap_mergeable },
	{ "mmap-mprotect",	0,	0,	OPT_mmap_mprotect },
	{ "mmap-mlock",		0,	0,	OPT_mmap_mlock },
	{ "mmap-mmap2",		0,	0,	OPT_mmap_mmap2 },
	{ "mmap-odirect",	0,	0,	OPT_mmap_odirect },
	{ "mmap-ops",		1,	0,	OPT_mmap_ops },
	{ "mmap-osync",		0,	0,	OPT_mmap_osync },
	{ "mmap-slow-munmap",	0,	0,	OPT_mmap_slow_munmap },
	{ "mmap-stressful",	0,	0,	OPT_mmap_stressful },
	{ "mmap-write-check",	0,	0,	OPT_mmap_write_check },
	{ "mmapaddr",		1,	0,	OPT_mmapaddr },
	{ "mmapaddr-mlock",	0,	0,	OPT_mmapaddr_mlock },
	{ "mmapaddr-ops",	1,	0,	OPT_mmapaddr_ops },
	{ "mmapfiles",		1,	0,	OPT_mmapfiles },
	{ "mmapfiles-ops",	1,	0,	OPT_mmapfiles_ops },
	{ "mmapfiles-populate",	0,	0,	OPT_mmapfiles_populate },
	{ "mmapfiles-shared",	0,	0,	OPT_mmapfiles_shared },
	{ "mmapfixed",		1,	0,	OPT_mmapfixed},
	{ "mmapfixed-mlock",	0,	0,	OPT_mmapfixed_mlock },
	{ "mmapfixed-ops",	1,	0,	OPT_mmapfixed_ops },
	{ "mmapfork",		1,	0,	OPT_mmapfork },
	{ "mmapfork-ops",	1,	0,	OPT_mmapfork_ops },
	{ "mmapfork-bytes",	1,	0,	OPT_mmapfork_bytes},
	{ "mmaphuge",		1,	0,	OPT_mmaphuge },
	{ "mmaphuge-file",	0,	0,	OPT_mmaphuge_file },
	{ "mmaphuge-mlock",	0,	0,	OPT_mmaphuge_mlock },
	{ "mmaphuge-mmaps",	1,	0,	OPT_mmaphuge_mmaps },
	{ "mmaphuge-ops",	1,	0,	OPT_mmaphuge_ops },
	{ "mmapmany",		1,	0,	OPT_mmapmany },
	{ "mmapmany-mlock",	0,	0,	OPT_mmapmany_mlock },
	{ "mmapmany-ops",	1,	0,	OPT_mmapmany_ops },
	{ "module",		1,	0,	OPT_module},
	{ "module-ops",		1,	0,	OPT_module_ops },
	{ "module-name",	1,	0,	OPT_module_name},
	{ "module-no-modver",	0,	0,	OPT_module_no_modver},
	{ "module-no-vermag",	0,	0,	OPT_module_no_vermag,},
	{ "module-no-unload",	0,	0,	OPT_module_no_unload},
	{ "monte-carlo",	1,	0,	OPT_monte_carlo },
	{ "monte-carlo-method",	1,	0,	OPT_monte_carlo_method },
	{ "monte-carlo-ops",	1,	0,	OPT_monte_carlo_ops },
	{ "monte-carlo-rand",	1,	0,	OPT_monte_carlo_rand },
	{ "monte-carlo-samples",1,	0,	OPT_monte_carlo_samples },
	{ "mprotect",		1,	0,	OPT_mprotect },
	{ "mprotect-ops",	1,	0,	OPT_mprotect_ops },
	{ "mpfr",		1,	0,	OPT_mpfr },
	{ "mpfr-ops",		1,	0,	OPT_mpfr_ops },
	{ "mpfr-precision",	1,	0,	OPT_mpfr_precision },
	{ "mq",			1,	0,	OPT_mq },
	{ "mq-ops",		1,	0,	OPT_mq_ops },
	{ "mq-size",		1,	0,	OPT_mq_size },
	{ "mremap",		1,	0,	OPT_mremap },
	{ "mremap-bytes",	1,	0,	OPT_mremap_bytes },
	{ "mremap-mlock",	0,	0,	OPT_mremap_mlock },
	{ "mremap-ops",		1,	0,	OPT_mremap_ops },
	{ "mseal",		1,	0,	OPT_mseal },
	{ "mseal-ops",		1,	0,	OPT_mseal_ops,},
	{ "msg",		1,	0,	OPT_msg },
	{ "msg-bytes",		1,	0,	OPT_msg_bytes },
	{ "msg-ops",		1,	0,	OPT_msg_ops },
	{ "msg-types",		1,	0,	OPT_msg_types },
	{ "msync",		1,	0,	OPT_msync },
	{ "msync-bytes",	1,	0,	OPT_msync_bytes },
	{ "msync-ops",		1,	0,	OPT_msync_ops },
	{ "msyncmany",		1,	0,	OPT_msyncmany },
	{ "msyncmany-ops",	1,	0,	OPT_msyncmany_ops },
	{ "mtx",		1,	0,	OPT_mtx },
	{ "mtx-ops",		1,	0,	OPT_mtx_ops },
	{ "mtx-procs",		1,	0,	OPT_mtx_procs },
	{ "munmap",		1,	0,	OPT_munmap },
	{ "munmap-ops",		1,	0,	OPT_munmap_ops },
	{ "mutex",		1,	0,	OPT_mutex },
	{ "mutex-affinity",	0,	0,	OPT_mutex_affinity },
	{ "mutex-ops",		1,	0,	OPT_mutex_ops },
	{ "mutex-procs",	1,	0,	OPT_mutex_procs },
	{ "nanosleep",		1,	0,	OPT_nanosleep },
	{ "nanosleep-method",	1,	0,	OPT_nanosleep_method },
	{ "nanosleep-ops",	1,	0,	OPT_nanosleep_ops },
	{ "nanosleep-threads",	1,	0,	OPT_nanosleep_threads },
	{ "netdev",		1,	0,	OPT_netdev },
	{ "netdev-ops",		1,	0,	OPT_netdev_ops },
	{ "netlink-proc",	1,	0,	OPT_netlink_proc },
	{ "netlink-proc-ops",	1,	0,	OPT_netlink_proc_ops },
	{ "netlink-task",	1,	0,	OPT_netlink_task },
	{ "netlink-task-ops",	1,	0,	OPT_netlink_task_ops },
	{ "nice",		1,	0,	OPT_nice },
	{ "nice-ops",		1,	0,	OPT_nice_ops },
	{ "no-madvise",		0,	0,	OPT_no_madvise },
	{ "no-oom-adjust",	0,	0,	OPT_no_oom_adjust },
	{ "no-rand-seed", 	0,	0,	OPT_no_rand_seed },
	{ "nop",		1,	0,	OPT_nop },
	{ "nop-instr",		1,	0,	OPT_nop_instr },
	{ "nop-ops",		1,	0,	OPT_nop_ops },
	{ "null",		1,	0,	OPT_null },
	{ "null-ops",		1,	0,	OPT_null_ops },
	{ "null-write",		0,	0,	OPT_null_write },
	{ "numa",		1,	0,	OPT_numa },
	{ "numa-bytes",		1,	0,	OPT_numa_bytes },
	{ "numa-ops",		1,	0,	OPT_numa_ops },
	{ "numa-shuffle-addr",	0,	0,	OPT_numa_shuffle_addr },
	{ "numa-shuffle-node",	0,	0,	OPT_numa_shuffle_node },
	{ "oomable",		0,	0,	OPT_oomable },
	{ "oom-avoid",		0,	0,	OPT_oom_avoid },
	{ "oom-avoid-bytes",	1,	0,	OPT_oom_avoid_bytes },
	{ "oom-pipe",		1,	0,	OPT_oom_pipe },
	{ "oom-pipe-ops",	1,	0,	OPT_oom_pipe_ops },
	{ "opcode",		1,	0,	OPT_opcode },
	{ "opcode-method",	1,	0,	OPT_opcode_method },
	{ "opcode-ops",		1,	0,	OPT_opcode_ops },
	{ "open",		1,	0,	OPT_open },
	{ "open-fd",		0,	0,	OPT_open_fd },
	{ "open-max",		1,	0,	OPT_open_max },
	{ "open-ops",		1,	0,	OPT_open_ops },
	{ "page-in",		0,	0,	OPT_page_in },
	{ "pagemove",		1,	0,	OPT_pagemove },
	{ "pagemove-bytes",	1,	0,	OPT_pagemove_bytes },
	{ "pagemove-mlock",	0,	0,	OPT_pagemove_mlock },
	{ "pagemove-ops",	1,	0,	OPT_pagemove_ops },
	{ "pageswap",		1,	0,	OPT_pageswap },
	{ "pageswap-ops",	1,	0,	OPT_pageswap_ops },
	{ "parallel",		1,	0,	OPT_all },
	{ "pathological",	0,	0,	OPT_pathological },
	{ "pause",		1,	0,	OPT_pause },
	{ "pci",		1,	0,	OPT_pci},
	{ "pci-dev",		1,	0,	OPT_pci_dev},
	{ "pci-ops",		1,	0,	OPT_pci_ops },
#if defined(STRESS_PERF_STATS) && 	\
    defined(HAVE_LINUX_PERF_EVENT_H)
	{ "perf",		0,	0,	OPT_perf_stats },
#endif
	{ "permute",		1,	0,	OPT_permute },
	{ "personality",	1,	0,	OPT_personality },
	{ "personality-ops",	1,	0,	OPT_personality_ops },
	{ "peterson",		1,	0,	OPT_peterson },
	{ "peterson-ops",	1,	0,	OPT_peterson_ops },
	{ "physpage",		1,	0,	OPT_physpage },
	{ "physpage-mtrr",	0,	0,	OPT_physpage_mtrr },
	{ "physpage-ops",	1,	0,	OPT_physpage_ops },
	{ "pidfd",		1,	0,	OPT_pidfd },
	{ "pidfd-ops",		1,	0,	OPT_pidfd_ops },
	{ "ping-sock",		1,	0,	OPT_ping_sock },
	{ "ping-sock-ops",	1,	0,	OPT_ping_sock_ops },
	{ "pipe",		1,	0,	OPT_pipe },
	{ "pipe-data-size",	1,	0,	OPT_pipe_data_size },
	{ "pipe-ops",		1,	0,	OPT_pipe_ops },
#if defined(F_SETPIPE_SZ)
	{ "pipe-size",		1,	0,	OPT_pipe_size },
#endif
	{ "pipe-vmsplice",	0,	0,	OPT_pipe_vmsplice },
	{ "pipeherd",		1,	0,	OPT_pipeherd },
	{ "pipeherd-ops",	1,	0,	OPT_pipeherd_ops },
	{ "pipeherd-yield", 	0,	0,	OPT_pipeherd_yield },
	{ "pkey",		1,	0,	OPT_pkey },
	{ "pkey-ops",		1,	0,	OPT_pkey_ops },
	{ "plugin",		1,	0,	OPT_plugin },
	{ "plugin-method",	1,	0,	OPT_plugin_method },
	{ "plugin-ops",		1,	0,	OPT_plugin_ops },
	{ "plugin-so",		1,	0,	OPT_plugin_so },
	{ "poll",		1,	0,	OPT_poll },
	{ "poll-ops",		1,	0,	OPT_poll_ops },
	{ "poll-fds",		1,	0,	OPT_poll_fds },
	{ "powmath",		1,	0,	OPT_powmath },
	{ "powmath-method",	1,	0,	OPT_powmath_method },
	{ "powmath-ops",	1,	0,	OPT_powmath_ops },
	{ "prctl",		1,	0,	OPT_prctl },
	{ "prctl-ops",		1,	0,	OPT_prctl_ops },
	{ "prefetch",		1,	0,	OPT_prefetch },
	{ "prefetch-l3-size",	1,	0,	OPT_prefetch_l3_size },
	{ "prefetch-method",	1,	0,	OPT_prefetch_method },
	{ "prefetch-ops",	1,	0,	OPT_prefetch_ops },
	{ "prime",		1,	0,	OPT_prime },
	{ "prime-method",	1,	0,	OPT_prime_method },
	{ "prime-ops",		1,	0,	OPT_prime_ops },
	{ "prime-progress",	0,	0,	OPT_prime_progress },
	{ "prime-start",	1,	0,	OPT_prime_start },
	{ "prio-inv",		1,	0,	OPT_prio_inv },
	{ "prio-inv-ops",	1,	0,	OPT_prio_inv_ops },
	{ "prio-inv-policy",	1,	0,	OPT_prio_inv_policy },
	{ "prio-inv-type",	1,	0,	OPT_prio_inv_type },
	{ "priv-instr",		1,	0,	OPT_priv_instr },
	{ "priv-instr-ops",	1,	0,	OPT_priv_instr_ops },
	{ "procfs",		1,	0,	OPT_procfs },
	{ "procfs-ops",		1,	0,	OPT_procfs_ops },
	{ "progress",		0,	0,	OPT_progress },
	{ "pseek",		1,	0,	OPT_pseek },
	{ "pseek-ops",		1,	0,	OPT_pseek_ops },
	{ "pseek-rand",		0,	0,	OPT_pseek_rand },
	{ "pseek-io-size",	1,	0,	OPT_pseek_io_size },
	{ "pthread",		1,	0,	OPT_pthread },
	{ "pthread-max",	1,	0,	OPT_pthread_max },
	{ "pthread-ops",	1,	0,	OPT_pthread_ops },
	{ "ptrace",		1,	0,	OPT_ptrace },
	{ "ptrace-ops",		1,	0,	OPT_ptrace_ops },
	{ "pty",		1,	0,	OPT_pty },
	{ "pty-max",		1,	0,	OPT_pty_max },
	{ "pty-ops",		1,	0,	OPT_pty_ops },
	{ "qsort",		1,	0,	OPT_qsort },
	{ "qsort-method",	1,	0,	OPT_qsort_method },
	{ "qsort-ops",		1,	0,	OPT_qsort_ops },
	{ "qsort-size",		1,	0,	OPT_qsort_size },
	{ "quiet",		0,	0,	OPT_quiet },
	{ "quota",		1,	0,	OPT_quota },
	{ "quota-ops",		1,	0,	OPT_quota_ops },
	{ "race-sched",		1,	0,	OPT_race_sched },
	{ "race-sched-ops",	1,	0,	OPT_race_sched_ops },
	{ "race-sched-method",	1,	0,	OPT_race_sched_method },
	{ "radixsort",		1,	0,	OPT_radixsort },
	{ "radixsort-method",	1,	0,	OPT_radixsort_method },
	{ "radixsort-ops",	1,	0,	OPT_radixsort_ops },
	{ "radixsort-size",	1,	0,	OPT_radixsort_size },
	{ "ramfs",		1,	0,	OPT_ramfs },
	{ "ramfs-fill",		0,	0,	OPT_ramfs_fill },
	{ "ramfs-ops",		1,	0,	OPT_ramfs_ops },
	{ "ramfs-size",		1,	0,	OPT_ramfs_size },
	{ "randlist",		1,	0,	OPT_randlist },
	{ "randlist-compact",	0,	0,	OPT_randlist_compact },
	{ "randlist-items", 	1,	0,	OPT_randlist_items },
	{ "randlist-ops",	1,	0,	OPT_randlist_ops },
	{ "randlist-size", 	1,	0,	OPT_randlist_size },
	{ "random",		1,	0,	OPT_random },
	{ "rapl",		0,	0,	OPT_rapl },
	{ "raplstat",		1,	0,	OPT_raplstat },
	{ "rawdev",		1,	0,	OPT_rawdev },
	{ "rawdev-method",	1,	0,	OPT_rawdev_method },
	{ "rawdev-ops",		1,	0,	OPT_rawdev_ops },
	{ "rawpkt",		1,	0,	OPT_rawpkt },
	{ "rawpkt-ops",		1,	0,	OPT_rawpkt_ops },
	{ "rawpkt-port",	1,	0,	OPT_rawpkt_port },
	{ "rawpkt-rxring",	1,	0,	OPT_rawpkt_rxring },
	{ "rawsock",		1,	0,	OPT_rawsock },
	{ "rawsock-ops",	1,	0,	OPT_rawsock_ops },
	{ "rawsock-port",	1,	0,	OPT_rawsock_port },
	{ "rawudp",		1,	0,	OPT_rawudp },
	{ "rawudp-if",		1,	0,	OPT_rawudp_if },
	{ "rawudp-ops",		1,	0,	OPT_rawudp_ops },
	{ "rawudp-port",	1,	0,	OPT_rawudp_port },
	{ "rdrand",		1,	0,	OPT_rdrand },
	{ "rdrand-ops",		1,	0,	OPT_rdrand_ops },
	{ "rdrand-seed",	0,	0,	OPT_rdrand_seed },
	{ "readahead",		1,	0,	OPT_readahead },
	{ "readahead-bytes",	1,	0,	OPT_readahead_bytes },
	{ "readahead-ops",	1,	0,	OPT_readahead_ops },
	{ "reboot",		1,	0,	OPT_reboot },
	{ "reboot-ops",		1,	0,	OPT_reboot_ops },
	{ "regs",		1,	0,	OPT_regs },
	{ "regs-ops",		1,	0,	OPT_regs_ops },
	{ "remap",		1,	0,	OPT_remap },
	{ "remap-mlock",	0,	0,	OPT_remap_mlock },
	{ "remap-ops",		1,	0,	OPT_remap_ops },
	{ "remap-pages",	1,	0,	OPT_remap_pages },
	{ "rename",		1,	0,	OPT_rename },
	{ "rename-ops",		1,	0,	OPT_rename_ops },
	{ "resched",		1,	0,	OPT_resched },
	{ "resched-ops",	1,	0,	OPT_resched_ops },
	{ "resources",		1,	0,	OPT_resources },
	{ "resources-mlock",	0,	0,	OPT_resources_mlock },
	{ "resources-ops",	1,	0,	OPT_resources_ops },
	{ "revio",		1,	0,	OPT_revio },
	{ "revio-bytes",	1,	0,	OPT_revio_bytes },
	{ "revio-ops",		1,	0,	OPT_revio_ops },
	{ "revio-opts",		1,	0,	OPT_revio_opts },
	{ "ring-pipe",		1,	0,	OPT_ring_pipe },
	{ "ring-pipe-num",	1,	0,	OPT_ring_pipe_num },
	{ "ring-pipe-ops",	1,	0,	OPT_ring_pipe_ops },
	{ "ring-pipe-size",	1,	0,	OPT_ring_pipe_size },
	{ "ring-pipe-splice",	0,	0,	OPT_ring_pipe_splice },
	{ "rlimit",		1,	0,	OPT_rlimit },
	{ "rlimit-ops",		1,	0,	OPT_rlimit_ops },
	{ "rmap",		1,	0,	OPT_rmap },
	{ "rmap-ops",		1,	0,	OPT_rmap_ops },
	{ "rotate",		1,	0,	OPT_rotate },
	{ "rotate-method",	1,	0,	OPT_rotate_method },
	{ "rotate-ops",		1,	0,	OPT_rotate_ops },
	{ "rseq",		1,	0,	OPT_rseq },
	{ "rseq-ops",		1,	0,	OPT_rseq_ops },
	{ "rtc",		1,	0,	OPT_rtc },
	{ "rtc-ops",		1,	0,	OPT_rtc_ops },
	{ "sched",		1,	0,	OPT_sched },
	{ "sched-deadline",	1,	0,	OPT_sched_deadline },
	{ "sched-period",	1,	0,	OPT_sched_period },
	{ "sched-prio",		1,	0,	OPT_sched_prio },
	{ "sched-reclaim",	0,	0,      OPT_sched_reclaim },
	{ "sched-runtime",	1,	0,	OPT_sched_runtime },
	{ "schedmix",		1,	0,	OPT_schedmix },
	{ "schedmix-ops",	1,	0,	OPT_schedmix_ops },
	{ "schedmix-procs",	1,	0,	OPT_schedmix_procs },
	{ "schedpolicy",	1,	0,	OPT_schedpolicy },
	{ "schedpolicy-ops",	1,	0,	OPT_schedpolicy_ops },
	{ "schedpolicy-rand",	0,	0,	OPT_schedpolicy_rand },
	{ "sctp",		1,	0,	OPT_sctp },
	{ "sctp-domain",	1,	0,	OPT_sctp_domain },
	{ "sctp-if",		1,	0,	OPT_sctp_if },
	{ "sctp-ops",		1,	0,	OPT_sctp_ops },
	{ "sctp-port",		1,	0,	OPT_sctp_port },
	{ "sctp-sched",		1,	0,	OPT_sctp_sched },
	{ "seal",		1,	0,	OPT_seal },
	{ "seal-ops",		1,	0,	OPT_seal_ops },
	{ "seccomp",		1,	0,	OPT_seccomp },
	{ "seccomp-ops",	1,	0,	OPT_seccomp_ops },
	{ "secretmem",		1,	0,	OPT_secretmem },
	{ "secretmem-ops",	1,	0,	OPT_secretmem_ops },
	{ "seed",		1,	0,	OPT_seed },
	{ "seek",		1,	0,	OPT_seek },
	{ "seek-ops",		1,	0,	OPT_seek_ops },
	{ "seek-punch",		0,	0,	OPT_seek_punch  },
	{ "seek-size",		1,	0,	OPT_seek_size },
	{ "sem",		1,	0,	OPT_sem },
	{ "sem-ops",		1,	0,	OPT_sem_ops },
	{ "sem-procs",		1,	0,	OPT_sem_procs },
	{ "sem-shared",		0,	0,	OPT_sem_shared },
	{ "sem-sysv",		1,	0,	OPT_sem_sysv },
	{ "sem-sysv-ops",	1,	0,	OPT_sem_sysv_ops },
	{ "sem-sysv-procs",	1,	0,	OPT_sem_sysv_procs },
	{ "sem-sysv-setall",	0,	0,	OPT_sem_sysv_setall },
	{ "sendfile",		1,	0,	OPT_sendfile },
	{ "sendfile-ops",	1,	0,	OPT_sendfile_ops },
	{ "sendfile-size",	1,	0,	OPT_sendfile_size },
	{ "sequential",		1,	0,	OPT_sequential },
	{ "session",		1,	0,	OPT_session },
	{ "session-ops",	1,	0,	OPT_session_ops },
	{ "set",		1,	0,	OPT_set },
	{ "set-ops",		1,	0,	OPT_set_ops },
	{ "settings",		0,	0,	OPT_settings },
	{ "shellsort",		1,	0,	OPT_shellsort },
	{ "shellsort-ops",	1,	0,	OPT_shellsort_ops },
	{ "shellsort-size",	1,	0,	OPT_shellsort_size },
	{ "shm",		1,	0,	OPT_shm },
	{ "shm-bytes",		1,	0,	OPT_shm_bytes },
	{ "shm-mlock",		0,	0,	OPT_shm_mlock },
	{ "shm-objs",		1,	0,	OPT_shm_objs },
	{ "shm-ops",		1,	0,	OPT_shm_ops },
	{ "shm-sysv",		1,	0,	OPT_shm_sysv },
	{ "shm-sysv-bytes",	1,	0,	OPT_shm_sysv_bytes },
	{ "shm-sysv-mlock",	0,	0,	OPT_shm_sysv_mlock },
	{ "shm-sysv-ops",	1,	0,	OPT_shm_sysv_ops },
	{ "shm-sysv-segs",	1,	0,	OPT_shm_sysv_segs },
	{ "sigabrt",		1,	0,	OPT_sigabrt },
	{ "sigabrt-ops",	1,	0,	OPT_sigabrt_ops },
	{ "sigbus",		1,	0,	OPT_sigbus },
	{ "sigbus-ops",		1,	0,	OPT_sigbus_ops },
	{ "sigchld",		1,	0,	OPT_sigchld },
	{ "sigchld-ops",	1,	0,	OPT_sigchld_ops },
	{ "sigfd",		1,	0,	OPT_sigfd },
	{ "sigfd-ops",		1,	0,	OPT_sigfd_ops },
	{ "sighup",		1,	0,	OPT_sighup },
	{ "sighup-ops",		1,	0,	OPT_sighup_ops },
	{ "sigill",		1,	0,	OPT_sigill },
	{ "sigill-ops",		1,	0,	OPT_sigill_ops },
	{ "sigio",		1,	0,	OPT_sigio },
	{ "sigio-ops",		1,	0,	OPT_sigio_ops },
	{ "sigfpe",		1,	0,	OPT_sigfpe },
	{ "sigfpe-ops",		1,	0,	OPT_sigfpe_ops },
	{ "signal",		1,	0,	OPT_signal },
	{ "signal-ops",		1,	0,	OPT_signal_ops },
	{ "signest",		1,	0,	OPT_signest },
	{ "signest-ops",	1,	0,	OPT_signest_ops },
	{ "sigpending",		1,	0,	OPT_sigpending},
	{ "sigpending-ops",	1,	0,	OPT_sigpending_ops },
	{ "sigpipe",		1,	0,	OPT_sigpipe },
	{ "sigpipe-ops",	1,	0,	OPT_sigpipe_ops },
	{ "sigq",		1,	0,	OPT_sigq },
	{ "sigq-ops",		1,	0,	OPT_sigq_ops },
	{ "sigrt",		1,	0,	OPT_sigrt },
	{ "sigrt-ops",		1,	0,	OPT_sigrt_ops },
	{ "sigsegv",		1,	0,	OPT_sigsegv },
	{ "sigsegv-ops",	1,	0,	OPT_sigsegv_ops },
	{ "sigsuspend",		1,	0,	OPT_sigsuspend },
	{ "sigsuspend-ops",	1,	0,	OPT_sigsuspend_ops },
	{ "sigtrap",		1,	0,	OPT_sigtrap },
	{ "sigtrap-ops",	1,	0,	OPT_sigtrap_ops},
	{ "sigurg",		1,	0,	OPT_sigurg },
	{ "sigurg-ops",		1,	0,	OPT_sigurg_ops },
	{ "sigvtalrm",		1,	0,	OPT_sigvtalrm },
	{ "sigvtalrm-ops",	1,	0,	OPT_sigvtalrm_ops },
	{ "sigxcpu",		1,	0,	OPT_sigxcpu },
	{ "sigxcpu-ops",	1,	0,	OPT_sigxcpu_ops },
	{ "sigxfsz",		1,	0,	OPT_sigxfsz },
	{ "sigxfsz-ops",	1,	0,	OPT_sigxfsz_ops },
	{ "skiplist",		1,	0,	OPT_skiplist },
	{ "skiplist-ops",	1,	0,	OPT_skiplist_ops },
	{ "skiplist-size",	1,	0,	OPT_skiplist_size },
	{ "skip-silent",	0,	0,	OPT_skip_silent },
	{ "sleep",		1,	0,	OPT_sleep },
	{ "sleep-max",		1,	0,	OPT_sleep_max },
	{ "sleep-ops",		1,	0,	OPT_sleep_ops },
	{ "smart",		0,	0,	OPT_smart },
	{ "smi",		1,	0,	OPT_smi },
	{ "smi-ops",		1,	0,	OPT_smi_ops },
	{ "sn",			0,	0,	OPT_sn },
	{ "sock",		1,	0,	OPT_sock },
	{ "sock-domain",	1,	0,	OPT_sock_domain },
	{ "sock-if",		1,	0,	OPT_sock_if },
	{ "sock-msgs",		1,	0,	OPT_sock_msgs },
	{ "sock-nodelay",	0,	0,	OPT_sock_nodelay },
	{ "sock-ops",		1,	0,	OPT_sock_ops },
	{ "sock-opts",		1,	0,	OPT_sock_opts },
	{ "sock-port",		1,	0,	OPT_sock_port },
	{ "sock-protocol",	1,	0,	OPT_sock_protocol },
	{ "sock-type",		1,	0,	OPT_sock_type },
	{ "sock-zerocopy", 	0,	0,	OPT_sock_zerocopy },
	{ "sockabuse",		1,	0,	OPT_sockabuse },
	{ "sockabuse-ops",	1,	0,	OPT_sockabuse_ops },
	{ "sockabuse-port",	1,	0,	OPT_sockabuse_port },
	{ "sockdiag",		1,	0,	OPT_sockdiag },
	{ "sockdiag-ops",	1,	0,	OPT_sockdiag_ops },
	{ "sockfd",		1,	0,	OPT_sockfd },
	{ "sockfd-ops",		1,	0,	OPT_sockfd_ops },
	{ "sockfd-port",	1,	0,	OPT_sockfd_port },
	{ "sockfd-reuse",	0,	0,	OPT_sockfd_reuse },
	{ "sockmany",		1,	0,	OPT_sockmany },
	{ "sockmany-if",	1,	0,	OPT_sockmany_if },
	{ "sockmany-ops",	1,	0,	OPT_sockmany_ops },
	{ "sockmany-port",	1,	0,	OPT_sockmany_port },
	{ "sockpair",		1,	0,	OPT_sockpair },
	{ "sockpair-ops",	1,	0,	OPT_sockpair_ops },
	{ "softlockup",		1,	0,	OPT_softlockup },
	{ "softlockup-ops",	1,	0,	OPT_softlockup_ops },
	{ "sparsematrix",	1,	0,	OPT_sparsematrix},
	{ "sparsematrix-items",	1,	0,	OPT_sparsematrix_items },
	{ "sparsematrix-method",1,	0,	OPT_sparsematrix_method },
	{ "sparsematrix-ops",	1,	0,	OPT_sparsematrix_ops },
	{ "sparsematrix-size",	1,	0,	OPT_sparsematrix_size },
	{ "spawn",		1,	0,	OPT_spawn },
	{ "spawn-ops",		1,	0,	OPT_spawn_ops },
	{ "spinmem",		1,	0,	OPT_spinmem },
	{ "spinmem-ops",	1,	0,	OPT_spinmem_ops },
	{ "spinmem-method",	1,	0,	OPT_spinmem_method },
	{ "splice",		1,	0,	OPT_splice },
	{ "splice-bytes",	1,	0,	OPT_splice_bytes },
	{ "splice-ops",		1,	0,	OPT_splice_ops },
	{ "stack",		1,	0,	OPT_stack},
	{ "stack-fill",		0,	0,	OPT_stack_fill },
	{ "stack-mlock",	0,	0,	OPT_stack_mlock },
	{ "stack-ops",		1,	0,	OPT_stack_ops },
	{ "stack-pageout",	0,	0,	OPT_stack_pageout },
	{ "stack-unmap",	0,	0,	OPT_stack_unmap },
	{ "stackmmap",		1,	0,	OPT_stackmmap },
	{ "stackmmap-ops",	1,	0,	OPT_stackmmap_ops },
	{ "statmount",		1,	0,	OPT_statmount },
	{ "statmount-ops",	1,	0,	OPT_statmount_ops },
	{ "status",		1,	0,	OPT_status },
	{ "stderr",		0,	0,	OPT_stderr },
	{ "stdout",		0,	0,	OPT_stdout },
	{ "str",		1,	0,	OPT_str },
	{ "str-method",		1,	0,	OPT_str_method },
	{ "str-ops",		1,	0,	OPT_str_ops },
	{ "stressors",		0,	0,	OPT_stressors },
	{ "stream",		1,	0,	OPT_stream },
	{ "stream-index",	1,	0,	OPT_stream_index },
	{ "stream-l3-size",	1,	0,	OPT_stream_l3_size },
	{ "stream-madvise",	1,	0,	OPT_stream_madvise },
	{ "stream-mlock",	0,	0,	OPT_stream_mlock },
	{ "stream-ops",		1,	0,	OPT_stream_ops },
	{ "swap",		1,	0,	OPT_swap },
	{ "swap-ops",		1,	0,	OPT_swap_ops },
	{ "swap-self",		0,	0,	OPT_swap_self },
	{ "switch",		1,	0,	OPT_switch },
	{ "switch-freq",	1,	0,	OPT_switch_freq },
	{ "switch-method",	1,	0,	OPT_switch_method },
	{ "switch-ops",		1,	0,	OPT_switch_ops },
	{ "symlink",		1,	0,	OPT_symlink },
	{ "symlink-ops",	1,	0,	OPT_symlink_ops },
	{ "symlink-sync",	0,	0,	OPT_symlink_sync },
	{ "sync-file",		1,	0,	OPT_sync_file },
	{ "sync-file-bytes", 	1,	0,	OPT_sync_file_bytes },
	{ "sync-file-ops", 	1,	0,	OPT_sync_file_ops },
	{ "sync-start",		0,	0,	OPT_sync_start },
	{ "syncload",		1,	0,	OPT_syncload },
	{ "syncload-msbusy",	1,	0,	OPT_syncload_msbusy },
	{ "syncload-mssleep",	1,	0,	OPT_syncload_mssleep },
	{ "syncload-ops",	1,	0,	OPT_syncload_ops },
	{ "sysbadaddr",		1,	0,	OPT_sysbadaddr },
	{ "sysbadaddr-ops",	1,	0,	OPT_sysbadaddr_ops },
	{ "syscall",		1,	0,	OPT_syscall },
	{ "syscall-method",	1,	0,	OPT_syscall_method },
	{ "syscall-ops",	1,	0,	OPT_syscall_ops },
	{ "syscall-top",	1,	0,	OPT_syscall_top },
	{ "sysfs",		1,	0,	OPT_sysfs },
	{ "sysfs-ops",		1,	0,	OPT_sysfs_ops },
	{ "sysinfo",		1,	0,	OPT_sysinfo },
	{ "sysinfo-ops",	1,	0,	OPT_sysinfo_ops },
	{ "sysinval",		1,	0,	OPT_sysinval },
	{ "sysinval-ops",	1,	0,	OPT_sysinval_ops },
#if defined(HAVE_SYSLOG_H)
	{ "syslog",		0,	0,	OPT_syslog },
#endif
	{ "taskset",		1,	0,	OPT_taskset },
	{ "tee",		1,	0,	OPT_tee },
	{ "tee-ops",		1,	0,	OPT_tee_ops },
	{ "temp-path",		1,	0,	OPT_temp_path },
	{ "timeout",		1,	0,	OPT_timeout },
	{ "timer",		1,	0,	OPT_timer },
	{ "timer-freq",		1,	0,	OPT_timer_freq },
	{ "timer-ops",		1,	0,	OPT_timer_ops },
	{ "timer-rand", 	0,	0,	OPT_timer_rand },
	{ "timerfd",		1,	0,	OPT_timerfd },
	{ "timerfd-fds",	1,	0,	OPT_timerfd_fds },
	{ "timerfd-freq",	1,	0,	OPT_timerfd_freq },
	{ "timerfd-ops",	1,	0,	OPT_timerfd_ops },
	{ "timerfd-rand",	0,	0,	OPT_timerfd_rand },
	{ "timer-slack"	,	1,	0,	OPT_timer_slack },
	{ "time-warp",		1,	0,	OPT_time_warp },
	{ "time-warp-ops",	1,	0,	OPT_time_warp_ops },
	{ "tlb-shootdown",	1,	0,	OPT_tlb_shootdown },
	{ "tlb-shootdown-ops",	1,	0,	OPT_tlb_shootdown_ops },
	{ "tmpfs",		1,	0,	OPT_tmpfs },
	{ "tmpfs-mmap-async",	0,	0,	OPT_tmpfs_mmap_async },
	{ "tmpfs-mmap-file",	0,	0,	OPT_tmpfs_mmap_file },
	{ "tmpfs-ops",		1,	0,	OPT_tmpfs_ops },
	{ "touch",		1,	0,	OPT_touch },
	{ "touch-method",	1,	0,	OPT_touch_method },
	{ "touch-ops",		1,	0,	OPT_touch_ops },
	{ "touch-opts",		1,	0,	OPT_touch_opts },
	{ "tree",		1,	0,	OPT_tree },
	{ "tree-method",	1,	0,	OPT_tree_method },
	{ "tree-ops",		1,	0,	OPT_tree_ops },
	{ "tree-size",		1,	0,	OPT_tree_size },
	{ "trig",		1,	0,	OPT_trig },
	{ "trig-method",	1,	0,	OPT_trig_method },
	{ "trig-ops",		1,	0,	OPT_trig_ops },
	{ "tsc",		1,	0,	OPT_tsc },
	{ "tsc-lfence",		0,	0,	OPT_tsc_lfence },
	{ "tsc-ops",		1,	0,	OPT_tsc_ops },
	{ "tsc-rdtscp",		0,	0,	OPT_tsc_rdtscp },
	{ "tsearch",		1,	0,	OPT_tsearch },
	{ "tsearch-ops",	1,	0,	OPT_tsearch_ops },
	{ "tsearch-size",	1,	0,	OPT_tsearch_size },
	{ "thermalstat",	1,	0,	OPT_thermalstat },
	{ "thrash",		0,	0,	OPT_thrash },
	{ "times",		0,	0,	OPT_times },
	{ "timestamp",		0,	0,	OPT_timestamp },
	{ "tz",			0,	0,	OPT_thermal_zones },
	{ "tun",		1,	0,	OPT_tun},
	{ "tun-tap",		0,	0,	OPT_tun_tap },
	{ "tun-ops",		1,	0,	OPT_tun_ops },
	{ "udp",		1,	0,	OPT_udp },
	{ "udp-domain",		1,	0,	OPT_udp_domain },
	{ "udp-gro",		0,	0,	OPT_udp_gro },
	{ "udp-if",		1,	0,	OPT_udp_if },
	{ "udp-lite",		0,	0,	OPT_udp_lite },
	{ "udp-ops",		1,	0,	OPT_udp_ops },
	{ "udp-port",		1,	0,	OPT_udp_port },
	{ "udp-flood",		1,	0,	OPT_udp_flood },
	{ "udp-flood-domain",	1,	0,	OPT_udp_flood_domain },
	{ "udp-flood-if",	1,	0,	OPT_udp_flood_if },
	{ "udp-flood-ops",	1,	0,	OPT_udp_flood_ops },
	{ "umount",		1,	0,	OPT_umount },
	{ "umount-ops",		1,	0,	OPT_umount_ops },
	{ "unlink",		1,	0,	OPT_unlink },
	{ "unlink-ops",		1,	0,	OPT_unlink_ops },
	{ "unshare",		1,	0,	OPT_unshare },
	{ "unshare-ops",	1,	0,	OPT_unshare_ops },
	{ "uprobe",		1,	0,	OPT_uprobe },
	{ "uprobe-ops",		1,	0,	OPT_uprobe_ops },
	{ "urandom",		1,	0,	OPT_urandom },
	{ "urandom-ops",	1,	0,	OPT_urandom_ops },
	{ "userfaultfd",	1,	0,	OPT_userfaultfd },
	{ "userfaultfd-bytes",	1,	0,	OPT_userfaultfd_bytes },
	{ "userfaultfd-ops",	1,	0,	OPT_userfaultfd_ops },
	{ "usersyscall",	1,	0,	OPT_usersyscall },
	{ "usersyscall-ops",	1,	0,	OPT_usersyscall_ops },
	{ "utime",		1,	0,	OPT_utime },
	{ "utime-fsync",	0,	0,	OPT_utime_fsync },
	{ "utime-ops",		1,	0,	OPT_utime_ops },
	{ "vdso",		1,	0,	OPT_vdso },
	{ "vdso-func",		1,	0,	OPT_vdso_func },
	{ "vdso-ops",		1,	0,	OPT_vdso_ops },
	{ "vecfp",		1,	0,	OPT_vecfp },
	{ "vecfp-method",	1,	0,	OPT_vecfp_method },
	{ "vecfp-ops",		1,	0,	OPT_vecfp_ops },
	{ "vecmath",		1,	0,	OPT_vecmath },
	{ "vecmath-ops",	1,	0,	OPT_vecmath_ops },
	{ "vecshuf",		1,	0,	OPT_vecshuf },
	{ "vecshuf-method",	1,	0,	OPT_vecshuf_method },
	{ "vecshuf-ops",	1,	0,	OPT_vecshuf_ops },
	{ "vecwide",		1,	0,	OPT_vecwide},
	{ "vecwide-ops",	1,	0,	OPT_vecwide_ops },
	{ "verbose",		0,	0,	OPT_verbose },
	{ "verify",		0,	0,	OPT_verify },
	{ "verifiable",		0,	0,	OPT_verifiable },
	{ "verity",		1,	0,	OPT_verity },
	{ "verity-ops",		1,	0,	OPT_verity_ops },
	{ "version",		0,	0,	OPT_version },
	{ "vfork",		1,	0,	OPT_vfork },
	{ "vfork-max",		1,	0,	OPT_vfork_max },
	{ "vfork-ops",		1,	0,	OPT_vfork_ops },
	{ "vforkmany",		1,	0,	OPT_vforkmany },
	{ "vforkmany-ops", 	1,	0,	OPT_vforkmany_ops },
	{ "vforkmany-vm", 	0,	0,	OPT_vforkmany_vm },
	{ "vforkmany-vm-bytes", 1,	0,	OPT_vforkmany_vm_bytes },
	{ "vm",			1,	0,	OPT_vm },
	{ "vm-bytes",		1,	0,	OPT_vm_bytes },
	{ "vm-hang",		1,	0,	OPT_vm_hang },
	{ "vm-keep",		0,	0,	OPT_vm_keep },
#if defined(MAP_LOCKED)
	{ "vm-locked",		0,	0,	OPT_vm_locked },
#endif
	{ "vm-madvise",		1,	0,	OPT_vm_madvise },
	{ "vm-method",		1,	0,	OPT_vm_method },
	{ "vm-ops",		1,	0,	OPT_vm_ops },
#if defined(MAP_POPULATE)
	{ "vm-populate",	0,	0,	OPT_vm_populate },
#endif
	{ "vm-addr",		1,	0,	OPT_vm_addr },
	{ "vm-addr-method",	1,	0,	OPT_vm_addr_method },
	{ "vm-addr-mlock",	0,	0,	OPT_vm_addr_mlock },
	{ "vm-addr-ops",	1,	0,	OPT_vm_addr_ops },
	{ "vm-rw",		1,	0,	OPT_vm_rw },
	{ "vm-rw-bytes",	1,	0,	OPT_vm_rw_bytes },
	{ "vm-rw-ops",		1,	0,	OPT_vm_rw_ops },
	{ "vm-segv",		1,	0,	OPT_vm_segv },
	{ "vm-segv-ops",	1,	0,	OPT_vm_segv_ops },
	{ "vm-splice",		1,	0,	OPT_vm_splice },
	{ "vm-splice-bytes",	1,	0,	OPT_vm_splice_bytes },
	{ "vm-splice-ops",	1,	0,	OPT_vm_splice_ops },
	{ "vma",		1,	0,	OPT_vma },
	{ "vma-ops",		1,	0,	OPT_vma_ops },
	{ "vmstat",		1,	0,	OPT_vmstat },
	{ "vnni",		1,	0,	OPT_vnni },
	{ "vnni-intrinsic",	0,	0,	OPT_vnni_intrinsic },
	{ "vnni-method",	1,	0,	OPT_vnni_method },
	{ "vnni-ops",		1,	0,	OPT_vnni_ops },
	{ "wait",		1,	0,	OPT_wait },
	{ "wait-ops",		1,	0,	OPT_wait_ops },
	{ "waitcpu",		1,	0,	OPT_waitcpu },
	{ "waitcpu-ops",	1,	0,	OPT_waitcpu_ops },
	{ "watchdog",		1,	0,	OPT_watchdog },
	{ "watchdog-ops",	1,	0,	OPT_watchdog_ops },
	{ "with",		1,	0,	OPT_with },
	{ "wcs",		1,	0,	OPT_wcs},
	{ "wcs-method",		1,	0,	OPT_wcs_method },
	{ "wcs-ops",		1,	0,	OPT_wcs_ops },
	{ "workload",		1,	0,	OPT_workload },
	{ "workload-dist",	1,	0,	OPT_workload_dist },
	{ "workload-load",	1,	0,	OPT_workload_load },
	{ "workload-method",	1,	0,	OPT_workload_method },
	{ "workload-ops",	1,	0,	OPT_workload_ops },
	{ "workload-quanta-us",	1,	0,	OPT_workload_quanta_us },
	{ "workload-sched",	1,	0,	OPT_workload_sched },
	{ "workload-slice-us",	1,	0,	OPT_workload_slice_us },
	{ "workload-threads",	1,	0,	OPT_workload_threads },
	{ "x86cpuid",		1,	0,	OPT_x86cpuid },
	{ "x86cpuid-ops",	1,	0,	OPT_x86cpuid_ops },
	{ "x86syscall",		1,	0,	OPT_x86syscall },
	{ "x86syscall-func",	1,	0,	OPT_x86syscall_func },
	{ "x86syscall-ops",	1,	0,	OPT_x86syscall_ops },
	{ "xattr",		1,	0,	OPT_xattr },
	{ "xattr-ops",		1,	0,	OPT_xattr_ops },
	{ "yaml",		1,	0,	OPT_yaml },
	{ "yield",		1,	0,	OPT_yield },
	{ "yield-ops",		1,	0,	OPT_yield_ops },
	{ "yield-procs",	1,	0,	OPT_yield_procs },
	{ "yield-sched",	1,	0,	OPT_yield_sched },
	{ "zero",		1,	0,	OPT_zero },
	{ "zero-ops",		1,	0,	OPT_zero_ops },
	{ "zero-read",		0,	0,	OPT_zero_read },
	{ "zlib",		1,	0,	OPT_zlib },
	{ "zlib-level",		1,	0,	OPT_zlib_level },
	{ "zlib-method",	1,	0,	OPT_zlib_method },
	{ "zlib-mem-level",	1,	0,	OPT_zlib_mem_level },
	{ "zlib-ops",		1,	0,	OPT_zlib_ops },
	{ "zlib-strategy",	1,	0,	OPT_zlib_strategy, },
	{ "zlib-stream-bytes",	1,	0,	OPT_zlib_stream_bytes, },
	{ "zlib-window-bits",	1,	0,	OPT_zlib_window_bits },
	{ "zombie",		1,	0,	OPT_zombie },
	{ "zombie-max",		1,	0,	OPT_zombie_max },
	{ "zombie-ops",		1,	0,	OPT_zombie_ops },
	{ NULL,			0,	0,	0 }
};

