/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.CopulaHeadFinder;
import edu.stanford.nlp.trees.DateTreeTransformer;
import edu.stanford.nlp.trees.DependencyTreeTransformer;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.QPTreeTransformer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CoordinationTransformer
implements TreeTransformer {
    private static final boolean VERBOSE = System.getProperty("CoordinationTransformer", null) != null;
    private final TreeTransformer tn = new DependencyTreeTransformer();
    private final TreeTransformer dates = new DateTreeTransformer();
    private final TreeTransformer qp;
    private final HeadFinder headFinder;
    private final boolean performMWETransformation;
    private static TregexPattern rearrangeNowThatTregex = TregexPattern.compile("ADVP=advp <1 (RB < /^(?i:now)$/) <2 (SBAR=sbar <1 (IN < /^(?i:that)$/))");
    private static TsurgeonPattern rearrangeNowThatTsurgeon = Tsurgeon.parseOperation("[relabel advp SBAR] [excise sbar sbar]");
    private static TregexPattern changeSbarToPPTregex = TregexPattern.compile("NP < (NP $++ (SBAR=sbar < (IN < /^(?i:after|before|until|since|during)$/ $++ S)))");
    private static TsurgeonPattern changeSbarToPPTsurgeon = Tsurgeon.parseOperation("relabel sbar PP");
    private static TregexPattern findFlatConjpTregex = TregexPattern.compile("/^(S|PP|VP)/ < (/^(S(?!YM)|PP|VP)/ $++ (CC=start $+ (RB|ADVP $+ /^(S(?!YM)|PP|VP)/) [ (< and $+ (RB=end < yet)) |   (< and $+ (RB=end < so)) |   (< and $+ (ADVP=end < (RB|IN < so))) ] ))");
    private static TsurgeonPattern addConjpTsurgeon = Tsurgeon.parseOperation("createSubtree CONJP start end");
    private static TregexPattern[] moveRBTregex = new TregexPattern[]{TregexPattern.compile("/^S|PP|VP|NP/ < (/^(S|PP|VP|NP)/ $++ (/^(,|CC|CONJP)$/ [ $+ (RB=adv [ < not | < then ]) | $+ (ADVP=adv <: RB) ])) : (=adv $+ /^(S(?!YM)|PP|VP|NP)/=dest) "), TregexPattern.compile("/^ADVP/ < (/^ADVP/ $++ (/^(,|CC|CONJP)$/ [$+ (RB=adv [ < not | < then ]) | $+ (ADVP=adv <: RB)])) : (=adv $+ /^NP-ADV|ADVP|PP/=dest)"), TregexPattern.compile("/^FRAG/ < (ADVP|RB=adv $+ VP=dest)")};
    private static TsurgeonPattern moveRBTsurgeon = Tsurgeon.parseOperation("move adv >0 dest");
    private static TregexPattern flattenSQTregex = TregexPattern.compile("SBARQ < ((WHNP=what < WP) $+ (SQ=sq < (/^VB/=verb < " + EnglishPatterns.copularWordRegex + ") " + " !< (/^VB/ < !" + EnglishPatterns.copularWordRegex + ") " + " !< (/^V/ < /^VB/ < !" + EnglishPatterns.copularWordRegex + ") " + " !< (PP $- =verb) " + " !<, (/^VB/ < " + EnglishPatterns.copularWordRegex + " $+ (NP < (EX < there)))))");
    private static TsurgeonPattern flattenSQTsurgeon = Tsurgeon.parseOperation("excise sq sq");
    private static TregexPattern removeXOverXTregex = TregexPattern.compile("__=repeat <: (~repeat < __)");
    private static TsurgeonPattern removeXOverXTsurgeon = Tsurgeon.parseOperation("excise repeat repeat");
    private static final TregexPattern ucpRenameTregex = TregexPattern.compile("/^UCP/=ucp [ <, /^JJ|ADJP/=adjp | ( <1 DT <2 /^JJ|ADJP/=adjp ) | <- (ADJP=adjp < (JJR < /^(?i:younger|older)$/)) | <, /^N/=np | ( <1 DT <2 /^N/=np ) |  <, /^ADVP/=advp ]");
    private static final TsurgeonPattern ucpRenameTsurgeon = Tsurgeon.parseOperation("[if exists adjp relabel ucp /^UCP(.*)$/ADJP$1/] [if exists np relabel ucp /^UCP(.*)$/NP$1/] [if exists advp relabel ucp /^UCP(.*)$/ADVP/]");
    private static TregexPattern[] MWE_PATTERNS = new TregexPattern[]{TregexPattern.compile("@CONJP <1 (RB=node1 < /^(?i)as$/) <2 (RB=node2 < /^(?i)well$/) <- (IN=node3 < /^(?i)as$/)"), TregexPattern.compile("@ADVP|CONJP <1 (RB=node1 < /^(?i)as$/) <- (IN|RB=node2 < /^(?i)well$/)"), TregexPattern.compile("@PP < ((JJ=node1 < /^(?i)such$/) $+ (IN=node2 < /^(?i)as$/))"), TregexPattern.compile("@PP < ((JJ|IN=node1 < /^(?i)due$/) $+ (IN|TO=node2 < /^(?i)to$/))"), TregexPattern.compile("@PP|CONJP < ((IN|RB=node1 < /^(?i)(because|instead)$/) $+ (IN=node2 < of))"), TregexPattern.compile("@ADVP|SBAR < ((IN|RB=node1 < /^(?i)in$/) $+ (NN=node2 < /^(?i)case$/))"), TregexPattern.compile("@ADVP|PP < ((IN|RB=node1 < /^(?i)of$/) $+ (NN|RB=node2 < /^(?i)course$/))"), TregexPattern.compile("@SBAR|PP < ((IN|RB=node1 < /^(?i)in$/) $+ (NN|NP|RB=node2 [< /^(?i)order$/ | <: (NN < /^(?i)order$/)]))"), TregexPattern.compile("@PP|CONJP|SBAR < ((IN|RB=node1 < /^(?i)rather$/) $+ (IN=node2 < /^(?i)than$/))"), TregexPattern.compile("@CONJP < ((IN|RB=node1 < /^(?i)not$/) $+ (TO=node2 < /^(?i)to$/ $+ (VB|RB=node3 < /^(?i)mention$/)))"), TregexPattern.compile("@PP|SBAR < ((JJ|IN|RB=node1 < /^(?i)so$/) $+ (IN|TO=node2 < /^(?i)that$/))"), TregexPattern.compile("@SBAR < ((IN|RB=node1 < /^(?i)as$/) $+ (IN=node2 < /^(?i)if$/))"), TregexPattern.compile("@PP < ((JJ|RB=node1 < /^(?i)prior$/) $+ (TO|IN=node2 < /^(?i)to$/))"), TregexPattern.compile("@PP < ((IN=node1 < /^(?i)as$/) $+ (TO|IN=node2 < /^(?i)to$/))"), TregexPattern.compile("@ADVP < ((RB|NN=node1 < /^(?i)kind$/) $+ (IN|RB=node2 < /^(?i)of$/))"), TregexPattern.compile("@SBAR < ((IN|RB=node1 < /^(?i)whether$/) $+ (CC=node2 < /^(?i)or$/ $+ (RB=node3 < /^(?i)not$/)))"), TregexPattern.compile("@CONJP < ((IN=node1 < /^(?i)as$/) $+ (VBN=node2 < /^(?i)opposed$/ $+ (TO|IN=node3 < /^(?i)to$/)))"), TregexPattern.compile("@ADVP|CONJP < ((VB|RB|VBD=node1 < /^(?i)let$/) $+ (RB|JJ=node2 < /^(?i)alone$/))"), TregexPattern.compile("@ADVP|PP < ((IN|RB=node1 < /^(?i)in$/) $+ (IN|NP|PP|RB|ADVP=node2 [< /^(?i)between$/ | <: (IN|RB < /^(?i)between$/)]))"), TregexPattern.compile("@ADVP|QP|ADJP < ((DT|RB=node1 < /^(?i)all$/) $+ (CC|RB|IN=node2 < /^(?i)but$/))"), TregexPattern.compile("@ADVP|INTJ < ((NN|DT|RB=node1 < /^(?i)that$/) $+ (VBZ|RB=node2 < /^(?i)is$/))"), TregexPattern.compile("@WHADVP < ((WRB=node1 < /^(?i:how)$/) $+ (VB=node2 < /^(?i)come$/))"), TregexPattern.compile("@VP < ((VBD=node1 < had|'d) $+ (@PRT|ADVP=node2 <: (RBR < /^(?i)better$/)))"), TregexPattern.compile("@QP|XS < ((JJR|RBR|IN=node1 < /^(?i)(more|less)$/) $+ (IN=node2 < /^(?i)than$/))"), TregexPattern.compile("@QP < ((JJR|RBR|IN=node1 < /^(?i)up$/) $+ (IN|TO=node2 < /^(?i)to$/))"), TregexPattern.compile("@S|SQ|VP|ADVP|PP < (@ADVP < ((IN|RB=node1 < /^(?i)at$/) $+ (JJS|RBS=node2 < /^(?i)least$/)) !$+ (RB < /(?i)(once|twice)/))")};
    private static TsurgeonPattern MWE_OPERATION = Tsurgeon.parseOperation("[createSubtree MWE node1 node2] [if exists node3 move node3 $- node2]");
    private static TregexPattern ACCORDING_TO_PATTERN = TregexPattern.compile("PP=pp1 < (VBG=node1 < /^(?i)according$/ $+ (PP=pp2 < (TO|IN=node2 < to)))");
    private static TsurgeonPattern ACCORDING_TO_OPERATION = Tsurgeon.parseOperation("[createSubtree MWE node1] [move node2 $- node1] [excise pp2 pp2]");
    private static TregexPattern BUT_ALSO_PATTERN = TregexPattern.compile("CONJP=conjp < (CC=cc < but) < (RB=rb < also) $+ __=nextNode");
    private static TsurgeonPattern BUT_ALSO_OPERATION = Tsurgeon.parseOperation("[move cc $- conjp] [move rb >1 nextNode] [createSubtree ADVP rb] [delete conjp]");
    private static TregexPattern AT_RBS_PATTERN = TregexPattern.compile("@ADVP|QP < ((IN|RB=node1 < /^(?i)at$/) $+ (JJS|RBS=node2))");
    private static TsurgeonPattern AT_RBS_OPERATION = Tsurgeon.parseOperation("[relabel node1 IN] [createSubtree ADVP node1] [move node2 $- node1] [createSubtree NP node2]");
    private static TregexPattern AT_ALL_PATTERN = TregexPattern.compile("@ADVP=head < (RB|IN=node1 < /^(?i)at$/ $+ (RB|DT=node2 < /^(?i)all$/))");
    private static TsurgeonPattern AT_ALL_OPERATION = Tsurgeon.parseOperation("[relabel head PP] [relabel node1 IN] [createSubtree NP node2]");
    private static TregexPattern FLAT_PREP_CC_PATTERN = TregexPattern.compile("PP <, (/^(IN|TO)$/=p1 $+ (CC=cc $+ /^(IN|TO)$/=p2))");
    private static TsurgeonPattern FLAT_PREP_CC_OPERATION = Tsurgeon.parseOperation("[createSubtree PCONJP p1 cc] [move p2 $- cc]");

    public CoordinationTransformer(HeadFinder hf) {
        this(hf, false);
    }

    public CoordinationTransformer(HeadFinder hf, boolean performMWETransformation) {
        this.headFinder = hf;
        this.performMWETransformation = performMWETransformation;
        this.qp = new QPTreeTransformer(performMWETransformation);
    }

    @Override
    public Tree transformTree(Tree t) {
        if (VERBOSE) {
            System.err.println("Input to CoordinationTransformer: " + t);
        }
        t = this.tn.transformTree(t);
        if (VERBOSE) {
            System.err.println("After DependencyTreeTransformer:  " + t);
        }
        if (t == null) {
            return t;
        }
        t = CoordinationTransformer.UCPtransform(t);
        if (VERBOSE) {
            System.err.println("After UCPTransformer:             " + t);
        }
        t = CoordinationTransformer.CCtransform(t);
        if (VERBOSE) {
            System.err.println("After CCTransformer:              " + t);
        }
        t = this.qp.transformTree(t);
        if (VERBOSE) {
            System.err.println("After QPTreeTransformer:          " + t);
        }
        t = this.SQflatten(t);
        if (VERBOSE) {
            System.err.println("After SQ flattening:              " + t);
        }
        t = this.dates.transformTree(t);
        if (VERBOSE) {
            System.err.println("After DateTreeTransformer:        " + t);
        }
        t = CoordinationTransformer.removeXOverX(t);
        if (VERBOSE) {
            System.err.println("After removeXoverX:               " + t);
        }
        t = CoordinationTransformer.combineConjp(t);
        if (VERBOSE) {
            System.err.println("After combineConjp:               " + t);
        }
        t = CoordinationTransformer.moveRB(t);
        if (VERBOSE) {
            System.err.println("After moveRB:                     " + t);
        }
        t = CoordinationTransformer.changeSbarToPP(t);
        if (VERBOSE) {
            System.err.println("After changeSbarToPP:             " + t);
        }
        t = CoordinationTransformer.rearrangeNowThat(t);
        if (VERBOSE) {
            System.err.println("After rearrangeNowThat:           " + t);
        }
        if (this.performMWETransformation) {
            t = CoordinationTransformer.MWETransform(t);
            if (VERBOSE) {
                System.err.println("After MWETransform:               " + t);
            }
            t = CoordinationTransformer.prepCCTransform(t);
            if (VERBOSE) {
                System.err.println("After prepCCTransform:               " + t);
            }
        }
        return t;
    }

    private static Tree rearrangeNowThat(Tree t) {
        if (t == null) {
            return t;
        }
        return Tsurgeon.processPattern(rearrangeNowThatTregex, rearrangeNowThatTsurgeon, t);
    }

    private static Tree changeSbarToPP(Tree t) {
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(changeSbarToPPTregex, changeSbarToPPTsurgeon, t);
    }

    private static Tree combineConjp(Tree t) {
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(findFlatConjpTregex, addConjpTsurgeon, t);
    }

    static Tree moveRB(Tree t) {
        if (t == null) {
            return null;
        }
        for (TregexPattern pattern : moveRBTregex) {
            t = Tsurgeon.processPattern(pattern, moveRBTsurgeon, t);
        }
        return t;
    }

    public Tree SQflatten(Tree t) {
        if (this.headFinder != null && this.headFinder instanceof CopulaHeadFinder && ((CopulaHeadFinder)((Object)this.headFinder)).makesCopulaHead()) {
            return t;
        }
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(flattenSQTregex, flattenSQTsurgeon, t);
    }

    public static Tree removeXOverX(Tree t) {
        return Tsurgeon.processPattern(removeXOverXTregex, removeXOverXTsurgeon, t);
    }

    public static Tree UCPtransform(Tree t) {
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(ucpRenameTregex, ucpRenameTsurgeon, t);
    }

    public static Tree CCtransform(Tree t) {
        boolean notDone = true;
        while (notDone) {
            Tree cc = CoordinationTransformer.findCCparent(t, t);
            if (cc != null) {
                t = cc;
                continue;
            }
            notDone = false;
        }
        return t;
    }

    private static String getHeadTag(Tree t) {
        if (t.value().startsWith("NN")) {
            return "NP";
        }
        if (t.value().startsWith("JJ")) {
            return "ADJP";
        }
        return "NP";
    }

    private static Tree transformCC(Tree t, int ccIndex) {
        if (VERBOSE) {
            System.err.println("transformCC in:  " + t);
        }
        TreeFactory tf = t.treeFactory();
        LabelFactory lf = t.label().labelFactory();
        Tree[] ccSiblings = t.children();
        ArrayList<Integer> ccPositions = new ArrayList<Integer>();
        for (int i = ccIndex + 1; i < ccSiblings.length; ++i) {
            if (!ccSiblings[i].value().startsWith("CC") || i >= ccSiblings.length - 1) continue;
            ccPositions.add(i);
        }
        String beforeSibling = ccSiblings[ccIndex - 1].value();
        if (!(ccIndex != 1 || !beforeSibling.equals("DT") && !beforeSibling.equals("JJ") && !beforeSibling.equals("RB") && ccSiblings[ccIndex + 1].value().equals("DT") || beforeSibling.startsWith("NP") || beforeSibling.equals("ADJP") || beforeSibling.equals("NNS"))) {
            int i;
            String leftHead = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree left = tf.newTreeNode(lf.newLabel(leftHead), null);
            for (i = 0; i < ccIndex + 2; ++i) {
                left.addChild(ccSiblings[i]);
            }
            if (VERBOSE) {
                System.out.println("print left tree");
                left.pennPrint();
                System.out.println();
            }
            for (i = 0; i < ccIndex + 2; ++i) {
                t.removeChild(0);
            }
            if (VERBOSE && t.numChildren() == 0) {
                System.out.println("Youch! No t children");
            }
            if (!ccPositions.isEmpty()) {
                boolean comma = false;
                int index = (Integer)ccPositions.get(0);
                if (VERBOSE) {
                    System.err.println("more CC index " + index);
                }
                if (ccSiblings[index - 1].value().equals(",")) {
                    --index;
                    comma = true;
                }
                if (VERBOSE) {
                    System.err.println("more CC index " + index);
                }
                String head = CoordinationTransformer.getHeadTag(ccSiblings[index - 1]);
                if (ccIndex + 2 < index) {
                    Tree tree = tf.newTreeNode(lf.newLabel(head), null);
                    tree.addChild(0, left);
                    int k = 1;
                    for (int j = ccIndex + 2; j < index; ++j) {
                        if (VERBOSE) {
                            ccSiblings[j].pennPrint();
                        }
                        t.removeChild(0);
                        tree.addChild(k, ccSiblings[j]);
                        ++k;
                    }
                    if (VERBOSE) {
                        System.out.println("print t");
                        t.pennPrint();
                        System.out.println("print tree");
                        tree.pennPrint();
                        System.out.println();
                    }
                    t.addChild(0, tree);
                } else {
                    t.addChild(0, left);
                }
                Tree rightTree = tf.newTreeNode(lf.newLabel("NP"), null);
                int start = 2;
                if (comma) {
                    ++start;
                }
                while (start < t.numChildren()) {
                    Tree sib = t.getChild(start);
                    t.removeChild(start);
                    rightTree.addChild(sib);
                }
                t.addChild(rightTree);
            } else {
                t.addChild(0, left);
            }
        } else if (ccIndex == 2 && ccSiblings[0].value().startsWith("DT") && !ccSiblings[ccIndex - 1].value().equals("NNS") && (ccSiblings.length == 5 || !ccPositions.isEmpty() && (Integer)ccPositions.get(0) == 5)) {
            int i;
            String head = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree child = tf.newTreeNode(lf.newLabel(head), null);
            for (i = 1; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            if (VERBOSE && child.numChildren() == 0) {
                System.out.println("Youch! No child children");
            }
            for (i = 1; i < ccIndex + 2; ++i) {
                t.removeChild(1);
            }
            t.addChild(1, child);
        } else if (ccIndex > 2 && ccSiblings[ccIndex - 2].value().equals(",") && !ccSiblings[ccIndex - 1].value().equals("NNS")) {
            int i;
            String head = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree child = tf.newTreeNode(lf.newLabel(head), null);
            for (i = ccIndex - 3; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            if (VERBOSE && child.numChildren() == 0) {
                System.out.println("Youch! No child children");
            }
            for (i = ccIndex - 4; i > 0 && ccSiblings[i].value().equals(","); i -= 2) {
                child.addChild(0, ccSiblings[i]);
                child.addChild(0, ccSiblings[i - 1]);
            }
            if (i < 0) {
                i = -1;
            }
            for (int j = i + 1; j < ccIndex + 2; ++j) {
                t.removeChild(i + 1);
            }
            t.addChild(i + 1, child);
        } else {
            int i;
            boolean commaLeft = false;
            boolean commaRight = false;
            boolean preconj = false;
            int indexBegin = 0;
            Tree conjT = tf.newTreeNode(lf.newLabel("CC"), null);
            String leftHead = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree left = tf.newTreeNode(lf.newLabel(leftHead), null);
            Tree first = ccSiblings[0];
            String leaf = first.firstChild().value().toLowerCase();
            if (leaf.equals("either") || leaf.equals("neither") || leaf.equals("both")) {
                preconj = true;
                indexBegin = 1;
                conjT.addChild(first.firstChild());
            }
            for (int i2 = indexBegin; i2 < ccIndex - 1; ++i2) {
                left.addChild(ccSiblings[i2]);
            }
            if (ccSiblings[ccIndex - 1].value().equals(",")) {
                commaLeft = true;
            } else {
                left.addChild(ccSiblings[ccIndex - 1]);
            }
            Tree cc = ccSiblings[ccIndex];
            int nextCC = ccPositions.isEmpty() ? ccSiblings.length : (Integer)ccPositions.get(0);
            String rightHead = CoordinationTransformer.getHeadTag(ccSiblings[nextCC - 1]);
            Tree right = tf.newTreeNode(lf.newLabel(rightHead), null);
            for (i = ccIndex + 1; i < nextCC - 1; ++i) {
                right.addChild(ccSiblings[i]);
            }
            if (ccSiblings[nextCC - 1].value().equals(",")) {
                commaRight = true;
            } else {
                right.addChild(ccSiblings[nextCC - 1]);
            }
            if (VERBOSE) {
                if (left.numChildren() == 0) {
                    System.out.println("Youch! No left children");
                }
                if (right.numChildren() == 0) {
                    System.out.println("Youch! No right children");
                }
            }
            for (i = 0; i < nextCC; ++i) {
                t.removeChild(0);
            }
            if (!ccPositions.isEmpty()) {
                Tree tree = tf.newTreeNode(lf.newLabel("NP"), null);
                if (preconj) {
                    tree.addChild(conjT);
                }
                if (left.numChildren() > 0) {
                    tree.addChild(left);
                }
                if (commaLeft) {
                    tree.addChild(ccSiblings[ccIndex - 1]);
                }
                tree.addChild(cc);
                if (right.numChildren() > 0) {
                    tree.addChild(right);
                }
                if (commaRight) {
                    t.addChild(0, ccSiblings[nextCC - 1]);
                }
                t.addChild(0, tree);
            } else {
                if (preconj) {
                    t.addChild(conjT);
                }
                if (left.numChildren() > 0) {
                    t.addChild(left);
                }
                if (commaLeft) {
                    t.addChild(ccSiblings[ccIndex - 1]);
                }
                t.addChild(cc);
                if (right.numChildren() > 0) {
                    t.addChild(right);
                }
                if (commaRight) {
                    t.addChild(ccSiblings[nextCC - 1]);
                }
            }
        }
        if (VERBOSE) {
            System.err.println("transformCC out: " + t);
        }
        return t;
    }

    private static boolean notNP(List<Tree> children, int ccIndex) {
        int sz = children.size();
        for (int i = ccIndex; i < sz; ++i) {
            if (!children.get(i).value().startsWith("NP")) continue;
            return false;
        }
        return true;
    }

    private static Tree findCCparent(Tree t, Tree root) {
        if (t.isPreTerminal()) {
            Tree parent;
            if (t.value().startsWith("CC") && (parent = t.parent(root)) != null && parent.value().startsWith("NP")) {
                List<Tree> children = parent.getChildrenAsList();
                int ccIndex = children.indexOf(t);
                if (children.size() > ccIndex + 2 && CoordinationTransformer.notNP(children, ccIndex) && ccIndex != 0 && (ccIndex == children.size() - 1 || !children.get(ccIndex + 1).value().startsWith("CC"))) {
                    CoordinationTransformer.transformCC(parent, ccIndex);
                    if (VERBOSE) {
                        System.err.println("After transformCC:             " + root);
                    }
                    return root;
                }
            }
        } else {
            for (Tree child : t.getChildrenAsList()) {
                Tree cur = CoordinationTransformer.findCCparent(child, root);
                if (cur == null) continue;
                return cur;
            }
        }
        return null;
    }

    public static Tree MWETransform(Tree t) {
        for (TregexPattern p : MWE_PATTERNS) {
            Tsurgeon.processPattern(p, MWE_OPERATION, t);
        }
        Tsurgeon.processPattern(ACCORDING_TO_PATTERN, ACCORDING_TO_OPERATION, t);
        Tsurgeon.processPattern(BUT_ALSO_PATTERN, BUT_ALSO_OPERATION, t);
        Tsurgeon.processPattern(AT_RBS_PATTERN, AT_RBS_OPERATION, t);
        Tsurgeon.processPattern(AT_ALL_PATTERN, AT_ALL_OPERATION, t);
        return t;
    }

    public static Tree prepCCTransform(Tree t) {
        Tsurgeon.processPattern(FLAT_PREP_CC_PATTERN, FLAT_PREP_CC_OPERATION, t);
        return t;
    }

    public static void main(String[] args) {
        CoordinationTransformer transformer = new CoordinationTransformer(null);
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        if (treeFileName != null) {
            try {
                Tree t;
                PennTreeReader tr = new PennTreeReader(new BufferedReader(new InputStreamReader(new FileInputStream(treeFileName))), new LabeledScoredTreeFactory());
                while ((t = tr.readTree()) != null) {
                    ((AbstractCollection)tb).add(t);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("File problem: " + e);
            }
        }
        for (Tree t : tb) {
            System.out.println("Original tree");
            t.pennPrint();
            System.out.println();
            System.out.println("Tree transformed");
            Tree tree = transformer.transformTree(t);
            tree.pennPrint();
            System.out.println();
            System.out.println("----------------------------");
        }
    }
}

