/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CoreMapAggregator
implements Function<List<? extends CoreMap>, CoreMap> {
    public static final CoreMapAggregator DEFAULT_AGGREGATOR = CoreMapAggregator.getAggregator(CoreMapAttributeAggregator.getDefaultAggregators());
    public static final CoreMapAggregator DEFAULT_NUMERIC_TOKENS_AGGREGATOR = CoreMapAggregator.getAggregator(CoreMapAttributeAggregator.DEFAULT_NUMERIC_TOKENS_AGGREGATORS);
    Map<Class, CoreMapAttributeAggregator> aggregators;
    Class mergedKey = null;
    CoreLabelTokenFactory tokenFactory = null;

    public CoreMapAggregator(Map<Class, CoreMapAttributeAggregator> aggregators) {
        this.aggregators = aggregators;
    }

    public CoreMapAggregator(Map<Class, CoreMapAttributeAggregator> aggregators, Class mergedKey, CoreLabelTokenFactory tokenFactory) {
        this.aggregators = aggregators;
        this.mergedKey = mergedKey;
        this.tokenFactory = tokenFactory;
    }

    public CoreMap merge(List<? extends CoreMap> in, int start, int end) {
        CoreMap merged = ChunkAnnotationUtils.getMergedChunk(in, start, end, this.aggregators, this.tokenFactory);
        if (this.mergedKey != null) {
            merged.set(this.mergedKey, new ArrayList<CoreMap>(in.subList(start, end)));
        }
        return merged;
    }

    public CoreMap merge(List<? extends CoreMap> in) {
        return this.merge(in, 0, in.size());
    }

    @Override
    public CoreMap apply(List<? extends CoreMap> in) {
        return this.merge(in, 0, in.size());
    }

    public static CoreMapAggregator getDefaultAggregator() {
        return DEFAULT_AGGREGATOR;
    }

    public static CoreMapAggregator getAggregator(Map<Class, CoreMapAttributeAggregator> aggregators) {
        return new CoreMapAggregator(aggregators);
    }

    public static CoreMapAggregator getAggregator(Map<Class, CoreMapAttributeAggregator> aggregators, Class key) {
        return new CoreMapAggregator(aggregators, key, null);
    }

    public static CoreMapAggregator getAggregator(Map<Class, CoreMapAttributeAggregator> aggregators, Class key, CoreLabelTokenFactory tokenFactory) {
        return new CoreMapAggregator(aggregators, key, tokenFactory);
    }

    public List<CoreMap> merge(List<? extends CoreMap> list, List<? extends HasInterval<Integer>> matched) {
        return CollectionUtils.mergeList(list, matched, this);
    }

    public <M> List<CoreMap> merge(List<? extends CoreMap> list, List<M> matched, Function<M, Interval<Integer>> toIntervalFunc) {
        return CollectionUtils.mergeList(list, matched, toIntervalFunc, this);
    }
}

