/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.TreeShapedStack;
import java.util.List;

public class UnaryTransition
implements Transition {
    public final String label;
    public final boolean isRoot;
    private static final long serialVersionUID = 1L;

    public UnaryTransition(String label, boolean isRoot) {
        this.label = label;
        this.isRoot = isRoot;
    }

    @Override
    public boolean isLegal(State state, List<ParserConstraint> constraints) {
        Tree grandChild;
        Tree child;
        if (state.finished) {
            return false;
        }
        if (state.stack.size() == 0) {
            return false;
        }
        Tree top = state.stack.peek();
        if (top.label().value().equals(this.label)) {
            return false;
        }
        if (top.label().value().startsWith("@") && !this.label.equals(top.label().value().substring(1))) {
            return false;
        }
        if (top.children().length == 1 && (child = top.children()[0]).children().length == 1 && (grandChild = child.children()[0]).children().length == 1) {
            return false;
        }
        return !this.isRoot || state.stack.size() <= 1 && state.endOfQueue();
    }

    @Override
    public State apply(State state) {
        return this.apply(state, 0.0);
    }

    static Tree addUnaryNode(Tree top, String label) {
        if (!(top.label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Stack should have CoreLabel nodes");
        }
        Tree newTop = UnaryTransition.createNode(top, label, top);
        return newTop;
    }

    static Tree createNode(Tree top, String label, Tree ... children) {
        CoreLabel headLabel = (CoreLabel)top.label();
        CoreLabel production = new CoreLabel();
        production.setValue(label);
        production.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class));
        production.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadTagLabelAnnotation.class));
        LabeledScoredTreeNode newTop = new LabeledScoredTreeNode(production);
        for (Tree child : children) {
            newTop.addChild(child);
        }
        return newTop;
    }

    @Override
    public State apply(State state, double scoreDelta) {
        Tree top = state.stack.peek();
        Tree newTop = UnaryTransition.addUnaryNode(top, this.label);
        TreeShapedStack<Tree> stack = state.stack.pop();
        stack = stack.push(newTop);
        return new State(stack, state.transitions.push(this), state.separators, state.sentence, state.tokenPosition, state.score + scoreDelta, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnaryTransition)) {
            return false;
        }
        String otherLabel = ((UnaryTransition)o).label;
        return this.label.equals(otherLabel);
    }

    public int hashCode() {
        return 0x1C1A3D7 ^ this.label.hashCode();
    }

    public String toString() {
        return "Unary" + (this.isRoot ? "*" : "") + "(" + this.label + ")";
    }
}

