/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunctionWithDropout;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CRFClassifierWithDropout<IN extends CoreMap>
extends CRFClassifier<IN> {
    private static Redwood.RedwoodChannels log = Redwood.channels(CRFClassifierWithDropout.class);
    private List<List<IN>> unsupDocs;

    public CRFClassifierWithDropout(SeqClassifierFlags flags) {
        super(flags);
    }

    @Override
    protected Collection<List<IN>> loadAuxiliaryData(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (this.flags.unsupDropoutFile != null) {
            log.info("Reading unsupervised dropout data from file: " + this.flags.unsupDropoutFile);
            Timing timer = new Timing();
            timer.start();
            this.unsupDocs = new ArrayList<List<IN>>();
            ObjectBank<List<IN>> unsupObjBank = this.makeObjectBankFromFile(this.flags.unsupDropoutFile, readerAndWriter);
            for (List<IN> doc : unsupObjBank) {
                for (CoreMap tok : doc) {
                    tok.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
                    tok.set(CoreAnnotations.GoldAnswerAnnotation.class, this.flags.backgroundSymbol);
                }
                this.unsupDocs.add(doc);
            }
            long elapsedMs = timer.stop();
            log.info("Time to read: : " + Timing.toSecondsString(elapsedMs) + " seconds");
        }
        if (this.unsupDocs != null && this.flags.doFeatureDiscovery) {
            ArrayList<List<IN>> totalDocs = new ArrayList<List<IN>>();
            totalDocs.addAll(docs);
            totalDocs.addAll(this.unsupDocs);
            return totalDocs;
        }
        return docs;
    }

    @Override
    protected CRFLogConditionalObjectiveFunction getObjectiveFunction(int[][][][] data, int[][] labels) {
        Object unsupDropoutData = null;
        if (this.unsupDocs != null) {
            Timing timer = new Timing();
            timer.start();
            List<Triple<int[][][], int[], double[][][]>> unsupDataAndLabels = this.documentsToDataAndLabelsList(this.unsupDocs);
            unsupDropoutData = new int[unsupDataAndLabels.size()][][][];
            for (int q = 0; q < ((int[][][][])unsupDropoutData).length; ++q) {
                unsupDropoutData[q] = unsupDataAndLabels.get(q).first();
            }
            long elapsedMs = timer.stop();
            log.info("Time to read unsupervised dropout data: " + Timing.toSecondsString(elapsedMs) + " seconds, read " + ((int[][][][])unsupDropoutData).length + " files");
        }
        return new CRFLogConditionalObjectiveFunctionWithDropout(data, labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.priorType, this.flags.backgroundSymbol, this.flags.sigma, null, this.flags.dropoutRate, this.flags.dropoutScale, this.flags.multiThreadGrad, this.flags.dropoutApprox, this.flags.unsupDropoutScale, (int[][][][])unsupDropoutData);
    }
}

