/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ColumnDocumentReaderAndWriter
implements DocumentReaderAndWriter<CoreLabel> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ColumnDocumentReaderAndWriter.class);
    private static final long serialVersionUID = 3806263423697973704L;
    private static final boolean includeProbabilities = false;
    private Class[] map;
    private IteratorFromReaderFactory<List<CoreLabel>> factory;

    @Override
    public void init(SeqClassifierFlags flags) {
        this.init(flags.map);
    }

    public void init(String map) {
        this.map = CoreLabel.parseStringKeys(StringUtils.mapStringToArray(map));
        this.factory = DelimitRegExIterator.getFactory("\n(?:\\s*\n)+", new ColumnDocParser());
    }

    @Override
    public Iterator<List<CoreLabel>> getIterator(Reader r) {
        return this.factory.getIterator(r);
    }

    @Override
    public void printAnswers(List<CoreLabel> doc, PrintWriter out2) {
        for (CoreLabel wi : doc) {
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            String goldAnswer = (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class);
            out2.println(wi.word() + '\t' + goldAnswer + '\t' + answer);
        }
        out2.println();
    }

    private class ColumnDocParser
    implements Serializable,
    Function<String, List<CoreLabel>> {
        private static final long serialVersionUID = -6266332661459630572L;
        private final Pattern whitePattern = Pattern.compile("\\s+");
        private int lineCount;

        private ColumnDocParser() {
        }

        @Override
        public List<CoreLabel> apply(String doc) {
            String[] lines;
            ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
            for (String line : lines = doc.split("\n")) {
                CoreLabel wi;
                ++this.lineCount;
                if (line.trim().isEmpty()) continue;
                String[] info = line.split("\t");
                if (info.length == 1) {
                    info = this.whitePattern.split(line);
                }
                try {
                    wi = new CoreLabel(ColumnDocumentReaderAndWriter.this.map, info);
                    if (!wi.containsKey(CoreAnnotations.GoldAnswerAnnotation.class) && wi.containsKey(CoreAnnotations.AnswerAnnotation.class)) {
                        wi.set(CoreAnnotations.GoldAnswerAnnotation.class, wi.get(CoreAnnotations.AnswerAnnotation.class));
                    }
                }
                catch (RuntimeException e) {
                    log.info("Error on line " + this.lineCount + ": " + line);
                    throw e;
                }
                words.add(wi);
            }
            return words;
        }
    }
}

