/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.util.MemoryMonitor;
import edu.stanford.nlp.util.logging.Redwood;

public class MemoryEvaluator
implements Evaluator {
    private static Redwood.RedwoodChannels log = Redwood.channels(MemoryEvaluator.class);
    private MemoryMonitor memMonitor = new MemoryMonitor();

    public String toString() {
        return "Memory Usage";
    }

    @Override
    public double evaluate(double[] x) {
        StringBuilder sb = new StringBuilder("Memory Usage: ");
        sb.append(" used(KB):").append(this.memMonitor.getUsedMemory(false));
        sb.append(" maxAvailable(KB):").append(this.memMonitor.getMaxAvailableMemory(false));
        sb.append(" max(KB):").append(this.memMonitor.getMaxMemory());
        String memString = sb.toString();
        log.info(memString);
        return 0.0;
    }
}

