/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.util;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Fixed;
import de.jollyday.util.XMLUtil;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.CopticChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.IslamicChronology;
import org.joda.time.chrono.JulianChronology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarUtil {
    private XMLUtil xmlUtil = new XMLUtil();

    public LocalDate create() {
        return new LocalDate((Chronology)ISOChronology.getInstance());
    }

    public LocalDate create(int year, int month, int day) {
        return this.create(year, month, day, (Chronology)ISOChronology.getInstance());
    }

    public LocalDate create(int year, int month, int day, Chronology chronology) {
        return new LocalDate(year, month, day, chronology);
    }

    public LocalDate create(int year, Fixed fixed) {
        return this.create(year, this.xmlUtil.getMonth(fixed.getMonth()), fixed.getDay());
    }

    public LocalDate create(Calendar c) {
        return new LocalDate((Object)c, (Chronology)ISOChronology.getInstance());
    }

    public LocalDate getEasterSunday(int year) {
        if (year <= 1583) {
            return this.getJulianEasterSunday(year);
        }
        return this.getGregorianEasterSunday(year);
    }

    public LocalDate getJulianEasterSunday(int year) {
        int a = year % 4;
        int b = year % 7;
        int c = year % 19;
        int d = (19 * c + 15) % 30;
        int e = (2 * a + 4 * b - d + 34) % 7;
        int x = d + e + 114;
        int month = x / 31;
        int day = x % 31 + 1;
        LocalDate julianEasterDate = this.create(year, month == 3 ? 3 : 4, day, (Chronology)JulianChronology.getInstanceUTC());
        return this.convertToISODate(julianEasterDate);
    }

    public LocalDate getGregorianEasterSunday(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int j = c % 4;
        int k = (32 + 2 * e + 2 * i - h - j) % 7;
        int l = (a + 11 * h + 22 * k) / 451;
        int x = h + k - 7 * l + 114;
        int month = x / 31;
        int day = x % 31 + 1;
        return this.create(year, month == 3 ? 3 : 4, day);
    }

    public boolean isWeekend(LocalDate date) {
        return date.getDayOfWeek() == 6 || date.getDayOfWeek() == 7;
    }

    public Set<LocalDate> getIslamicHolidaysInGregorianYear(int gregorianYear, int islamicMonth, int islamicDay) {
        return this.getDatesFromChronologyWithinGregorianYear(islamicMonth, islamicDay, gregorianYear, (Chronology)IslamicChronology.getInstance());
    }

    public Set<LocalDate> getEthiopianOrthodoxHolidaysInGregorianYear(int gregorianYear, int eoMonth, int eoDay) {
        return this.getDatesFromChronologyWithinGregorianYear(eoMonth, eoDay, gregorianYear, (Chronology)CopticChronology.getInstance());
    }

    private Set<LocalDate> getDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, int gregorianYear, Chronology targetChrono) {
        HashSet<LocalDate> holidays = new HashSet<LocalDate>();
        LocalDate firstGregorianDate = new LocalDate(gregorianYear, 1, 1, (Chronology)ISOChronology.getInstance());
        LocalDate lastGregorianDate = new LocalDate(gregorianYear, 12, 31, (Chronology)ISOChronology.getInstance());
        LocalDate firstTargetDate = new LocalDate(firstGregorianDate.toDateTimeAtStartOfDay().getMillis(), targetChrono);
        LocalDate lastTargetDate = new LocalDate(lastGregorianDate.toDateTimeAtStartOfDay().getMillis(), targetChrono);
        Interval interv = new Interval((ReadableInstant)firstTargetDate.toDateTimeAtStartOfDay(), (ReadableInstant)lastTargetDate.plusDays(1).toDateTimeAtStartOfDay());
        for (int targetYear = firstTargetDate.getYear(); targetYear <= lastTargetDate.getYear(); ++targetYear) {
            LocalDate d = new LocalDate(targetYear, targetMonth, targetDay, targetChrono);
            if (!interv.contains((ReadableInstant)d.toDateTimeAtStartOfDay())) continue;
            holidays.add(this.convertToISODate(d));
        }
        return holidays;
    }

    public LocalDate convertToISODate(LocalDate date) {
        if (!(date.getChronology() instanceof ISOChronology)) {
            return new LocalDate(date.toDateTimeAtStartOfDay().getMillis(), (Chronology)ISOChronology.getInstance());
        }
        return date;
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date, HolidayType holidayType) {
        for (Holiday h : holidays) {
            if (!h.getDate().equals((Object)date) || holidayType != null && h.getType() != holidayType) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date) {
        return this.contains(holidays, date, null);
    }
}

