/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Map;

public class FetchNode
extends TsurgeonPattern {
    private static Redwood.RedwoodChannels log = Redwood.channels(FetchNode.class);

    public FetchNode(String nodeName) {
        super(nodeName, TsurgeonPattern.EMPTY_TSURGEON_PATTERN_ARRAY);
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(FetchNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree result = (Tree)this.newNodeNames.get(FetchNode.this.label);
            if (result == null) {
                result = tregex.getNode(FetchNode.this.label);
            }
            if (result == null) {
                log.info("Warning -- null node fetched by Tsurgeon operation for node: " + this + " (either no node labeled this, or the labeled node didn't match anything)");
            }
            return result;
        }
    }
}

